/*
 * Decompiled with CFR 0.152.
 */
package org.controlsfx.control;

import impl.org.controlsfx.skin.MasterDetailPaneSkin;
import java.util.Objects;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.geometry.Pos;
import javafx.geometry.Side;
import javafx.scene.Node;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import org.controlsfx.control.ControlsFXControl;

public class MasterDetailPane
extends ControlsFXControl {
    private final DoubleProperty dividerSizeHint = new SimpleDoubleProperty((Object)this, "dividerSizeHint", 10.0){

        public void set(double d2) {
            super.set(Math.max(0.0, d2));
        }
    };
    private final ObjectProperty<Side> detailSide = new SimpleObjectProperty((Object)this, "detailSide", (Object)Side.RIGHT);
    private final BooleanProperty showDetailNode = new SimpleBooleanProperty((Object)this, "showDetailNode", true);
    private final ObjectProperty<Node> masterNode = new SimpleObjectProperty((Object)this, "masterNode");
    private final ObjectProperty<Node> detailNode = new SimpleObjectProperty((Object)this, "detailNode");
    private final BooleanProperty animated = new SimpleBooleanProperty((Object)this, "animated", true);
    private DoubleProperty dividerPosition = new SimpleDoubleProperty((Object)this, "dividerPosition", 0.33);

    public MasterDetailPane(Side side, Node node, Node node2, boolean bl2) {
        Objects.requireNonNull(side);
        Objects.requireNonNull(node);
        Objects.requireNonNull(node2);
        this.getStyleClass().add((Object)"master-detail-pane");
        this.setDetailSide(side);
        this.setMasterNode(node);
        this.setDetailNode(node2);
        this.setShowDetailNode(bl2);
        switch (side) {
            case BOTTOM: 
            case RIGHT: {
                this.setDividerPosition(0.8);
                break;
            }
            case TOP: 
            case LEFT: {
                this.setDividerPosition(0.2);
                break;
            }
        }
    }

    public MasterDetailPane(Side side, boolean bl2) {
        this(side, (Node)new Placeholder(true), (Node)new Placeholder(false), bl2);
    }

    public MasterDetailPane(Side side) {
        this(side, (Node)new Placeholder(true), (Node)new Placeholder(false), true);
    }

    public MasterDetailPane() {
        this(Side.RIGHT, (Node)new Placeholder(true), (Node)new Placeholder(false), true);
    }

    protected Skin<?> createDefaultSkin() {
        return new MasterDetailPaneSkin(this);
    }

    public String getUserAgentStylesheet() {
        return this.getUserAgentStylesheet(MasterDetailPane.class, "masterdetailpane.css");
    }

    public final void resetDividerPosition() {
        double d2;
        Node node = this.getDetailNode();
        if (node == null) {
            return;
        }
        boolean bl2 = this.isShowDetailNode();
        boolean bl3 = this.isAnimated();
        if (!bl2) {
            this.setAnimated(false);
            this.setShowDetailNode(true);
            node.applyCss();
        }
        double d3 = this.getDividerSizeHint();
        switch (this.getDetailSide()) {
            case RIGHT: 
            case LEFT: {
                d2 = node.prefWidth(-1.0) + d3;
                break;
            }
            default: {
                d2 = node.prefHeight(-1.0) + d3;
            }
        }
        double d4 = 0.0;
        switch (this.getDetailSide()) {
            case LEFT: {
                d4 = d2 / this.getWidth();
                break;
            }
            case RIGHT: {
                d4 = 1.0 - d2 / this.getWidth();
                break;
            }
            case TOP: {
                d4 = d2 / this.getHeight();
                break;
            }
            case BOTTOM: {
                d4 = 1.0 - d2 / this.getHeight();
            }
        }
        this.setDividerPosition(Math.min(1.0, Math.max(0.0, d4)));
        if (!bl2) {
            this.setShowDetailNode(bl2);
            this.setAnimated(bl3);
        }
    }

    public final DoubleProperty dividerSizeHintProperty() {
        return this.dividerSizeHint;
    }

    public final void setDividerSizeHint(double d2) {
        this.dividerSizeHint.set(d2);
    }

    public final double getDividerSizeHint() {
        return this.dividerSizeHint.get();
    }

    public final ObjectProperty<Side> detailSideProperty() {
        return this.detailSide;
    }

    public final Side getDetailSide() {
        return (Side)this.detailSideProperty().get();
    }

    public final void setDetailSide(Side side) {
        Objects.requireNonNull(side);
        this.detailSideProperty().set((Object)side);
    }

    public final BooleanProperty showDetailNodeProperty() {
        return this.showDetailNode;
    }

    public final boolean isShowDetailNode() {
        return this.showDetailNodeProperty().get();
    }

    public final void setShowDetailNode(boolean bl2) {
        this.showDetailNodeProperty().set(bl2);
    }

    public final ObjectProperty<Node> masterNodeProperty() {
        return this.masterNode;
    }

    public final Node getMasterNode() {
        return (Node)this.masterNodeProperty().get();
    }

    public final void setMasterNode(Node node) {
        Objects.requireNonNull(node);
        this.masterNodeProperty().set((Object)node);
    }

    public final ObjectProperty<Node> detailNodeProperty() {
        return this.detailNode;
    }

    public final Node getDetailNode() {
        return (Node)this.detailNodeProperty().get();
    }

    public final void setDetailNode(Node node) {
        this.detailNodeProperty().set((Object)node);
    }

    public final BooleanProperty animatedProperty() {
        return this.animated;
    }

    public final boolean isAnimated() {
        return this.animatedProperty().get();
    }

    public final void setAnimated(boolean bl2) {
        this.animatedProperty().set(bl2);
    }

    public final DoubleProperty dividerPositionProperty() {
        return this.dividerPosition;
    }

    public final double getDividerPosition() {
        return this.dividerPosition.get();
    }

    public final void setDividerPosition(double d2) {
        if (this.getDividerPosition() == d2) {
            this.dividerPosition.set(-1.0);
        }
        this.dividerPosition.set(d2);
    }

    private static final class Placeholder
    extends Label {
        public Placeholder(boolean bl2) {
            super(bl2 ? "Master" : "Detail");
            this.setAlignment(Pos.CENTER);
            if (bl2) {
                this.setStyle("-fx-background-color: -fx-background;");
            } else {
                this.setStyle("-fx-background-color: derive(-fx-background, -10%);");
            }
        }
    }
}

