/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.generation;

import java.io.File;
import java.io.IOException;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.util.Objects;
import org.agrona.generation.OutputManager;

public class PackageOutputManager
implements OutputManager {
    private final File outputDir;

    public PackageOutputManager(String string, String string2) {
        Objects.requireNonNull(string, "baseDirName");
        Objects.requireNonNull(string2, "packageName");
        char c2 = string.charAt(string.length() - 1);
        String string3 = c2 == File.separatorChar ? string : string + File.separatorChar;
        String string4 = string3 + string2.replace('.', File.separatorChar);
        this.outputDir = new File(string4);
        if (!this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new IllegalStateException("Unable to create directory: " + string4);
        }
    }

    @Override
    public Writer createOutput(String string) throws IOException {
        File file = new File(this.outputDir, string + ".java");
        return Files.newBufferedWriter(file.toPath(), StandardCharsets.UTF_8, new OpenOption[0]);
    }
}

