/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import java.nio.ByteBuffer;
import org.agrona.UnsafeAccess;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.CountersManager;
import org.agrona.concurrent.status.StatusIndicator;

public class UnsafeBufferStatusIndicator
extends StatusIndicator {
    private final int counterId;
    private final long addressOffset;
    private final byte[] byteArray;
    private final ByteBuffer byteBuffer;

    public UnsafeBufferStatusIndicator(AtomicBuffer atomicBuffer, int n2) {
        this.counterId = n2;
        this.byteArray = atomicBuffer.byteArray();
        this.byteBuffer = atomicBuffer.byteBuffer();
        int n3 = CountersManager.counterOffset(n2);
        atomicBuffer.boundsCheck(n3, 8);
        this.addressOffset = atomicBuffer.addressOffset() + (long)n3;
    }

    @Override
    public int id() {
        return this.counterId;
    }

    @Override
    public void setOrdered(long l2) {
        UnsafeAccess.UNSAFE.putOrderedLong(this.byteArray, this.addressOffset, l2);
    }

    @Override
    public long getVolatile() {
        return UnsafeAccess.UNSAFE.getLongVolatile(this.byteArray, this.addressOffset);
    }

    public String toString() {
        return "UnsafeBufferStatusIndicator{counterId=" + this.counterId + "value=" + this.getVolatile() + "}";
    }
}

