/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.AbstractSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import java.util.function.Predicate;
import org.agrona.BitUtil;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public class ObjectHashSet<T>
extends AbstractSet<T> {
    public static final int DEFAULT_INITIAL_CAPACITY = 8;
    static final Object MISSING_VALUE = null;
    private final boolean shouldAvoidAllocation;
    private final float loadFactor;
    private int resizeThreshold;
    private int size;
    private T[] values;
    private ObjectIterator iterator;
    private IntConsumer resizeNotifier;

    public ObjectHashSet() {
        this(8);
    }

    public ObjectHashSet(int n2) {
        this(n2, 0.65f);
    }

    public ObjectHashSet(int n2, float f2) {
        this(n2, f2, true);
    }

    public ObjectHashSet(int n2, float f2, boolean bl2) {
        CollectionUtil.validateLoadFactor(f2);
        this.shouldAvoidAllocation = bl2;
        this.loadFactor = f2;
        this.size = 0;
        int n3 = BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2));
        this.resizeThreshold = (int)((float)n3 * f2);
        this.values = new Object[n3];
    }

    public float loadFactor() {
        return this.loadFactor;
    }

    public int capacity() {
        return this.values.length;
    }

    public int resizeThreshold() {
        return this.resizeThreshold;
    }

    public void resizeNotifier(IntConsumer intConsumer) {
        this.resizeNotifier = intConsumer;
    }

    @Override
    public boolean add(T t2) {
        Objects.requireNonNull(t2);
        int n2 = this.values.length - 1;
        int n3 = Hashing.hash(t2.hashCode(), n2);
        while (this.values[n3] != MISSING_VALUE) {
            if (this.values[n3].equals(t2)) {
                return false;
            }
            n3 = ObjectHashSet.next(n3, n2);
        }
        this.values[n3] = t2;
        ++this.size;
        if (this.size > this.resizeThreshold) {
            this.increaseCapacity();
            if (this.resizeNotifier != null) {
                this.resizeNotifier.accept(this.resizeThreshold);
            }
        }
        return true;
    }

    private void increaseCapacity() {
        int n2 = this.values.length * 2;
        if (n2 < 0) {
            throw new IllegalStateException("max capacity reached at size=" + this.size);
        }
        this.rehash(n2);
    }

    private void rehash(int n2) {
        int n3 = n2 - 1;
        this.resizeThreshold = (int)((float)n2 * this.loadFactor);
        Object[] objectArray = new Object[n2];
        Arrays.fill(objectArray, MISSING_VALUE);
        for (T t2 : this.values) {
            if (t2 == MISSING_VALUE) continue;
            int n4 = Hashing.hash(t2.hashCode(), n3);
            while (objectArray[n4] != MISSING_VALUE) {
                ++n4;
                n4 &= n3;
            }
            objectArray[n4] = t2;
        }
        this.values = objectArray;
    }

    @Override
    public boolean remove(Object object) {
        T[] TArray = this.values;
        int n2 = TArray.length - 1;
        int n3 = Hashing.hash(object.hashCode(), n2);
        while (TArray[n3] != MISSING_VALUE) {
            if (TArray[n3].equals(object)) {
                TArray[n3] = MISSING_VALUE;
                this.compactChain(n3);
                --this.size;
                return true;
            }
            n3 = ObjectHashSet.next(n3, n2);
        }
        return false;
    }

    private static int next(int n2, int n3) {
        return n2 + 1 & n3;
    }

    void compactChain(int n2) {
        T[] TArray = this.values;
        int n3 = TArray.length - 1;
        int n4 = n2;
        while (TArray[n4 = ObjectHashSet.next(n4, n3)] != MISSING_VALUE) {
            int n5 = Hashing.hash(TArray[n4].hashCode(), n3);
            if ((n4 >= n5 || n5 > n2 && n2 > n4) && (n5 > n2 || n2 > n4)) continue;
            TArray[n2] = TArray[n4];
            TArray[n4] = MISSING_VALUE;
            n2 = n4;
        }
        return;
    }

    public void compact() {
        int n2 = (int)Math.round((double)this.size() * (1.0 / (double)this.loadFactor));
        this.rehash(BitUtil.findNextPositivePowerOfTwo(Math.max(8, n2)));
    }

    @Override
    public boolean contains(Object object) {
        int n2 = this.values.length - 1;
        int n3 = Hashing.hash(object.hashCode(), n2);
        while (this.values[n3] != MISSING_VALUE) {
            if (object == this.values[n3] || this.values[n3].equals(object)) {
                return true;
            }
            n3 = ObjectHashSet.next(n3, n2);
        }
        return false;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return this.size == 0;
    }

    @Override
    public void clear() {
        if (this.size > 0) {
            Arrays.fill(this.values, MISSING_VALUE);
            this.size = 0;
        }
    }

    @Override
    public boolean containsAll(Collection<?> collection) {
        for (Object obj : collection) {
            if (this.contains(obj)) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean addAll(Collection<? extends T> collection) {
        return ObjectHashSet.disjunction(collection, this::add);
    }

    @Override
    public boolean addAll(ObjectHashSet<T> objectHashSet) {
        boolean bl2 = false;
        for (T t2 : objectHashSet.values) {
            if (t2 == MISSING_VALUE) continue;
            bl2 |= this.add(t2);
        }
        return bl2;
    }

    public ObjectHashSet<T> difference(ObjectHashSet<T> objectHashSet) {
        ObjectHashSet<T> objectHashSet2 = null;
        for (T t2 : this.values) {
            if (t2 == MISSING_VALUE || objectHashSet.contains(t2)) continue;
            if (objectHashSet2 == null) {
                objectHashSet2 = new ObjectHashSet<T>(this.size);
            }
            objectHashSet2.add(t2);
        }
        return objectHashSet2;
    }

    @Override
    public boolean removeAll(Collection<?> collection) {
        return ObjectHashSet.disjunction(collection, this::remove);
    }

    @Override
    public boolean removeAll(ObjectHashSet<T> objectHashSet) {
        boolean bl2 = false;
        for (T t2 : objectHashSet.values) {
            if (t2 == MISSING_VALUE) continue;
            bl2 |= this.remove(t2);
        }
        return bl2;
    }

    private static <T> boolean disjunction(Collection<T> collection, Predicate<T> predicate) {
        boolean bl2 = false;
        for (T t2 : collection) {
            bl2 |= predicate.test(t2);
        }
        return bl2;
    }

    public ObjectIterator iterator() {
        ObjectIterator objectIterator = this.iterator;
        if (null == objectIterator) {
            objectIterator = new ObjectIterator();
            if (this.shouldAvoidAllocation) {
                this.iterator = objectIterator;
            }
        }
        return objectIterator.reset();
    }

    public void copy(ObjectHashSet<T> objectHashSet) {
        if (this.values.length != objectHashSet.values.length) {
            throw new IllegalArgumentException("cannot copy object: lengths not equal");
        }
        System.arraycopy(objectHashSet.values, 0, this.values, 0, this.values.length);
        this.size = objectHashSet.size;
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        for (T t2 : this.values) {
            if (t2 == MISSING_VALUE) continue;
            stringBuilder.append(t2).append(", ");
        }
        if (stringBuilder.length() > 1) {
            stringBuilder.setLength(stringBuilder.length() - 2);
        }
        stringBuilder.append('}');
        return stringBuilder.toString();
    }

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (object instanceof ObjectHashSet) {
            ObjectHashSet objectHashSet = (ObjectHashSet)object;
            return objectHashSet.size == this.size && this.containsAll(objectHashSet);
        }
        if (!(object instanceof Set)) {
            return false;
        }
        Set set = (Set)object;
        if (set.size() != this.size()) {
            return false;
        }
        try {
            return this.containsAll(set);
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        for (T t2 : this.values) {
            if (t2 == MISSING_VALUE) continue;
            n2 += t2.hashCode();
        }
        return n2;
    }

    @Override
    public void forEach(Consumer<? super T> consumer) {
        int n2 = this.size;
        int n3 = this.values.length;
        for (int i2 = 0; n2 > 0 && i2 < n3; ++i2) {
            if (null == this.values[i2]) continue;
            consumer.accept(this.values[i2]);
            --n2;
        }
    }

    public final class ObjectIterator
    implements Iterator<T> {
        private int remaining;
        private int positionCounter;
        private int stopCounter;
        private boolean isPositionValid = false;

        ObjectIterator reset() {
            int n2;
            this.remaining = ObjectHashSet.this.size;
            T[] TArray = ObjectHashSet.this.values;
            int n3 = n2 = TArray.length;
            if (TArray[n2 - 1] != MISSING_VALUE) {
                for (n3 = 0; n3 < n2 && TArray[n3] != MISSING_VALUE; ++n3) {
                }
            }
            this.stopCounter = n3;
            this.positionCounter = n3 + n2;
            this.isPositionValid = false;
            return this;
        }

        public int remaining() {
            return this.remaining;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        @Override
        public T next() {
            return this.nextValue();
        }

        public T nextValue() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            T[] TArray = ObjectHashSet.this.values;
            int n2 = TArray.length - 1;
            this.isPositionValid = false;
            for (int i2 = this.positionCounter - 1; i2 >= this.stopCounter; --i2) {
                int n3 = i2 & n2;
                Object t2 = TArray[n3];
                if (t2 == MISSING_VALUE) continue;
                this.positionCounter = i2;
                this.isPositionValid = true;
                --this.remaining;
                return t2;
            }
            throw new IllegalStateException();
        }

        @Override
        public void remove() {
            int n2;
            if (this.isPositionValid) {
                T[] TArray = ObjectHashSet.this.values;
                n2 = this.position(TArray);
                TArray[n2] = MISSING_VALUE;
                --ObjectHashSet.this.size;
            } else {
                throw new IllegalStateException();
            }
            ObjectHashSet.this.compactChain(n2);
            this.isPositionValid = false;
        }

        private int position(T[] TArray) {
            return this.positionCounter & TArray.length - 1;
        }
    }
}

