/*
 * Decompiled with CFR 0.152.
 */
package org.agrona;

import java.nio.ByteBuffer;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.collections.ArrayUtil;
import org.agrona.concurrent.UnsafeBuffer;

public class ExpandableRingBuffer {
    public static final int MAX_CAPACITY = 0x40000000;
    public static final int HEADER_ALIGNMENT = 8;
    public static final int HEADER_LENGTH = 8;
    private static final int MESSAGE_LENGTH_OFFSET = 0;
    private static final int MESSAGE_TYPE_OFFSET = 4;
    private static final int MESSAGE_TYPE_PADDING = 0;
    private static final int MESSAGE_TYPE_DATA = 1;
    private final int maxCapacity;
    private int capacity;
    private int mask;
    private long head;
    private long tail;
    private final UnsafeBuffer buffer = new UnsafeBuffer();
    private final boolean isDirect;

    public ExpandableRingBuffer() {
        this(0, 0x40000000, true);
    }

    public ExpandableRingBuffer(int n2, int n3, boolean bl2) {
        this.isDirect = bl2;
        this.maxCapacity = n3;
        if (n3 < 0 || n3 > 0x40000000 || !BitUtil.isPowerOfTwo(n3)) {
            throw new IllegalArgumentException("illegal max capacity: " + n3);
        }
        if (0 == n2) {
            this.buffer.wrap(ArrayUtil.EMPTY_BYTE_ARRAY);
            return;
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("initial capacity < 0 : " + n2);
        }
        this.capacity = BitUtil.findNextPositivePowerOfTwo(n2);
        if (this.capacity < 0) {
            throw new IllegalArgumentException("invalid initial capacity: " + n2);
        }
        this.mask = this.capacity - 1;
        this.buffer.wrap(bl2 ? ByteBuffer.allocateDirect(this.capacity) : ByteBuffer.allocate(this.capacity));
    }

    public boolean isDirect() {
        return this.isDirect;
    }

    public int maxCapacity() {
        return this.maxCapacity;
    }

    public int capacity() {
        return this.capacity;
    }

    public int size() {
        return (int)(this.tail - this.head);
    }

    public boolean isEmpty() {
        return this.head == this.tail;
    }

    public long head() {
        return this.head;
    }

    public long tail() {
        return this.tail;
    }

    public void reset(int n2) {
        if (n2 < 0) {
            throw new IllegalArgumentException("required capacity <= 0 : " + n2);
        }
        int n3 = BitUtil.findNextPositivePowerOfTwo(n2);
        if (n3 < 0) {
            throw new IllegalArgumentException("invalid required capacity: " + n2);
        }
        if (n3 > this.maxCapacity) {
            throw new IllegalArgumentException("requiredCapacity=" + n2 + " > maxCapacity=" + this.maxCapacity);
        }
        if (n3 != this.capacity) {
            this.capacity = n3;
            this.mask = n3 == 0 ? 0 : n3 - 1;
            this.buffer.wrap(this.isDirect ? ByteBuffer.allocateDirect(n3) : ByteBuffer.allocate(n3));
        }
        this.head = 0L;
        this.tail = 0L;
    }

    public int forEach(MessageConsumer messageConsumer, int n2) {
        long l2 = this.head;
        int n3 = 0;
        while (n3 < n2 && l2 < this.tail) {
            int n4 = (int)l2 & this.mask;
            int n5 = this.buffer.getInt(n4 + 0);
            int n6 = this.buffer.getInt(n4 + 4);
            int n7 = BitUtil.align(n5, 8);
            l2 += (long)n7;
            if (0 == n6) continue;
            int n8 = (int)(l2 - this.head);
            if (!messageConsumer.onMessage(this.buffer, n4 + 8, n5 - 8, n8)) break;
            ++n3;
        }
        return (int)(l2 - this.head);
    }

    public int forEach(int n2, MessageConsumer messageConsumer, int n3) {
        long l2;
        if (n2 < 0 || n2 > this.size()) {
            throw new IllegalArgumentException("size=" + this.size() + " : headOffset=" + n2);
        }
        if (!BitUtil.isAligned(n2, 8)) {
            throw new IllegalArgumentException(n2 + " not aligned to 8");
        }
        long l3 = l2 = this.head + (long)n2;
        int n4 = 0;
        while (n4 < n3 && l3 < this.tail) {
            int n5 = (int)l3 & this.mask;
            int n6 = this.buffer.getInt(n5 + 0);
            int n7 = this.buffer.getInt(n5 + 4);
            int n8 = BitUtil.align(n6, 8);
            l3 += (long)n8;
            if (0 == n7) continue;
            int n9 = (int)(l3 - this.head);
            if (!messageConsumer.onMessage(this.buffer, n5 + 8, n6 - 8, n9)) break;
            ++n4;
        }
        return (int)(l3 - l2);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int consume(MessageConsumer messageConsumer, int n2) {
        int n3;
        int n4 = 0;
        long l2 = this.head;
        try {
            while (n4 < n2 && l2 < this.tail) {
                int n5 = (int)l2 & this.mask;
                int n6 = this.buffer.getInt(n5 + 0);
                int n7 = this.buffer.getInt(n5 + 4);
                int n8 = BitUtil.align(n6, 8);
                l2 += (long)n8;
                if (0 == n7) continue;
                int n9 = (int)(l2 - this.head);
                if (!messageConsumer.onMessage(this.buffer, n5 + 8, n6 - 8, n9)) {
                    l2 -= (long)n8;
                    break;
                }
                ++n4;
            }
        }
        finally {
            n3 = (int)(l2 - this.head);
            this.head = l2;
        }
        return n3;
    }

    public boolean append(DirectBuffer directBuffer, int n2, int n3) {
        int n4;
        int n5;
        int n6 = (int)this.head & this.mask;
        int n7 = (int)this.tail & this.mask;
        int n8 = BitUtil.align(8 + n3, 8);
        if (n8 > (n5 = this.capacity - (int)(this.tail - this.head))) {
            this.resize(n8);
        } else if (n7 >= n6 && n8 > (n4 = this.capacity - n7)) {
            if (n8 <= n5 - n4) {
                this.buffer.putInt(n7 + 0, n4);
                this.buffer.putInt(n7 + 4, 0);
                this.tail += (long)n4;
            } else {
                this.resize(n8);
            }
        }
        n4 = this.capacity - (int)(this.tail - this.head);
        if (n8 > n4) {
            return false;
        }
        this.writeMessage(directBuffer, n2, n3);
        this.tail += (long)n8;
        return true;
    }

    private void resize(int n2) {
        int n3 = BitUtil.findNextPositivePowerOfTwo(this.capacity + n2);
        if (n3 < this.capacity || n3 > this.maxCapacity) {
            return;
        }
        UnsafeBuffer unsafeBuffer = new UnsafeBuffer(this.isDirect ? ByteBuffer.allocateDirect(n3) : ByteBuffer.allocate(n3));
        int n4 = (int)this.head & this.mask;
        int n5 = (int)(this.tail - this.head);
        int n6 = Math.min(n5, this.capacity - n4);
        unsafeBuffer.putBytes(0, this.buffer, n4, n6);
        int n7 = n6;
        if (n6 < n5) {
            int n8 = n5 - n6;
            unsafeBuffer.putBytes(n6, this.buffer, 0, n8);
            n7 += n8;
        }
        this.buffer.wrap(unsafeBuffer);
        this.capacity = n3;
        this.mask = n3 - 1;
        this.head = 0L;
        this.tail = n7;
    }

    private void writeMessage(DirectBuffer directBuffer, int n2, int n3) {
        int n4 = (int)this.tail & this.mask;
        this.buffer.putInt(n4 + 0, 8 + n3);
        this.buffer.putInt(n4 + 4, 1);
        this.buffer.putBytes(n4 + 8, directBuffer, n2, n3);
    }

    @FunctionalInterface
    public static interface MessageConsumer {
        public boolean onMessage(MutableDirectBuffer var1, int var2, int var3, int var4);
    }
}

