/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.math.filter.iir;

import io.fair_acc.math.filter.iir.ComplexPair;
import io.fair_acc.math.filter.iir.LayoutBase;
import io.fair_acc.math.filter.iir.PoleZeroPair;
import org.apache.commons.math3.complex.Complex;

public final class BandPassTransform {
    private BandPassTransform() {
    }

    public static void transform(double d2, double d3, LayoutBase layoutBase, LayoutBase layoutBase2) {
        Object object;
        layoutBase.reset();
        double d4 = Math.PI * 2 * d3;
        double d5 = Math.PI * 2 * d2 - d4 / 2.0;
        double d6 = d5 + d4;
        if (d5 < 1.0E-8) {
            d5 = 1.0E-8;
        }
        if (d6 > 3.141592643589793) {
            d6 = 3.141592643589793;
        }
        double d7 = Math.cos((d6 + d5) * 0.5) / Math.cos((d6 - d5) * 0.5);
        double d8 = 1.0 / Math.tan((d6 - d5) * 0.5);
        int n2 = layoutBase2.getNumPoles();
        int n3 = n2 / 2;
        for (int i2 = 0; i2 < n3; ++i2) {
            object = layoutBase2.getPair(i2);
            ComplexPair complexPair = BandPassTransform.transform(((PoleZeroPair)object).poles.first, d7, d8);
            ComplexPair complexPair2 = BandPassTransform.transform(((PoleZeroPair)object).zeros.first, d7, d8);
            layoutBase.addPoleZeroConjugatePairs(complexPair.first, complexPair2.first);
            layoutBase.addPoleZeroConjugatePairs(complexPair.second, complexPair2.second);
        }
        if ((n2 & 1) == 1) {
            ComplexPair complexPair = BandPassTransform.transform(layoutBase2.getPair((int)n3).poles.first, d7, d8);
            object = BandPassTransform.transform(layoutBase2.getPair((int)n3).zeros.first, d7, d8);
            layoutBase.add(complexPair, (ComplexPair)object);
        }
        double d9 = layoutBase2.getNormalW();
        layoutBase.setNormal(2.0 * Math.atan(Math.sqrt(Math.tan((d6 + d9) * 0.5) * Math.tan((d5 + d9) * 0.5))), layoutBase2.getNormalGain());
    }

    private static ComplexPair transform(Complex complex, double d2, double d3) {
        if (complex.isInfinite()) {
            return new ComplexPair(new Complex(-1.0), new Complex(1.0));
        }
        Complex complex2 = new Complex(1.0).add(complex).divide(new Complex(1.0).subtract(complex));
        double d4 = d2 * d2;
        double d5 = d3 * d3;
        double d6 = d2 * d3;
        double d7 = 2.0 * d6;
        Complex complex3 = new Complex(0.0).add(complex2.multiply(4.0 * (d5 * (d4 - 1.0) + 1.0)));
        complex3 = complex3.add(8.0 * (d5 * (d4 - 1.0) - 1.0));
        complex3 = complex3.multiply(complex2);
        complex3 = complex3.add(4.0 * (d5 * (d4 - 1.0) + 1.0));
        complex3 = complex3.sqrt();
        Complex complex4 = complex3.multiply(-1).add(complex2.multiply(d7)).add(d7);
        complex3 = complex3.add(complex2.multiply(d7)).add(d7);
        Complex complex5 = new Complex(0.0).add(complex2.multiply(2.0 * (d3 - 1.0))).add(2.0 * (1.0 + d3));
        return new ComplexPair(complex4.divide(complex5), complex3.divide(complex5));
    }
}

