/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.utils.trees;

import io.fair_acc.dataset.utils.trees.AbstractSet;
import java.io.Serializable;
import java.util.AbstractCollection;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.Set;

public abstract class AbstractMap<K, V>
implements Map<K, V> {
    volatile transient Set<K> keySet = null;
    volatile transient Collection<V> values = null;

    protected AbstractMap() {
    }

    @Override
    public void clear() {
        this.entrySet().clear();
    }

    protected Object clone() throws CloneNotSupportedException {
        AbstractMap abstractMap = (AbstractMap)super.clone();
        abstractMap.keySet = null;
        abstractMap.values = null;
        return abstractMap;
    }

    @Override
    public boolean containsKey(Object object) {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                if (entry.getKey() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                if (!object.equals(entry.getKey())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean containsValue(Object object) {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                if (entry.getValue() != null) continue;
                return true;
            }
        } else {
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                if (!object.equals(entry.getValue())) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public abstract Set<Map.Entry<K, V>> entrySet();

    @Override
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Map)) {
            return false;
        }
        Map map = (Map)object;
        if (map.size() != this.size()) {
            return false;
        }
        try {
            for (Map.Entry<K, V> entry : this.entrySet()) {
                K k2 = entry.getKey();
                V v2 = entry.getValue();
                if (!(v2 == null ? map.get(k2) != null || !map.containsKey(k2) : !v2.equals(map.get(k2)))) continue;
                return false;
            }
        }
        catch (ClassCastException | NullPointerException runtimeException) {
            return false;
        }
        return true;
    }

    @Override
    public V get(Object object) {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        if (object == null) {
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                if (entry.getKey() != null) continue;
                return entry.getValue();
            }
        } else {
            while (iterator.hasNext()) {
                Map.Entry<K, V> entry = iterator.next();
                if (!object.equals(entry.getKey())) continue;
                return entry.getValue();
            }
        }
        return null;
    }

    @Override
    public int hashCode() {
        int n2 = 0;
        for (Map.Entry<K, V> entry : this.entrySet()) {
            n2 += entry.hashCode();
        }
        return n2;
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    @Override
    public Set<K> keySet() {
        if (this.keySet == null) {
            this.keySet = new AbstractSet<K>(){

                @Override
                public boolean contains(Object object) {
                    return AbstractMap.this.containsKey(object);
                }

                @Override
                public Iterator<K> iterator() {
                    return new Iterator<K>(){
                        private final Iterator<Map.Entry<K, V>> i;
                        {
                            this.i = AbstractMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public K next() {
                            return this.i.next().getKey();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return AbstractMap.this.size();
                }
            };
        }
        return this.keySet;
    }

    @Override
    public V put(K k2, V v2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(Map<? extends K, ? extends V> map) {
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    @Override
    public V remove(Object object) {
        Map.Entry<K, V> entry;
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        Map.Entry<K, V> entry2 = null;
        if (object == null) {
            while (entry2 == null && iterator.hasNext()) {
                entry = iterator.next();
                if (entry.getKey() != null) continue;
                entry2 = entry;
            }
        } else {
            while (entry2 == null && iterator.hasNext()) {
                entry = iterator.next();
                if (!object.equals(entry.getKey())) continue;
                entry2 = entry;
            }
        }
        entry = null;
        if (entry2 != null) {
            entry = entry2.getValue();
            iterator.remove();
        }
        return (V)entry;
    }

    @Override
    public int size() {
        return this.entrySet().size();
    }

    public String toString() {
        Iterator<Map.Entry<K, V>> iterator = this.entrySet().iterator();
        if (!iterator.hasNext()) {
            return "{}";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append('{');
        while (true) {
            Map.Entry<K, V> entry = iterator.next();
            K k2 = entry.getKey();
            V v2 = entry.getValue();
            stringBuilder.append((Object)(k2 == this ? "(this Map)" : k2));
            stringBuilder.append('=');
            stringBuilder.append((Object)(v2 == this ? "(this Map)" : v2));
            if (!iterator.hasNext()) {
                return stringBuilder.append('}').toString();
            }
            stringBuilder.append(", ");
        }
    }

    @Override
    public Collection<V> values() {
        if (this.values == null) {
            this.values = new AbstractCollection<V>(){

                @Override
                public boolean contains(Object object) {
                    return AbstractMap.this.containsValue(object);
                }

                @Override
                public Iterator<V> iterator() {
                    return new Iterator<V>(){
                        private final Iterator<Map.Entry<K, V>> i;
                        {
                            this.i = AbstractMap.this.entrySet().iterator();
                        }

                        @Override
                        public boolean hasNext() {
                            return this.i.hasNext();
                        }

                        @Override
                        public V next() {
                            return this.i.next().getValue();
                        }

                        @Override
                        public void remove() {
                            this.i.remove();
                        }
                    };
                }

                @Override
                public int size() {
                    return AbstractMap.this.size();
                }
            };
        }
        return this.values;
    }

    public static class SimpleImmutableEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = 7138329143949025153L;
        private final K key;
        private final V value;

        public SimpleImmutableEntry(Map.Entry<? extends K, ? extends V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        public SimpleImmutableEntry(K k2, V v2) {
            this.key = k2;
            this.value = v2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return Objects.equals(this.key, entry.getKey()) && Objects.equals(this.value, entry.getValue());
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @Override
        public V setValue(V v2) {
            throw new UnsupportedOperationException();
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }

    public static class SimpleEntry<K, V>
    implements Map.Entry<K, V>,
    Serializable {
        private static final long serialVersionUID = -8499721149061103585L;
        private final K key;
        private V value;

        public SimpleEntry(Map.Entry<? extends K, ? extends V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        public SimpleEntry(K k2, V v2) {
            this.key = k2;
            this.value = v2;
        }

        @Override
        public boolean equals(Object object) {
            if (!(object instanceof Map.Entry)) {
                return false;
            }
            Map.Entry entry = (Map.Entry)object;
            return Objects.equals(this.key, entry.getKey()) && Objects.equals(this.value, entry.getValue());
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public int hashCode() {
            return (this.key == null ? 0 : this.key.hashCode()) ^ (this.value == null ? 0 : this.value.hashCode());
        }

        @Override
        public V setValue(V v2) {
            V v3 = this.value;
            this.value = v2;
            return v3;
        }

        public String toString() {
            return this.key + "=" + this.value;
        }
    }
}

