/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.testdata.spi;

import io.fair_acc.dataset.AxisDescription;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.DataSetError;
import io.fair_acc.dataset.events.BitState;
import io.fair_acc.dataset.locks.DataSetLock;
import io.fair_acc.dataset.locks.DefaultDataSetLock;
import io.fair_acc.dataset.spi.DefaultAxisDescription;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.Collections;
import java.util.List;

public class ErrorTestDataSet
implements DataSetError {
    private final int nSamples;
    private final ErrorType errorType;
    private final DataSetLock<ErrorTestDataSet> lock = new DefaultDataSetLock<ErrorTestDataSet>(this);
    private final BitState state = BitState.initDirty(this);
    private static final double STEP = 0.4;
    private static final int N_STEP_SWEEP = 10;
    private static final int SWEEP_STEPS = 55;
    private static final double OMEGA = 0.1;
    private static final double AMPLITUDE = 3.2;
    private static final double X_ERR_POS = 0.2;
    private static final double X_ERR_NEG = 0.75;
    private static final double Y_ERR_POS = 1.1;
    private static final double Y_ERR_NEG = 2.85;

    public ErrorTestDataSet(int n2, ErrorType errorType) {
        this.nSamples = n2;
        this.errorType = errorType;
    }

    @Override
    public double get(int n2, int n3) {
        switch (n2) {
            case 0: {
                return 0.4 * (double)(55 * (n3 / 10) + n3 % 10 * (n3 % 10 + 1) / 2);
            }
            case 1: {
                return 3.2 * Math.sin(this.get(0, n3) * 0.1);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public List<AxisDescription> getAxisDescriptions() {
        return List.of(this.getAxisDescription(0), this.getAxisDescription(1));
    }

    @Override
    public AxisDescription getAxisDescription(int n2) {
        switch (n2) {
            case 0: {
                return new DefaultAxisDescription(n2, "time", "s", 0.0, 0.4 * ((double)(50 * (this.nSamples / 10)) + Math.pow(this.nSamples % 10, 2.0) / 2.0));
            }
            case 1: {
                return new DefaultAxisDescription(n2, "amplitude", "V", -3.2, 3.2);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public int getDataCount() {
        return this.nSamples;
    }

    @Override
    public String getDataLabel(int n2) {
        return null;
    }

    @Override
    public boolean hasDataLabels() {
        return false;
    }

    @Override
    public int getDimension() {
        return 2;
    }

    @Override
    public int getIndex(int n2, double ... dArray) {
        if (n2 != 0) {
            throw new UnsupportedOperationException("Can only get index of X dimension");
        }
        int n3 = (int)(dArray[0] / 0.4);
        return (int)((double)(10 * (n3 / 55)) + Math.floor(Math.sqrt((double)(n3 % 55) * 2.0)));
    }

    @Override
    public String getName() {
        return "ErrorTestDataSet(n=" + this.nSamples + ",error=" + this.errorType.name() + ")";
    }

    @Override
    public List<String> getStyleClasses() {
        return Collections.emptyList();
    }

    @Override
    public DataSet addStyleClasses(String ... stringArray) {
        return this;
    }

    @Override
    public String getStyle() {
        return null;
    }

    @Override
    public String getStyle(int n2) {
        return null;
    }

    @Override
    public boolean hasStyles() {
        return false;
    }

    @Override
    public double[] getValues(int n2) {
        double[] dArray = new double[this.nSamples];
        for (int i2 = 0; i2 < this.nSamples; ++i2) {
            dArray[i2] = this.get(n2, i2);
        }
        return dArray;
    }

    public DataSetLock<ErrorTestDataSet> lock() {
        return this.lock;
    }

    @Override
    public ErrorTestDataSet recomputeLimits(int n2) {
        return this;
    }

    @Override
    public DataSet setStyle(String string) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getValue(int n2, double ... dArray) {
        AssertUtils.checkArrayDimension("x", dArray, 1);
        int n3 = this.getIndex(0, dArray);
        double d2 = this.get(0, n3);
        double d3 = this.get(n2, n3);
        int n4 = d2 < dArray[0] ? n3 + 1 : n3 - 1;
        n4 = Math.max(0, Math.min(n4, this.getDataCount() - 1));
        double d4 = this.get(n2, n4);
        if (Double.isNaN(d3) || Double.isNaN(d4)) {
            return Double.NaN;
        }
        double d5 = this.get(0, n4);
        if (d2 == d5) {
            return this.get(n2, n3);
        }
        double d6 = this.get(n2, n3);
        return d6 + (this.get(n2, n4) - d6) * (dArray[0] - d2) / (d5 - d2);
    }

    @Override
    public DataSet set(DataSet dataSet, boolean bl2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public double getErrorNegative(int n2, int n3) {
        if (this.getErrorType(n2) == DataSetError.ErrorType.SYMMETRIC) {
            return this.getErrorPositive(n2, n3);
        }
        switch (n2) {
            case 0: {
                return 0.75;
            }
            case 1: {
                return 2.85;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public double getErrorPositive(int n2, int n3) {
        switch (n2) {
            case 0: {
                return 0.2;
            }
            case 1: {
                return 1.1;
            }
        }
        throw new IndexOutOfBoundsException();
    }

    @Override
    public DataSetError.ErrorType getErrorType(int n2) {
        return this.errorType.getType(n2);
    }

    @Override
    public BitState getBitState() {
        return this.state;
    }

    public static enum ErrorType {
        X_SYM,
        XY_SYM,
        Y_SYM,
        X_ASYM,
        XY_ASYM,
        Y_ASYM,
        X_ASYM_Y_SYM,
        X_SYM_Y_ASYM,
        NO_ERRORS;


        public DataSetError.ErrorType getType(int n2) {
            switch (this) {
                case X_SYM: {
                    return n2 == 0 ? DataSetError.ErrorType.SYMMETRIC : DataSetError.ErrorType.NO_ERROR;
                }
                case XY_SYM: {
                    return DataSetError.ErrorType.SYMMETRIC;
                }
                case Y_SYM: {
                    return n2 == 1 ? DataSetError.ErrorType.SYMMETRIC : DataSetError.ErrorType.NO_ERROR;
                }
                case X_ASYM: {
                    return n2 == 0 ? DataSetError.ErrorType.ASYMMETRIC : DataSetError.ErrorType.NO_ERROR;
                }
                case XY_ASYM: {
                    return DataSetError.ErrorType.ASYMMETRIC;
                }
                case Y_ASYM: {
                    return n2 == 1 ? DataSetError.ErrorType.ASYMMETRIC : DataSetError.ErrorType.NO_ERROR;
                }
                case X_ASYM_Y_SYM: {
                    return n2 == 0 ? DataSetError.ErrorType.ASYMMETRIC : DataSetError.ErrorType.SYMMETRIC;
                }
                case X_SYM_Y_ASYM: {
                    return n2 == 0 ? DataSetError.ErrorType.SYMMETRIC : DataSetError.ErrorType.ASYMMETRIC;
                }
            }
            return DataSetError.ErrorType.NO_ERROR;
        }
    }
}

