/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi.utils;

import io.fair_acc.dataset.spi.fastutil.IntArrayList;
import io.fair_acc.dataset.spi.utils.StringHashMapList;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class StringHashMapList2
implements Map<Integer, String> {
    private static final long PARALLELISM_THRESHOLD = 1000L;
    private final IntArrayList indices = new IntArrayList(10);
    private final List<String> data = new ArrayList<String>();

    public void addValueAndShiftKeys(int n2, int n3, String string) {
        int n4 = n3 - n2;
        int[] nArray = this.indices.elements();
        int n5 = this.getLocalIndexForExternalIndex(n2);
        for (int i2 = 0; i2 < this.indices.size(); ++i2) {
            if (nArray[i2] < n2) continue;
            nArray[i2] = nArray[i2] + n4;
        }
        if (n5 >= 0) {
            throw new IllegalArgumentException("element with index " + n2 + " already exists");
        }
        this.indices.add(-n5, n2);
        this.data.add(-n5, string);
    }

    @Override
    public void clear() {
        this.indices.clear();
        this.data.clear();
    }

    @Override
    public boolean containsKey(Object object) {
        if (!(object instanceof Integer)) {
            return false;
        }
        return this.getLocalIndexForExternalIndex((Integer)object) >= 0;
    }

    @Override
    public boolean containsValue(Object object) {
        return this.data.contains(object);
    }

    @Override
    public Set<Map.Entry<Integer, String>> entrySet() {
        HashSet<Map.Entry<Integer, String>> hashSet = new HashSet<Map.Entry<Integer, String>>();
        for (int i2 = 0; i2 < this.indices.size(); ++i2) {
            hashSet.add(new AbstractMap.SimpleEntry<Integer, String>(this.indices.getInt(i2), this.data.get(i2)));
        }
        return hashSet;
    }

    public String get(int n2) {
        int n3 = this.getLocalIndexForExternalIndex(n2);
        return n3 < 0 ? null : this.data.get(n3);
    }

    @Override
    public String get(Object object) {
        if (!(object instanceof Integer)) {
            return null;
        }
        int n2 = (Integer)object;
        int n3 = this.getLocalIndexForExternalIndex(n2);
        return n3 < 0 ? null : this.data.get(n3);
    }

    private int getLocalIndexForExternalIndex(int n2) {
        int n3 = 0;
        int n4 = this.indices.size() - 1;
        while (n3 <= n4) {
            int n5 = n3 + n4 >>> 1;
            int n6 = this.indices.elements()[n5];
            if (n6 < n2) {
                n3 = n5 + 1;
                continue;
            }
            if (n6 > n2) {
                n4 = n5 - 1;
                continue;
            }
            return n5;
        }
        return -(n3 + 1);
    }

    @Override
    public boolean isEmpty() {
        return this.indices.isEmpty();
    }

    @Override
    public Set<Integer> keySet() {
        HashSet<Integer> hashSet = new HashSet<Integer>();
        this.indices.forEach(hashSet::add);
        return hashSet;
    }

    @Override
    public String put(Integer n2, String string) {
        int n3 = this.getLocalIndexForExternalIndex(n2);
        if (n3 < 0) {
            if (-n3 < this.indices.size()) {
                this.indices.add(-n3, n2);
                this.data.add(-n3, string);
            } else {
                this.indices.add(n2);
                this.data.add(string);
            }
            return null;
        }
        return this.data.set(n3, string);
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends String> map) {
    }

    public void remove(int n2, int n3) {
        int n4 = n3 - n2;
        for (int i2 = 0; i2 < n4; ++i2) {
            this.remove(n3 + i2);
        }
    }

    @Override
    public String remove(Object object) {
        if (!(object instanceof Integer)) {
            return null;
        }
        int n2 = this.getLocalIndexForExternalIndex((Integer)object);
        if (n2 < 0) {
            return null;
        }
        String string = this.data.get(n2);
        this.indices.removeInt(n2);
        this.data.remove(n2);
        return string;
    }

    public void setAll(StringHashMapList stringHashMapList) {
        this.clear();
        stringHashMapList.forEachEntry(1000L, entry -> {
            String string = (String)entry.getValue();
            if (string != null && !string.isEmpty()) {
                this.put((Integer)entry.getKey(), string);
            }
        });
    }

    public void shiftKeys(int n2, int n3) {
        if (this.indices.isEmpty()) {
            return;
        }
        int n4 = n3 - n2;
        int[] nArray = this.indices.elements();
        for (int i2 = 0; i2 < this.indices.size(); ++i2) {
            nArray[i2] = nArray[i2] + n4;
        }
    }

    @Override
    public int size() {
        return this.indices.size();
    }

    @Override
    public Collection<String> values() {
        return this.data;
    }
}

