/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.dataset.spi;

import io.fair_acc.dataset.DataSetError;
import io.fair_acc.dataset.spi.AbstractDataSet;
import io.fair_acc.dataset.spi.DataRange;

public abstract class AbstractErrorDataSet<D extends AbstractErrorDataSet<D>>
extends AbstractDataSet<D>
implements DataSetError {
    private static final long serialVersionUID = -5592816592868472957L;
    private final DataSetError.ErrorType[] errorType;

    protected AbstractErrorDataSet(String string, int n2, DataSetError.ErrorType ... errorTypeArray) {
        super(string, n2);
        this.errorType = errorTypeArray;
    }

    @Override
    public DataSetError.ErrorType getErrorType(int n2) {
        return this.errorType[n2];
    }

    @Override
    protected D getThis() {
        return (D)this;
    }

    public D recomputeLimits(int n2) {
        DataRange dataRange = new DataRange();
        int n3 = this.getDataCount();
        switch (this.getErrorType(n2)) {
            case NO_ERROR: {
                super.recomputeLimits(n2);
                break;
            }
            case ASYMMETRIC: {
                for (int i2 = 0; i2 < n3; ++i2) {
                    double d2 = this.get(n2, i2);
                    double d3 = this.getErrorNegative(n2, i2);
                    double d4 = this.getErrorPositive(n2, i2);
                    dataRange.add(d2 - d3);
                    dataRange.add(d2 + d4);
                }
                this.getAxisDescription(n2).set(dataRange.getMin(), dataRange.getMax());
                break;
            }
            default: {
                for (int i3 = 0; i3 < n3; ++i3) {
                    double d5 = this.get(n2, i3);
                    double d6 = this.getErrorPositive(n2, i3);
                    dataRange.add(d5 - d6);
                    dataRange.add(d5 + d6);
                }
                this.getAxisDescription(n2).set(dataRange.getMin(), dataRange.getMax());
            }
        }
        return (D)this.getThis();
    }

    public D setErrorType(int n2, DataSetError.ErrorType errorType) {
        this.errorType[n2] = errorType;
        return (D)this.getThis();
    }
}

