/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.utils;

import java.text.DecimalFormat;
import javafx.util.StringConverter;

public class PercentageStringConverter
extends StringConverter<Number> {
    private int precision = 1;
    private boolean appendPercentSign = true;
    private final DecimalFormat format = new DecimalFormat();

    public PercentageStringConverter() {
        this.buildFormat(this.precision);
    }

    public PercentageStringConverter(int n2) {
        this.precision = n2;
        this.buildFormat(n2);
    }

    public PercentageStringConverter(int n2, boolean bl2) {
        this.precision = n2;
        this.appendPercentSign = bl2;
        this.buildFormat(n2);
    }

    private void buildFormat(int n2) {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append('0');
        if (n2 > 0) {
            stringBuilder.append('.');
            stringBuilder.append("0".repeat(n2));
        }
        this.format.applyPattern(stringBuilder.toString());
    }

    public Number fromString(String string) {
        String string2 = string;
        int n2 = string2.indexOf(37);
        if (n2 > 0) {
            string2 = string2.substring(0, n2);
        }
        return Double.parseDouble(string2);
    }

    public int getPrecision() {
        return this.precision;
    }

    public boolean isAppendPercentSign() {
        return this.appendPercentSign;
    }

    public void setAppendPercentSign(boolean bl2) {
        this.appendPercentSign = bl2;
    }

    public void setPrecision(int n2) {
        this.precision = n2;
        this.buildFormat(n2);
    }

    public String toString(Number number) {
        return this.format.format(number.doubleValue() * 100.0) + (this.appendPercentSign ? "%" : "");
    }
}

