/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.utils;

import java.text.DecimalFormat;
import javafx.util.StringConverter;

public class MemorySizeStringConverter
extends StringConverter<Number> {
    private int precision = 1;
    private Unit unit = Unit.BEST;
    private final DecimalFormat format = new DecimalFormat();

    public MemorySizeStringConverter() {
        this.buildFormat(this.precision);
    }

    public MemorySizeStringConverter(int n2) {
        this.precision = n2;
        this.buildFormat(n2);
    }

    public MemorySizeStringConverter(Unit unit) {
        this.unit = unit;
        this.buildFormat(this.precision);
    }

    public MemorySizeStringConverter(Unit unit, int n2) {
        this.unit = unit;
        this.precision = n2;
        this.buildFormat(n2);
    }

    private void buildFormat(int n2) {
        StringBuilder stringBuilder = new StringBuilder(32);
        stringBuilder.append("0.");
        stringBuilder.append("0".repeat(Math.max(0, n2)));
        this.format.applyPattern(stringBuilder.toString());
    }

    public Number fromString(String string) {
        throw new UnsupportedOperationException("Parsing memory size string not implemented yet");
    }

    public int getPrecision() {
        return this.precision;
    }

    public Unit getUnit() {
        return this.unit;
    }

    public void setPrecision(int n2) {
        this.precision = n2;
        this.buildFormat(n2);
    }

    public void setUnit(Unit unit) {
        this.unit = unit;
    }

    public String toString(Number number) {
        double d2 = number.doubleValue();
        return this.format.format(d2) + (switch (this.unit) {
            case Unit.BEST -> {
                if (d2 < 1000.0) {
                    yield "B";
                }
                if (d2 < 1000000.0) {
                    d2 /= 1000.0;
                    yield "kB";
                }
                if (d2 < 1.0E9) {
                    d2 /= 1000000.0;
                    yield "MB";
                }
                d2 /= 1.0E9;
                yield "GB";
            }
            case Unit.KILOBYTE -> {
                d2 /= 1000.0;
                yield "kB";
            }
            case Unit.MEGABYTE -> {
                d2 /= 1000000.0;
                yield "MB";
            }
            case Unit.GIGABYTE -> {
                d2 /= 1.0E9;
                yield "GB";
            }
            default -> "B";
        });
    }

    public static enum Unit {
        BEST,
        BYTE,
        KILOBYTE,
        MEGABYTE,
        GIGABYTE;

    }
}

