/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.ui.css;

import io.fair_acc.chartfx.renderer.spi.AbstractRenderer;
import io.fair_acc.chartfx.ui.css.DataSetNodeParameter;
import io.fair_acc.chartfx.ui.css.StyleUtil;
import io.fair_acc.chartfx.utils.PropUtil;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.events.BitState;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.events.EventSource;
import io.fair_acc.dataset.utils.AssertUtils;
import java.util.Objects;
import java.util.function.IntSupplier;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;

public class DataSetNode
extends DataSetNodeParameter
implements EventSource {
    private final ObservableList<String> currentUserStyles = FXCollections.observableArrayList();
    private final DataSet dataSet;
    private final AbstractRenderer<?> renderer;

    public DataSetNode(AbstractRenderer<?> abstractRenderer, DataSet dataSet) {
        this.renderer = AssertUtils.notNull("renderer", abstractRenderer);
        this.dataSet = AssertUtils.notNull("dataSet", dataSet);
        StyleUtil.styleNode(this, this.getDefaultColorClass(), "dataset");
        PropUtil.runOnChange(() -> this.getStyleClass().set(0, (Object)this.getDefaultColorClass()), new ObservableValue[]{this.colorIndexProperty()});
        this.setName(dataSet.getName());
        this.setStyle(dataSet.getStyle());
        this.currentUserStyles.setAll(dataSet.getStyleClasses());
        this.getStyleClass().addAll(this.currentUserStyles);
        this.changeCounterProperty().addListener(dataSet.getBitState().onPropChange(ChartBits.ChartCanvas, new IntSupplier[0])::set);
    }

    protected String getDefaultColorClass() {
        return DataSetNode.getDefaultColorClass(this.getColorIndex());
    }

    public static String getDefaultColorClass(int n2) {
        return DefaultColorClass.getForIndex(n2);
    }

    public void runPreLayout() {
        BitState bitState = this.dataSet.getBitState();
        if (bitState.isClean(ChartBits.DataSetName, ChartBits.DataSetStyle)) {
            return;
        }
        if (bitState.isDirty(ChartBits.DataSetName) && !this.nameProperty().isBound() && !Objects.equals(this.getName(), this.dataSet.getName())) {
            this.setName(this.dataSet.getName());
        }
        if (bitState.isDirty(ChartBits.DataSetStyle)) {
            if (!this.currentUserStyles.equals(this.dataSet.getStyleClasses())) {
                this.getStyleClass().removeAll(this.currentUserStyles);
                this.currentUserStyles.setAll(this.dataSet.getStyleClasses());
                this.getStyleClass().addAll(this.currentUserStyles);
            }
            if (!Objects.equals(this.getStyle(), this.dataSet.getStyle())) {
                this.setStyle(this.dataSet.getStyle());
            }
        }
    }

    @Override
    public BitState getBitState() {
        return this.dataSet.getBitState();
    }

    public DataSet getDataSet() {
        return this.dataSet;
    }

    public AbstractRenderer<?> getRenderer() {
        return this.renderer;
    }

    static class DefaultColorClass {
        private static final String[] precomputed = new String[20];

        DefaultColorClass() {
        }

        public static String getForIndex(int n2) {
            if (n2 >= 0 && n2 < precomputed.length) {
                return precomputed[n2];
            }
            return DefaultColorClass.createDefaultClass(n2);
        }

        private static String createDefaultClass(int n2) {
            return "default-color" + n2;
        }

        static {
            for (int i2 = 0; i2 < precomputed.length; ++i2) {
                DefaultColorClass.precomputed[i2] = DefaultColorClass.createDefaultClass(i2);
            }
        }
    }
}

