/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.renderer.spi;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.renderer.Renderer;
import io.fair_acc.chartfx.ui.css.CssPropertyFactory;
import io.fair_acc.chartfx.ui.css.DataSetNode;
import io.fair_acc.chartfx.ui.css.StyleUtil;
import io.fair_acc.chartfx.utils.PropUtil;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.events.ChartBits;
import io.fair_acc.dataset.utils.NoDuplicatesList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Set;
import java.util.function.IntSupplier;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javafx.css.CssMetaData;
import javafx.css.Styleable;
import javafx.css.StyleableBooleanProperty;
import javafx.geometry.Orientation;
import javafx.scene.Node;
import javafx.scene.Parent;

public abstract class AbstractRenderer<R extends Renderer>
extends Parent
implements Renderer {
    protected final StyleableBooleanProperty showInLegend = this.css().createBooleanProperty(this, "showInLegend", true, new Runnable[0]);
    protected final StyleableBooleanProperty useGlobalColorIndex = this.css().createBooleanProperty(this, "useGlobalColorIndex", true, new Runnable[0]);
    protected final IntegerProperty globalIndexOffset = new SimpleIntegerProperty((Object)this, "globalIndexOffset", 0);
    protected final IntegerProperty localIndexOffset = this.css().createIntegerProperty(this, "localIndexOffset", 0, new Runnable[0]);
    protected final IntegerProperty colorCount = this.css().createIntegerProperty(this, "colorCount", 8, true, null, new Runnable[0]);
    private final ObservableList<DataSet> datasets = FXCollections.observableArrayList();
    private final ObservableList<DataSetNode> dataSetNodes = FXCollections.observableArrayList();
    private final ObservableList<DataSetNode> readOnlyDataSetNodes = FXCollections.unmodifiableObservableList(this.dataSetNodes);
    private final ObservableList<Axis> axesList = FXCollections.observableList(new NoDuplicatesList());
    private final ObjectProperty<Chart> chart = new SimpleObjectProperty();
    private final Set<DataSet> distinctDataSets = Collections.newSetFromMap(new IdentityHashMap());
    private static final CssPropertyFactory<AbstractRenderer<?>> CSS = new CssPropertyFactory(Parent.getClassCssMetaData());

    protected DataSetNode createNode(DataSet dataSet) {
        for (DataSetNode dataSetNode : this.dataSetNodes) {
            if (dataSetNode.getDataSet() != dataSet) continue;
            return dataSetNode;
        }
        return new DataSetNode(this, dataSet);
    }

    public AbstractRenderer() {
        StyleUtil.addStyles(this, "renderer");
        PropUtil.runOnChange(() -> this.fireInvalidated(ChartBits.ChartLegend), new ObservableValue[]{this.showInLegend});
        this.dataSetNodes.addListener(change -> this.getChildren().setAll(this.dataSetNodes));
        this.datasets.addListener(change -> this.updateNodes());
        this.dataSetNodes.addListener(change -> this.updateIndices());
        PropUtil.runOnChange(this::updateIndices, new ObservableValue[]{this.useGlobalColorIndex, this.globalIndexOffset, this.localIndexOffset, this.colorCount});
    }

    protected void updateNodes() {
        ArrayList<DataSetNode> arrayList = new ArrayList<DataSetNode>(this.datasets.size());
        this.distinctDataSets.clear();
        for (DataSet dataSet : this.datasets) {
            if (!this.distinctDataSets.add(dataSet)) continue;
            arrayList.add(this.createNode(dataSet));
        }
        this.distinctDataSets.clear();
        this.dataSetNodes.setAll(arrayList);
    }

    protected void updateIndices() {
        int n2 = this.getLocalIndexOffset();
        int n3 = this.getGlobalIndexOffset() + n2;
        int n4 = this.useGlobalColorIndex.get() ? n3 : n2;
        int n5 = this.getColorCount();
        for (DataSetNode dataSetNode : this.getDatasetNodes()) {
            dataSetNode.setLocalIndex(n2++);
            dataSetNode.setGlobalIndex(n3++);
            dataSetNode.setColorIndex(n4++ % n5);
        }
    }

    @Override
    public ObservableList<Axis> getAxes() {
        return this.axesList;
    }

    @Override
    public ObservableList<DataSet> getDatasets() {
        return this.datasets;
    }

    @Override
    public ObservableList<DataSetNode> getDatasetNodes() {
        return this.readOnlyDataSetNodes;
    }

    protected ObservableList<DataSetNode> getInternalDataSetNodes() {
        return this.dataSetNodes;
    }

    public Axis getFirstAxis(Orientation orientation) {
        block3: for (Axis axis : this.getAxes()) {
            if (axis.getSide() == null) continue;
            switch (orientation) {
                case VERTICAL: {
                    if (!axis.getSide().isVertical()) continue block3;
                    return axis;
                }
            }
            if (!axis.getSide().isHorizontal()) continue;
            return axis;
        }
        return null;
    }

    protected Axis getFirstAxis(Orientation orientation, Chart chart) {
        Axis axis = this.getFirstAxis(orientation);
        if (axis == null) {
            return chart.getFirstAxis(orientation);
        }
        return axis;
    }

    protected abstract R getThis();

    public Chart getChart() {
        return (Chart)this.chart.get();
    }

    public ObjectProperty<Chart> chartProperty() {
        return this.chart;
    }

    @Override
    public void setChart(Chart chart) {
        this.chart.set((Object)chart);
    }

    public R setShowInLegend(boolean bl2) {
        this.showInLegend.set(bl2);
        return this.getThis();
    }

    @Override
    public boolean showInLegend() {
        return this.showInLegend.get();
    }

    @Override
    public final BooleanProperty showInLegendProperty() {
        return this.showInLegend;
    }

    @Override
    public int getGlobalIndexOffset() {
        return this.globalIndexOffset.get();
    }

    public ReadOnlyIntegerProperty globalIndexOffsetProperty() {
        return this.globalIndexOffset;
    }

    @Override
    public void setGlobalIndexOffset(int n2) {
        this.globalIndexOffset.set(n2);
    }

    public int getLocalIndexOffset() {
        return this.localIndexOffset.get();
    }

    public IntegerProperty localIndexOffsetProperty() {
        return this.localIndexOffset;
    }

    public void setLocalIndexOffset(int n2) {
        this.localIndexOffset.set(n2);
    }

    public boolean isUseGlobalColorIndex() {
        return this.useGlobalColorIndex.get();
    }

    public BooleanProperty useGlobalColorIndexProperty() {
        return this.useGlobalColorIndex;
    }

    public void setUseGlobalColorIndex(boolean bl2) {
        this.useGlobalColorIndex.set(bl2);
    }

    public int getColorCount() {
        return this.colorCount.get();
    }

    public IntegerProperty colorCountProperty() {
        return this.colorCount;
    }

    public void setColorCount(int n2) {
        this.colorCount.set(n2);
    }

    protected <T extends Property<?>> T registerCanvasProp(T t2) {
        PropUtil.runOnChange(this::invalidateCanvas, new ObservableValue[]{t2});
        return t2;
    }

    protected void invalidateCanvas() {
        this.fireInvalidated(ChartBits.ChartCanvas);
    }

    protected void fireInvalidated(IntSupplier intSupplier) {
        Chart chart = this.getChart();
        if (chart != null) {
            chart.fireInvalidated(intSupplier);
        }
    }

    @Override
    public Node getNode() {
        return this;
    }

    protected CssPropertyFactory<AbstractRenderer<?>> css() {
        return CSS;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return this.css().getCssMetaData();
    }
}

