/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.plugins.measurements;

import io.fair_acc.chartfx.Chart;
import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.AxisLabelFormatter;
import io.fair_acc.chartfx.axes.AxisMode;
import io.fair_acc.chartfx.axes.spi.DefaultNumericAxis;
import io.fair_acc.chartfx.axes.spi.MetricPrefix;
import io.fair_acc.chartfx.events.FxEventProcessor;
import io.fair_acc.chartfx.plugins.AbstractSingleValueIndicator;
import io.fair_acc.chartfx.plugins.ParameterMeasurements;
import io.fair_acc.chartfx.plugins.measurements.AbstractChartMeasurement;
import io.fair_acc.chartfx.utils.DragResizerUtil;
import io.fair_acc.chartfx.utils.FXUtils;
import io.fair_acc.dataset.DataSet;
import io.fair_acc.dataset.events.BitState;
import io.fair_acc.math.SimpleDataSetEstimators;
import java.util.Optional;
import javafx.scene.Node;
import javafx.scene.control.ButtonType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleMeasurements
extends AbstractChartMeasurement {
    private static final Logger LOGGER = LoggerFactory.getLogger(SimpleMeasurements.class);
    private final MeasurementType measType;

    public SimpleMeasurements(ParameterMeasurements parameterMeasurements, MeasurementType measurementType) {
        super(parameterMeasurements, measurementType.toString(), measurementType.isVertical ? AxisMode.X : AxisMode.Y, measurementType.getRequiredSelectors(), 1);
        this.measType = measurementType;
        this.setTitle(measurementType.toString());
        this.getValueField().setMinRange(Double.NEGATIVE_INFINITY).setMaxRange(Double.POSITIVE_INFINITY);
        this.addMinMaxRangeFields();
    }

    public MeasurementType getMeasType() {
        return this.measType;
    }

    public void handle() {
        DataSet dataSet = this.getDataSet();
        if (this.getValueIndicatorsUser().size() < this.measType.getRequiredSelectors() || dataSet == null) {
            return;
        }
        double d2 = this.requiredNumberOfIndicators >= 1 && !this.getValueIndicatorsUser().isEmpty() ? ((AbstractSingleValueIndicator)this.getValueIndicatorsUser().get(0)).getValue() : Double.NEGATIVE_INFINITY;
        double d3 = this.requiredNumberOfIndicators >= 2 && this.getValueIndicatorsUser().size() >= 2 ? ((AbstractSingleValueIndicator)this.getValueIndicatorsUser().get(1)).getValue() : Double.POSITIVE_INFINITY;
        dataSet.lock().readLockGuard(() -> {
            String string;
            double d4;
            String string2;
            if (!dataSet.getAxisDescription(0).isDefined()) {
                dataSet.recomputeLimits(0);
            }
            int n2 = dataSet.getIndex(0, d2);
            int n3 = dataSet.getIndex(0, d3);
            int n4 = this.requiredNumberOfIndicators == 1 ? n2 : Math.min(n2, n3);
            int n5 = Math.max(n2, n3);
            Chart chart = this.getMeasurementPlugin().getChart();
            Axis axis = SimpleMeasurements.getFirstAxisForDataSet(chart, dataSet, !this.measType.isVerticalMeasurement());
            double d5 = Double.NaN;
            switch (this.measType) {
                case MARKER_HOR: {
                    d5 = d2;
                    axis = SimpleMeasurements.getFirstAxisForDataSet(chart, dataSet, true);
                    break;
                }
                case MARKER_DISTANCE_HOR: {
                    d5 = d3 - d2;
                    axis = SimpleMeasurements.getFirstAxisForDataSet(chart, dataSet, true);
                    break;
                }
                case MARKER_VER: {
                    d5 = d2;
                    axis = SimpleMeasurements.getFirstAxisForDataSet(chart, dataSet, false);
                    break;
                }
                case MARKER_DISTANCE_VER: {
                    d5 = d3 - d2;
                    axis = SimpleMeasurements.getFirstAxisForDataSet(chart, dataSet, false);
                    break;
                }
                case VALUE_HOR: {
                    d5 = SimpleDataSetEstimators.getZeroCrossing(dataSet, d2);
                    break;
                }
                case VALUE_VER: {
                    d5 = dataSet.get(1, n4);
                    break;
                }
                case DISTANCE_HOR: {
                    d5 = SimpleDataSetEstimators.getZeroCrossing(dataSet, d3) - SimpleDataSetEstimators.getZeroCrossing(dataSet, d2);
                    break;
                }
                case DISTANCE_VER: {
                    d5 = SimpleDataSetEstimators.getDistance(dataSet, n4, n5, false);
                    break;
                }
                case MINIMUM: {
                    d5 = SimpleDataSetEstimators.getMinimum(dataSet, n4, n5);
                    break;
                }
                case MAXIMUM: {
                    d5 = SimpleDataSetEstimators.getMaximum(dataSet, n4, n5);
                    break;
                }
                case RANGE: {
                    d5 = SimpleDataSetEstimators.getRange(dataSet, n4, n5);
                    break;
                }
                case MEAN: {
                    d5 = SimpleDataSetEstimators.getMean(dataSet, n4, n5);
                    break;
                }
                case RMS: {
                    d5 = SimpleDataSetEstimators.getRms(dataSet, n4, n5);
                    break;
                }
                case MEDIAN: {
                    d5 = SimpleDataSetEstimators.getMedian(dataSet, n4, n5);
                    break;
                }
                case INTEGRAL: {
                    d5 = SimpleDataSetEstimators.getIntegral(dataSet, n2, n3);
                    break;
                }
                case INTEGRAL_FULL: {
                    d5 = SimpleDataSetEstimators.getIntegral(dataSet, 0, dataSet.getDataCount());
                    break;
                }
                case TRANSMISSION_ABS: {
                    d5 = SimpleDataSetEstimators.getTransmission(dataSet, n2, n3, true);
                    break;
                }
                case TRANSMISSION_REL: {
                    d5 = SimpleDataSetEstimators.getTransmission(dataSet, n2, n3, false);
                    break;
                }
                case EDGE_DETECT: {
                    d5 = SimpleDataSetEstimators.getEdgeDetect(dataSet, n4, n5);
                    break;
                }
                case RISETIME_10_90: {
                    d5 = SimpleDataSetEstimators.getSimpleRiseTime1090(dataSet, n4, n5);
                    break;
                }
                case RISETIME_20_80: {
                    d5 = SimpleDataSetEstimators.getSimpleRiseTime2080(dataSet, n4, n5);
                    break;
                }
                case FWHM: {
                    d5 = SimpleDataSetEstimators.getFullWidthHalfMaximum(dataSet, n4, n5, false);
                    break;
                }
                case FWHM_INTERPOLATED: {
                    d5 = SimpleDataSetEstimators.getFullWidthHalfMaximum(dataSet, n4, n5, true);
                    break;
                }
                case LOCATION_MAXIMUM: {
                    d5 = dataSet.get(0, SimpleDataSetEstimators.getLocationMaximum(dataSet, n4, n5));
                    break;
                }
                case LOCATION_MAXIMUM_GAUSS: {
                    d5 = SimpleDataSetEstimators.getLocationMaximumGaussInterpolated(dataSet, n4, n5);
                    break;
                }
                case DUTY_CYCLE: {
                    d5 = SimpleDataSetEstimators.getDutyCycle(dataSet, n4, n5);
                    break;
                }
                case PERIOD: {
                    d5 = 1.0 / SimpleDataSetEstimators.getFrequencyEstimate(dataSet, n4, n5);
                    break;
                }
                case FREQUENCY: {
                    d5 = SimpleDataSetEstimators.getFrequencyEstimate(dataSet, n4, n5);
                    break;
                }
            }
            String string3 = axis.getUnit();
            String string4 = string2 = string3 == null ? "a.u." : string3;
            if (axis instanceof DefaultNumericAxis && string3 != null) {
                d4 = axis.getUnitScaling();
                String string5 = MetricPrefix.getShortPrefix(d4);
                double d6 = d5 / d4;
                FXUtils.runFX(() -> this.getValueField().setUnit(string5 + string2));
                AxisLabelFormatter axisLabelFormatter = ((DefaultNumericAxis)axis).getAxisLabelFormatter();
                string = axisLabelFormatter.toString(d6);
            } else {
                string = Math.abs(Math.log10(Math.abs(d5))) < 3.0 ? this.formatterSmall.format(d5) : this.formatterLarge.format(d5);
                FXUtils.runFX(() -> this.getValueField().setUnit(string2));
            }
            d4 = d5;
            FXUtils.runFX(() -> this.getValueField().setValue(d4, string));
            switch (this.measType) {
                case TRANSMISSION_ABS: 
                case TRANSMISSION_REL: {
                    FXUtils.runFX(() -> this.getValueField().setUnit("%"));
                    break;
                }
            }
        });
    }

    @Override
    public void initialize() {
        this.getDataViewWindow().setContent((Node)this.getValueField());
        DragResizerUtil.makeResizable((Node)this.getValueField());
        Optional<ButtonType> optional = super.showConfigDialogue();
        if (LOGGER.isTraceEnabled()) {
            LOGGER.atTrace().addArgument(optional).log("config dialogue finished with result {}");
            LOGGER.atTrace().addArgument(this.getValueIndicators()).log("detected getValueIndicators() = {}");
            LOGGER.atTrace().addArgument(this.getValueIndicatorsUser()).log("detected getValueIndicatorsUser() = {}");
        }
        DataSet dataSet = this.getDataSet();
        BitState bitState = BitState.initDirty(dataSet, -1);
        dataSet.getBitState().addInvalidateListener(bitState);
        this.getValueIndicators().forEach(abstractSingleValueIndicator -> abstractSingleValueIndicator.valueProperty().addListener(bitState.onPropChange(-1)::set));
        this.getValueIndicators().addListener(change -> {
            while (change.next()) {
                change.getAddedSubList().forEach(abstractSingleValueIndicator -> abstractSingleValueIndicator.valueProperty().addListener(bitState.onPropChange(-1)::set));
            }
        });
        FxEventProcessor.getInstance().addAction(bitState, this::handle);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.atTrace().log("initialised and called initial handle(null)");
        }
    }

    @Override
    protected void removeAction() {
        super.removeAction();
        this.getMeasurementPlugin().getChart().invalidate();
    }

    public static enum MeasurementType {
        MARKER_HOR(true, MeasurementCategory.INDICATOR, "Marker X", 1),
        MARKER_DISTANCE_HOR(true, MeasurementCategory.INDICATOR, "Marker \u2206X"),
        MARKER_VER(false, MeasurementCategory.INDICATOR, "Marker Y", 1),
        MARKER_DISTANCE_VER(false, MeasurementCategory.INDICATOR, "Marker \u2206Y"),
        VALUE_HOR(false, MeasurementCategory.INDICATOR, "hor. value", 1),
        DISTANCE_HOR(false, MeasurementCategory.INDICATOR, "hor. distance"),
        VALUE_VER(true, MeasurementCategory.INDICATOR, "ver. value", 1),
        DISTANCE_VER(true, MeasurementCategory.INDICATOR, "ver. distance"),
        MINIMUM(true, MeasurementCategory.VERTICAL, "Minimum"),
        MAXIMUM(true, MeasurementCategory.VERTICAL, "Maximum"),
        RANGE(true, MeasurementCategory.VERTICAL, "Range"),
        MEAN(true, MeasurementCategory.VERTICAL, "Mean"),
        RMS(true, MeasurementCategory.VERTICAL, "R.M.S."),
        MEDIAN(true, MeasurementCategory.VERTICAL, "Median"),
        INTEGRAL(true, MeasurementCategory.VERTICAL, "Integral"),
        INTEGRAL_FULL(true, MeasurementCategory.VERTICAL, "Integral - full range", 0),
        TRANSMISSION_ABS(true, MeasurementCategory.ACC, "Abs. Transmission"),
        TRANSMISSION_REL(true, MeasurementCategory.ACC, "Rel. Transmission"),
        EDGE_DETECT(true, MeasurementCategory.HORIZONTAL, "Edge-Detect"),
        RISETIME_10_90(true, MeasurementCategory.HORIZONTAL, "10%-90% Rise-/Fall-Time\n (simple)"),
        RISETIME_20_80(true, MeasurementCategory.HORIZONTAL, "20%-80% Rise-/Fall-Time\n (simple)"),
        FWHM(true, MeasurementCategory.HORIZONTAL, "FWHM"),
        FWHM_INTERPOLATED(true, MeasurementCategory.HORIZONTAL, "FWHM (interp.)"),
        LOCATION_MAXIMUM(true, MeasurementCategory.HORIZONTAL, "Loc. Maximum"),
        LOCATION_MAXIMUM_GAUSS(true, MeasurementCategory.HORIZONTAL, "Loc. Maximum\n(Gauss-interp.)"),
        DUTY_CYCLE(true, MeasurementCategory.HORIZONTAL, "Duty Cycle\n(10% hysteresis)"),
        PERIOD(true, MeasurementCategory.HORIZONTAL, "Period"),
        FREQUENCY(true, MeasurementCategory.HORIZONTAL, "Frequency");

        private final String name;
        private final MeasurementCategory category;
        private final boolean isVertical;
        private final int requiredSelectors;
        private final int requiredDataSets;

        private MeasurementType(boolean bl2, MeasurementCategory measurementCategory, String string2) {
            this(bl2, measurementCategory, string2, 2);
        }

        private MeasurementType(boolean bl2, MeasurementCategory measurementCategory, String string2, int n3) {
            this.isVertical = bl2;
            this.category = measurementCategory;
            this.name = string2;
            this.requiredSelectors = n3;
            this.requiredDataSets = 1;
        }

        public MeasurementCategory getCategory() {
            return this.category;
        }

        public boolean isVerticalMeasurement() {
            return this.isVertical;
        }

        public String getName() {
            return this.name;
        }

        public int getRequiredDataSets() {
            return this.requiredDataSets;
        }

        public int getRequiredSelectors() {
            return this.requiredSelectors;
        }

        public String toString() {
            return this.name;
        }
    }

    public static enum MeasurementCategory {
        INDICATOR("Indicators"),
        VERTICAL("Vertical Measurements"),
        HORIZONTAL("Horizontal Measurements"),
        ACC("Accelerator Misc.");

        private final String name;

        private MeasurementCategory(String string2) {
            this.name = string2;
        }

        public String getName() {
            return this.name;
        }

        public String toString() {
            return this.name;
        }
    }
}

