/*
 * Decompiled with CFR 0.152.
 */
package io.fair_acc.chartfx.axes.spi;

import io.fair_acc.chartfx.axes.Axis;
import io.fair_acc.chartfx.axes.AxisTransform;
import io.fair_acc.chartfx.axes.LogAxisType;
import io.fair_acc.chartfx.axes.TickUnitSupplier;
import io.fair_acc.chartfx.axes.spi.AbstractAxis;
import io.fair_acc.chartfx.axes.spi.AxisRange;
import io.fair_acc.chartfx.axes.spi.transforms.DefaultAxisTransform;
import io.fair_acc.chartfx.axes.spi.transforms.LogarithmicAxisTransform;
import io.fair_acc.chartfx.axes.spi.transforms.LogarithmicTimeAxisTransform;
import io.fair_acc.chartfx.utils.PropUtil;
import io.fair_acc.dataset.spi.fastutil.DoubleArrayList;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultNumericAxis
extends AbstractAxis
implements Axis {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultNumericAxis.class);
    public static final double DEFAULT_LOG_MIN_VALUE = 1.0E-6;
    private static final int DEFAULT_RANGE_LENGTH = 2;
    private double offset;
    private final transient Cache cache = new Cache();
    private final transient DefaultAxisTransform linearTransform = new DefaultAxisTransform(this);
    private final transient LogarithmicAxisTransform logTransform = new LogarithmicAxisTransform(this);
    private final transient LogarithmicTimeAxisTransform logTimeTransform = new LogarithmicTimeAxisTransform(this);
    private transient AxisTransform axisTransform = this.linearTransform;
    protected boolean isUpdating;
    private final transient BooleanProperty forceZeroInRange = PropUtil.createBooleanProperty(this, "forceZeroInRange", false, this.invalidateAxisRange);
    protected boolean isLogAxis = false;
    private final transient BooleanProperty logAxis = new SimpleBooleanProperty((Object)this, "logAxis", this.isLogAxis);

    public DefaultNumericAxis() {
        this("axis label", 0.0, 0.0, 5.0);
    }

    public DefaultNumericAxis(double d2, double d3, double d4) {
        this(null, d2, d3, d4);
    }

    public DefaultNumericAxis(String string) {
        this(string, 0.0, 0.0, 5.0);
    }

    public DefaultNumericAxis(String string, double d2, double d3, double d4) {
        super(d2, d3);
        this.logAxis.addListener((observableValue, bl2, bl3) -> {
            this.isLogAxis = bl3;
            if (this.isLogAxis) {
                if (this.isTimeAxis()) {
                    this.axisTransform = this.logTimeTransform;
                    this.setMinorTickCount(0);
                } else {
                    this.axisTransform = this.logTransform;
                    this.setMinorTickCount(10);
                }
                if (this.getMin() <= 0.0) {
                    this.isUpdating = true;
                    this.setMin(1.0E-6);
                    this.isUpdating = false;
                }
            } else {
                this.axisTransform = this.linearTransform;
                if (this.isTimeAxis()) {
                    this.setMinorTickCount(0);
                } else {
                    this.setMinorTickCount(10);
                }
            }
            this.invalidateAxisRange.run();
        });
        this.setName(string);
        if (d2 >= d3) {
            this.setAutoRanging(true);
        }
        this.setTickUnit(d4);
        this.setMinorTickCount(10);
        this.isUpdating = false;
    }

    public DefaultNumericAxis(String string, String string2) {
        this(string, 0.0, 0.0, 5.0);
        this.setUnit(string2);
    }

    @Override
    public double computePreferredTickUnit(double d2) {
        double d3 = this.getTickLabelFont().getSize() * 2.0;
        int n2 = (int)Math.floor(d2 / d3);
        int n3 = Math.max(Math.min(n2, this.getMaxMajorTickLabelCount()), 2);
        double d4 = (this.getMax() - this.getMin()) / (double)n3;
        if (d4 == 0.0 || Double.isNaN(d4)) {
            d4 = 0.001;
        }
        return this.computeTickUnit(d4);
    }

    public BooleanProperty forceZeroInRangeProperty() {
        return this.forceZeroInRange;
    }

    @Override
    public AxisTransform getAxisTransform() {
        return this.axisTransform;
    }

    @Override
    public double getDisplayPosition(double d2) {
        if (this.isInvertedAxis) {
            return this.offset - this.getDisplayPositionImpl(d2);
        }
        return this.getDisplayPositionImpl(d2);
    }

    public double getLogarithmBase() {
        return this.logarithmBaseProperty().get();
    }

    @Override
    public LogAxisType getLogAxisType() {
        if (this.isLogAxis) {
            return LogAxisType.LOG10_SCALE;
        }
        return LogAxisType.LINEAR_SCALE;
    }

    @Override
    public double getValueForDisplay(double d2) {
        if (this.isInvertedAxis) {
            return this.getValueForDisplayImpl(this.offset - d2);
        }
        return this.getValueForDisplayImpl(d2);
    }

    @Override
    public double getZeroPosition() {
        if (this.isLogAxis) {
            return this.getDisplayPosition(this.cache.localCurrentLowerBound);
        }
        if (0.0 < this.cache.localCurrentLowerBound || 0.0 > this.cache.localCurrentUpperBound) {
            return Double.NaN;
        }
        return this.getDisplayPosition(0.0);
    }

    public boolean isForceZeroInRange() {
        return this.forceZeroInRangeProperty().getValue();
    }

    @Override
    public boolean isLogAxis() {
        return this.isLogAxis;
    }

    @Override
    public boolean isValueOnAxis(double d2) {
        return d2 >= this.getMin() && d2 <= this.getMax();
    }

    public DoubleProperty logarithmBaseProperty() {
        return this.logTransform.logarithmBaseProperty();
    }

    public BooleanProperty logAxisProperty() {
        return this.logAxis;
    }

    @Override
    public void requestAxisLayout() {
        if (this.isUpdating) {
            return;
        }
        super.requestAxisLayout();
    }

    public void setForceZeroInRange(boolean bl2) {
        this.forceZeroInRangeProperty().setValue(Boolean.valueOf(bl2));
    }

    public void setLogarithmBase(double d2) {
        this.logarithmBaseProperty().set(d2);
        this.invalidateAxisRange.run();
    }

    public void setLogAxis(boolean bl2) {
        this.isLogAxis = bl2;
        this.logAxis.set(bl2);
    }

    private AxisRange computeRangeImpl(double d2, double d3, double d4, double d5) {
        int n2 = (int)Math.floor(d4 / d5);
        int n3 = Math.max(Math.min(n2, this.getMaxMajorTickLabelCount()), 2);
        double d6 = (d3 - d2) / (double)n3;
        if (d6 == 0.0 || Double.isNaN(d6)) {
            d6 = 0.001;
        }
        double d7 = this.computeTickUnit(d6);
        boolean bl2 = (this.isAutoRanging() || this.isAutoGrowRanging()) && this.isAutoRangeRounding();
        double d8 = bl2 ? this.axisTransform.getRoundedMinimumRange(d2) : d2;
        double d9 = bl2 ? this.axisTransform.getRoundedMaximumRange(d3) : d3;
        double d10 = this.calculateNewScale(d4, d8, d9);
        return new AxisRange(d8, d9, d4, d10, d7);
    }

    private double getDisplayPositionImpl(double d2) {
        if (this.isLogAxis) {
            double d3 = this.axisTransform.forward(d2) - this.cache.lowerBoundLog;
            if (this.cache.isVerticalAxis) {
                return this.cache.axisLength - d3 * this.cache.logScaleLengthInv;
            }
            return d3 * this.cache.logScaleLengthInv;
        }
        return this.cache.localOffset2 + d2 * this.cache.localScale;
    }

    private double getValueForDisplayImpl(double d2) {
        if (this.isLogAxis) {
            if (this.cache.isVerticalAxis) {
                double d3 = this.cache.axisLength;
                return this.axisTransform.backward(this.cache.lowerBoundLog + (d3 - d2) / d3 * this.cache.logScaleLength);
            }
            return this.axisTransform.backward(this.cache.lowerBoundLog + d2 / this.cache.axisLength * this.cache.logScaleLength);
        }
        return this.cache.localCurrentLowerBound + (d2 - this.cache.localOffset) / this.cache.localScale;
    }

    @Override
    protected AxisRange autoRange(double d2, double d3, double d4, double d5) {
        double d6;
        double d7 = d6 = d2 > 0.0 && this.isForceZeroInRange() ? 0.0 : d2;
        if (this.isLogAxis && d2 <= 0.0) {
            d6 = 1.0E-6;
            this.isUpdating = true;
            this.setMin(1.0E-6);
            this.isUpdating = false;
        }
        double d8 = d3 < 0.0 && this.isForceZeroInRange() ? 0.0 : d3;
        double d9 = DefaultNumericAxis.getEffectiveRange(d6, d8) * this.getAutoRangePadding();
        double d10 = 1.0 + this.getAutoRangePadding();
        double d11 = this.isLogAxis ? d2 / d10 : DefaultNumericAxis.clampBoundToZero(d6 - d9, d6);
        double d12 = this.isLogAxis ? d3 * d10 : DefaultNumericAxis.clampBoundToZero(d8 + d9, d8);
        return this.computeRange(d11, d12, d4, d5);
    }

    @Override
    protected void calculateMajorTickValues(AxisRange axisRange, DoubleArrayList doubleArrayList) {
        if (this.isLogAxis) {
            if (axisRange.getLowerBound() >= axisRange.getUpperBound()) {
                doubleArrayList.add(axisRange.getLowerBound());
                return;
            }
            double d2 = Math.ceil(this.axisTransform.forward(axisRange.getLowerBound()));
            double d3 = this.axisTransform.backward(d2);
            while (d3 <= axisRange.getUpperBound()) {
                doubleArrayList.add(d3);
                d3 = this.axisTransform.backward(d2 += 1.0);
            }
            return;
        }
        if (axisRange.getLowerBound() == axisRange.getUpperBound() || axisRange.getTickUnit() <= 0.0) {
            doubleArrayList.add(axisRange.getLowerBound());
            return;
        }
        double d4 = DefaultNumericAxis.computeFistMajorTick(axisRange.getLowerBound(), axisRange.getTickUnit());
        if (d4 + axisRange.getTickUnit() == d4) {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.atDebug().log("major ticks numerically not resolvable");
            }
            return;
        }
        int n2 = this.getMaxMajorTickLabelCount();
        for (double d5 = d4; d5 <= axisRange.getUpperBound() && doubleArrayList.size() <= n2 && doubleArrayList.size() <= this.getMaxMajorTickLabelCount(); d5 += axisRange.getTickUnit()) {
            doubleArrayList.add(d5);
        }
    }

    @Override
    protected void calculateMinorTickValues(DoubleArrayList doubleArrayList) {
        if (this.getMinorTickCount() <= 0 || this.getTickUnit() <= 0.0) {
            return;
        }
        double d2 = this.getMin();
        double d3 = this.getMax();
        double d4 = this.getTickUnit();
        int n2 = this.getMaxMajorTickLabelCount();
        int n3 = this.getMaxMajorTickLabelCount() * this.getMinorTickCount();
        if (this.isLogAxis) {
            double d5 = Math.floor(this.axisTransform.forward(d2));
            double d6 = this.axisTransform.backward(d5);
            for (int i2 = 0; d6 < d3 && i2 <= n2; ++i2) {
                double d7 = this.axisTransform.backward(d5 + 1.0);
                double d8 = (d7 - d6) / (double)this.getMinorTickCount();
                for (double d9 = d6 + d8; d9 < d7 && doubleArrayList.size() < n3 && d9 != d6; d9 += d8) {
                    if (!(d9 >= d2) || !(d9 <= d3)) continue;
                    doubleArrayList.add(d9);
                }
                d6 = this.axisTransform.backward(d5 += 1.0);
            }
        } else {
            double d10 = DefaultNumericAxis.computeFistMajorTick(d2, d4);
            double d11 = d4 / (double)this.getMinorTickCount();
            int n4 = 0;
            for (double d12 = d10 - d4; d12 < d3 && n4 <= n2 && d12 + d4 != d12; ++n4, d12 += d4) {
                double d13 = d12 + d4;
                for (double d14 = d12 + d11; d14 < d13 && doubleArrayList.size() < n3 && d14 != d12; d14 += d11) {
                    if (!(d14 >= d2) || !(d14 <= d3)) continue;
                    doubleArrayList.add(d14);
                }
            }
        }
    }

    @Override
    protected AxisRange computeRange(double d2, double d3, double d4, double d5) {
        double d6 = d2;
        double d7 = d3;
        if (this.isLogAxis) {
            if ((this.isAutoRanging() || this.isAutoGrowRanging()) && this.isAutoRangeRounding()) {
                d6 = this.axisTransform.getRoundedMinimumRange(d6);
                d7 = this.axisTransform.getRoundedMaximumRange(d7);
            }
            double d8 = this.calculateNewScale(d4, d6, d7);
            return new AxisRange(d6, d7, d4, d8, this.getTickUnit());
        }
        if (d7 - d6 == 0.0) {
            double d9 = this.getAutoRangePadding() < 0.0 ? 0.0 : this.getAutoRangePadding();
            double d10 = DefaultNumericAxis.getEffectiveRange(d6, d7) * d9;
            d6 -= d10 / 2.0;
            d7 += d10 / 2.0;
        }
        return this.computeRangeImpl(d6, d7, d4, d5);
    }

    protected double computeTickUnit(double d2) {
        TickUnitSupplier tickUnitSupplier = this.getAxisLabelFormatter().getTickUnitSupplier();
        if (tickUnitSupplier == null) {
            throw new IllegalStateException("class defaults not properly initialised");
        }
        double d3 = tickUnitSupplier.computeTickUnit(d2);
        if (d3 <= 0.0) {
            throw new IllegalArgumentException("The " + tickUnitSupplier.getClass().getName() + " computed illegal unit value [" + d3 + "] for argument " + d2);
        }
        return d3;
    }

    @Override
    public void updateCachedTransforms() {
        super.updateCachedTransforms();
        if (this.cache == null) {
            return;
        }
        this.cache.updateCachedAxisVariables();
    }

    private static double computeFistMajorTick(double d2, double d3) {
        return Math.ceil(d2 / d3) * d3;
    }

    protected static double clampBoundToZero(double d2, double d3) {
        if (d2 < 0.0 && d3 >= 0.0 || d2 > 0.0 && d3 <= 0.0) {
            return 0.0;
        }
        return d2;
    }

    protected static double getEffectiveRange(double d2, double d3) {
        double d4 = d3 - d2;
        if (d4 == 0.0) {
            d4 = d2 == 0.0 ? 2.0 : Math.abs(d2);
        }
        return d4;
    }

    protected class Cache {
        protected double localScale;
        protected double localCurrentLowerBound;
        protected double localCurrentUpperBound;
        protected double localOffset;
        protected double localOffset2;
        protected double upperBoundLog;
        protected double lowerBoundLog;
        protected double logScaleLength;
        protected double logScaleLengthInv;
        protected boolean isVerticalAxis;
        protected double axisLength;

        protected Cache() {
        }

        private void updateCachedAxisVariables() {
            this.axisLength = DefaultNumericAxis.this.getLength();
            this.localCurrentLowerBound = DefaultNumericAxis.super.getMin();
            this.localCurrentUpperBound = DefaultNumericAxis.super.getMax();
            this.upperBoundLog = DefaultNumericAxis.this.axisTransform.forward(DefaultNumericAxis.this.getMax());
            this.lowerBoundLog = DefaultNumericAxis.this.axisTransform.forward(DefaultNumericAxis.this.getMin());
            this.logScaleLength = this.upperBoundLog - this.lowerBoundLog;
            this.logScaleLengthInv = 1.0 / this.logScaleLength;
            this.localScale = DefaultNumericAxis.this.scaleProperty().get();
            double d2 = DefaultNumericAxis.super.getDisplayPosition(0.0);
            this.localOffset = d2 + this.localCurrentLowerBound * this.localScale;
            this.localOffset2 = this.localOffset - DefaultNumericAxis.this.cache.localCurrentLowerBound * DefaultNumericAxis.this.cache.localScale;
            if (DefaultNumericAxis.this.getSide() != null) {
                this.isVerticalAxis = DefaultNumericAxis.this.getSide().isVertical();
            }
            this.logScaleLengthInv = this.axisLength / this.logScaleLength;
            DefaultNumericAxis.this.offset = this.axisLength;
            DefaultNumericAxis.this.offset = this.isVerticalAxis ? DefaultNumericAxis.this.getHeight() : DefaultNumericAxis.this.getWidth();
        }
    }
}

