/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.reports;

import org.agrona.BitUtil;
import org.agrona.concurrent.AtomicBuffer;

public final class LossReport {
    public static final int ENTRY_ALIGNMENT = 64;
    public static final int OBSERVATION_COUNT_OFFSET = 0;
    public static final int TOTAL_BYTES_LOST_OFFSET = 8;
    public static final int FIRST_OBSERVATION_OFFSET = 16;
    public static final int LAST_OBSERVATION_OFFSET = 24;
    public static final int SESSION_ID_OFFSET = 32;
    public static final int STREAM_ID_OFFSET = 36;
    public static final int CHANNEL_OFFSET = 40;
    private int nextRecordOffset = 0;
    private final AtomicBuffer buffer;

    public LossReport(AtomicBuffer atomicBuffer) {
        atomicBuffer.verifyAlignment();
        this.buffer = atomicBuffer;
    }

    public ReportEntry createEntry(long l2, long l3, int n2, int n3, String string, String string2) {
        ReportEntry reportEntry = null;
        int n4 = 40 + BitUtil.align(4 + string.length(), 4) + 4 + string2.length();
        if (n4 <= this.buffer.capacity() - this.nextRecordOffset) {
            int n5 = this.nextRecordOffset;
            this.buffer.putLong(n5 + 8, l2);
            this.buffer.putLong(n5 + 16, l3);
            this.buffer.putLong(n5 + 24, l3);
            this.buffer.putInt(n5 + 32, n2);
            this.buffer.putInt(n5 + 36, n3);
            int n6 = this.buffer.putStringAscii(n5 + 40, string);
            this.buffer.putStringAscii(n5 + 40 + BitUtil.align(n6, 4), string2);
            this.buffer.putLongOrdered(n5 + 0, 1L);
            reportEntry = new ReportEntry(this.buffer, n5);
            this.nextRecordOffset += BitUtil.align(n4, 64);
        }
        return reportEntry;
    }

    public String toString() {
        return "LossReport{nextRecordOffset=" + this.nextRecordOffset + ", buffer=" + this.buffer + '}';
    }

    public static final class ReportEntry {
        private final AtomicBuffer buffer;
        private final int offset;

        ReportEntry(AtomicBuffer atomicBuffer, int n2) {
            this.buffer = atomicBuffer;
            this.offset = n2;
        }

        public void recordObservation(long l2, long l3) {
            this.buffer.putLongOrdered(this.offset + 24, l3);
            this.buffer.getAndAddLong(this.offset + 8, l2);
            this.buffer.getAndAddLong(this.offset + 0, 1L);
        }
    }
}

