/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver.media;

import io.aeron.driver.NameResolver;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import org.agrona.AsciiEncoding;
import org.agrona.Strings;

class SocketAddressParser {
    SocketAddressParser() {
    }

    static InetSocketAddress parse(String string, String string2, boolean bl2, NameResolver nameResolver) {
        if (Strings.isEmpty(string)) {
            throw new NullPointerException("input string must not be null or empty");
        }
        String string3 = nameResolver.lookup(string, string2, bl2);
        InetSocketAddress inetSocketAddress = SocketAddressParser.tryParseIpV4(string3, string2, bl2, nameResolver);
        if (null == inetSocketAddress) {
            inetSocketAddress = SocketAddressParser.tryParseIpV6(string3, string2, bl2, nameResolver);
        }
        if (null == inetSocketAddress) {
            throw new IllegalArgumentException("invalid format: " + string);
        }
        return inetSocketAddress;
    }

    private static InetSocketAddress tryParseIpV4(String string, String string2, boolean bl2, NameResolver nameResolver) {
        int n2;
        IpV4State ipV4State = IpV4State.HOST;
        int n3 = -1;
        int n4 = string.length();
        block4: for (int i2 = 0; i2 < n4; ++i2) {
            n2 = string.charAt(i2);
            switch (ipV4State) {
                case HOST: {
                    if (58 != n2) continue block4;
                    n3 = i2;
                    ipV4State = IpV4State.PORT;
                    continue block4;
                }
                case PORT: {
                    if (58 == n2) {
                        return null;
                    }
                    if (n2 >= 48 && 57 >= n2) continue block4;
                    return null;
                }
            }
        }
        if (-1 != n3 && 1 < n4 - n3) {
            String string3 = string.substring(0, n3);
            n2 = n3 + 1;
            int n5 = AsciiEncoding.parseIntAscii(string, n2, n4 - n2);
            InetAddress inetAddress = nameResolver.resolve(string3, string2, bl2);
            return null == inetAddress ? InetSocketAddress.createUnresolved(string3, n5) : new InetSocketAddress(inetAddress, n5);
        }
        throw new IllegalArgumentException("address 'port' is required for ipv4: " + string);
    }

    private static InetSocketAddress tryParseIpV6(String string, String string2, boolean bl2, NameResolver nameResolver) {
        int n2;
        IpV6State ipV6State = IpV6State.START_ADDR;
        int n3 = -1;
        int n4 = -1;
        int n5 = string.length();
        block7: for (int i2 = 0; i2 < n5; ++i2) {
            n2 = string.charAt(i2);
            switch (ipV6State) {
                case START_ADDR: {
                    if (91 == n2) {
                        ipV6State = IpV6State.HOST;
                        continue block7;
                    }
                    return null;
                }
                case HOST: {
                    if (93 == n2) {
                        ipV6State = IpV6State.END_ADDR;
                        continue block7;
                    }
                    if (37 == n2) {
                        n4 = i2;
                        ipV6State = IpV6State.SCOPE;
                        continue block7;
                    }
                    if (58 == n2 || n2 >= 97 && 102 >= n2 || n2 >= 65 && 70 >= n2 || n2 >= 48 && 57 >= n2) continue block7;
                    return null;
                }
                case SCOPE: {
                    if (93 == n2) {
                        ipV6State = IpV6State.END_ADDR;
                        continue block7;
                    }
                    if (95 == n2 || 46 == n2 || 126 == n2 || 45 == n2 || n2 >= 97 && 122 >= n2 || n2 >= 65 && 90 >= n2 || n2 >= 48 && 57 >= n2) continue block7;
                    return null;
                }
                case END_ADDR: {
                    if (58 == n2) {
                        n3 = i2;
                        ipV6State = IpV6State.PORT;
                        continue block7;
                    }
                    return null;
                }
                case PORT: {
                    if (58 == n2) {
                        return null;
                    }
                    if (n2 >= 48 && 57 >= n2) continue block7;
                    return null;
                }
            }
        }
        if (-1 != n3 && 1 < n5 - n3) {
            String string3 = string.substring(1, n4 != -1 ? n4 : n3 - 1);
            n2 = AsciiEncoding.parseIntAscii(string, ++n3, n5 - n3);
            InetAddress inetAddress = nameResolver.resolve(string3, string2, bl2);
            return null == inetAddress ? InetSocketAddress.createUnresolved(string3, n2) : new InetSocketAddress(inetAddress, n2);
        }
        throw new IllegalArgumentException("address 'port' is required for ipv6: " + string);
    }

    static enum IpV6State {
        START_ADDR,
        HOST,
        SCOPE,
        END_ADDR,
        PORT;

    }

    static enum IpV4State {
        HOST,
        PORT;

    }
}

