/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.PublicationImage;
import io.aeron.driver.Receiver;
import io.aeron.driver.ThreadingMode;
import io.aeron.driver.media.ReceiveChannelEndpoint;
import io.aeron.driver.media.ReceiveDestinationTransport;
import io.aeron.driver.media.UdpChannel;
import java.net.InetSocketAddress;
import org.agrona.concurrent.AgentTerminationException;
import org.agrona.concurrent.QueuedPipe;
import org.agrona.concurrent.status.AtomicCounter;

final class ReceiverProxy {
    private final ThreadingMode threadingMode;
    private final QueuedPipe<Runnable> commandQueue;
    private final AtomicCounter failCount;
    private Receiver receiver;

    ReceiverProxy(ThreadingMode threadingMode, QueuedPipe<Runnable> queuedPipe, AtomicCounter atomicCounter) {
        this.threadingMode = threadingMode;
        this.commandQueue = queuedPipe;
        this.failCount = atomicCounter;
    }

    public String toString() {
        return "ReceiverProxy{threadingMode=" + (Object)((Object)this.threadingMode) + ", failCount=" + this.failCount + '}';
    }

    void receiver(Receiver receiver) {
        this.receiver = receiver;
    }

    Receiver receiver() {
        return this.receiver;
    }

    boolean isApplyingBackpressure() {
        return this.commandQueue.remainingCapacity() < 1;
    }

    void addSubscription(ReceiveChannelEndpoint receiveChannelEndpoint, int n2) {
        if (this.notConcurrent()) {
            this.receiver.onAddSubscription(receiveChannelEndpoint, n2);
        } else {
            this.offer(() -> this.receiver.onAddSubscription(receiveChannelEndpoint, n2));
        }
    }

    void addSubscription(ReceiveChannelEndpoint receiveChannelEndpoint, int n2, int n3) {
        if (this.notConcurrent()) {
            this.receiver.onAddSubscription(receiveChannelEndpoint, n2, n3);
        } else {
            this.offer(() -> this.receiver.onAddSubscription(receiveChannelEndpoint, n2, n3));
        }
    }

    void removeSubscription(ReceiveChannelEndpoint receiveChannelEndpoint, int n2) {
        if (this.notConcurrent()) {
            this.receiver.onRemoveSubscription(receiveChannelEndpoint, n2);
        } else {
            this.offer(() -> this.receiver.onRemoveSubscription(receiveChannelEndpoint, n2));
        }
    }

    void removeSubscription(ReceiveChannelEndpoint receiveChannelEndpoint, int n2, int n3) {
        if (this.notConcurrent()) {
            this.receiver.onRemoveSubscription(receiveChannelEndpoint, n2, n3);
        } else {
            this.offer(() -> this.receiver.onRemoveSubscription(receiveChannelEndpoint, n2, n3));
        }
    }

    void newPublicationImage(ReceiveChannelEndpoint receiveChannelEndpoint, PublicationImage publicationImage) {
        if (this.notConcurrent()) {
            this.receiver.onNewPublicationImage(receiveChannelEndpoint, publicationImage);
        } else {
            this.offer(() -> this.receiver.onNewPublicationImage(receiveChannelEndpoint, publicationImage));
        }
    }

    void registerReceiveChannelEndpoint(ReceiveChannelEndpoint receiveChannelEndpoint) {
        if (this.notConcurrent()) {
            this.receiver.onRegisterReceiveChannelEndpoint(receiveChannelEndpoint);
        } else {
            this.offer(() -> this.receiver.onRegisterReceiveChannelEndpoint(receiveChannelEndpoint));
        }
    }

    void closeReceiveChannelEndpoint(ReceiveChannelEndpoint receiveChannelEndpoint) {
        if (this.notConcurrent()) {
            this.receiver.onCloseReceiveChannelEndpoint(receiveChannelEndpoint);
        } else {
            this.offer(() -> this.receiver.onCloseReceiveChannelEndpoint(receiveChannelEndpoint));
        }
    }

    void removeCoolDown(ReceiveChannelEndpoint receiveChannelEndpoint, int n2, int n3) {
        if (this.notConcurrent()) {
            this.receiver.onRemoveCoolDown(receiveChannelEndpoint, n2, n3);
        } else {
            this.offer(() -> this.receiver.onRemoveCoolDown(receiveChannelEndpoint, n2, n3));
        }
    }

    void addDestination(ReceiveChannelEndpoint receiveChannelEndpoint, ReceiveDestinationTransport receiveDestinationTransport) {
        if (this.notConcurrent()) {
            this.receiver.onAddDestination(receiveChannelEndpoint, receiveDestinationTransport);
        } else {
            this.offer(() -> this.receiver.onAddDestination(receiveChannelEndpoint, receiveDestinationTransport));
        }
    }

    void removeDestination(ReceiveChannelEndpoint receiveChannelEndpoint, UdpChannel udpChannel) {
        if (this.notConcurrent()) {
            this.receiver.onRemoveDestination(receiveChannelEndpoint, udpChannel);
        } else {
            this.offer(() -> this.receiver.onRemoveDestination(receiveChannelEndpoint, udpChannel));
        }
    }

    void onResolutionChange(ReceiveChannelEndpoint receiveChannelEndpoint, UdpChannel udpChannel, InetSocketAddress inetSocketAddress) {
        if (this.notConcurrent()) {
            this.receiver.onResolutionChange(receiveChannelEndpoint, udpChannel, inetSocketAddress);
        } else {
            this.offer(() -> this.receiver.onResolutionChange(receiveChannelEndpoint, udpChannel, inetSocketAddress));
        }
    }

    private boolean notConcurrent() {
        return this.threadingMode == ThreadingMode.SHARED || this.threadingMode == ThreadingMode.INVOKER;
    }

    private void offer(Runnable runnable) {
        while (!this.commandQueue.offer(runnable)) {
            if (!this.failCount.isClosed()) {
                this.failCount.increment();
            }
            Thread.yield();
            if (!Thread.currentThread().isInterrupted()) continue;
            throw new AgentTerminationException("interrupted");
        }
    }
}

