/*
 * Decompiled with CFR 0.152.
 */
package io.aeron.driver;

import io.aeron.driver.media.ReceiveChannelEndpoint;
import java.net.InetSocketAddress;

final class PendingSetupMessageFromSource {
    private final int sessionId;
    private final int streamId;
    private final int transportIndex;
    private final boolean periodic;
    private final ReceiveChannelEndpoint channelEndpoint;
    private InetSocketAddress controlAddress;
    private long timeOfStatusMessageNs;

    PendingSetupMessageFromSource(int n2, int n3, int n4, ReceiveChannelEndpoint receiveChannelEndpoint, boolean bl2, InetSocketAddress inetSocketAddress) {
        this.sessionId = n2;
        this.streamId = n3;
        this.transportIndex = n4;
        this.channelEndpoint = receiveChannelEndpoint;
        this.periodic = bl2;
        this.controlAddress = inetSocketAddress;
    }

    int sessionId() {
        return this.sessionId;
    }

    int streamId() {
        return this.streamId;
    }

    int transportIndex() {
        return this.transportIndex;
    }

    ReceiveChannelEndpoint channelEndpoint() {
        return this.channelEndpoint;
    }

    boolean isPeriodic() {
        return this.periodic;
    }

    boolean shouldElicitSetupMessage() {
        return this.channelEndpoint.dispatcher().shouldElicitSetupMessage();
    }

    void controlAddress(InetSocketAddress inetSocketAddress) {
        this.controlAddress = inetSocketAddress;
    }

    InetSocketAddress controlAddress() {
        return this.controlAddress;
    }

    long timeOfStatusMessageNs() {
        return this.timeOfStatusMessageNs;
    }

    void timeOfStatusMessageNs(long l2) {
        this.timeOfStatusMessageNs = l2;
    }

    void removeFromDataPacketDispatcher() {
        this.channelEndpoint.dispatcher().removePendingSetup(this.sessionId, this.streamId);
    }
}

