/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.BufferBuilder;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;

public class ImageFragmentAssembler
implements FragmentHandler {
    private final FragmentHandler delegate;
    private final BufferBuilder builder;

    public ImageFragmentAssembler(FragmentHandler fragmentHandler) {
        this(fragmentHandler, 0, false);
    }

    public ImageFragmentAssembler(FragmentHandler fragmentHandler, int n2) {
        this.delegate = fragmentHandler;
        this.builder = new BufferBuilder(n2, false);
    }

    public ImageFragmentAssembler(FragmentHandler fragmentHandler, int n2, boolean bl2) {
        this.delegate = fragmentHandler;
        this.builder = new BufferBuilder(n2, bl2);
    }

    public FragmentHandler delegate() {
        return this.delegate;
    }

    public BufferBuilder bufferBuilder() {
        return this.builder;
    }

    @Override
    public void onFragment(DirectBuffer directBuffer, int n2, int n3, Header header) {
        byte by2 = header.flags();
        if ((by2 & 0xFFFFFFC0) == -64) {
            this.delegate.onFragment(directBuffer, n2, n3, header);
        } else {
            this.handleFragment(directBuffer, n2, n3, header, by2);
        }
    }

    private void handleFragment(DirectBuffer directBuffer, int n2, int n3, Header header, byte by2) {
        if ((by2 & 0xFFFFFF80) == -128) {
            this.builder.reset().append(directBuffer, n2, n3).nextTermOffset(BitUtil.align(n2 + n3 + 32, 32));
        } else if (n2 == this.builder.nextTermOffset()) {
            this.builder.append(directBuffer, n2, n3);
            if ((by2 & 0x40) == 64) {
                this.delegate.onFragment(this.builder.buffer(), 0, this.builder.limit(), header);
                this.builder.reset();
            } else {
                this.builder.nextTermOffset(BitUtil.align(n2 + n3 + 32, 32));
            }
        } else {
            this.builder.reset();
        }
    }
}

