/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.BufferBuilder;
import io.aeron.logbuffer.FragmentHandler;
import io.aeron.logbuffer.Header;
import org.agrona.BitUtil;
import org.agrona.DirectBuffer;
import org.agrona.collections.Int2ObjectHashMap;

public class FragmentAssembler
implements FragmentHandler {
    private final boolean isDirectByteBuffer;
    private final int initialBufferLength;
    private final FragmentHandler delegate;
    private final Int2ObjectHashMap<BufferBuilder> builderBySessionIdMap = new Int2ObjectHashMap();

    public FragmentAssembler(FragmentHandler fragmentHandler) {
        this(fragmentHandler, 0, false);
    }

    public FragmentAssembler(FragmentHandler fragmentHandler, int n2) {
        this(fragmentHandler, n2, false);
    }

    public FragmentAssembler(FragmentHandler fragmentHandler, int n2, boolean bl2) {
        this.initialBufferLength = n2;
        this.delegate = fragmentHandler;
        this.isDirectByteBuffer = bl2;
    }

    public FragmentHandler delegate() {
        return this.delegate;
    }

    public boolean isDirectByteBuffer() {
        return this.isDirectByteBuffer;
    }

    @Override
    public void onFragment(DirectBuffer directBuffer, int n2, int n3, Header header) {
        byte by2 = header.flags();
        if ((by2 & 0xFFFFFFC0) == -64) {
            this.delegate.onFragment(directBuffer, n2, n3, header);
        } else {
            this.handleFragment(directBuffer, n2, n3, header, by2);
        }
    }

    private void handleFragment(DirectBuffer directBuffer, int n2, int n3, Header header, byte by2) {
        if ((by2 & 0xFFFFFF80) == -128) {
            BufferBuilder bufferBuilder = this.getBufferBuilder(header.sessionId());
            bufferBuilder.reset().append(directBuffer, n2, n3).nextTermOffset(BitUtil.align(n2 + n3 + 32, 32));
        } else {
            BufferBuilder bufferBuilder = this.builderBySessionIdMap.get(header.sessionId());
            if (null != bufferBuilder) {
                if (n2 == bufferBuilder.nextTermOffset()) {
                    bufferBuilder.append(directBuffer, n2, n3);
                    if ((by2 & 0x40) == 64) {
                        this.delegate.onFragment(bufferBuilder.buffer(), 0, bufferBuilder.limit(), header);
                        bufferBuilder.reset();
                    } else {
                        bufferBuilder.nextTermOffset(BitUtil.align(n2 + n3 + 32, 32));
                    }
                } else {
                    bufferBuilder.reset();
                }
            }
        }
    }

    public boolean freeSessionBuffer(int n2) {
        return null != this.builderBySessionIdMap.remove(n2);
    }

    public void clear() {
        this.builderBySessionIdMap.clear();
    }

    private BufferBuilder getBufferBuilder(int n2) {
        BufferBuilder bufferBuilder = this.builderBySessionIdMap.get(n2);
        if (null == bufferBuilder) {
            bufferBuilder = new BufferBuilder(this.initialBufferLength, this.isDirectByteBuffer);
            this.builderBySessionIdMap.put(n2, bufferBuilder);
        }
        return bufferBuilder;
    }
}

