/*
 * Decompiled with CFR 0.152.
 */
package io.aeron;

import io.aeron.ClientConductor;
import io.aeron.exceptions.AeronException;
import java.util.concurrent.atomic.AtomicIntegerFieldUpdater;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.status.AtomicCounter;
import org.agrona.concurrent.status.CountersReader;

public final class Counter
extends AtomicCounter {
    private static final AtomicIntegerFieldUpdater<Counter> IS_CLOSED_UPDATER = AtomicIntegerFieldUpdater.newUpdater(Counter.class, "isClosed");
    private final long registrationId;
    private final ClientConductor clientConductor;
    private volatile int isClosed;

    Counter(long l2, ClientConductor clientConductor, AtomicBuffer atomicBuffer, int n2) {
        super(atomicBuffer, n2);
        this.registrationId = l2;
        this.clientConductor = clientConductor;
    }

    public Counter(CountersReader countersReader, long l2, int n2) {
        super(countersReader.valuesBuffer(), n2);
        if (countersReader.getCounterState(n2) != 1) {
            throw new AeronException("Counter id is not allocated: " + n2);
        }
        this.registrationId = l2;
        this.clientConductor = null;
    }

    public long registrationId() {
        return this.registrationId;
    }

    @Override
    public void close() {
        if (IS_CLOSED_UPDATER.compareAndSet(this, 0, 1)) {
            super.close();
            if (null != this.clientConductor) {
                this.clientConductor.releaseCounter(this);
            }
        }
    }

    @Override
    public boolean isClosed() {
        return 1 == this.isClosed;
    }

    void internalClose() {
        super.close();
        this.isClosed = 1;
    }
}

