/*
 * Decompiled with CFR 0.152.
 */
package impl.org.controlsfx.spreadsheet;

import impl.org.controlsfx.spreadsheet.SpreadsheetGridView;
import javafx.application.Platform;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.scene.control.TableColumn;
import javafx.scene.control.TablePosition;
import javafx.scene.control.TableView;
import org.controlsfx.control.spreadsheet.SpreadsheetCell;
import org.controlsfx.control.spreadsheet.SpreadsheetView;

public class FocusModelListener
implements ChangeListener<TablePosition<ObservableList<SpreadsheetCell>, ?>> {
    private final TableView.TableViewFocusModel<ObservableList<SpreadsheetCell>> tfm;
    private final SpreadsheetGridView cellsView;
    private final SpreadsheetView spreadsheetView;

    public FocusModelListener(SpreadsheetView spreadsheetView, SpreadsheetGridView spreadsheetGridView) {
        this.tfm = spreadsheetGridView.getFocusModel();
        this.spreadsheetView = spreadsheetView;
        this.cellsView = spreadsheetGridView;
    }

    public void changed(ObservableValue<? extends TablePosition<ObservableList<SpreadsheetCell>, ?>> observableValue, TablePosition<ObservableList<SpreadsheetCell>, ?> tablePosition, TablePosition<ObservableList<SpreadsheetCell>, ?> tablePosition2) {
        int n2 = -1;
        if (tablePosition2 != null && tablePosition2.getTableColumn() != null) {
            n2 = this.cellsView.getColumns().indexOf((Object)tablePosition2.getTableColumn());
        }
        SpreadsheetView.SpanType spanType = this.spreadsheetView.getSpanType(tablePosition2.getRow(), n2);
        switch (spanType) {
            case ROW_SPAN_INVISIBLE: {
                if (!this.spreadsheetView.isPressed() && tablePosition.getColumn() == tablePosition2.getColumn() && tablePosition.getRow() == tablePosition2.getRow() - 1) {
                    Platform.runLater(() -> this.tfm.focus(FocusModelListener.getNextRowNumber(tablePosition, this.cellsView, this.spreadsheetView), tablePosition.getTableColumn()));
                    break;
                }
                Platform.runLater(() -> this.tfm.focus(tablePosition2.getRow() - 1, tablePosition2.getTableColumn()));
                break;
            }
            case BOTH_INVISIBLE: {
                Platform.runLater(() -> this.tfm.focus(tablePosition2.getRow() - 1, (TableColumn)this.cellsView.getColumns().get(tablePosition2.getColumn() - 1)));
                break;
            }
            case COLUMN_SPAN_INVISIBLE: {
                if (!this.spreadsheetView.isPressed() && tablePosition.getColumn() == tablePosition2.getColumn() - 1 && tablePosition.getRow() == tablePosition2.getRow()) {
                    Platform.runLater(() -> this.tfm.focus(tablePosition.getRow(), FocusModelListener.getTableColumnSpan(tablePosition, this.cellsView, this.spreadsheetView)));
                    break;
                }
                Platform.runLater(() -> this.tfm.focus(tablePosition2.getRow(), this.cellsView.getVisibleLeafColumn(tablePosition2.getColumn() - 1)));
            }
        }
    }

    static TableColumn<ObservableList<SpreadsheetCell>, ?> getTableColumnSpan(TablePosition<?, ?> tablePosition, SpreadsheetGridView spreadsheetGridView, SpreadsheetView spreadsheetView) {
        return spreadsheetGridView.getVisibleLeafColumn(tablePosition.getColumn() + spreadsheetView.getColumnSpan((SpreadsheetCell)((ObservableList)spreadsheetGridView.getItems().get(tablePosition.getRow())).get(spreadsheetGridView.getColumns().indexOf((Object)tablePosition.getTableColumn()))));
    }

    public static int getNextRowNumber(TablePosition<?, ?> tablePosition, TableView<ObservableList<SpreadsheetCell>> tableView, SpreadsheetView spreadsheetView) {
        return spreadsheetView.getRowSpan((SpreadsheetCell)((ObservableList)tableView.getItems().get(tablePosition.getRow())).get(tableView.getColumns().indexOf((Object)tablePosition.getTableColumn())), tablePosition.getRow()) + tablePosition.getRow();
    }
}

