/*
 * Decompiled with CFR 0.152.
 */
package de.jensd.fx.glyphs;

import de.jensd.fx.glyphs.GlyphIconUtils;
import de.jensd.fx.glyphs.GlyphIcons;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleStringProperty;
import javafx.beans.property.StringProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableObjectProperty;
import javafx.css.StyleConverter;
import javafx.css.Styleable;
import javafx.css.StyleableProperty;
import javafx.fxml.FXML;
import javafx.scene.text.Font;
import javafx.scene.text.Text;

public abstract class GlyphIcon<T extends Enum<T>>
extends Text {
    public static final Double DEFAULT_ICON_SIZE = 12.0;
    public static final String DEFAULT_FONT_SIZE = "1em";
    private StringProperty glyphStyle;
    private String glyphFontFamily;
    private String unicode;
    private ObjectProperty<String> glyphName;
    private ObjectProperty<Number> glyphSize;
    public final Class<T> typeOfT;

    @FXML
    public void init() {
    }

    public GlyphIcon(Class<T> clazz) {
        this.typeOfT = clazz;
        this.initProperties();
    }

    private void initProperties() {
        this.getStyleClass().addAll((Object[])new String[]{"glyph-icon"});
        this.glyphSizeProperty().addListener(observable -> this.updateSize());
        this.glyphStyleProperty().addListener(observable -> this.updateStyle());
        this.glyphNameProperty().addListener(observable -> this.updateIcon());
        this.setIcon(this.getDefaultGlyph());
    }

    public final GlyphIcon setStyleClass(String string) {
        this.getStyleClass().add((Object)string);
        return this;
    }

    public final StringProperty glyphStyleProperty() {
        if (this.glyphStyle == null) {
            this.glyphStyle = new SimpleStringProperty("");
        }
        return this.glyphStyle;
    }

    public final String getGlyphStyle() {
        return this.glyphStyleProperty().getValue();
    }

    public final void setGlyphStyle(String string) {
        if (!this.getGlyphStyle().isEmpty() && !this.getGlyphStyle().endsWith(";")) {
            string = ";".concat(string);
        }
        this.glyphStyleProperty().setValue(this.getGlyphStyle().concat(string));
    }

    public final ObjectProperty<String> glyphNameProperty() {
        if (this.glyphName == null) {
            this.glyphName = new SimpleStyleableObjectProperty(StyleableProperties.GLYPH_NAME, (Object)this, "glyphName");
        }
        return this.glyphName;
    }

    public final String getGlyphName() {
        return (String)this.glyphNameProperty().getValue();
    }

    public final void setGlyphName(String string) {
        this.glyphNameProperty().setValue((Object)string);
    }

    public final String getGlyphFontFamily() {
        return this.glyphFontFamily;
    }

    public final ObjectProperty<Number> glyphSizeProperty() {
        if (this.glyphSize == null) {
            this.glyphSize = new SimpleStyleableObjectProperty(StyleableProperties.GLYPH_SIZE, (Object)this, "glyphSize");
            this.glyphSize.setValue((Object)DEFAULT_ICON_SIZE);
        }
        return this.glyphSize;
    }

    public final Number getGlyphSize() {
        return (Number)this.glyphSizeProperty().getValue();
    }

    public final void setGlyphSize(Number number) {
        number = number == null ? (Number)DEFAULT_ICON_SIZE : (Number)number;
        this.glyphSizeProperty().setValue((Object)number);
    }

    public final String getSize() {
        return this.getGlyphSize().toString();
    }

    public final void setSize(String string) {
        Number number = this.convert(string);
        this.setGlyphSize(number);
    }

    public final void setIcon(T t2) {
        this.setGlyphName(((Enum)t2).name());
        this.glyphFontFamily = ((GlyphIcons)t2).fontFamily();
        this.unicode = ((GlyphIcons)t2).unicode();
    }

    public String unicode() {
        return this.unicode;
    }

    public abstract T getDefaultGlyph();

    private void updateSize() {
        Font font = new Font(this.getFont().getFamily(), this.getGlyphSize().doubleValue());
        this.setFont(font);
        this.setGlyphStyle(String.format("-fx-font-family: %s; -fx-font-size: %s;", this.getGlyphFontFamily(), this.getGlyphSize().doubleValue()));
    }

    void updateIcon() {
        GlyphIcons glyphIcons = (GlyphIcons)this.getDefaultGlyph();
        try {
            glyphIcons = (GlyphIcons)Enum.valueOf(this.typeOfT, this.getGlyphName());
        }
        catch (Exception exception) {
            String string = String.format("Icon '%s' not found. Using '%s' (default) instead", this.getGlyphName(), this.getDefaultGlyph());
            Logger.getLogger(GlyphIcon.class.getName()).log(Level.SEVERE, string);
        }
        this.setText(glyphIcons.unicode());
    }

    private void updateStyle() {
        this.setStyle(this.getGlyphStyle());
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.STYLEABLES;
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return GlyphIcon.getClassCssMetaData();
    }

    public Number convert(String string) {
        return GlyphIconUtils.convert(string, this.getFont());
    }

    private static class StyleableProperties {
        private static final CssMetaData<GlyphIcon, String> GLYPH_NAME = new CssMetaData<GlyphIcon, String>("-glyph-name", StyleConverter.getStringConverter(), "BLANK"){

            public boolean isSettable(GlyphIcon glyphIcon) {
                return glyphIcon.glyphName == null || !glyphIcon.glyphName.isBound();
            }

            public StyleableProperty<String> getStyleableProperty(GlyphIcon glyphIcon) {
                return (StyleableProperty)glyphIcon.glyphNameProperty();
            }

            public String getInitialValue(GlyphIcon glyphIcon) {
                return "BLANK";
            }
        };
        private static final CssMetaData<GlyphIcon, Number> GLYPH_SIZE = new CssMetaData<GlyphIcon, Number>("-glyph-size", StyleConverter.getSizeConverter(), (Number)DEFAULT_ICON_SIZE){

            public boolean isSettable(GlyphIcon glyphIcon) {
                return glyphIcon.glyphSize == null || !glyphIcon.glyphSize.isBound();
            }

            public StyleableProperty<Number> getStyleableProperty(GlyphIcon glyphIcon) {
                return (StyleableProperty)glyphIcon.glyphSizeProperty();
            }

            public Number getInitialValue(GlyphIcon glyphIcon) {
                return DEFAULT_ICON_SIZE;
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> STYLEABLES;

        private StyleableProperties() {
        }

        static {
            ArrayList arrayList = new ArrayList(Text.getClassCssMetaData());
            Collections.addAll(arrayList, GLYPH_NAME, GLYPH_SIZE);
            STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

