/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.svg;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javafx.beans.NamedArg;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.css.CssMetaData;
import javafx.css.SimpleStyleableDoubleProperty;
import javafx.css.Styleable;
import javafx.css.StyleableDoubleProperty;
import javafx.css.converter.SizeConverter;
import javafx.scene.layout.Background;
import javafx.scene.layout.BackgroundFill;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.SVGPath;
import javafx.scene.shape.Shape;

public class SVGGlyph
extends Pane {
    private static final String DEFAULT_STYLE_CLASS = "jfx-svg-glyph";
    private final int glyphId;
    private final String name;
    private static final int DEFAULT_PREF_SIZE = 64;
    private double widthHeightRatio = 1.0;
    private ObjectProperty<Paint> fill = new SimpleObjectProperty();
    private StyleableDoubleProperty size = new SimpleStyleableDoubleProperty(StyleableProperties.access$000(), (Object)this, "size", -1.0){

        public void invalidated() {
            SVGGlyph.this.setSizeRatio(SVGGlyph.this.getSize());
        }
    };

    public SVGGlyph() {
        this(null);
    }

    public SVGGlyph(@NamedArg(value="svgPathContent") String string) {
        this(-1, "UNNAMED", string, (Paint)Color.BLACK);
    }

    public SVGGlyph(@NamedArg(value="svgPathContent") String string, @NamedArg(value="fill") Paint paint) {
        this(-1, "UNNAMED", string, paint);
    }

    public SVGGlyph(int n2, String string, String string2, Paint paint) {
        this.glyphId = n2;
        this.name = string;
        this.getStyleClass().add((Object)DEFAULT_STYLE_CLASS);
        this.fill.addListener(observable -> this.setBackground(new Background(new BackgroundFill[]{new BackgroundFill((Paint)(this.getFill() == null ? Color.BLACK : this.getFill()), null, null)})));
        this.shapeProperty().addListener(observable -> {
            Shape shape = this.getShape();
            if (this.getShape() != null) {
                this.widthHeightRatio = shape.prefWidth(-1.0) / shape.prefHeight(-1.0);
                if (this.getSize() != -1.0) {
                    this.setSizeRatio(this.getSize());
                }
            }
        });
        if (string2 != null && !string2.isEmpty()) {
            SVGPath sVGPath = new SVGPath();
            sVGPath.setContent(string2);
            this.setShape((Shape)sVGPath);
            this.setFill(paint);
        }
        this.setPrefSize(64.0, 64.0);
    }

    public int getGlyphId() {
        return this.glyphId;
    }

    public String getName() {
        return this.name;
    }

    public void setFill(Paint paint) {
        this.fill.setValue((Object)paint);
    }

    public ObjectProperty<Paint> fillProperty() {
        return this.fill;
    }

    public Paint getFill() {
        return (Paint)this.fill.getValue();
    }

    public void setSize(double d2, double d3) {
        this.setMinSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
        this.setPrefSize(d2, d3);
        this.setMaxSize(Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY);
    }

    private void setSizeRatio(double d2) {
        double d3 = this.widthHeightRatio * d2;
        double d4 = d2 / this.widthHeightRatio;
        if (d3 <= d2) {
            this.setSize(d3, d2);
        } else if (d4 <= d2) {
            this.setSize(d2, d4);
        } else {
            this.setSize(d2, d2);
        }
    }

    public void setSizeForWidth(double d2) {
        double d3 = d2 / this.widthHeightRatio;
        this.setSize(d2, d3);
    }

    public void setSizeForHeight(double d2) {
        double d3 = d2 * this.widthHeightRatio;
        this.setSize(d3, d2);
    }

    public double getSize() {
        return this.size.get();
    }

    public DoubleProperty sizeProperty() {
        return this.size;
    }

    public void setSize(double d2) {
        this.size.set(d2);
    }

    public List<CssMetaData<? extends Styleable, ?>> getCssMetaData() {
        return SVGGlyph.getClassCssMetaData();
    }

    public static List<CssMetaData<? extends Styleable, ?>> getClassCssMetaData() {
        return StyleableProperties.CHILD_STYLEABLES;
    }

    private static class StyleableProperties {
        private static final CssMetaData<SVGGlyph, Number> SIZE = new CssMetaData<SVGGlyph, Number>("-jfx-size", SizeConverter.getInstance(), (Number)-1.0){

            public boolean isSettable(SVGGlyph sVGGlyph) {
                return sVGGlyph.size == null || !sVGGlyph.size.isBound();
            }

            public StyleableDoubleProperty getStyleableProperty(SVGGlyph sVGGlyph) {
                return sVGGlyph.size;
            }
        };
        private static final List<CssMetaData<? extends Styleable, ?>> CHILD_STYLEABLES;

        private StyleableProperties() {
        }

        static /* synthetic */ CssMetaData access$000() {
            return SIZE;
        }

        static {
            ArrayList arrayList = new ArrayList(Pane.getClassCssMetaData());
            Collections.addAll(arrayList, SIZE);
            CHILD_STYLEABLES = Collections.unmodifiableList(arrayList);
        }
    }
}

