/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.skins;

import com.jfoenix.effects.JFXDepthManager;
import com.jfoenix.skins.JFXColorPickerUI;
import com.jfoenix.transitions.CachedTransition;
import java.util.ArrayList;
import javafx.animation.Interpolator;
import javafx.animation.KeyFrame;
import javafx.animation.KeyValue;
import javafx.animation.Timeline;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.ObjectProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.property.SimpleObjectProperty;
import javafx.beans.value.ObservableValue;
import javafx.beans.value.WritableValue;
import javafx.geometry.Point2D;
import javafx.scene.Node;
import javafx.scene.effect.DropShadow;
import javafx.scene.input.MouseEvent;
import javafx.scene.layout.Pane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.CubicCurve;
import javafx.scene.shape.CubicCurveTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.PathElement;
import javafx.scene.shape.StrokeLineCap;
import javafx.scene.shape.StrokeType;
import javafx.scene.transform.Rotate;
import javafx.util.Duration;

class JFXCustomColorPicker
extends Pane {
    ObjectProperty<RecentColorPath> selectedPath = new SimpleObjectProperty();
    private MoveTo startPoint;
    private CubicCurveTo curve0To;
    private CubicCurveTo outerCircleCurveTo;
    private CubicCurveTo curve1To;
    private CubicCurveTo innerCircleCurveTo;
    private ArrayList<CubicCurve> curves = new ArrayList();
    private double distance;
    private double centerX = this.distance = 200.0;
    private double centerY = this.distance;
    private double radius = 110.0;
    private int shapesNumber = 13;
    private ArrayList<RecentColorPath> shapes = new ArrayList();
    private CachedTransition showAnimation;
    private JFXColorPickerUI hslColorPicker;

    public JFXCustomColorPicker() {
        this.setPickOnBounds(false);
        this.setMinSize(this.distance * 2.0, this.distance * 2.0);
        SimpleDoubleProperty simpleDoubleProperty = new SimpleDoubleProperty(2.1);
        this.init((DoubleProperty)simpleDoubleProperty, this.centerX + 53.0, this.centerY + 162.0);
        this.hslColorPicker = new JFXColorPickerUI((int)this.distance);
        this.hslColorPicker.setLayoutX(this.centerX - this.distance / 2.0);
        this.hslColorPicker.setLayoutY(this.centerY - this.distance / 2.0);
        this.getChildren().add((Object)this.hslColorPicker);
        int n2 = this.getChildren().size();
        int n3 = n2 + this.shapesNumber;
        for (int i2 = 0; i2 < this.shapesNumber; ++i2) {
            double d2 = (double)(2 * i2) * Math.PI / (double)this.shapesNumber;
            RecentColorPath recentColorPath3 = new RecentColorPath(new PathElement[]{this.startPoint, this.curve0To, this.outerCircleCurveTo, this.curve1To, this.innerCircleCurveTo});
            this.shapes.add(recentColorPath3);
            recentColorPath3.setPickOnBounds(false);
            Rotate rotate = new Rotate(Math.toDegrees(d2), this.centerX, this.centerY);
            recentColorPath3.getTransforms().add((Object)rotate);
            this.getChildren().add(n2, (Object)recentColorPath3);
            recentColorPath3.setFill((Paint)Color.valueOf((String)this.getDefaultColor(i2)));
            recentColorPath3.setFocusTraversable(true);
            recentColorPath3.addEventHandler(MouseEvent.MOUSE_CLICKED, mouseEvent -> {
                recentColorPath3.requestFocus();
                this.selectedPath.set((Object)recentColorPath3);
            });
        }
        this.selectedPath.addListener((observableValue, recentColorPath, recentColorPath2) -> {
            if (recentColorPath != null) {
                this.hslColorPicker.removeColorSelectionNode(new Node[]{recentColorPath});
                recentColorPath.playTransition(-1.0);
            }
            while (this.getChildren().indexOf((Object)recentColorPath2) != n3 - 1) {
                Node node = (Node)this.getChildren().get(n3 - 1);
                this.getChildren().remove(n3 - 1);
                this.getChildren().add(n2, (Object)node);
            }
            recentColorPath2.setStroke((Paint)Color.rgb((int)255, (int)255, (int)255, (double)0.87));
            recentColorPath2.playTransition(1.0);
            this.hslColorPicker.moveToColor((Color)recentColorPath2.getFill());
            this.hslColorPicker.addColorSelectionNode(new Node[]{recentColorPath2});
        });
        this.selectedPath.set((Object)((RecentColorPath)((Object)this.getChildren().get(n2))));
    }

    public int getShapesNumber() {
        return this.shapesNumber;
    }

    public int getSelectedIndex() {
        if (this.selectedPath.get() != null) {
            return this.shapes.indexOf(this.selectedPath.get());
        }
        return -1;
    }

    public void setColor(Color color) {
        this.shapes.get(this.getSelectedIndex()).setFill((Paint)color);
        this.hslColorPicker.moveToColor(color);
    }

    public Color getColor(int n2) {
        if (n2 >= 0 && n2 < this.shapes.size()) {
            return (Color)this.shapes.get(n2).getFill();
        }
        return Color.WHITE;
    }

    public void preAnimate() {
        CubicCurve cubicCurve = this.curves.get(0);
        double d2 = cubicCurve.getStartX();
        double d3 = cubicCurve.getStartY();
        cubicCurve.setStartX(this.centerX);
        cubicCurve.setStartY(this.centerY);
        CubicCurve cubicCurve2 = this.curves.get(1);
        double d4 = cubicCurve2.getStartX();
        double d5 = cubicCurve2.getStartY();
        cubicCurve2.setStartX(this.centerX);
        cubicCurve2.setStartY(this.centerY);
        double d6 = cubicCurve.getControlX1();
        double d7 = cubicCurve.getControlY1();
        cubicCurve.setControlX1(this.centerX + this.radius);
        cubicCurve.setControlY1(this.centerY + this.radius / 2.0);
        KeyFrame keyFrame = new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)cubicCurve.startXProperty(), (Object)d2, Interpolator.EASE_BOTH), new KeyValue((WritableValue)cubicCurve.startYProperty(), (Object)d3, Interpolator.EASE_BOTH), new KeyValue((WritableValue)cubicCurve2.startXProperty(), (Object)d4, Interpolator.EASE_BOTH), new KeyValue((WritableValue)cubicCurve2.startYProperty(), (Object)d5, Interpolator.EASE_BOTH), new KeyValue((WritableValue)cubicCurve.controlX1Property(), (Object)d6, Interpolator.EASE_BOTH), new KeyValue((WritableValue)cubicCurve.controlY1Property(), (Object)d7, Interpolator.EASE_BOTH)});
        Timeline timeline = new Timeline(new KeyFrame[]{keyFrame});
        this.showAnimation = new CachedTransition((Node)this, timeline){
            {
                this.setCycleDuration(Duration.millis((double)240.0));
                this.setDelay(Duration.millis((double)0.0));
            }
        };
    }

    public void animate() {
        this.showAnimation.play();
    }

    private void init(DoubleProperty doubleProperty, double d2, double d3) {
        Circle circle = new Circle(this.centerX, this.centerY, this.radius, (Paint)Color.TRANSPARENT);
        Circle circle2 = new Circle(this.centerX, this.centerY, this.radius * 2.0, (Paint)Color.web((String)"blue", (double)0.5));
        this.createQuadraticCurve(doubleProperty, d2, d3);
        CubicCurve cubicCurve = new CubicCurve();
        cubicCurve.startXProperty().bind((ObservableValue)this.curves.get(0).startXProperty());
        cubicCurve.startYProperty().bind((ObservableValue)this.curves.get(0).startYProperty());
        cubicCurve.endXProperty().bind((ObservableValue)this.curves.get(1).startXProperty());
        cubicCurve.endYProperty().bind((ObservableValue)this.curves.get(1).startYProperty());
        this.curves.get(0).startXProperty().addListener((observableValue, number, number2) -> {
            Point2D point2D = this.makeControlPoint(number2.doubleValue(), this.curves.get(0).getStartY(), circle, this.shapesNumber, -1);
            cubicCurve.setControlX1(point2D.getX());
            cubicCurve.setControlY1(point2D.getY());
        });
        this.curves.get(0).startYProperty().addListener((observableValue, number, number2) -> {
            Point2D point2D = this.makeControlPoint(this.curves.get(0).getStartX(), number2.doubleValue(), circle, this.shapesNumber, -1);
            cubicCurve.setControlX1(point2D.getX());
            cubicCurve.setControlY1(point2D.getY());
        });
        this.curves.get(1).startXProperty().addListener((observableValue, number, number2) -> {
            Point2D point2D = this.makeControlPoint(number2.doubleValue(), this.curves.get(1).getStartY(), circle, this.shapesNumber, 1);
            cubicCurve.setControlX2(point2D.getX());
            cubicCurve.setControlY2(point2D.getY());
        });
        this.curves.get(1).startYProperty().addListener((observableValue, number, number2) -> {
            Point2D point2D = this.makeControlPoint(this.curves.get(1).getStartX(), number2.doubleValue(), circle, this.shapesNumber, 1);
            cubicCurve.setControlX2(point2D.getX());
            cubicCurve.setControlY2(point2D.getY());
        });
        Point2D point2D = this.makeControlPoint(this.curves.get(0).getStartX(), this.curves.get(0).getStartY(), circle, this.shapesNumber, -1);
        cubicCurve.setControlX1(point2D.getX());
        cubicCurve.setControlY1(point2D.getY());
        point2D = this.makeControlPoint(this.curves.get(1).getStartX(), this.curves.get(1).getStartY(), circle, this.shapesNumber, 1);
        cubicCurve.setControlX2(point2D.getX());
        cubicCurve.setControlY2(point2D.getY());
        CubicCurve cubicCurve2 = new CubicCurve();
        cubicCurve2.startXProperty().bind((ObservableValue)this.curves.get(0).endXProperty());
        cubicCurve2.startYProperty().bind((ObservableValue)this.curves.get(0).endYProperty());
        cubicCurve2.endXProperty().bind((ObservableValue)this.curves.get(1).endXProperty());
        cubicCurve2.endYProperty().bind((ObservableValue)this.curves.get(1).endYProperty());
        point2D = this.makeControlPoint(this.curves.get(0).getEndX(), this.curves.get(0).getEndY(), circle2, this.shapesNumber, -1);
        cubicCurve2.setControlX1(point2D.getX());
        cubicCurve2.setControlY1(point2D.getY());
        point2D = this.makeControlPoint(this.curves.get(1).getEndX(), this.curves.get(1).getEndY(), circle2, this.shapesNumber, 1);
        cubicCurve2.setControlX2(point2D.getX());
        cubicCurve2.setControlY2(point2D.getY());
        this.startPoint = new MoveTo();
        this.startPoint.xProperty().bind((ObservableValue)this.curves.get(0).startXProperty());
        this.startPoint.yProperty().bind((ObservableValue)this.curves.get(0).startYProperty());
        this.curve0To = new CubicCurveTo();
        this.curve0To.controlX1Property().bind((ObservableValue)this.curves.get(0).controlX1Property());
        this.curve0To.controlY1Property().bind((ObservableValue)this.curves.get(0).controlY1Property());
        this.curve0To.controlX2Property().bind((ObservableValue)this.curves.get(0).controlX2Property());
        this.curve0To.controlY2Property().bind((ObservableValue)this.curves.get(0).controlY2Property());
        this.curve0To.xProperty().bind((ObservableValue)this.curves.get(0).endXProperty());
        this.curve0To.yProperty().bind((ObservableValue)this.curves.get(0).endYProperty());
        this.outerCircleCurveTo = new CubicCurveTo();
        this.outerCircleCurveTo.controlX1Property().bind((ObservableValue)cubicCurve2.controlX1Property());
        this.outerCircleCurveTo.controlY1Property().bind((ObservableValue)cubicCurve2.controlY1Property());
        this.outerCircleCurveTo.controlX2Property().bind((ObservableValue)cubicCurve2.controlX2Property());
        this.outerCircleCurveTo.controlY2Property().bind((ObservableValue)cubicCurve2.controlY2Property());
        this.outerCircleCurveTo.xProperty().bind((ObservableValue)cubicCurve2.endXProperty());
        this.outerCircleCurveTo.yProperty().bind((ObservableValue)cubicCurve2.endYProperty());
        this.curve1To = new CubicCurveTo();
        this.curve1To.controlX1Property().bind((ObservableValue)this.curves.get(1).controlX2Property());
        this.curve1To.controlY1Property().bind((ObservableValue)this.curves.get(1).controlY2Property());
        this.curve1To.controlX2Property().bind((ObservableValue)this.curves.get(1).controlX1Property());
        this.curve1To.controlY2Property().bind((ObservableValue)this.curves.get(1).controlY1Property());
        this.curve1To.xProperty().bind((ObservableValue)this.curves.get(1).startXProperty());
        this.curve1To.yProperty().bind((ObservableValue)this.curves.get(1).startYProperty());
        this.innerCircleCurveTo = new CubicCurveTo();
        this.innerCircleCurveTo.controlX1Property().bind((ObservableValue)cubicCurve.controlX2Property());
        this.innerCircleCurveTo.controlY1Property().bind((ObservableValue)cubicCurve.controlY2Property());
        this.innerCircleCurveTo.controlX2Property().bind((ObservableValue)cubicCurve.controlX1Property());
        this.innerCircleCurveTo.controlY2Property().bind((ObservableValue)cubicCurve.controlY1Property());
        this.innerCircleCurveTo.xProperty().bind((ObservableValue)cubicCurve.startXProperty());
        this.innerCircleCurveTo.yProperty().bind((ObservableValue)cubicCurve.startYProperty());
    }

    private void createQuadraticCurve(DoubleProperty doubleProperty, double d2, double d3) {
        for (int i2 = 0; i2 < 2; ++i2) {
            double d4 = (double)(2 * i2) * Math.PI / (double)this.shapesNumber;
            double d5 = this.radius * Math.cos(d4);
            double d6 = this.radius * Math.sin(d4);
            double d7 = this.centerX + d5;
            double d8 = this.centerY + d6;
            double d9 = d7 - this.centerX;
            double d10 = d8 - this.centerY;
            double d11 = Math.sin(doubleProperty.get());
            double d12 = Math.cos(doubleProperty.get());
            double d13 = d12 * d9 - d11 * d10 + this.centerX;
            double d14 = d11 * d9 + d12 * d10 + this.centerY;
            d4 = (double)(2 * i2) * Math.PI / (double)this.shapesNumber;
            d5 = this.distance * Math.cos(d4);
            d6 = this.distance * Math.sin(d4);
            double d15 = this.centerX + d5;
            double d16 = this.centerY + d6;
            CubicCurve cubicCurve = new CubicCurve();
            cubicCurve.setStartX(d13);
            cubicCurve.setStartY(d14);
            cubicCurve.setControlX1(d13);
            cubicCurve.setControlY1(d14);
            cubicCurve.setControlX2(d15);
            cubicCurve.setControlY2(d16);
            cubicCurve.setEndX(d15);
            cubicCurve.setEndY(d16);
            cubicCurve.setStroke((Paint)Color.FORESTGREEN);
            cubicCurve.setStrokeWidth(1.0);
            cubicCurve.setStrokeLineCap(StrokeLineCap.ROUND);
            cubicCurve.setFill((Paint)Color.TRANSPARENT);
            cubicCurve.setMouseTransparent(true);
            doubleProperty.addListener((observableValue, number, number2) -> {
                double d6 = d12 * d9 - d11 * d10 + this.centerX;
                double d7 = d11 * d9 + d12 * d10 + this.centerY;
                cubicCurve.setStartX(d6);
                cubicCurve.setStartY(d7);
            });
            this.curves.add(cubicCurve);
            if (i2 == 0) {
                cubicCurve.setControlX1(d2);
                cubicCurve.setControlY1(d3);
                continue;
            }
            CubicCurve cubicCurve2 = this.curves.get(0);
            double d17 = (double)(2 * this.curves.indexOf(cubicCurve)) * Math.PI / (double)this.shapesNumber;
            cubicCurve.controlX1Property().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
                double d3 = cubicCurve2.getControlX1() - this.centerX;
                double d4 = Math.sin(d17) * (cubicCurve2.getControlY1() - this.centerY);
                return Math.cos(d17) * d3 - d4 + this.centerX;
            }, (Observable[])new Observable[]{cubicCurve2.controlX1Property(), cubicCurve2.controlY1Property()}));
            cubicCurve.controlY1Property().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
                double d3 = Math.sin(d17) * (cubicCurve2.getControlX1() - this.centerX);
                double d4 = Math.cos(d17) * (cubicCurve2.getControlY1() - this.centerY);
                return d3 + d4 + this.centerY;
            }, (Observable[])new Observable[]{cubicCurve2.controlX1Property(), cubicCurve2.controlY1Property()}));
            cubicCurve.controlX2Property().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
                double d3 = cubicCurve2.getControlX2() - this.centerX;
                double d4 = cubicCurve2.getControlY2() - this.centerY;
                return Math.cos(d17) * d3 - Math.sin(d17) * d4 + this.centerX;
            }, (Observable[])new Observable[]{cubicCurve2.controlX2Property(), cubicCurve2.controlY2Property()}));
            cubicCurve.controlY2Property().bind((ObservableValue)Bindings.createDoubleBinding(() -> {
                double d3 = Math.sin(d17) * (cubicCurve2.getControlX2() - this.centerX);
                double d4 = Math.cos(d17) * (cubicCurve2.getControlY2() - this.centerY);
                return d3 + d4 + this.centerY;
            }, (Observable[])new Observable[]{cubicCurve2.controlX2Property(), cubicCurve2.controlY2Property()}));
        }
    }

    private String getDefaultColor(int n2) {
        String string = "#FFFFFF";
        switch (n2) {
            case 0: {
                string = "#8F3F7E";
                break;
            }
            case 1: {
                string = "#B5305F";
                break;
            }
            case 2: {
                string = "#CE584A";
                break;
            }
            case 3: {
                string = "#DB8D5C";
                break;
            }
            case 4: {
                string = "#DA854E";
                break;
            }
            case 5: {
                string = "#E9AB44";
                break;
            }
            case 6: {
                string = "#FEE435";
                break;
            }
            case 7: {
                string = "#99C286";
                break;
            }
            case 8: {
                string = "#01A05E";
                break;
            }
            case 9: {
                string = "#4A8895";
                break;
            }
            case 10: {
                string = "#16669B";
                break;
            }
            case 11: {
                string = "#2F65A5";
                break;
            }
            case 12: {
                string = "#4E6A9C";
                break;
            }
        }
        return string;
    }

    private Point2D rotate(Point2D point2D, Point2D point2D2, double d2) {
        double d3 = point2D2.getX() + (point2D.getX() - point2D2.getX()) * Math.cos(d2) - (point2D.getY() - point2D2.getY()) * Math.sin(d2);
        double d4 = point2D2.getY() + (point2D.getX() - point2D2.getX()) * Math.sin(d2) + (point2D.getY() - point2D2.getY()) * Math.cos(d2);
        return new Point2D(d3, d4);
    }

    private Point2D makeControlPoint(double d2, double d3, Circle circle, int n2, int n3) {
        double d4 = 1.3333333333333333 * Math.tan(Math.PI / (double)(2 * n2)) * circle.getRadius();
        Point2D point2D = new Point2D(circle.getCenterX(), circle.getCenterY());
        Point2D point2D2 = new Point2D(d2, d3);
        Point2D point2D3 = this.rotate(point2D, point2D2, (double)n3 * Math.PI / 2.0);
        Point2D point2D4 = point2D3.subtract(point2D2);
        point2D4 = point2D4.normalize();
        point2D4 = this.scale(point2D4, d4);
        return point2D2.add(point2D4);
    }

    private Point2D scale(Point2D point2D, double d2) {
        return new Point2D(point2D.getX() * d2, point2D.getY() * d2);
    }

    private final class PathClickTransition
    extends CachedTransition {
        PathClickTransition(Path path) {
            super((Node)JFXCustomColorPicker.this, new Timeline(new KeyFrame[]{new KeyFrame(Duration.ZERO, new KeyValue[]{new KeyValue((WritableValue)((DropShadow)path.getEffect()).radiusProperty(), (Object)JFXDepthManager.getShadowAt(2).radiusProperty().get(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)((DropShadow)path.getEffect()).spreadProperty(), (Object)JFXDepthManager.getShadowAt(2).spreadProperty().get(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)((DropShadow)path.getEffect()).offsetXProperty(), (Object)JFXDepthManager.getShadowAt(2).offsetXProperty().get(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)((DropShadow)path.getEffect()).offsetYProperty(), (Object)JFXDepthManager.getShadowAt(2).offsetYProperty().get(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)path.strokeWidthProperty(), (Object)0, Interpolator.EASE_BOTH)}), new KeyFrame(Duration.millis((double)1000.0), new KeyValue[]{new KeyValue((WritableValue)((DropShadow)path.getEffect()).radiusProperty(), (Object)JFXDepthManager.getShadowAt(5).radiusProperty().get(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)((DropShadow)path.getEffect()).spreadProperty(), (Object)JFXDepthManager.getShadowAt(5).spreadProperty().get(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)((DropShadow)path.getEffect()).offsetXProperty(), (Object)JFXDepthManager.getShadowAt(5).offsetXProperty().get(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)((DropShadow)path.getEffect()).offsetYProperty(), (Object)JFXDepthManager.getShadowAt(5).offsetYProperty().get(), Interpolator.EASE_BOTH), new KeyValue((WritableValue)path.strokeWidthProperty(), (Object)2, Interpolator.EASE_BOTH)})}));
            this.setCycleDuration(Duration.millis((double)120.0));
            this.setDelay(Duration.seconds((double)0.0));
            this.setAutoReverse(false);
        }
    }

    final class RecentColorPath
    extends Path {
        PathClickTransition transition;

        RecentColorPath(PathElement ... pathElementArray) {
            super(pathElementArray);
            this.setStrokeLineCap(StrokeLineCap.ROUND);
            this.setStrokeWidth(0.0);
            this.setStrokeType(StrokeType.CENTERED);
            this.setCache(true);
            JFXDepthManager.setDepth((Node)this, 2);
            this.transition = new PathClickTransition(this);
        }

        void playTransition(double d2) {
            this.transition.setRate(d2);
            this.transition.play();
        }
    }
}

