/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.model.Parameter;
import com.github.scribejava.core.utils.OAuthEncoder;
import com.github.scribejava.core.utils.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class ParameterList {
    private static final char QUERY_STRING_SEPARATOR = '?';
    private static final String PARAM_SEPARATOR = "&";
    private static final String PAIR_SEPARATOR = "=";
    private static final String EMPTY_STRING = "";
    private final List<Parameter> params;

    public ParameterList() {
        this.params = new ArrayList<Parameter>();
    }

    ParameterList(List<Parameter> list) {
        this.params = new ArrayList<Parameter>(list);
    }

    public ParameterList(Map<String, String> map) {
        this();
        if (map != null && !map.isEmpty()) {
            for (Map.Entry<String, String> entry : map.entrySet()) {
                this.params.add(new Parameter(entry.getKey(), entry.getValue()));
            }
        }
    }

    public void add(String string, String string2) {
        this.params.add(new Parameter(string, string2));
    }

    public String appendTo(String string) {
        Preconditions.checkNotNull(string, "Cannot append to null URL");
        String string2 = this.asFormUrlEncodedString();
        if (string2.equals(EMPTY_STRING)) {
            return string;
        }
        return string + (string.indexOf(63) == -1 ? Character.valueOf('?') : PARAM_SEPARATOR) + string2;
    }

    public String asOauthBaseString() {
        return OAuthEncoder.encode(this.asFormUrlEncodedString());
    }

    public String asFormUrlEncodedString() {
        if (this.params.isEmpty()) {
            return EMPTY_STRING;
        }
        StringBuilder stringBuilder = new StringBuilder();
        for (Parameter parameter : this.params) {
            stringBuilder.append(PARAM_SEPARATOR).append(parameter.asUrlEncodedPair());
        }
        return stringBuilder.substring(1);
    }

    public void addAll(ParameterList parameterList) {
        this.params.addAll(parameterList.getParams());
    }

    public void addQuerystring(String string) {
        if (string != null && !string.isEmpty()) {
            for (String string2 : string.split(PARAM_SEPARATOR)) {
                String[] stringArray = string2.split(PAIR_SEPARATOR);
                String string3 = OAuthEncoder.decode(stringArray[0]);
                String string4 = stringArray.length > 1 ? OAuthEncoder.decode(stringArray[1]) : EMPTY_STRING;
                this.params.add(new Parameter(string3, string4));
            }
        }
    }

    public boolean contains(Parameter parameter) {
        return this.params.contains(parameter);
    }

    public int size() {
        return this.params.size();
    }

    public List<Parameter> getParams() {
        return this.params;
    }

    public ParameterList sort() {
        ParameterList parameterList = new ParameterList(this.params);
        Collections.sort(parameterList.getParams());
        return parameterList;
    }
}

