/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.model;

import com.github.scribejava.core.model.Token;
import com.github.scribejava.core.utils.Preconditions;
import java.util.Objects;

public class OAuth2AccessToken
extends Token {
    private static final long serialVersionUID = 8901381135476613449L;
    private String accessToken;
    private String tokenType;
    private Integer expiresIn;
    private String refreshToken;
    private String scope;

    public OAuth2AccessToken(String string) {
        this(string, null);
    }

    public OAuth2AccessToken(String string, String string2) {
        this(string, null, null, null, null, string2);
    }

    public OAuth2AccessToken(String string, String string2, Integer n2, String string3, String string4, String string5) {
        super(string5);
        Preconditions.checkNotNull(string, "access_token can't be null");
        this.accessToken = string;
        this.tokenType = string2;
        this.expiresIn = n2;
        this.refreshToken = string3;
        this.scope = string4;
    }

    public String getAccessToken() {
        return this.accessToken;
    }

    public String getTokenType() {
        return this.tokenType;
    }

    public Integer getExpiresIn() {
        return this.expiresIn;
    }

    public String getRefreshToken() {
        return this.refreshToken;
    }

    public String getScope() {
        return this.scope;
    }

    public int hashCode() {
        int n2 = 7;
        n2 = 41 * n2 + Objects.hashCode(this.accessToken);
        n2 = 41 * n2 + Objects.hashCode(this.tokenType);
        n2 = 41 * n2 + Objects.hashCode(this.expiresIn);
        n2 = 41 * n2 + Objects.hashCode(this.refreshToken);
        n2 = 41 * n2 + Objects.hashCode(this.scope);
        return n2;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (this.getClass() != object.getClass()) {
            return false;
        }
        OAuth2AccessToken oAuth2AccessToken = (OAuth2AccessToken)object;
        if (!Objects.equals(this.accessToken, oAuth2AccessToken.getAccessToken())) {
            return false;
        }
        if (!Objects.equals(this.tokenType, oAuth2AccessToken.getTokenType())) {
            return false;
        }
        if (!Objects.equals(this.refreshToken, oAuth2AccessToken.getRefreshToken())) {
            return false;
        }
        if (!Objects.equals(this.scope, oAuth2AccessToken.getScope())) {
            return false;
        }
        return Objects.equals(this.expiresIn, oAuth2AccessToken.getExpiresIn());
    }
}

