/*
 * Decompiled with CFR 0.152.
 */
package com.github.scribejava.core.builder;

import com.github.scribejava.core.builder.api.BaseApi;
import com.github.scribejava.core.httpclient.HttpClient;
import com.github.scribejava.core.httpclient.HttpClientConfig;
import com.github.scribejava.core.model.OAuthConfig;
import com.github.scribejava.core.oauth.OAuthService;
import com.github.scribejava.core.utils.Preconditions;
import java.io.OutputStream;

public class ServiceBuilder {
    private String callback;
    private String apiKey;
    private String apiSecret;
    private String scope;
    private String state;
    private OutputStream debugStream;
    private String responseType = "code";
    private String userAgent;
    private HttpClientConfig httpClientConfig;
    private HttpClient httpClient;

    public ServiceBuilder(String string) {
        this.apiKey(string);
    }

    public ServiceBuilder callback(String string) {
        this.callback = string;
        return this;
    }

    public final ServiceBuilder apiKey(String string) {
        Preconditions.checkEmptyString(string, "Invalid Api key");
        this.apiKey = string;
        return this;
    }

    public ServiceBuilder apiSecret(String string) {
        Preconditions.checkEmptyString(string, "Invalid Api secret");
        this.apiSecret = string;
        return this;
    }

    public ServiceBuilder scope(String string) {
        Preconditions.checkEmptyString(string, "Invalid OAuth scope");
        this.scope = string;
        return this;
    }

    public ServiceBuilder state(String string) {
        Preconditions.checkEmptyString(string, "Invalid OAuth state");
        this.state = string;
        return this;
    }

    public ServiceBuilder debugStream(OutputStream outputStream) {
        Preconditions.checkNotNull(outputStream, "debug stream can't be null");
        this.debugStream = outputStream;
        return this;
    }

    public ServiceBuilder responseType(String string) {
        Preconditions.checkEmptyString(string, "Invalid OAuth responseType");
        this.responseType = string;
        return this;
    }

    public ServiceBuilder httpClientConfig(HttpClientConfig httpClientConfig) {
        Preconditions.checkNotNull(httpClientConfig, "httpClientConfig can't be null");
        this.httpClientConfig = httpClientConfig;
        return this;
    }

    public ServiceBuilder httpClient(HttpClient httpClient) {
        this.httpClient = httpClient;
        return this;
    }

    public ServiceBuilder userAgent(String string) {
        this.userAgent = string;
        return this;
    }

    public ServiceBuilder debug() {
        this.debugStream(System.out);
        return this;
    }

    public <S extends OAuthService> S build(BaseApi<S> baseApi) {
        return baseApi.createService(new OAuthConfig(this.apiKey, this.apiSecret, this.callback, this.scope, this.debugStream, this.state, this.responseType, this.userAgent, this.httpClientConfig, this.httpClient));
    }
}

