/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind.deser.std;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonIncludeProperties;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.StreamReadCapability;
import com.fasterxml.jackson.databind.AnnotationIntrospector;
import com.fasterxml.jackson.databind.BeanProperty;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.KeyDeserializer;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.annotation.JacksonStdImpl;
import com.fasterxml.jackson.databind.deser.ContextualDeserializer;
import com.fasterxml.jackson.databind.deser.ContextualKeyDeserializer;
import com.fasterxml.jackson.databind.deser.NullValueProvider;
import com.fasterxml.jackson.databind.deser.ResolvableDeserializer;
import com.fasterxml.jackson.databind.deser.SettableBeanProperty;
import com.fasterxml.jackson.databind.deser.UnresolvedForwardReference;
import com.fasterxml.jackson.databind.deser.ValueInstantiator;
import com.fasterxml.jackson.databind.deser.impl.PropertyBasedCreator;
import com.fasterxml.jackson.databind.deser.impl.PropertyValueBuffer;
import com.fasterxml.jackson.databind.deser.impl.ReadableObjectId;
import com.fasterxml.jackson.databind.deser.std.ContainerDeserializerBase;
import com.fasterxml.jackson.databind.introspect.AnnotatedMember;
import com.fasterxml.jackson.databind.jsontype.TypeDeserializer;
import com.fasterxml.jackson.databind.type.LogicalType;
import com.fasterxml.jackson.databind.util.ArrayBuilders;
import com.fasterxml.jackson.databind.util.IgnorePropertiesUtil;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

@JacksonStdImpl
public class MapDeserializer
extends ContainerDeserializerBase<Map<Object, Object>>
implements ContextualDeserializer,
ResolvableDeserializer {
    private static final long serialVersionUID = 1L;
    protected final KeyDeserializer _keyDeserializer;
    protected boolean _standardStringKey;
    protected final JsonDeserializer<Object> _valueDeserializer;
    protected final TypeDeserializer _valueTypeDeserializer;
    protected final ValueInstantiator _valueInstantiator;
    protected JsonDeserializer<Object> _delegateDeserializer;
    protected PropertyBasedCreator _propertyBasedCreator;
    protected final boolean _hasDefaultCreator;
    protected Set<String> _ignorableProperties;
    protected Set<String> _includableProperties;
    protected IgnorePropertiesUtil.Checker _inclusionChecker;
    protected boolean _checkDupSquash;

    public MapDeserializer(JavaType javaType, ValueInstantiator valueInstantiator, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer) {
        super(javaType, null, null);
        this._keyDeserializer = keyDeserializer;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._valueInstantiator = valueInstantiator;
        this._hasDefaultCreator = valueInstantiator.canCreateUsingDefault();
        this._delegateDeserializer = null;
        this._propertyBasedCreator = null;
        this._standardStringKey = this._isStdKeyDeser(javaType, keyDeserializer);
        this._inclusionChecker = null;
        this._checkDupSquash = javaType.getContentType().hasRawClass(Object.class);
    }

    protected MapDeserializer(MapDeserializer mapDeserializer) {
        super(mapDeserializer);
        this._keyDeserializer = mapDeserializer._keyDeserializer;
        this._valueDeserializer = mapDeserializer._valueDeserializer;
        this._valueTypeDeserializer = mapDeserializer._valueTypeDeserializer;
        this._valueInstantiator = mapDeserializer._valueInstantiator;
        this._propertyBasedCreator = mapDeserializer._propertyBasedCreator;
        this._delegateDeserializer = mapDeserializer._delegateDeserializer;
        this._hasDefaultCreator = mapDeserializer._hasDefaultCreator;
        this._ignorableProperties = mapDeserializer._ignorableProperties;
        this._includableProperties = mapDeserializer._includableProperties;
        this._inclusionChecker = mapDeserializer._inclusionChecker;
        this._standardStringKey = mapDeserializer._standardStringKey;
        this._checkDupSquash = mapDeserializer._checkDupSquash;
    }

    protected MapDeserializer(MapDeserializer mapDeserializer, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer, NullValueProvider nullValueProvider, Set<String> set) {
        this(mapDeserializer, keyDeserializer, jsonDeserializer, typeDeserializer, nullValueProvider, set, null);
    }

    protected MapDeserializer(MapDeserializer mapDeserializer, KeyDeserializer keyDeserializer, JsonDeserializer<Object> jsonDeserializer, TypeDeserializer typeDeserializer, NullValueProvider nullValueProvider, Set<String> set, Set<String> set2) {
        super(mapDeserializer, nullValueProvider, mapDeserializer._unwrapSingle);
        this._keyDeserializer = keyDeserializer;
        this._valueDeserializer = jsonDeserializer;
        this._valueTypeDeserializer = typeDeserializer;
        this._valueInstantiator = mapDeserializer._valueInstantiator;
        this._propertyBasedCreator = mapDeserializer._propertyBasedCreator;
        this._delegateDeserializer = mapDeserializer._delegateDeserializer;
        this._hasDefaultCreator = mapDeserializer._hasDefaultCreator;
        this._ignorableProperties = set;
        this._includableProperties = set2;
        this._inclusionChecker = IgnorePropertiesUtil.buildCheckerIfNeeded(set, set2);
        this._standardStringKey = this._isStdKeyDeser(this._containerType, keyDeserializer);
        this._checkDupSquash = mapDeserializer._checkDupSquash;
    }

    protected MapDeserializer withResolved(KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider, Set<String> set) {
        return this.withResolved(keyDeserializer, typeDeserializer, jsonDeserializer, nullValueProvider, set, this._includableProperties);
    }

    protected MapDeserializer withResolved(KeyDeserializer keyDeserializer, TypeDeserializer typeDeserializer, JsonDeserializer<?> jsonDeserializer, NullValueProvider nullValueProvider, Set<String> set, Set<String> set2) {
        if (this._keyDeserializer == keyDeserializer && this._valueDeserializer == jsonDeserializer && this._valueTypeDeserializer == typeDeserializer && this._nullProvider == nullValueProvider && this._ignorableProperties == set && this._includableProperties == set2) {
            return this;
        }
        return new MapDeserializer(this, keyDeserializer, jsonDeserializer, typeDeserializer, nullValueProvider, set, set2);
    }

    protected final boolean _isStdKeyDeser(JavaType javaType, KeyDeserializer keyDeserializer) {
        if (keyDeserializer == null) {
            return true;
        }
        JavaType javaType2 = javaType.getKeyType();
        if (javaType2 == null) {
            return true;
        }
        Class<?> clazz = javaType2.getRawClass();
        return (clazz == String.class || clazz == Object.class) && this.isDefaultKeyDeserializer(keyDeserializer);
    }

    @Deprecated
    public void setIgnorableProperties(String[] stringArray) {
        this._ignorableProperties = stringArray == null || stringArray.length == 0 ? null : ArrayBuilders.arrayToSet(stringArray);
        this._inclusionChecker = IgnorePropertiesUtil.buildCheckerIfNeeded(this._ignorableProperties, this._includableProperties);
    }

    public void setIgnorableProperties(Set<String> set) {
        this._ignorableProperties = set == null || set.isEmpty() ? null : set;
        this._inclusionChecker = IgnorePropertiesUtil.buildCheckerIfNeeded(this._ignorableProperties, this._includableProperties);
    }

    public void setIncludableProperties(Set<String> set) {
        this._includableProperties = set;
        this._inclusionChecker = IgnorePropertiesUtil.buildCheckerIfNeeded(this._ignorableProperties, this._includableProperties);
    }

    @Override
    public void resolve(DeserializationContext deserializationContext) throws JsonMappingException {
        Object object;
        if (this._valueInstantiator.canCreateUsingDelegate()) {
            object = this._valueInstantiator.getDelegateType(deserializationContext.getConfig());
            if (object == null) {
                deserializationContext.reportBadDefinition(this._containerType, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingDelegate()', but null for 'getDelegateType()'", this._containerType, this._valueInstantiator.getClass().getName()));
            }
            this._delegateDeserializer = this.findDeserializer(deserializationContext, (JavaType)object, null);
        } else if (this._valueInstantiator.canCreateUsingArrayDelegate()) {
            object = this._valueInstantiator.getArrayDelegateType(deserializationContext.getConfig());
            if (object == null) {
                deserializationContext.reportBadDefinition(this._containerType, String.format("Invalid delegate-creator definition for %s: value instantiator (%s) returned true for 'canCreateUsingArrayDelegate()', but null for 'getArrayDelegateType()'", this._containerType, this._valueInstantiator.getClass().getName()));
            }
            this._delegateDeserializer = this.findDeserializer(deserializationContext, (JavaType)object, null);
        }
        if (this._valueInstantiator.canCreateFromObjectWith()) {
            object = this._valueInstantiator.getFromObjectArguments(deserializationContext.getConfig());
            this._propertyBasedCreator = PropertyBasedCreator.construct(deserializationContext, this._valueInstantiator, object, deserializationContext.isEnabled(MapperFeature.ACCEPT_CASE_INSENSITIVE_PROPERTIES));
        }
        this._standardStringKey = this._isStdKeyDeser(this._containerType, this._keyDeserializer);
    }

    @Override
    public JsonDeserializer<?> createContextual(DeserializationContext deserializationContext, BeanProperty beanProperty) throws JsonMappingException {
        AnnotatedMember annotatedMember;
        KeyDeserializer keyDeserializer = this._keyDeserializer;
        if (keyDeserializer == null) {
            keyDeserializer = deserializationContext.findKeyDeserializer(this._containerType.getKeyType(), beanProperty);
        } else if (keyDeserializer instanceof ContextualKeyDeserializer) {
            keyDeserializer = ((ContextualKeyDeserializer)((Object)keyDeserializer)).createContextual(deserializationContext, beanProperty);
        }
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        if (beanProperty != null) {
            jsonDeserializer = this.findConvertingContentDeserializer(deserializationContext, beanProperty, jsonDeserializer);
        }
        JavaType javaType = this._containerType.getContentType();
        jsonDeserializer = jsonDeserializer == null ? deserializationContext.findContextualValueDeserializer(javaType, beanProperty) : deserializationContext.handleSecondaryContextualization(jsonDeserializer, beanProperty, javaType);
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        if (typeDeserializer != null) {
            typeDeserializer = typeDeserializer.forProperty(beanProperty);
        }
        Set<String> set = this._ignorableProperties;
        Set<String> set2 = this._includableProperties;
        AnnotationIntrospector annotationIntrospector = deserializationContext.getAnnotationIntrospector();
        if (MapDeserializer._neitherNull(annotationIntrospector, beanProperty) && (annotatedMember = beanProperty.getMember()) != null) {
            HashSet<String> hashSet;
            Object object;
            Object object2;
            DeserializationConfig deserializationConfig = deserializationContext.getConfig();
            JsonIgnoreProperties.Value value = annotationIntrospector.findPropertyIgnoralByName(deserializationConfig, annotatedMember);
            if (value != null && !(object2 = value.findIgnoredForDeserialization()).isEmpty()) {
                set = set == null ? new HashSet<String>() : new HashSet<String>(set);
                object = object2.iterator();
                while (object.hasNext()) {
                    hashSet = (String)object.next();
                    set.add((String)((Object)hashSet));
                }
            }
            if ((object2 = annotationIntrospector.findPropertyInclusionByName(deserializationConfig, annotatedMember)) != null && (object = ((JsonIncludeProperties.Value)object2).getIncluded()) != null) {
                hashSet = new HashSet();
                if (set2 == null) {
                    hashSet = new HashSet<String>((Collection<String>)object);
                } else {
                    Iterator iterator = object.iterator();
                    while (iterator.hasNext()) {
                        String string = (String)iterator.next();
                        if (!set2.contains(string)) continue;
                        hashSet.add(string);
                    }
                }
                set2 = hashSet;
            }
        }
        return this.withResolved(keyDeserializer, typeDeserializer, jsonDeserializer, this.findContentNullProvider(deserializationContext, beanProperty, jsonDeserializer), set, set2);
    }

    @Override
    public JsonDeserializer<Object> getContentDeserializer() {
        return this._valueDeserializer;
    }

    @Override
    public ValueInstantiator getValueInstantiator() {
        return this._valueInstantiator;
    }

    @Override
    public boolean isCachable() {
        return this._valueDeserializer == null && this._keyDeserializer == null && this._valueTypeDeserializer == null && this._ignorableProperties == null && this._includableProperties == null;
    }

    @Override
    public LogicalType logicalType() {
        return LogicalType.Map;
    }

    @Override
    public Map<Object, Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        if (this._propertyBasedCreator != null) {
            return this._deserializeUsingCreator(jsonParser, deserializationContext);
        }
        if (this._delegateDeserializer != null) {
            return (Map)this._valueInstantiator.createUsingDelegate(deserializationContext, this._delegateDeserializer.deserialize(jsonParser, deserializationContext));
        }
        if (!this._hasDefaultCreator) {
            return (Map)deserializationContext.handleMissingInstantiator(this.getMapClass(), this.getValueInstantiator(), jsonParser, "no default constructor found", new Object[0]);
        }
        switch (jsonParser.currentTokenId()) {
            case 1: 
            case 2: 
            case 5: {
                Map map = (Map)this._valueInstantiator.createUsingDefault(deserializationContext);
                if (this._standardStringKey) {
                    return this._readAndBindStringKeyMap(jsonParser, deserializationContext, map);
                }
                return this._readAndBind(jsonParser, deserializationContext, map);
            }
            case 6: {
                return (Map)this._deserializeFromString(jsonParser, deserializationContext);
            }
            case 3: {
                return (Map)this._deserializeFromArray(jsonParser, deserializationContext);
            }
        }
        return (Map)deserializationContext.handleUnexpectedToken(this.getValueType(deserializationContext), jsonParser);
    }

    @Override
    public Map<Object, Object> deserialize(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map) throws IOException {
        jsonParser.assignCurrentValue(map);
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken != JsonToken.START_OBJECT && jsonToken != JsonToken.FIELD_NAME) {
            return (Map)deserializationContext.handleUnexpectedToken(this.getMapClass(), jsonParser);
        }
        if (this._standardStringKey) {
            this._readAndUpdateStringKeyMap(jsonParser, deserializationContext, map);
            return map;
        }
        this._readAndUpdate(jsonParser, deserializationContext, map);
        return map;
    }

    @Override
    public Object deserializeWithType(JsonParser jsonParser, DeserializationContext deserializationContext, TypeDeserializer typeDeserializer) throws IOException {
        return typeDeserializer.deserializeTypedFromObject(jsonParser, deserializationContext);
    }

    public final Class<?> getMapClass() {
        return this._containerType.getRawClass();
    }

    @Override
    public JavaType getValueType() {
        return this._containerType;
    }

    protected final Map<Object, Object> _readAndBind(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map) throws IOException {
        Object object;
        String string;
        boolean bl2;
        KeyDeserializer keyDeserializer = this._keyDeserializer;
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        MapReferringAccumulator mapReferringAccumulator = null;
        boolean bl3 = bl2 = jsonDeserializer.getObjectIdReader() != null;
        if (bl2) {
            mapReferringAccumulator = new MapReferringAccumulator(this._containerType.getContentType().getRawClass(), map);
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            string = jsonParser.nextFieldName();
        } else {
            object = jsonParser.currentToken();
            if (object != JsonToken.FIELD_NAME) {
                if (object == JsonToken.END_OBJECT) {
                    return map;
                }
                deserializationContext.reportWrongTokenException(this, JsonToken.FIELD_NAME, null, new Object[0]);
            }
            string = jsonParser.currentName();
        }
        while (string != null) {
            block16: {
                object = keyDeserializer.deserializeKey(string, deserializationContext);
                JsonToken jsonToken = jsonParser.nextToken();
                if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(string)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        Object object2;
                        if (jsonToken == JsonToken.VALUE_NULL) {
                            if (this._skipNullValues) break block16;
                            object2 = this._nullProvider.getNullValue(deserializationContext);
                        } else {
                            object2 = typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
                        }
                        if (bl2) {
                            mapReferringAccumulator.put(object, object2);
                        } else {
                            Object object3 = map.put(object, object2);
                            if (object3 != null) {
                                this._squashDups(deserializationContext, map, object, object3, object2);
                            }
                        }
                    }
                    catch (UnresolvedForwardReference unresolvedForwardReference) {
                        this.handleUnresolvedReference(deserializationContext, mapReferringAccumulator, object, unresolvedForwardReference);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow(deserializationContext, exception, map, string);
                    }
                }
            }
            string = jsonParser.nextFieldName();
        }
        return map;
    }

    protected final Map<Object, Object> _readAndBindStringKeyMap(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map) throws IOException {
        JsonToken jsonToken;
        String string;
        boolean bl2;
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        MapReferringAccumulator mapReferringAccumulator = null;
        boolean bl3 = bl2 = jsonDeserializer.getObjectIdReader() != null;
        if (bl2) {
            mapReferringAccumulator = new MapReferringAccumulator(this._containerType.getContentType().getRawClass(), map);
        }
        if (jsonParser.isExpectedStartObjectToken()) {
            string = jsonParser.nextFieldName();
        } else {
            jsonToken = jsonParser.currentToken();
            if (jsonToken == JsonToken.END_OBJECT) {
                return map;
            }
            if (jsonToken != JsonToken.FIELD_NAME) {
                deserializationContext.reportWrongTokenException(this, JsonToken.FIELD_NAME, null, new Object[0]);
            }
            string = jsonParser.currentName();
        }
        while (string != null) {
            block16: {
                jsonToken = jsonParser.nextToken();
                if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(string)) {
                    jsonParser.skipChildren();
                } else {
                    try {
                        Object object;
                        if (jsonToken == JsonToken.VALUE_NULL) {
                            if (this._skipNullValues) break block16;
                            object = this._nullProvider.getNullValue(deserializationContext);
                        } else {
                            object = typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
                        }
                        if (bl2) {
                            mapReferringAccumulator.put(string, object);
                        } else {
                            Object object2 = map.put(string, object);
                            if (object2 != null) {
                                this._squashDups(deserializationContext, map, string, object2, object);
                            }
                        }
                    }
                    catch (UnresolvedForwardReference unresolvedForwardReference) {
                        this.handleUnresolvedReference(deserializationContext, mapReferringAccumulator, string, unresolvedForwardReference);
                    }
                    catch (Exception exception) {
                        this.wrapAndThrow(deserializationContext, exception, map, string);
                    }
                }
            }
            string = jsonParser.nextFieldName();
        }
        return map;
    }

    public Map<Object, Object> _deserializeUsingCreator(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException {
        PropertyBasedCreator propertyBasedCreator = this._propertyBasedCreator;
        PropertyValueBuffer propertyValueBuffer = propertyBasedCreator.startBuilding(jsonParser, deserializationContext, null);
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        String string = jsonParser.isExpectedStartObjectToken() ? jsonParser.nextFieldName() : (jsonParser.hasToken(JsonToken.FIELD_NAME) ? jsonParser.currentName() : null);
        while (string != null) {
            block13: {
                JsonToken jsonToken = jsonParser.nextToken();
                if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(string)) {
                    jsonParser.skipChildren();
                } else {
                    Object object;
                    SettableBeanProperty settableBeanProperty = propertyBasedCreator.findCreatorProperty(string);
                    if (settableBeanProperty != null) {
                        if (propertyValueBuffer.assignParameter(settableBeanProperty, settableBeanProperty.deserialize(jsonParser, deserializationContext))) {
                            jsonParser.nextToken();
                            try {
                                object = (Map)propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
                            }
                            catch (Exception exception) {
                                return (Map)this.wrapAndThrow(deserializationContext, exception, this._containerType.getRawClass(), string);
                            }
                            return this._readAndBind(jsonParser, deserializationContext, (Map<Object, Object>)object);
                        }
                    } else {
                        Object object2;
                        block14: {
                            object = this._keyDeserializer.deserializeKey(string, deserializationContext);
                            try {
                                if (jsonToken == JsonToken.VALUE_NULL) {
                                    if (this._skipNullValues) break block13;
                                    object2 = this._nullProvider.getNullValue(deserializationContext);
                                    break block14;
                                }
                                object2 = typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer);
                            }
                            catch (Exception exception) {
                                this.wrapAndThrow(deserializationContext, exception, this._containerType.getRawClass(), string);
                                return null;
                            }
                        }
                        propertyValueBuffer.bufferMapProperty(object, object2);
                    }
                }
            }
            string = jsonParser.nextFieldName();
        }
        try {
            return (Map)propertyBasedCreator.build(deserializationContext, propertyValueBuffer);
        }
        catch (Exception exception) {
            this.wrapAndThrow(deserializationContext, exception, this._containerType.getRawClass(), string);
            return null;
        }
    }

    protected final void _readAndUpdate(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map) throws IOException {
        Object object;
        String string;
        KeyDeserializer keyDeserializer = this._keyDeserializer;
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        if (jsonParser.isExpectedStartObjectToken()) {
            string = jsonParser.nextFieldName();
        } else {
            object = jsonParser.currentToken();
            if (object == JsonToken.END_OBJECT) {
                return;
            }
            if (object != JsonToken.FIELD_NAME) {
                deserializationContext.reportWrongTokenException(this, JsonToken.FIELD_NAME, null, new Object[0]);
            }
            string = jsonParser.currentName();
        }
        while (string != null) {
            object = keyDeserializer.deserializeKey(string, deserializationContext);
            JsonToken jsonToken = jsonParser.nextToken();
            if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(string)) {
                jsonParser.skipChildren();
            } else {
                try {
                    if (jsonToken == JsonToken.VALUE_NULL) {
                        if (!this._skipNullValues) {
                            map.put(object, this._nullProvider.getNullValue(deserializationContext));
                        }
                    } else {
                        Object object2 = map.get(object);
                        Object object3 = object2 != null ? (typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext, object2) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer, object2)) : (typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer));
                        if (object3 != object2) {
                            map.put(object, object3);
                        }
                    }
                }
                catch (Exception exception) {
                    this.wrapAndThrow(deserializationContext, exception, map, string);
                }
            }
            string = jsonParser.nextFieldName();
        }
    }

    protected final void _readAndUpdateStringKeyMap(JsonParser jsonParser, DeserializationContext deserializationContext, Map<Object, Object> map) throws IOException {
        JsonToken jsonToken;
        String string;
        JsonDeserializer<Object> jsonDeserializer = this._valueDeserializer;
        TypeDeserializer typeDeserializer = this._valueTypeDeserializer;
        if (jsonParser.isExpectedStartObjectToken()) {
            string = jsonParser.nextFieldName();
        } else {
            jsonToken = jsonParser.currentToken();
            if (jsonToken == JsonToken.END_OBJECT) {
                return;
            }
            if (jsonToken != JsonToken.FIELD_NAME) {
                deserializationContext.reportWrongTokenException(this, JsonToken.FIELD_NAME, null, new Object[0]);
            }
            string = jsonParser.currentName();
        }
        while (string != null) {
            jsonToken = jsonParser.nextToken();
            if (this._inclusionChecker != null && this._inclusionChecker.shouldIgnore(string)) {
                jsonParser.skipChildren();
            } else {
                try {
                    if (jsonToken == JsonToken.VALUE_NULL) {
                        if (!this._skipNullValues) {
                            map.put(string, this._nullProvider.getNullValue(deserializationContext));
                        }
                    } else {
                        Object object = map.get(string);
                        Object object2 = object != null ? (typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext, object) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer, object)) : (typeDeserializer == null ? jsonDeserializer.deserialize(jsonParser, deserializationContext) : jsonDeserializer.deserializeWithType(jsonParser, deserializationContext, typeDeserializer));
                        if (object2 != object) {
                            map.put(string, object2);
                        }
                    }
                }
                catch (Exception exception) {
                    this.wrapAndThrow(deserializationContext, exception, map, string);
                }
            }
            string = jsonParser.nextFieldName();
        }
    }

    protected void _squashDups(DeserializationContext deserializationContext, Map<Object, Object> map, Object object, Object object2, Object object3) {
        if (this._checkDupSquash && deserializationContext.isEnabled(StreamReadCapability.DUPLICATE_PROPERTIES)) {
            if (object2 instanceof List) {
                ((List)object2).add(object3);
                map.put(object, object2);
            } else {
                ArrayList<Object> arrayList = new ArrayList<Object>();
                arrayList.add(object2);
                arrayList.add(object3);
                map.put(object, arrayList);
            }
        }
    }

    private void handleUnresolvedReference(DeserializationContext deserializationContext, MapReferringAccumulator mapReferringAccumulator, Object object, UnresolvedForwardReference unresolvedForwardReference) throws JsonMappingException {
        if (mapReferringAccumulator == null) {
            deserializationContext.reportInputMismatch(this, "Unresolved forward reference but no identity info: " + unresolvedForwardReference, new Object[0]);
        }
        ReadableObjectId.Referring referring = mapReferringAccumulator.handleUnresolvedReference(unresolvedForwardReference, object);
        unresolvedForwardReference.getRoid().appendReferring(referring);
    }

    static class MapReferring
    extends ReadableObjectId.Referring {
        private final MapReferringAccumulator _parent;
        public final Map<Object, Object> next = new LinkedHashMap<Object, Object>();
        public final Object key;

        MapReferring(MapReferringAccumulator mapReferringAccumulator, UnresolvedForwardReference unresolvedForwardReference, Class<?> clazz, Object object) {
            super(unresolvedForwardReference, clazz);
            this._parent = mapReferringAccumulator;
            this.key = object;
        }

        @Override
        public void handleResolvedForwardReference(Object object, Object object2) throws IOException {
            this._parent.resolveForwardReference(object, object2);
        }
    }

    private static final class MapReferringAccumulator {
        private final Class<?> _valueType;
        private Map<Object, Object> _result;
        private List<MapReferring> _accumulator = new ArrayList<MapReferring>();

        public MapReferringAccumulator(Class<?> clazz, Map<Object, Object> map) {
            this._valueType = clazz;
            this._result = map;
        }

        public void put(Object object, Object object2) {
            if (this._accumulator.isEmpty()) {
                this._result.put(object, object2);
            } else {
                MapReferring mapReferring = this._accumulator.get(this._accumulator.size() - 1);
                mapReferring.next.put(object, object2);
            }
        }

        public ReadableObjectId.Referring handleUnresolvedReference(UnresolvedForwardReference unresolvedForwardReference, Object object) {
            MapReferring mapReferring = new MapReferring(this, unresolvedForwardReference, this._valueType, object);
            this._accumulator.add(mapReferring);
            return mapReferring;
        }

        public void resolveForwardReference(Object object, Object object2) throws IOException {
            Iterator<MapReferring> iterator = this._accumulator.iterator();
            Map<Object, Object> map = this._result;
            while (iterator.hasNext()) {
                MapReferring mapReferring = iterator.next();
                if (mapReferring.hasId(object)) {
                    iterator.remove();
                    map.put(mapReferring.key, object2);
                    map.putAll(mapReferring.next);
                    return;
                }
                map = mapReferring.next;
            }
            throw new IllegalArgumentException("Trying to resolve a forward reference with id [" + object + "] that wasn't previously seen as unresolved.");
        }
    }
}

