/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.databind;

import com.fasterxml.jackson.core.Base64Variant;
import com.fasterxml.jackson.core.FormatFeature;
import com.fasterxml.jackson.core.FormatSchema;
import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonPointer;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.core.ObjectCodec;
import com.fasterxml.jackson.core.StreamReadFeature;
import com.fasterxml.jackson.core.TreeNode;
import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.core.Versioned;
import com.fasterxml.jackson.core.exc.StreamReadException;
import com.fasterxml.jackson.core.filter.FilteringParserDelegate;
import com.fasterxml.jackson.core.filter.JsonPointerBasedFilter;
import com.fasterxml.jackson.core.filter.TokenFilter;
import com.fasterxml.jackson.core.type.ResolvedType;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DatabindException;
import com.fasterxml.jackson.databind.DeserializationConfig;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.InjectableValues;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonMappingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.PropertyName;
import com.fasterxml.jackson.databind.cfg.ContextAttributes;
import com.fasterxml.jackson.databind.cfg.DatatypeFeature;
import com.fasterxml.jackson.databind.cfg.PackageVersion;
import com.fasterxml.jackson.databind.deser.DataFormatReaders;
import com.fasterxml.jackson.databind.deser.DefaultDeserializationContext;
import com.fasterxml.jackson.databind.deser.DeserializationProblemHandler;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.TreeTraversingParser;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.databind.util.ClassUtil;
import java.io.DataInput;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.Serializable;
import java.lang.reflect.Type;
import java.net.URL;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;

public class ObjectReader
extends ObjectCodec
implements Versioned,
Serializable {
    private static final long serialVersionUID = 2L;
    protected final DeserializationConfig _config;
    protected final DefaultDeserializationContext _context;
    protected final JsonFactory _parserFactory;
    protected final boolean _unwrapRoot;
    private final TokenFilter _filter;
    protected final JavaType _valueType;
    protected final JsonDeserializer<Object> _rootDeserializer;
    protected final Object _valueToUpdate;
    protected final FormatSchema _schema;
    protected final InjectableValues _injectableValues;
    protected final DataFormatReaders _dataFormatReaders;
    protected final ConcurrentHashMap<JavaType, JsonDeserializer<Object>> _rootDeserializers;
    protected transient JavaType _jsonNodeType;

    protected ObjectReader(ObjectMapper objectMapper, DeserializationConfig deserializationConfig) {
        this(objectMapper, deserializationConfig, null, null, null, null);
    }

    protected ObjectReader(ObjectMapper objectMapper, DeserializationConfig deserializationConfig, JavaType javaType, Object object, FormatSchema formatSchema, InjectableValues injectableValues) {
        this._config = deserializationConfig;
        this._context = objectMapper._deserializationContext;
        this._rootDeserializers = objectMapper._rootDeserializers;
        this._parserFactory = objectMapper._jsonFactory;
        this._valueType = javaType;
        this._valueToUpdate = object;
        this._schema = formatSchema;
        this._injectableValues = injectableValues;
        this._unwrapRoot = deserializationConfig.useRootWrapping();
        this._rootDeserializer = this._prefetchRootDeserializer(javaType);
        this._dataFormatReaders = null;
        this._filter = null;
    }

    protected ObjectReader(ObjectReader objectReader, DeserializationConfig deserializationConfig, JavaType javaType, JsonDeserializer<Object> jsonDeserializer, Object object, FormatSchema formatSchema, InjectableValues injectableValues, DataFormatReaders dataFormatReaders) {
        this._config = deserializationConfig;
        this._context = objectReader._context;
        this._rootDeserializers = objectReader._rootDeserializers;
        this._parserFactory = objectReader._parserFactory;
        this._valueType = javaType;
        this._rootDeserializer = jsonDeserializer;
        this._valueToUpdate = object;
        this._schema = formatSchema;
        this._injectableValues = injectableValues;
        this._unwrapRoot = deserializationConfig.useRootWrapping();
        this._dataFormatReaders = dataFormatReaders;
        this._filter = objectReader._filter;
    }

    protected ObjectReader(ObjectReader objectReader, DeserializationConfig deserializationConfig) {
        this._config = deserializationConfig;
        this._context = objectReader._context;
        this._rootDeserializers = objectReader._rootDeserializers;
        this._parserFactory = objectReader._parserFactory;
        this._valueType = objectReader._valueType;
        this._rootDeserializer = objectReader._rootDeserializer;
        this._valueToUpdate = objectReader._valueToUpdate;
        this._schema = objectReader._schema;
        this._injectableValues = objectReader._injectableValues;
        this._unwrapRoot = deserializationConfig.useRootWrapping();
        this._dataFormatReaders = objectReader._dataFormatReaders;
        this._filter = objectReader._filter;
    }

    protected ObjectReader(ObjectReader objectReader, JsonFactory jsonFactory) {
        this._config = (DeserializationConfig)objectReader._config.with(MapperFeature.SORT_PROPERTIES_ALPHABETICALLY, jsonFactory.requiresPropertyOrdering());
        this._context = objectReader._context;
        this._rootDeserializers = objectReader._rootDeserializers;
        this._parserFactory = jsonFactory;
        this._valueType = objectReader._valueType;
        this._rootDeserializer = objectReader._rootDeserializer;
        this._valueToUpdate = objectReader._valueToUpdate;
        this._schema = objectReader._schema;
        this._injectableValues = objectReader._injectableValues;
        this._unwrapRoot = objectReader._unwrapRoot;
        this._dataFormatReaders = objectReader._dataFormatReaders;
        this._filter = objectReader._filter;
    }

    protected ObjectReader(ObjectReader objectReader, TokenFilter tokenFilter) {
        this._config = objectReader._config;
        this._context = objectReader._context;
        this._rootDeserializers = objectReader._rootDeserializers;
        this._parserFactory = objectReader._parserFactory;
        this._valueType = objectReader._valueType;
        this._rootDeserializer = objectReader._rootDeserializer;
        this._valueToUpdate = objectReader._valueToUpdate;
        this._schema = objectReader._schema;
        this._injectableValues = objectReader._injectableValues;
        this._unwrapRoot = objectReader._unwrapRoot;
        this._dataFormatReaders = objectReader._dataFormatReaders;
        this._filter = tokenFilter;
    }

    @Override
    public Version version() {
        return PackageVersion.VERSION;
    }

    protected ObjectReader _new(ObjectReader objectReader, JsonFactory jsonFactory) {
        return new ObjectReader(objectReader, jsonFactory);
    }

    protected ObjectReader _new(ObjectReader objectReader, DeserializationConfig deserializationConfig) {
        return new ObjectReader(objectReader, deserializationConfig);
    }

    protected ObjectReader _new(ObjectReader objectReader, DeserializationConfig deserializationConfig, JavaType javaType, JsonDeserializer<Object> jsonDeserializer, Object object, FormatSchema formatSchema, InjectableValues injectableValues, DataFormatReaders dataFormatReaders) {
        return new ObjectReader(objectReader, deserializationConfig, javaType, jsonDeserializer, object, formatSchema, injectableValues, dataFormatReaders);
    }

    protected <T> MappingIterator<T> _newIterator(JsonParser jsonParser, DeserializationContext deserializationContext, JsonDeserializer<?> jsonDeserializer, boolean bl2) {
        return new MappingIterator(this._valueType, jsonParser, deserializationContext, jsonDeserializer, bl2, this._valueToUpdate);
    }

    protected JsonToken _initForReading(DeserializationContext deserializationContext, JsonParser jsonParser) throws IOException {
        this._config.initialize(jsonParser, this._schema);
        JsonToken jsonToken = jsonParser.currentToken();
        if (jsonToken == null && (jsonToken = jsonParser.nextToken()) == null) {
            deserializationContext.reportInputMismatch(this._valueType, "No content to map due to end-of-input", new Object[0]);
        }
        return jsonToken;
    }

    protected void _initForMultiRead(DeserializationContext deserializationContext, JsonParser jsonParser) throws IOException {
        this._config.initialize(jsonParser, this._schema);
    }

    public ObjectReader with(DeserializationFeature deserializationFeature) {
        return this._with(this._config.with(deserializationFeature));
    }

    public ObjectReader with(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        return this._with(this._config.with(deserializationFeature, deserializationFeatureArray));
    }

    public ObjectReader withFeatures(DeserializationFeature ... deserializationFeatureArray) {
        return this._with(this._config.withFeatures(deserializationFeatureArray));
    }

    public ObjectReader without(DeserializationFeature deserializationFeature) {
        return this._with(this._config.without(deserializationFeature));
    }

    public ObjectReader without(DeserializationFeature deserializationFeature, DeserializationFeature ... deserializationFeatureArray) {
        return this._with(this._config.without(deserializationFeature, deserializationFeatureArray));
    }

    public ObjectReader withoutFeatures(DeserializationFeature ... deserializationFeatureArray) {
        return this._with(this._config.withoutFeatures(deserializationFeatureArray));
    }

    public ObjectReader with(DatatypeFeature datatypeFeature) {
        return this._with((DeserializationConfig)this._config.with(datatypeFeature));
    }

    public ObjectReader withFeatures(DatatypeFeature ... datatypeFeatureArray) {
        return this._with((DeserializationConfig)this._config.withFeatures(datatypeFeatureArray));
    }

    public ObjectReader without(DatatypeFeature datatypeFeature) {
        return this._with((DeserializationConfig)this._config.without(datatypeFeature));
    }

    public ObjectReader withoutFeatures(DatatypeFeature ... datatypeFeatureArray) {
        return this._with((DeserializationConfig)this._config.withoutFeatures(datatypeFeatureArray));
    }

    public ObjectReader with(JsonParser.Feature feature) {
        return this._with(this._config.with(feature));
    }

    public ObjectReader withFeatures(JsonParser.Feature ... featureArray) {
        return this._with(this._config.withFeatures(featureArray));
    }

    public ObjectReader without(JsonParser.Feature feature) {
        return this._with(this._config.without(feature));
    }

    public ObjectReader withoutFeatures(JsonParser.Feature ... featureArray) {
        return this._with(this._config.withoutFeatures(featureArray));
    }

    public ObjectReader with(StreamReadFeature streamReadFeature) {
        return this._with(this._config.with(streamReadFeature.mappedFeature()));
    }

    public ObjectReader without(StreamReadFeature streamReadFeature) {
        return this._with(this._config.without(streamReadFeature.mappedFeature()));
    }

    public ObjectReader with(FormatFeature formatFeature) {
        return this._with(this._config.with(formatFeature));
    }

    public ObjectReader withFeatures(FormatFeature ... formatFeatureArray) {
        return this._with(this._config.withFeatures(formatFeatureArray));
    }

    public ObjectReader without(FormatFeature formatFeature) {
        return this._with(this._config.without(formatFeature));
    }

    public ObjectReader withoutFeatures(FormatFeature ... formatFeatureArray) {
        return this._with(this._config.withoutFeatures(formatFeatureArray));
    }

    public ObjectReader at(String string) {
        this._assertNotNull("pointerExpr", string);
        return new ObjectReader(this, new JsonPointerBasedFilter(string));
    }

    public ObjectReader at(JsonPointer jsonPointer) {
        this._assertNotNull("pointer", jsonPointer);
        return new ObjectReader(this, new JsonPointerBasedFilter(jsonPointer));
    }

    public ObjectReader with(DeserializationConfig deserializationConfig) {
        return this._with(deserializationConfig);
    }

    public ObjectReader with(InjectableValues injectableValues) {
        if (this._injectableValues == injectableValues) {
            return this;
        }
        return this._new(this, this._config, this._valueType, this._rootDeserializer, this._valueToUpdate, this._schema, injectableValues, this._dataFormatReaders);
    }

    public ObjectReader with(JsonNodeFactory jsonNodeFactory) {
        return this._with(this._config.with(jsonNodeFactory));
    }

    public ObjectReader with(JsonFactory jsonFactory) {
        if (jsonFactory == this._parserFactory) {
            return this;
        }
        ObjectReader objectReader = this._new(this, jsonFactory);
        if (jsonFactory.getCodec() == null) {
            jsonFactory.setCodec(objectReader);
        }
        return objectReader;
    }

    public ObjectReader withRootName(String string) {
        return this._with((DeserializationConfig)this._config.withRootName(string));
    }

    public ObjectReader withRootName(PropertyName propertyName) {
        return this._with(this._config.withRootName(propertyName));
    }

    public ObjectReader withoutRootName() {
        return this._with(this._config.withRootName(PropertyName.NO_NAME));
    }

    public ObjectReader with(FormatSchema formatSchema) {
        if (this._schema == formatSchema) {
            return this;
        }
        this._verifySchemaType(formatSchema);
        return this._new(this, this._config, this._valueType, this._rootDeserializer, this._valueToUpdate, formatSchema, this._injectableValues, this._dataFormatReaders);
    }

    public ObjectReader forType(JavaType javaType) {
        if (javaType != null && javaType.equals(this._valueType)) {
            return this;
        }
        JsonDeserializer<Object> jsonDeserializer = this._prefetchRootDeserializer(javaType);
        DataFormatReaders dataFormatReaders = this._dataFormatReaders;
        if (dataFormatReaders != null) {
            dataFormatReaders = dataFormatReaders.withType(javaType);
        }
        return this._new(this, this._config, javaType, jsonDeserializer, this._valueToUpdate, this._schema, this._injectableValues, dataFormatReaders);
    }

    public ObjectReader forType(Class<?> clazz) {
        return this.forType(this._config.constructType(clazz));
    }

    public ObjectReader forType(Type type) {
        return this.forType(this._config.getTypeFactory().constructType(type));
    }

    public ObjectReader forType(TypeReference<?> typeReference) {
        return this.forType(this._config.getTypeFactory().constructType(typeReference.getType()));
    }

    @Deprecated
    public ObjectReader withType(JavaType javaType) {
        return this.forType(javaType);
    }

    @Deprecated
    public ObjectReader withType(Class<?> clazz) {
        return this.forType(this._config.constructType(clazz));
    }

    @Deprecated
    public ObjectReader withType(Type type) {
        return this.forType(this._config.getTypeFactory().constructType(type));
    }

    @Deprecated
    public ObjectReader withType(TypeReference<?> typeReference) {
        return this.forType(this._config.getTypeFactory().constructType(typeReference.getType()));
    }

    public ObjectReader withValueToUpdate(Object object) {
        if (object == this._valueToUpdate) {
            return this;
        }
        if (object == null) {
            return this._new(this, this._config, this._valueType, this._rootDeserializer, null, this._schema, this._injectableValues, this._dataFormatReaders);
        }
        JavaType javaType = this._valueType == null ? this._config.constructType(object.getClass()) : this._valueType;
        return this._new(this, this._config, javaType, this._rootDeserializer, object, this._schema, this._injectableValues, this._dataFormatReaders);
    }

    public ObjectReader withView(Class<?> clazz) {
        return this._with((DeserializationConfig)this._config.withView((Class)clazz));
    }

    public ObjectReader with(Locale locale) {
        return this._with((DeserializationConfig)this._config.with(locale));
    }

    public ObjectReader with(TimeZone timeZone) {
        return this._with((DeserializationConfig)this._config.with(timeZone));
    }

    public ObjectReader withHandler(DeserializationProblemHandler deserializationProblemHandler) {
        return this._with(this._config.withHandler(deserializationProblemHandler));
    }

    public ObjectReader with(Base64Variant base64Variant) {
        return this._with((DeserializationConfig)this._config.with(base64Variant));
    }

    public ObjectReader withFormatDetection(ObjectReader ... objectReaderArray) {
        return this.withFormatDetection(new DataFormatReaders(objectReaderArray));
    }

    public ObjectReader withFormatDetection(DataFormatReaders dataFormatReaders) {
        return this._new(this, this._config, this._valueType, this._rootDeserializer, this._valueToUpdate, this._schema, this._injectableValues, dataFormatReaders);
    }

    public ObjectReader with(ContextAttributes contextAttributes) {
        return this._with(this._config.with(contextAttributes));
    }

    public ObjectReader withAttributes(Map<?, ?> map) {
        return this._with((DeserializationConfig)this._config.withAttributes(map));
    }

    public ObjectReader withAttribute(Object object, Object object2) {
        return this._with((DeserializationConfig)this._config.withAttribute(object, object2));
    }

    public ObjectReader withoutAttribute(Object object) {
        return this._with((DeserializationConfig)this._config.withoutAttribute(object));
    }

    protected ObjectReader _with(DeserializationConfig deserializationConfig) {
        if (deserializationConfig == this._config) {
            return this;
        }
        ObjectReader objectReader = this._new(this, deserializationConfig);
        if (this._dataFormatReaders != null) {
            objectReader = objectReader.withFormatDetection(this._dataFormatReaders.with(deserializationConfig));
        }
        return objectReader;
    }

    public boolean isEnabled(DeserializationFeature deserializationFeature) {
        return this._config.isEnabled(deserializationFeature);
    }

    public boolean isEnabled(MapperFeature mapperFeature) {
        return this._config.isEnabled(mapperFeature);
    }

    public boolean isEnabled(DatatypeFeature datatypeFeature) {
        return this._config.isEnabled(datatypeFeature);
    }

    public boolean isEnabled(JsonParser.Feature feature) {
        return this._config.isEnabled(feature, this._parserFactory);
    }

    public boolean isEnabled(StreamReadFeature streamReadFeature) {
        return this._config.isEnabled(streamReadFeature.mappedFeature(), this._parserFactory);
    }

    public DeserializationConfig getConfig() {
        return this._config;
    }

    @Override
    public JsonFactory getFactory() {
        return this._parserFactory;
    }

    public TypeFactory getTypeFactory() {
        return this._config.getTypeFactory();
    }

    public ContextAttributes getAttributes() {
        return this._config.getAttributes();
    }

    public InjectableValues getInjectableValues() {
        return this._injectableValues;
    }

    public JavaType getValueType() {
        return this._valueType;
    }

    public JsonParser createParser(File file) throws IOException {
        this._assertNotNull("src", file);
        return this._config.initialize(this._parserFactory.createParser(file), this._schema);
    }

    public JsonParser createParser(URL uRL) throws IOException {
        this._assertNotNull("src", uRL);
        return this._config.initialize(this._parserFactory.createParser(uRL), this._schema);
    }

    public JsonParser createParser(InputStream inputStream) throws IOException {
        this._assertNotNull("in", inputStream);
        return this._config.initialize(this._parserFactory.createParser(inputStream), this._schema);
    }

    public JsonParser createParser(Reader reader) throws IOException {
        this._assertNotNull("r", reader);
        return this._config.initialize(this._parserFactory.createParser(reader), this._schema);
    }

    public JsonParser createParser(byte[] byArray) throws IOException {
        this._assertNotNull("content", byArray);
        return this._config.initialize(this._parserFactory.createParser(byArray), this._schema);
    }

    public JsonParser createParser(byte[] byArray, int n2, int n3) throws IOException {
        this._assertNotNull("content", byArray);
        return this._config.initialize(this._parserFactory.createParser(byArray, n2, n3), this._schema);
    }

    public JsonParser createParser(String string) throws IOException {
        this._assertNotNull("content", string);
        return this._config.initialize(this._parserFactory.createParser(string), this._schema);
    }

    public JsonParser createParser(char[] cArray) throws IOException {
        this._assertNotNull("content", cArray);
        return this._config.initialize(this._parserFactory.createParser(cArray), this._schema);
    }

    public JsonParser createParser(char[] cArray, int n2, int n3) throws IOException {
        this._assertNotNull("content", cArray);
        return this._config.initialize(this._parserFactory.createParser(cArray, n2, n3), this._schema);
    }

    public JsonParser createParser(DataInput dataInput) throws IOException {
        this._assertNotNull("content", dataInput);
        return this._config.initialize(this._parserFactory.createParser(dataInput), this._schema);
    }

    public JsonParser createNonBlockingByteArrayParser() throws IOException {
        return this._config.initialize(this._parserFactory.createNonBlockingByteArrayParser(), this._schema);
    }

    public <T> T readValue(JsonParser jsonParser) throws IOException {
        this._assertNotNull("p", jsonParser);
        return (T)this._bind(jsonParser, this._valueToUpdate);
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, Class<T> clazz) throws IOException {
        this._assertNotNull("p", jsonParser);
        return this.forType(clazz).readValue(jsonParser);
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, TypeReference<T> typeReference) throws IOException {
        this._assertNotNull("p", jsonParser);
        return this.forType(typeReference).readValue(jsonParser);
    }

    @Override
    public <T> T readValue(JsonParser jsonParser, ResolvedType resolvedType) throws IOException {
        this._assertNotNull("p", jsonParser);
        return this.forType((JavaType)resolvedType).readValue(jsonParser);
    }

    public <T> T readValue(JsonParser jsonParser, JavaType javaType) throws IOException {
        this._assertNotNull("p", jsonParser);
        return this.forType(javaType).readValue(jsonParser);
    }

    @Override
    public <T> Iterator<T> readValues(JsonParser jsonParser, Class<T> clazz) throws IOException {
        this._assertNotNull("p", jsonParser);
        return this.forType(clazz).readValues(jsonParser);
    }

    @Override
    public <T> Iterator<T> readValues(JsonParser jsonParser, TypeReference<T> typeReference) throws IOException {
        this._assertNotNull("p", jsonParser);
        return this.forType(typeReference).readValues(jsonParser);
    }

    @Override
    public <T> Iterator<T> readValues(JsonParser jsonParser, ResolvedType resolvedType) throws IOException {
        this._assertNotNull("p", jsonParser);
        return this.readValues(jsonParser, (JavaType)resolvedType);
    }

    public <T> Iterator<T> readValues(JsonParser jsonParser, JavaType javaType) throws IOException {
        this._assertNotNull("p", jsonParser);
        return this.forType(javaType).readValues(jsonParser);
    }

    @Override
    public JsonNode createArrayNode() {
        return this._config.getNodeFactory().arrayNode();
    }

    @Override
    public JsonNode createObjectNode() {
        return this._config.getNodeFactory().objectNode();
    }

    @Override
    public JsonNode missingNode() {
        return this._config.getNodeFactory().missingNode();
    }

    @Override
    public JsonNode nullNode() {
        return this._config.getNodeFactory().nullNode();
    }

    @Override
    public JsonParser treeAsTokens(TreeNode treeNode) {
        this._assertNotNull("n", treeNode);
        ObjectReader objectReader = this.withValueToUpdate(null);
        return new TreeTraversingParser((JsonNode)treeNode, objectReader);
    }

    @Override
    public <T extends TreeNode> T readTree(JsonParser jsonParser) throws IOException {
        this._assertNotNull("p", jsonParser);
        return (T)this._bindAsTreeOrNull(jsonParser);
    }

    @Override
    public void writeTree(JsonGenerator jsonGenerator, TreeNode treeNode) {
        throw new UnsupportedOperationException();
    }

    public <T> T readValue(InputStream inputStream) throws IOException {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(this._dataFormatReaders.findFormat(inputStream), false);
        }
        return (T)this._bindAndClose(this._considerFilter(this.createParser(inputStream), false));
    }

    public <T> T readValue(InputStream inputStream, Class<T> clazz) throws IOException {
        return this.forType(clazz).readValue(inputStream);
    }

    public <T> T readValue(Reader reader) throws IOException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(reader);
        }
        return (T)this._bindAndClose(this._considerFilter(this.createParser(reader), false));
    }

    public <T> T readValue(Reader reader, Class<T> clazz) throws IOException {
        return this.forType(clazz).readValue(reader);
    }

    public <T> T readValue(String string) throws JsonProcessingException, JsonMappingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(string);
        }
        try {
            return (T)this._bindAndClose(this._considerFilter(this.createParser(string), false));
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
    }

    public <T> T readValue(String string, Class<T> clazz) throws IOException {
        return this.forType(clazz).readValue(string);
    }

    public <T> T readValue(byte[] byArray) throws IOException {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(byArray, 0, byArray.length);
        }
        return (T)this._bindAndClose(this._considerFilter(this.createParser(byArray), false));
    }

    public <T> T readValue(byte[] byArray, Class<T> clazz) throws IOException {
        return this.forType(clazz).readValue(byArray);
    }

    public <T> T readValue(byte[] byArray, int n2, int n3) throws IOException {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(byArray, n2, n3);
        }
        return (T)this._bindAndClose(this._considerFilter(this.createParser(byArray, n2, n3), false));
    }

    public <T> T readValue(byte[] byArray, int n2, int n3, Class<T> clazz) throws IOException {
        return this.forType(clazz).readValue(byArray, n2, n3);
    }

    public <T> T readValue(File file) throws IOException {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(this._dataFormatReaders.findFormat(this._inputStream(file)), true);
        }
        return (T)this._bindAndClose(this._considerFilter(this.createParser(file), false));
    }

    public <T> T readValue(File file, Class<T> clazz) throws IOException {
        return this.forType(clazz).readValue(file);
    }

    public <T> T readValue(URL uRL) throws IOException {
        if (this._dataFormatReaders != null) {
            return (T)this._detectBindAndClose(this._dataFormatReaders.findFormat(this._inputStream(uRL)), true);
        }
        return (T)this._bindAndClose(this._considerFilter(this.createParser(uRL), false));
    }

    public <T> T readValue(URL uRL, Class<T> clazz) throws IOException {
        return this.forType(clazz).readValue(uRL);
    }

    public <T> T readValue(JsonNode jsonNode) throws IOException {
        this._assertNotNull("content", jsonNode);
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(jsonNode);
        }
        return (T)this._bindAndClose(this._considerFilter(this.treeAsTokens(jsonNode), false));
    }

    public <T> T readValue(JsonNode jsonNode, Class<T> clazz) throws IOException {
        return this.forType(clazz).readValue(jsonNode);
    }

    public <T> T readValue(DataInput dataInput) throws IOException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(dataInput);
        }
        return (T)this._bindAndClose(this._considerFilter(this.createParser(dataInput), false));
    }

    public <T> T readValue(DataInput dataInput, Class<T> clazz) throws IOException {
        return this.forType(clazz).readValue(dataInput);
    }

    public JsonNode readTree(InputStream inputStream) throws IOException {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndCloseAsTree(inputStream);
        }
        return this._bindAndCloseAsTree(this._considerFilter(this.createParser(inputStream), false));
    }

    public JsonNode readTree(Reader reader) throws IOException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(reader);
        }
        return this._bindAndCloseAsTree(this._considerFilter(this.createParser(reader), false));
    }

    public JsonNode readTree(String string) throws JsonProcessingException, JsonMappingException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(string);
        }
        try {
            return this._bindAndCloseAsTree(this._considerFilter(this.createParser(string), false));
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
    }

    public JsonNode readTree(byte[] byArray) throws IOException {
        this._assertNotNull("json", byArray);
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(byArray);
        }
        return this._bindAndCloseAsTree(this._considerFilter(this.createParser(byArray), false));
    }

    public JsonNode readTree(byte[] byArray, int n2, int n3) throws IOException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(byArray);
        }
        return this._bindAndCloseAsTree(this._considerFilter(this.createParser(byArray, n2, n3), false));
    }

    public JsonNode readTree(DataInput dataInput) throws IOException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(dataInput);
        }
        return this._bindAndCloseAsTree(this._considerFilter(this.createParser(dataInput), false));
    }

    public <T> MappingIterator<T> readValues(JsonParser jsonParser) throws IOException {
        this._assertNotNull("p", jsonParser);
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser);
        return this._newIterator(jsonParser, defaultDeserializationContext, this._findRootDeserializer(defaultDeserializationContext), false);
    }

    public <T> MappingIterator<T> readValues(InputStream inputStream) throws IOException {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndReadValues(this._dataFormatReaders.findFormat(inputStream), false);
        }
        return this._bindAndReadValues(this._considerFilter(this.createParser(inputStream), true));
    }

    public <T> MappingIterator<T> readValues(Reader reader) throws IOException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(reader);
        }
        JsonParser jsonParser = this._considerFilter(this.createParser(reader), true);
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser);
        this._initForMultiRead(defaultDeserializationContext, jsonParser);
        jsonParser.nextToken();
        return this._newIterator(jsonParser, defaultDeserializationContext, this._findRootDeserializer(defaultDeserializationContext), true);
    }

    public <T> MappingIterator<T> readValues(String string) throws IOException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(string);
        }
        JsonParser jsonParser = this._considerFilter(this.createParser(string), true);
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser);
        this._initForMultiRead(defaultDeserializationContext, jsonParser);
        jsonParser.nextToken();
        return this._newIterator(jsonParser, defaultDeserializationContext, this._findRootDeserializer(defaultDeserializationContext), true);
    }

    public <T> MappingIterator<T> readValues(byte[] byArray, int n2, int n3) throws IOException {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndReadValues(this._dataFormatReaders.findFormat(byArray, n2, n3), false);
        }
        return this._bindAndReadValues(this._considerFilter(this.createParser(byArray, n2, n3), true));
    }

    public final <T> MappingIterator<T> readValues(byte[] byArray) throws IOException {
        this._assertNotNull("src", byArray);
        return this.readValues(byArray, 0, byArray.length);
    }

    public <T> MappingIterator<T> readValues(File file) throws IOException {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndReadValues(this._dataFormatReaders.findFormat(this._inputStream(file)), false);
        }
        return this._bindAndReadValues(this._considerFilter(this.createParser(file), true));
    }

    public <T> MappingIterator<T> readValues(URL uRL) throws IOException {
        if (this._dataFormatReaders != null) {
            return this._detectBindAndReadValues(this._dataFormatReaders.findFormat(this._inputStream(uRL)), true);
        }
        return this._bindAndReadValues(this._considerFilter(this.createParser(uRL), true));
    }

    public <T> MappingIterator<T> readValues(DataInput dataInput) throws IOException {
        if (this._dataFormatReaders != null) {
            this._reportUndetectableSource(dataInput);
        }
        return this._bindAndReadValues(this._considerFilter(this.createParser(dataInput), true));
    }

    @Override
    public <T> T treeToValue(TreeNode treeNode, Class<T> clazz) throws JsonProcessingException {
        this._assertNotNull("n", treeNode);
        try {
            return this.readValue(this.treeAsTokens(treeNode), clazz);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
    }

    public <T> T treeToValue(TreeNode treeNode, JavaType javaType) throws JsonProcessingException {
        this._assertNotNull("n", treeNode);
        try {
            return this.readValue(this.treeAsTokens(treeNode), javaType);
        }
        catch (JsonProcessingException jsonProcessingException) {
            throw jsonProcessingException;
        }
        catch (IOException iOException) {
            throw JsonMappingException.fromUnexpectedIOE(iOException);
        }
    }

    @Override
    public void writeValue(JsonGenerator jsonGenerator, Object object) throws IOException {
        throw new UnsupportedOperationException("Not implemented for ObjectReader");
    }

    protected Object _bind(JsonParser jsonParser, Object object) throws IOException {
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser);
        JsonToken jsonToken = this._initForReading(defaultDeserializationContext, jsonParser);
        Object object2 = jsonToken == JsonToken.VALUE_NULL ? (object == null ? this._findRootDeserializer(defaultDeserializationContext).getNullValue(defaultDeserializationContext) : object) : (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT ? object : defaultDeserializationContext.readRootValue(jsonParser, this._valueType, this._findRootDeserializer(defaultDeserializationContext), this._valueToUpdate));
        jsonParser.clearCurrentToken();
        if (this._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(jsonParser, defaultDeserializationContext, this._valueType);
        }
        return object2;
    }

    protected Object _bindAndClose(JsonParser jsonParser) throws IOException {
        try (JsonParser jsonParser2 = jsonParser;){
            DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser2);
            JsonToken jsonToken = this._initForReading(defaultDeserializationContext, jsonParser2);
            Object object = jsonToken == JsonToken.VALUE_NULL ? (this._valueToUpdate == null ? this._findRootDeserializer(defaultDeserializationContext).getNullValue(defaultDeserializationContext) : this._valueToUpdate) : (jsonToken == JsonToken.END_ARRAY || jsonToken == JsonToken.END_OBJECT ? this._valueToUpdate : defaultDeserializationContext.readRootValue(jsonParser2, this._valueType, this._findRootDeserializer(defaultDeserializationContext), this._valueToUpdate));
            if (this._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
                this._verifyNoTrailingTokens(jsonParser2, defaultDeserializationContext, this._valueType);
            }
            Object object2 = object;
            return object2;
        }
    }

    protected final JsonNode _bindAndCloseAsTree(JsonParser jsonParser) throws IOException {
        try (JsonParser jsonParser2 = jsonParser;){
            JsonNode jsonNode = this._bindAsTree(jsonParser2);
            return jsonNode;
        }
    }

    protected final JsonNode _bindAsTree(JsonParser jsonParser) throws IOException {
        JsonToken jsonToken;
        if (this._valueToUpdate != null) {
            return (JsonNode)this._bind(jsonParser, this._valueToUpdate);
        }
        this._config.initialize(jsonParser);
        if (this._schema != null) {
            jsonParser.setSchema(this._schema);
        }
        if ((jsonToken = jsonParser.currentToken()) == null && (jsonToken = jsonParser.nextToken()) == null) {
            return this._config.getNodeFactory().missingNode();
        }
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser);
        JsonNode jsonNode = jsonToken == JsonToken.VALUE_NULL ? this._config.getNodeFactory().nullNode() : (JsonNode)defaultDeserializationContext.readRootValue(jsonParser, this._jsonNodeType(), this._findTreeDeserializer(defaultDeserializationContext), null);
        jsonParser.clearCurrentToken();
        if (this._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(jsonParser, defaultDeserializationContext, this._jsonNodeType());
        }
        return jsonNode;
    }

    protected final JsonNode _bindAsTreeOrNull(JsonParser jsonParser) throws IOException {
        JsonToken jsonToken;
        if (this._valueToUpdate != null) {
            return (JsonNode)this._bind(jsonParser, this._valueToUpdate);
        }
        this._config.initialize(jsonParser);
        if (this._schema != null) {
            jsonParser.setSchema(this._schema);
        }
        if ((jsonToken = jsonParser.currentToken()) == null && (jsonToken = jsonParser.nextToken()) == null) {
            return null;
        }
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser);
        JsonNode jsonNode = jsonToken == JsonToken.VALUE_NULL ? this._config.getNodeFactory().nullNode() : (JsonNode)defaultDeserializationContext.readRootValue(jsonParser, this._jsonNodeType(), this._findTreeDeserializer(defaultDeserializationContext), null);
        jsonParser.clearCurrentToken();
        if (this._config.isEnabled(DeserializationFeature.FAIL_ON_TRAILING_TOKENS)) {
            this._verifyNoTrailingTokens(jsonParser, defaultDeserializationContext, this._jsonNodeType());
        }
        return jsonNode;
    }

    protected <T> MappingIterator<T> _bindAndReadValues(JsonParser jsonParser) throws IOException {
        DefaultDeserializationContext defaultDeserializationContext = this.createDeserializationContext(jsonParser);
        this._initForMultiRead(defaultDeserializationContext, jsonParser);
        jsonParser.nextToken();
        return this._newIterator(jsonParser, defaultDeserializationContext, this._findRootDeserializer(defaultDeserializationContext), true);
    }

    protected JsonParser _considerFilter(JsonParser jsonParser, boolean bl2) {
        return this._filter == null || FilteringParserDelegate.class.isInstance(jsonParser) ? jsonParser : new FilteringParserDelegate(jsonParser, this._filter, TokenFilter.Inclusion.ONLY_INCLUDE_ALL, bl2);
    }

    protected final void _verifyNoTrailingTokens(JsonParser jsonParser, DeserializationContext deserializationContext, JavaType javaType) throws IOException {
        JsonToken jsonToken = jsonParser.nextToken();
        if (jsonToken != null) {
            Class<?> clazz = ClassUtil.rawClass(javaType);
            if (clazz == null && this._valueToUpdate != null) {
                clazz = this._valueToUpdate.getClass();
            }
            deserializationContext.reportTrailingTokens(clazz, jsonParser, jsonToken);
        }
    }

    protected Object _detectBindAndClose(byte[] byArray, int n2, int n3) throws IOException {
        DataFormatReaders.Match match = this._dataFormatReaders.findFormat(byArray, n2, n3);
        if (!match.hasMatch()) {
            this._reportUnkownFormat(this._dataFormatReaders, match);
        }
        JsonParser jsonParser = match.createParserWithMatch();
        return match.getReader()._bindAndClose(jsonParser);
    }

    protected Object _detectBindAndClose(DataFormatReaders.Match match, boolean bl2) throws IOException {
        if (!match.hasMatch()) {
            this._reportUnkownFormat(this._dataFormatReaders, match);
        }
        JsonParser jsonParser = match.createParserWithMatch();
        if (bl2) {
            jsonParser.enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        }
        return match.getReader()._bindAndClose(jsonParser);
    }

    protected <T> MappingIterator<T> _detectBindAndReadValues(DataFormatReaders.Match match, boolean bl2) throws IOException {
        if (!match.hasMatch()) {
            this._reportUnkownFormat(this._dataFormatReaders, match);
        }
        JsonParser jsonParser = match.createParserWithMatch();
        if (bl2) {
            jsonParser.enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        }
        return match.getReader()._bindAndReadValues(jsonParser);
    }

    protected JsonNode _detectBindAndCloseAsTree(InputStream inputStream) throws IOException {
        DataFormatReaders.Match match = this._dataFormatReaders.findFormat(inputStream);
        if (!match.hasMatch()) {
            this._reportUnkownFormat(this._dataFormatReaders, match);
        }
        JsonParser jsonParser = match.createParserWithMatch();
        jsonParser.enable(JsonParser.Feature.AUTO_CLOSE_SOURCE);
        return match.getReader()._bindAndCloseAsTree(jsonParser);
    }

    protected void _reportUnkownFormat(DataFormatReaders dataFormatReaders, DataFormatReaders.Match match) throws IOException {
        throw new JsonParseException(null, "Cannot detect format from input, does not look like any of detectable formats " + dataFormatReaders.toString());
    }

    protected void _verifySchemaType(FormatSchema formatSchema) {
        if (formatSchema != null && !this._parserFactory.canUseSchema(formatSchema)) {
            throw new IllegalArgumentException("Cannot use FormatSchema of type " + formatSchema.getClass().getName() + " for format " + this._parserFactory.getFormatName());
        }
    }

    protected DefaultDeserializationContext createDeserializationContext(JsonParser jsonParser) {
        return this._context.createInstance(this._config, jsonParser, this._injectableValues);
    }

    protected DefaultDeserializationContext createDummyDeserializationContext() {
        return this._context.createDummyInstance(this._config);
    }

    protected InputStream _inputStream(URL uRL) throws IOException {
        return uRL.openStream();
    }

    protected InputStream _inputStream(File file) throws IOException {
        return new FileInputStream(file);
    }

    protected void _reportUndetectableSource(Object object) throws StreamReadException {
        throw new JsonParseException(null, "Cannot use source of type " + object.getClass().getName() + " with format auto-detection: must be byte- not char-based");
    }

    protected JsonDeserializer<Object> _findRootDeserializer(DeserializationContext deserializationContext) throws DatabindException {
        JsonDeserializer<Object> jsonDeserializer;
        if (this._rootDeserializer != null) {
            return this._rootDeserializer;
        }
        JavaType javaType = this._valueType;
        if (javaType == null) {
            deserializationContext.reportBadDefinition((JavaType)null, "No value type configured for ObjectReader");
        }
        if ((jsonDeserializer = this._rootDeserializers.get(javaType)) != null) {
            return jsonDeserializer;
        }
        jsonDeserializer = deserializationContext.findRootValueDeserializer(javaType);
        if (jsonDeserializer == null) {
            deserializationContext.reportBadDefinition(javaType, "Cannot find a deserializer for type " + javaType);
        }
        this._rootDeserializers.put(javaType, jsonDeserializer);
        return jsonDeserializer;
    }

    protected JsonDeserializer<Object> _findTreeDeserializer(DeserializationContext deserializationContext) throws DatabindException {
        JavaType javaType = this._jsonNodeType();
        JsonDeserializer<Object> jsonDeserializer = this._rootDeserializers.get(javaType);
        if (jsonDeserializer == null) {
            jsonDeserializer = deserializationContext.findRootValueDeserializer(javaType);
            if (jsonDeserializer == null) {
                deserializationContext.reportBadDefinition(javaType, "Cannot find a deserializer for type " + javaType);
            }
            this._rootDeserializers.put(javaType, jsonDeserializer);
        }
        return jsonDeserializer;
    }

    protected JsonDeserializer<Object> _prefetchRootDeserializer(JavaType javaType) {
        if (javaType == null || !this._config.isEnabled(DeserializationFeature.EAGER_DESERIALIZER_FETCH)) {
            return null;
        }
        JsonDeserializer<Object> jsonDeserializer = this._rootDeserializers.get(javaType);
        if (jsonDeserializer == null) {
            try {
                DefaultDeserializationContext defaultDeserializationContext = this.createDummyDeserializationContext();
                jsonDeserializer = defaultDeserializationContext.findRootValueDeserializer(javaType);
                if (jsonDeserializer != null) {
                    this._rootDeserializers.put(javaType, jsonDeserializer);
                }
                return jsonDeserializer;
            }
            catch (JacksonException jacksonException) {
                // empty catch block
            }
        }
        return jsonDeserializer;
    }

    protected final JavaType _jsonNodeType() {
        JavaType javaType = this._jsonNodeType;
        if (javaType == null) {
            this._jsonNodeType = javaType = this.getTypeFactory().constructType((Type)((Object)JsonNode.class));
        }
        return javaType;
    }

    protected final void _assertNotNull(String string, Object object) {
        if (object == null) {
            throw new IllegalArgumentException(String.format("argument \"%s\" is null", string));
        }
    }
}

