/*
 * Decompiled with CFR 0.152.
 */
package com.fasterxml.jackson.core.io.doubleparser;

import com.fasterxml.jackson.core.io.doubleparser.JavaBigIntegerFromByteArray;
import com.fasterxml.jackson.core.io.doubleparser.JavaBigIntegerFromCharArray;
import com.fasterxml.jackson.core.io.doubleparser.JavaBigIntegerFromCharSequence;
import java.math.BigInteger;

public class JavaBigIntegerParser {
    private static final JavaBigIntegerFromByteArray BYTE_ARRAY_PARSER = new JavaBigIntegerFromByteArray();
    private static final JavaBigIntegerFromCharArray CHAR_ARRAY_PARSER = new JavaBigIntegerFromCharArray();
    private static final JavaBigIntegerFromCharSequence CHAR_SEQUENCE_PARSER = new JavaBigIntegerFromCharSequence();

    private JavaBigIntegerParser() {
    }

    public static BigInteger parseBigInteger(CharSequence charSequence) {
        return CHAR_SEQUENCE_PARSER.parseBigIntegerString(charSequence, 0, charSequence.length(), 10);
    }

    public static BigInteger parseBigInteger(CharSequence charSequence, int n2) {
        return CHAR_SEQUENCE_PARSER.parseBigIntegerString(charSequence, 0, charSequence.length(), n2);
    }

    public static BigInteger parseBigInteger(CharSequence charSequence, int n2, int n3) {
        return CHAR_SEQUENCE_PARSER.parseBigIntegerString(charSequence, n2, n3, 10);
    }

    public static BigInteger parseBigInteger(CharSequence charSequence, int n2, int n3, int n4) {
        return CHAR_SEQUENCE_PARSER.parseBigIntegerString(charSequence, n2, n3, n4);
    }

    public static BigInteger parseBigInteger(byte[] byArray) {
        return BYTE_ARRAY_PARSER.parseBigIntegerString(byArray, 0, byArray.length, 10);
    }

    public static BigInteger parseBigInteger(byte[] byArray, int n2) {
        return BYTE_ARRAY_PARSER.parseBigIntegerString(byArray, 0, byArray.length, n2);
    }

    public static BigInteger parseBigInteger(byte[] byArray, int n2, int n3) {
        return BYTE_ARRAY_PARSER.parseBigIntegerString(byArray, n2, n3, 10);
    }

    public static BigInteger parseBigInteger(byte[] byArray, int n2, int n3, int n4) {
        return BYTE_ARRAY_PARSER.parseBigIntegerString(byArray, n2, n3, n4);
    }

    public static BigInteger parseBigInteger(char[] cArray) {
        return CHAR_ARRAY_PARSER.parseBigIntegerString(cArray, 0, cArray.length, 10);
    }

    public static BigInteger parseBigInteger(char[] cArray, int n2) {
        return CHAR_ARRAY_PARSER.parseBigIntegerString(cArray, 0, cArray.length, n2);
    }

    public static BigInteger parseBigInteger(char[] cArray, int n2, int n3) {
        return CHAR_ARRAY_PARSER.parseBigIntegerString(cArray, n2, n3, 10);
    }

    public static BigInteger parseBigInteger(char[] cArray, int n2, int n3, int n4) {
        return CHAR_ARRAY_PARSER.parseBigIntegerString(cArray, n2, n3, n4);
    }
}

