/*
 * Decompiled with CFR 0.152.
 */
package atlantafx.base.controls;

import atlantafx.base.controls.Popover;
import java.util.ArrayList;
import java.util.List;
import javafx.beans.InvalidationListener;
import javafx.beans.binding.Bindings;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleDoubleProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.EventHandler;
import javafx.geometry.Point2D;
import javafx.geometry.Pos;
import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.control.ContentDisplay;
import javafx.scene.control.Label;
import javafx.scene.control.Skin;
import javafx.scene.layout.BorderPane;
import javafx.scene.layout.StackPane;
import javafx.scene.paint.Color;
import javafx.scene.paint.Paint;
import javafx.scene.shape.Circle;
import javafx.scene.shape.HLineTo;
import javafx.scene.shape.Line;
import javafx.scene.shape.LineTo;
import javafx.scene.shape.MoveTo;
import javafx.scene.shape.Path;
import javafx.scene.shape.QuadCurveTo;
import javafx.scene.shape.VLineTo;
import javafx.stage.Window;

public class PopoverSkin
implements Skin<Popover> {
    private static final String DETACHED_STYLE_CLASS = "detached";
    private double xOffset;
    private double yOffset;
    private boolean tornOff;
    private final Path path;
    private final Path clip;
    private final BorderPane content;
    private final StackPane titlePane;
    private final StackPane stackPane;
    private Point2D dragStartLocation;
    private final Popover popover;
    private MoveTo moveTo;
    private QuadCurveTo topCurveTo;
    private QuadCurveTo rightCurveTo;
    private QuadCurveTo bottomCurveTo;
    private QuadCurveTo leftCurveTo;
    private HLineTo lineBTop;
    private HLineTo lineETop;
    private HLineTo lineHTop;
    private HLineTo lineKTop;
    private LineTo lineCTop;
    private LineTo lineDTop;
    private LineTo lineFTop;
    private LineTo lineGTop;
    private LineTo lineITop;
    private LineTo lineJTop;
    private VLineTo lineBRight;
    private VLineTo lineERight;
    private VLineTo lineHRight;
    private VLineTo lineKRight;
    private LineTo lineCRight;
    private LineTo lineDRight;
    private LineTo lineFRight;
    private LineTo lineGRight;
    private LineTo lineIRight;
    private LineTo lineJRight;
    private HLineTo lineBBottom;
    private HLineTo lineEBottom;
    private HLineTo lineHBottom;
    private HLineTo lineKBottom;
    private LineTo lineCBottom;
    private LineTo lineDBottom;
    private LineTo lineFBottom;
    private LineTo lineGBottom;
    private LineTo lineIBottom;
    private LineTo lineJBottom;
    private VLineTo lineBLeft;
    private VLineTo lineELeft;
    private VLineTo lineHLeft;
    private VLineTo lineKLeft;
    private LineTo lineCLeft;
    private LineTo lineDLeft;
    private LineTo lineFLeft;
    private LineTo lineGLeft;
    private LineTo lineILeft;
    private LineTo lineJLeft;

    public PopoverSkin(Popover popover) {
        this.popover = popover;
        this.stackPane = popover.getRoot();
        this.stackPane.setPickOnBounds(false);
        Bindings.bindContent((List)this.stackPane.getStyleClass(), (ObservableList)popover.getStyleClass());
        this.stackPane.minWidthProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)Bindings.multiply((int)2, (ObservableNumberValue)popover.arrowSizeProperty()), (ObservableNumberValue)Bindings.add((ObservableNumberValue)Bindings.multiply((int)2, (ObservableNumberValue)popover.cornerRadiusProperty()), (ObservableNumberValue)Bindings.multiply((int)2, (ObservableNumberValue)popover.arrowIndentProperty()))));
        this.stackPane.minHeightProperty().bind((ObservableValue)this.stackPane.minWidthProperty());
        Label label = new Label();
        label.textProperty().bind((ObservableValue)popover.titleProperty());
        label.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label.setAlignment(Pos.CENTER);
        label.getStyleClass().add((Object)"text");
        Label label2 = new Label();
        label2.setGraphic(this.createCloseIcon());
        label2.setMaxSize(Double.MAX_VALUE, Double.MAX_VALUE);
        label2.setContentDisplay(ContentDisplay.GRAPHIC_ONLY);
        label2.visibleProperty().bind((ObservableValue)popover.closeButtonEnabledProperty().and((ObservableBooleanValue)popover.detachedProperty().or((ObservableBooleanValue)popover.headerAlwaysVisibleProperty())));
        label2.getStyleClass().add((Object)"icon");
        label2.setAlignment(Pos.TOP_RIGHT);
        label2.getGraphic().setOnMouseClicked(mouseEvent -> popover.hide());
        this.titlePane = new StackPane();
        this.titlePane.getChildren().add((Object)label);
        this.titlePane.getChildren().add((Object)label2);
        this.titlePane.getStyleClass().add((Object)"title");
        this.content = new BorderPane();
        this.content.setCenter(popover.getContentNode());
        this.content.getStyleClass().add((Object)"content");
        if (popover.isDetached() || popover.isHeaderAlwaysVisible()) {
            this.content.setTop((Node)this.titlePane);
        }
        if (popover.isDetached()) {
            popover.getStyleClass().add((Object)DETACHED_STYLE_CLASS);
            this.content.getStyleClass().add((Object)DETACHED_STYLE_CLASS);
        }
        popover.headerAlwaysVisibleProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                this.content.setTop((Node)this.titlePane);
            } else if (!popover.isDetached()) {
                this.content.setTop(null);
            }
        });
        InvalidationListener invalidationListener = observable -> this.updatePath();
        this.getPopupWindow().xProperty().addListener(invalidationListener);
        this.getPopupWindow().yProperty().addListener(invalidationListener);
        popover.arrowLocationProperty().addListener(invalidationListener);
        popover.contentNodeProperty().addListener((observableValue, node, node2) -> this.content.setCenter(node2));
        popover.detachedProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                popover.getStyleClass().add((Object)DETACHED_STYLE_CLASS);
                this.content.getStyleClass().add((Object)DETACHED_STYLE_CLASS);
                this.content.setTop((Node)this.titlePane);
                switch (this.getSkinnable().getArrowLocation()) {
                    case LEFT_TOP: 
                    case LEFT_CENTER: 
                    case LEFT_BOTTOM: {
                        popover.setAnchorX(popover.getAnchorX() + popover.getArrowSize());
                        break;
                    }
                    case TOP_LEFT: 
                    case TOP_CENTER: 
                    case TOP_RIGHT: {
                        popover.setAnchorY(popover.getAnchorY() + popover.getArrowSize());
                    }
                }
            } else {
                popover.getStyleClass().remove((Object)DETACHED_STYLE_CLASS);
                this.content.getStyleClass().remove((Object)DETACHED_STYLE_CLASS);
                if (!popover.isHeaderAlwaysVisible()) {
                    this.content.setTop(null);
                }
            }
            popover.sizeToScene();
            this.updatePath();
        });
        this.path = new Path();
        this.path.getStyleClass().add((Object)"border");
        this.path.setManaged(false);
        this.clip = new Path();
        this.clip.setFill((Paint)Color.YELLOW);
        this.createPathElements();
        this.updatePath();
        EventHandler eventHandler = mouseEvent -> {
            if (popover.isDetachable() || popover.isDetached()) {
                this.tornOff = false;
                this.xOffset = mouseEvent.getScreenX();
                this.yOffset = mouseEvent.getScreenY();
                this.dragStartLocation = new Point2D(this.xOffset, this.yOffset);
            }
        };
        EventHandler eventHandler2 = mouseEvent -> {
            if (this.tornOff && !this.getSkinnable().isDetached()) {
                this.tornOff = false;
                this.getSkinnable().detach();
            }
        };
        EventHandler eventHandler3 = mouseEvent -> {
            if (popover.isDetachable() || popover.isDetached()) {
                double d2 = mouseEvent.getScreenX() - this.xOffset;
                double d3 = mouseEvent.getScreenY() - this.yOffset;
                Window window = this.getSkinnable().getScene().getWindow();
                window.setX(window.getX() + d2);
                window.setY(window.getY() + d3);
                this.xOffset = mouseEvent.getScreenX();
                this.yOffset = mouseEvent.getScreenY();
                if (this.dragStartLocation.distance(this.xOffset, this.yOffset) > 20.0) {
                    this.tornOff = true;
                    this.updatePath();
                } else if (this.tornOff) {
                    this.tornOff = false;
                    this.updatePath();
                }
            }
        };
        this.stackPane.setOnMousePressed(eventHandler);
        this.stackPane.setOnMouseDragged(eventHandler3);
        this.stackPane.setOnMouseReleased(eventHandler2);
        this.stackPane.setVisible(false);
        this.stackPane.getChildren().add((Object)this.path);
        this.stackPane.getChildren().add((Object)this.content);
        this.content.setClip((Node)this.clip);
    }

    public Node getNode() {
        return this.stackPane;
    }

    public Popover getSkinnable() {
        return this.popover;
    }

    public void dispose() {
    }

    private Node createCloseIcon() {
        Group group = new Group();
        group.getStyleClass().add((Object)"graphics");
        Circle circle = new Circle();
        circle.getStyleClass().add((Object)"circle");
        circle.setRadius(12.0);
        circle.setCenterX(12.0);
        circle.setCenterY(12.0);
        group.getChildren().add((Object)circle);
        Line line = new Line();
        line.getStyleClass().add((Object)"line");
        line.setStartX(8.0);
        line.setStartY(8.0);
        line.setEndX(16.0);
        line.setEndY(16.0);
        group.getChildren().add((Object)line);
        Line line2 = new Line();
        line2.getStyleClass().add((Object)"line");
        line2.setStartX(16.0);
        line2.setStartY(8.0);
        line2.setEndX(8.0);
        line2.setEndY(16.0);
        group.getChildren().add((Object)line2);
        return group;
    }

    private void createPathElements() {
        SimpleDoubleProperty simpleDoubleProperty = new SimpleDoubleProperty();
        SimpleDoubleProperty simpleDoubleProperty2 = new SimpleDoubleProperty();
        SimpleDoubleProperty simpleDoubleProperty3 = new SimpleDoubleProperty();
        SimpleDoubleProperty simpleDoubleProperty4 = new SimpleDoubleProperty();
        SimpleDoubleProperty simpleDoubleProperty5 = new SimpleDoubleProperty();
        SimpleDoubleProperty simpleDoubleProperty6 = new SimpleDoubleProperty();
        SimpleDoubleProperty simpleDoubleProperty7 = new SimpleDoubleProperty();
        SimpleDoubleProperty simpleDoubleProperty8 = new SimpleDoubleProperty();
        SimpleDoubleProperty simpleDoubleProperty9 = new SimpleDoubleProperty();
        SimpleDoubleProperty simpleDoubleProperty10 = new SimpleDoubleProperty();
        DoubleProperty doubleProperty = this.getSkinnable().cornerRadiusProperty();
        DoubleProperty doubleProperty2 = this.getSkinnable().arrowSizeProperty();
        DoubleProperty doubleProperty3 = this.getSkinnable().arrowIndentProperty();
        simpleDoubleProperty.bind((ObservableValue)Bindings.divide((ObservableNumberValue)this.stackPane.heightProperty(), (int)2));
        simpleDoubleProperty2.bind((ObservableValue)Bindings.divide((ObservableNumberValue)this.stackPane.widthProperty(), (int)2));
        simpleDoubleProperty4.bind((ObservableValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty3, (ObservableNumberValue)this.getSkinnable().cornerRadiusProperty()));
        simpleDoubleProperty6.bind((ObservableValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty5, (ObservableNumberValue)this.getSkinnable().cornerRadiusProperty()));
        simpleDoubleProperty7.bind((ObservableValue)this.stackPane.widthProperty());
        simpleDoubleProperty8.bind((ObservableValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty7, (ObservableNumberValue)this.getSkinnable().cornerRadiusProperty()));
        simpleDoubleProperty9.bind((ObservableValue)this.stackPane.heightProperty());
        simpleDoubleProperty10.bind((ObservableValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty9, (ObservableNumberValue)this.getSkinnable().cornerRadiusProperty()));
        this.moveTo = new MoveTo();
        this.moveTo.xProperty().bind((ObservableValue)simpleDoubleProperty4);
        this.moveTo.yProperty().bind((ObservableValue)simpleDoubleProperty5);
        this.lineBTop = new HLineTo();
        this.lineBTop.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty4, (ObservableNumberValue)doubleProperty3));
        this.lineCTop = new LineTo();
        this.lineCTop.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)this.lineBTop.xProperty(), (ObservableNumberValue)doubleProperty2));
        this.lineCTop.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty5, (ObservableNumberValue)doubleProperty2));
        this.lineDTop = new LineTo();
        this.lineDTop.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)this.lineCTop.xProperty(), (ObservableNumberValue)doubleProperty2));
        this.lineDTop.yProperty().bind((ObservableValue)simpleDoubleProperty5);
        this.lineETop = new HLineTo();
        this.lineETop.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty2, (ObservableNumberValue)doubleProperty2));
        this.lineFTop = new LineTo();
        this.lineFTop.xProperty().bind((ObservableValue)simpleDoubleProperty2);
        this.lineFTop.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty5, (ObservableNumberValue)doubleProperty2));
        this.lineGTop = new LineTo();
        this.lineGTop.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty2, (ObservableNumberValue)doubleProperty2));
        this.lineGTop.yProperty().bind((ObservableValue)simpleDoubleProperty5);
        this.lineHTop = new HLineTo();
        this.lineHTop.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty8, (ObservableNumberValue)doubleProperty3), (ObservableNumberValue)Bindings.multiply((ObservableNumberValue)doubleProperty2, (int)2)));
        this.lineITop = new LineTo();
        this.lineITop.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty8, (ObservableNumberValue)doubleProperty3), (ObservableNumberValue)doubleProperty2));
        this.lineITop.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty5, (ObservableNumberValue)doubleProperty2));
        this.lineJTop = new LineTo();
        this.lineJTop.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty8, (ObservableNumberValue)doubleProperty3));
        this.lineJTop.yProperty().bind((ObservableValue)simpleDoubleProperty5);
        this.lineKTop = new HLineTo();
        this.lineKTop.xProperty().bind((ObservableValue)simpleDoubleProperty8);
        this.rightCurveTo = new QuadCurveTo();
        this.rightCurveTo.xProperty().bind((ObservableValue)simpleDoubleProperty7);
        this.rightCurveTo.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty5, (ObservableNumberValue)doubleProperty));
        this.rightCurveTo.controlXProperty().bind((ObservableValue)simpleDoubleProperty7);
        this.rightCurveTo.controlYProperty().bind((ObservableValue)simpleDoubleProperty5);
        this.lineBRight = new VLineTo();
        this.lineBRight.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty6, (ObservableNumberValue)doubleProperty3));
        this.lineCRight = new LineTo();
        this.lineCRight.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty7, (ObservableNumberValue)doubleProperty2));
        this.lineCRight.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)this.lineBRight.yProperty(), (ObservableNumberValue)doubleProperty2));
        this.lineDRight = new LineTo();
        this.lineDRight.xProperty().bind((ObservableValue)simpleDoubleProperty7);
        this.lineDRight.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)this.lineCRight.yProperty(), (ObservableNumberValue)doubleProperty2));
        this.lineERight = new VLineTo();
        this.lineERight.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty, (ObservableNumberValue)doubleProperty2));
        this.lineFRight = new LineTo();
        this.lineFRight.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty7, (ObservableNumberValue)doubleProperty2));
        this.lineFRight.yProperty().bind((ObservableValue)simpleDoubleProperty);
        this.lineGRight = new LineTo();
        this.lineGRight.xProperty().bind((ObservableValue)simpleDoubleProperty7);
        this.lineGRight.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty, (ObservableNumberValue)doubleProperty2));
        this.lineHRight = new VLineTo();
        this.lineHRight.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty10, (ObservableNumberValue)doubleProperty3), (ObservableNumberValue)Bindings.multiply((ObservableNumberValue)doubleProperty2, (int)2)));
        this.lineIRight = new LineTo();
        this.lineIRight.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty7, (ObservableNumberValue)doubleProperty2));
        this.lineIRight.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty10, (ObservableNumberValue)doubleProperty3), (ObservableNumberValue)doubleProperty2));
        this.lineJRight = new LineTo();
        this.lineJRight.xProperty().bind((ObservableValue)simpleDoubleProperty7);
        this.lineJRight.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty10, (ObservableNumberValue)doubleProperty3));
        this.lineKRight = new VLineTo();
        this.lineKRight.yProperty().bind((ObservableValue)simpleDoubleProperty10);
        this.bottomCurveTo = new QuadCurveTo();
        this.bottomCurveTo.xProperty().bind((ObservableValue)simpleDoubleProperty8);
        this.bottomCurveTo.yProperty().bind((ObservableValue)simpleDoubleProperty9);
        this.bottomCurveTo.controlXProperty().bind((ObservableValue)simpleDoubleProperty7);
        this.bottomCurveTo.controlYProperty().bind((ObservableValue)simpleDoubleProperty9);
        this.lineBBottom = new HLineTo();
        this.lineBBottom.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty8, (ObservableNumberValue)doubleProperty3));
        this.lineCBottom = new LineTo();
        this.lineCBottom.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)this.lineBBottom.xProperty(), (ObservableNumberValue)doubleProperty2));
        this.lineCBottom.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty9, (ObservableNumberValue)doubleProperty2));
        this.lineDBottom = new LineTo();
        this.lineDBottom.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)this.lineCBottom.xProperty(), (ObservableNumberValue)doubleProperty2));
        this.lineDBottom.yProperty().bind((ObservableValue)simpleDoubleProperty9);
        this.lineEBottom = new HLineTo();
        this.lineEBottom.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty2, (ObservableNumberValue)doubleProperty2));
        this.lineFBottom = new LineTo();
        this.lineFBottom.xProperty().bind((ObservableValue)simpleDoubleProperty2);
        this.lineFBottom.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty9, (ObservableNumberValue)doubleProperty2));
        this.lineGBottom = new LineTo();
        this.lineGBottom.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty2, (ObservableNumberValue)doubleProperty2));
        this.lineGBottom.yProperty().bind((ObservableValue)simpleDoubleProperty9);
        this.lineHBottom = new HLineTo();
        this.lineHBottom.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty4, (ObservableNumberValue)doubleProperty3), (ObservableNumberValue)Bindings.multiply((ObservableNumberValue)doubleProperty2, (int)2)));
        this.lineIBottom = new LineTo();
        this.lineIBottom.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty4, (ObservableNumberValue)doubleProperty3), (ObservableNumberValue)doubleProperty2));
        this.lineIBottom.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty9, (ObservableNumberValue)doubleProperty2));
        this.lineJBottom = new LineTo();
        this.lineJBottom.xProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty4, (ObservableNumberValue)doubleProperty3));
        this.lineJBottom.yProperty().bind((ObservableValue)simpleDoubleProperty9);
        this.lineKBottom = new HLineTo();
        this.lineKBottom.xProperty().bind((ObservableValue)simpleDoubleProperty4);
        this.leftCurveTo = new QuadCurveTo();
        this.leftCurveTo.xProperty().bind((ObservableValue)simpleDoubleProperty3);
        this.leftCurveTo.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty9, (ObservableNumberValue)doubleProperty));
        this.leftCurveTo.controlXProperty().bind((ObservableValue)simpleDoubleProperty3);
        this.leftCurveTo.controlYProperty().bind((ObservableValue)simpleDoubleProperty9);
        this.lineBLeft = new VLineTo();
        this.lineBLeft.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty10, (ObservableNumberValue)doubleProperty3));
        this.lineCLeft = new LineTo();
        this.lineCLeft.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty3, (ObservableNumberValue)doubleProperty2));
        this.lineCLeft.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)this.lineBLeft.yProperty(), (ObservableNumberValue)doubleProperty2));
        this.lineDLeft = new LineTo();
        this.lineDLeft.xProperty().bind((ObservableValue)simpleDoubleProperty3);
        this.lineDLeft.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)this.lineCLeft.yProperty(), (ObservableNumberValue)doubleProperty2));
        this.lineELeft = new VLineTo();
        this.lineELeft.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty, (ObservableNumberValue)doubleProperty2));
        this.lineFLeft = new LineTo();
        this.lineFLeft.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty3, (ObservableNumberValue)doubleProperty2));
        this.lineFLeft.yProperty().bind((ObservableValue)simpleDoubleProperty);
        this.lineGLeft = new LineTo();
        this.lineGLeft.xProperty().bind((ObservableValue)simpleDoubleProperty3);
        this.lineGLeft.yProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty, (ObservableNumberValue)doubleProperty2));
        this.lineHLeft = new VLineTo();
        this.lineHLeft.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty6, (ObservableNumberValue)doubleProperty3), (ObservableNumberValue)Bindings.multiply((ObservableNumberValue)doubleProperty2, (int)2)));
        this.lineILeft = new LineTo();
        this.lineILeft.xProperty().bind((ObservableValue)Bindings.subtract((ObservableNumberValue)simpleDoubleProperty3, (ObservableNumberValue)doubleProperty2));
        this.lineILeft.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty6, (ObservableNumberValue)doubleProperty3), (ObservableNumberValue)doubleProperty2));
        this.lineJLeft = new LineTo();
        this.lineJLeft.xProperty().bind((ObservableValue)simpleDoubleProperty3);
        this.lineJLeft.yProperty().bind((ObservableValue)Bindings.add((ObservableNumberValue)simpleDoubleProperty6, (ObservableNumberValue)doubleProperty3));
        this.lineKLeft = new VLineTo();
        this.lineKLeft.yProperty().bind((ObservableValue)simpleDoubleProperty6);
        this.topCurveTo = new QuadCurveTo();
        this.topCurveTo.xProperty().bind((ObservableValue)simpleDoubleProperty4);
        this.topCurveTo.yProperty().bind((ObservableValue)simpleDoubleProperty5);
        this.topCurveTo.controlXProperty().bind((ObservableValue)simpleDoubleProperty3);
        this.topCurveTo.controlYProperty().bind((ObservableValue)simpleDoubleProperty5);
    }

    private Window getPopupWindow() {
        return this.getSkinnable().getScene().getWindow();
    }

    private boolean showArrow(Popover.ArrowLocation arrowLocation) {
        Popover.ArrowLocation arrowLocation2 = this.getSkinnable().getArrowLocation();
        return arrowLocation.equals((Object)arrowLocation2) && !this.getSkinnable().isDetached() && !this.tornOff;
    }

    private void updatePath() {
        ArrayList<Object> arrayList = new ArrayList<Object>();
        arrayList.add(this.moveTo);
        if (this.showArrow(Popover.ArrowLocation.TOP_LEFT)) {
            arrayList.add(this.lineBTop);
            arrayList.add(this.lineCTop);
            arrayList.add(this.lineDTop);
        }
        if (this.showArrow(Popover.ArrowLocation.TOP_CENTER)) {
            arrayList.add(this.lineETop);
            arrayList.add(this.lineFTop);
            arrayList.add(this.lineGTop);
        }
        if (this.showArrow(Popover.ArrowLocation.TOP_RIGHT)) {
            arrayList.add(this.lineHTop);
            arrayList.add(this.lineITop);
            arrayList.add(this.lineJTop);
        }
        arrayList.add(this.lineKTop);
        arrayList.add(this.rightCurveTo);
        if (this.showArrow(Popover.ArrowLocation.RIGHT_TOP)) {
            arrayList.add(this.lineBRight);
            arrayList.add(this.lineCRight);
            arrayList.add(this.lineDRight);
        }
        if (this.showArrow(Popover.ArrowLocation.RIGHT_CENTER)) {
            arrayList.add(this.lineERight);
            arrayList.add(this.lineFRight);
            arrayList.add(this.lineGRight);
        }
        if (this.showArrow(Popover.ArrowLocation.RIGHT_BOTTOM)) {
            arrayList.add(this.lineHRight);
            arrayList.add(this.lineIRight);
            arrayList.add(this.lineJRight);
        }
        arrayList.add(this.lineKRight);
        arrayList.add(this.bottomCurveTo);
        if (this.showArrow(Popover.ArrowLocation.BOTTOM_RIGHT)) {
            arrayList.add(this.lineBBottom);
            arrayList.add(this.lineCBottom);
            arrayList.add(this.lineDBottom);
        }
        if (this.showArrow(Popover.ArrowLocation.BOTTOM_CENTER)) {
            arrayList.add(this.lineEBottom);
            arrayList.add(this.lineFBottom);
            arrayList.add(this.lineGBottom);
        }
        if (this.showArrow(Popover.ArrowLocation.BOTTOM_LEFT)) {
            arrayList.add(this.lineHBottom);
            arrayList.add(this.lineIBottom);
            arrayList.add(this.lineJBottom);
        }
        arrayList.add(this.lineKBottom);
        arrayList.add(this.leftCurveTo);
        if (this.showArrow(Popover.ArrowLocation.LEFT_BOTTOM)) {
            arrayList.add(this.lineBLeft);
            arrayList.add(this.lineCLeft);
            arrayList.add(this.lineDLeft);
        }
        if (this.showArrow(Popover.ArrowLocation.LEFT_CENTER)) {
            arrayList.add(this.lineELeft);
            arrayList.add(this.lineFLeft);
            arrayList.add(this.lineGLeft);
        }
        if (this.showArrow(Popover.ArrowLocation.LEFT_TOP)) {
            arrayList.add(this.lineHLeft);
            arrayList.add(this.lineILeft);
            arrayList.add(this.lineJLeft);
        }
        arrayList.add(this.lineKLeft);
        arrayList.add(this.topCurveTo);
        this.path.getElements().setAll(arrayList);
        this.clip.getElements().setAll(arrayList);
    }
}

