/*
 * Decompiled with CFR 0.152.
 */
package ar.com.hjg.pngj;

import ar.com.hjg.pngj.DeflatedChunkReader;
import ar.com.hjg.pngj.PngjException;
import ar.com.hjg.pngj.PngjInputException;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class DeflatedChunksSet {
    protected byte[] row;
    private int rowfilled;
    private int rowlen;
    private int rown;
    State state = State.WAITING_FOR_INPUT;
    private Inflater inf;
    private final boolean infOwn;
    private DeflatedChunkReader curChunk;
    private boolean callbackMode = true;
    private long nBytesIn = 0L;
    private long nBytesOut = 0L;
    public final String chunkid;

    public DeflatedChunksSet(String string, int n2, int n3, Inflater inflater, byte[] byArray) {
        this.chunkid = string;
        this.rowlen = n2;
        if (n2 < 1 || n3 < n2) {
            throw new PngjException("bad inital row len " + n2);
        }
        if (inflater != null) {
            this.inf = inflater;
            this.infOwn = false;
        } else {
            this.inf = new Inflater();
            this.infOwn = true;
        }
        this.row = byArray != null && byArray.length >= n2 ? byArray : new byte[n3];
        this.rown = -1;
        this.state = State.WAITING_FOR_INPUT;
        try {
            this.prepareForNextRow(n2);
        }
        catch (RuntimeException runtimeException) {
            this.close();
            throw runtimeException;
        }
    }

    public DeflatedChunksSet(String string, int n2, int n3) {
        this(string, n2, n3, null, null);
    }

    protected void appendNewChunk(DeflatedChunkReader deflatedChunkReader) {
        if (!this.chunkid.equals(deflatedChunkReader.getChunkRaw().id)) {
            throw new PngjInputException("Bad chunk inside IdatSet, id:" + deflatedChunkReader.getChunkRaw().id + ", expected:" + this.chunkid);
        }
        this.curChunk = deflatedChunkReader;
    }

    protected void processBytes(byte[] byArray, int n2, int n3) {
        this.nBytesIn += (long)n3;
        if (n3 < 1 || this.state.isDone()) {
            return;
        }
        if (this.state == State.ROW_READY) {
            throw new PngjInputException("this should only be called if waitingForMoreInput");
        }
        if (this.inf.needsDictionary() || !this.inf.needsInput()) {
            throw new RuntimeException("should not happen");
        }
        this.inf.setInput(byArray, n2, n3);
        if (this.isCallbackMode()) {
            while (this.inflateData()) {
                int n4 = this.processRowCallback();
                this.prepareForNextRow(n4);
                if (!this.isDone()) continue;
                this.processDoneCallback();
            }
        } else {
            this.inflateData();
        }
    }

    private boolean inflateData() {
        try {
            if (this.state == State.ROW_READY) {
                throw new PngjException("invalid state");
            }
            if (this.state.isDone()) {
                return false;
            }
            int n2 = 0;
            if (this.row == null || this.row.length < this.rowlen) {
                this.row = new byte[this.rowlen];
            }
            if (this.rowfilled < this.rowlen && !this.inf.finished()) {
                try {
                    n2 = this.inf.inflate(this.row, this.rowfilled, this.rowlen - this.rowfilled);
                }
                catch (DataFormatException dataFormatException) {
                    throw new PngjInputException("error decompressing zlib stream ", dataFormatException);
                }
                this.rowfilled += n2;
                this.nBytesOut += (long)n2;
            }
            State state = null;
            state = this.rowfilled == this.rowlen ? State.ROW_READY : (!this.inf.finished() ? State.WAITING_FOR_INPUT : (this.rowfilled > 0 ? State.ROW_READY : State.WORK_DONE));
            this.state = state;
            if (this.state == State.ROW_READY) {
                this.preProcessRow();
                return true;
            }
        }
        catch (RuntimeException runtimeException) {
            this.close();
            throw runtimeException;
        }
        return false;
    }

    protected void preProcessRow() {
    }

    protected int processRowCallback() {
        throw new PngjInputException("not implemented");
    }

    protected void processDoneCallback() {
    }

    public byte[] getInflatedRow() {
        return this.row;
    }

    public void prepareForNextRow(int n2) {
        this.rowfilled = 0;
        ++this.rown;
        if (n2 < 1) {
            this.rowlen = 0;
            this.done();
        } else if (this.inf.finished()) {
            this.rowlen = 0;
            this.done();
        } else {
            this.state = State.WAITING_FOR_INPUT;
            this.rowlen = n2;
            if (!this.callbackMode) {
                this.inflateData();
            }
        }
    }

    public boolean isWaitingForMoreInput() {
        return this.state == State.WAITING_FOR_INPUT;
    }

    public boolean isRowReady() {
        return this.state == State.ROW_READY;
    }

    public boolean isDone() {
        return this.state.isDone();
    }

    public boolean isTerminated() {
        return this.state.isTerminated();
    }

    public boolean ackNextChunkId(String string) {
        if (this.state.isTerminated()) {
            return false;
        }
        if (string.equals(this.chunkid)) {
            return true;
        }
        if (!this.allowOtherChunksInBetween(string)) {
            if (this.state.isDone()) {
                if (!this.isTerminated()) {
                    this.terminate();
                }
                return false;
            }
            throw new PngjInputException("Unexpected chunk " + string + " while " + this.chunkid + " set is not done");
        }
        return true;
    }

    protected void terminate() {
        this.close();
    }

    public void close() {
        try {
            if (!this.state.isTerminated()) {
                this.state = State.TERMINATED;
            }
            if (this.infOwn && this.inf != null) {
                this.inf.end();
                this.inf = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void done() {
        if (!this.isDone()) {
            this.state = State.WORK_DONE;
        }
    }

    public int getRowLen() {
        return this.rowlen;
    }

    public int getRowFilled() {
        return this.rowfilled;
    }

    public int getRown() {
        return this.rown;
    }

    public boolean allowOtherChunksInBetween(String string) {
        return false;
    }

    public boolean isCallbackMode() {
        return this.callbackMode;
    }

    public void setCallbackMode(boolean bl2) {
        this.callbackMode = bl2;
    }

    public long getBytesIn() {
        return this.nBytesIn;
    }

    public long getBytesOut() {
        return this.nBytesOut;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder("idatSet : " + this.curChunk.getChunkRaw().id + " state=" + (Object)((Object)this.state) + " rows=" + this.rown + " bytes=" + this.nBytesIn + "/" + this.nBytesOut);
        return stringBuilder.toString();
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum State {
        WAITING_FOR_INPUT,
        ROW_READY,
        WORK_DONE,
        TERMINATED;


        public boolean isDone() {
            return this == WORK_DONE || this == TERMINATED;
        }

        public boolean isTerminated() {
            return this == TERMINATED;
        }
    }
}

