/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.teachrepeat.state;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.function.Consumer;
import javafx.animation.AnimationTimer;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.ReadOnlyIntegerProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import us.hebi.gui.lib.aa;
import us.hebi.gui.lib.bcg;
import us.hebi.gui.views.teachrepeat.state.Waypoint;

public class WaypointList {
    public final ObservableList<Waypoint> waypoints = FXCollections.observableArrayList();
    private final IntegerProperty numWaypoints = new SimpleIntegerProperty(0);
    private final IntegerProperty numJoints = new SimpleIntegerProperty(0);
    public final BooleanProperty dirty = new SimpleBooleanProperty(false);
    public final List<Consumer<List<Waypoint>>> updateActions = new ArrayList<Consumer<List<Waypoint>>>();
    private final Runnable setDirty = this::setDirty;
    private AnimationTimer syncer;

    public void add(Waypoint waypoint) {
        this.waypoints.add((Object)waypoint);
    }

    public ObservableList<Waypoint> getList() {
        return this.waypoints;
    }

    public WaypointList() {
        this.waypoints.addListener(change -> {
            this.setDirty();
            this.numWaypoints.set(this.waypoints.size());
            this.numJoints.set(this.waypoints.isEmpty() ? 0 : ((Waypoint)this.waypoints.get(0)).getNumJoints());
            while (change.next()) {
                if (change.wasAdded()) {
                    change.getAddedSubList().forEach(waypoint -> waypoint.setOnChange(this.setDirty));
                    continue;
                }
                if (!change.wasRemoved()) continue;
                change.getRemoved().forEach(Waypoint::clearOnChange);
            }
        });
        this.dirty.addListener((observableValue, bl2, bl3) -> {
            if (bl3 == Boolean.TRUE) {
                FXCollections.sort(this.waypoints, Comparator.comparingDouble(Waypoint::getTime));
            }
        });
    }

    public int getNumWaypoints() {
        return this.numWaypointsProperty().get();
    }

    public int getNumJoints() {
        return this.numJointsProperty().get();
    }

    public ReadOnlyIntegerProperty numWaypointsProperty() {
        return this.numWaypoints;
    }

    public ReadOnlyIntegerProperty numJointsProperty() {
        return this.numJoints;
    }

    public void addOnUpdate(Consumer<List<Waypoint>> consumer) {
        this.updateActions.add(aa.b(consumer));
    }

    public void setDirty() {
        this.dirty.set(true);
    }

    @PostConstruct
    private void init() {
        this.syncer = new bcg(this);
        this.syncer.start();
    }

    @PreDestroy
    private void delete() {
        this.syncer.stop();
    }
}

