/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.dialogs.convertlog;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.CompletableFuture;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.ObjectBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ProgressBar;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.stage.FileChooser;
import javafx.stage.Window;
import javax.inject.Inject;
import us.hebi.gui.lib.amk;
import us.hebi.gui.lib.aro;
import us.hebi.gui.lib.atd;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.bby;
import us.hebi.gui.lib.ev;
import us.hebi.gui.lib.xs;
import us.hebi.gui.lib.xt;
import us.hebi.gui.lib.xx;

public class ConvertLogPresenter {
    @FXML
    private ToggleButton formatToggleMat;
    @FXML
    private ToggleGroup outputFormat;
    @FXML
    private ToggleButton formatToggleCsv;
    @FXML
    private ToggleButton viewToggleFull;
    @FXML
    private ToggleGroup outputView;
    @FXML
    private ToggleButton viewToggleIO;
    @FXML
    private ToggleButton viewToggleMobile;
    @FXML
    private ProgressBar progressBar;
    @FXML
    private Button convertBtn;
    @FXML
    private Button closeBtn;
    private static final bby INVALID_CONVERTER = new bby(amk2 -> Boolean.FALSE, amk2 -> {
        throw new IllegalStateException("Not a valid converter");
    });
    @Inject
    String logPath;
    @Inject
    aro properties;
    ObjectBinding<bby> selectedFormat;
    ObjectBinding<amk> selectedView;
    BooleanProperty conversionInProgress = new SimpleBooleanProperty(false);
    final FileChooser outputFileChooser = new FileChooser();

    @FXML
    void initialize() {
        azx.a(this.outputFormat);
        this.formatToggleMat.setUserData((Object)new bby(xx::a, xx::a));
        this.formatToggleCsv.setUserData((Object)new bby(xt::a, xt::a));
        this.selectedFormat = Bindings.createObjectBinding(() -> {
            Toggle toggle = this.outputFormat.getSelectedToggle();
            if (toggle == null || toggle.getUserData() == null) {
                return INVALID_CONVERTER;
            }
            return (bby)toggle.getUserData();
        }, (Observable[])new Observable[]{this.outputFormat.selectedToggleProperty()});
        azx.a(this.outputView);
        this.viewToggleFull.setUserData((Object)amk.c);
        this.viewToggleIO.setUserData((Object)amk.e);
        this.viewToggleMobile.setUserData((Object)amk.f);
        this.selectedView = Bindings.createObjectBinding(() -> {
            Toggle toggle = this.outputView.getSelectedToggle();
            if (toggle == null || toggle.getUserData() == null) {
                return amk.c;
            }
            return (amk)((Object)((Object)toggle.getUserData()));
        }, (Observable[])new Observable[]{this.outputView.selectedToggleProperty()});
        this.selectedFormat.addListener(observable -> this.disableUnsupportedViews());
        BooleanBinding booleanBinding = Bindings.createBooleanBinding(() -> ((bby)this.selectedFormat.get()).e.apply((amk)((Object)((Object)this.selectedView.get()))) == false, (Observable[])new Observable[]{this.selectedFormat, this.selectedView});
        this.convertBtn.disableProperty().bind((ObservableValue)booleanBinding.or((ObservableBooleanValue)this.conversionInProgress));
        this.closeBtn.disableProperty().bind((ObservableValue)this.conversionInProgress);
        this.formatToggleMat.getParent().getParent().disableProperty().bind((ObservableValue)this.conversionInProgress);
        this.viewToggleFull.getParent().getParent().disableProperty().bind((ObservableValue)this.conversionInProgress);
        this.progressBar.setProgress(0.0);
        this.progressBar.visibleProperty().bind((ObservableValue)this.progressBar.progressProperty().isNotEqualTo(0));
        this.progressBar.managedProperty().bind((ObservableValue)this.progressBar.visibleProperty());
    }

    private void disableUnsupportedViews() {
        for (Toggle toggle : this.outputView.getToggles()) {
            ((ToggleButton)toggle).setDisable(((bby)this.selectedFormat.get()).e.apply((amk)((Object)toggle.getUserData())) == false);
        }
    }

    public Button getCloseButton() {
        return this.closeBtn;
    }

    @FXML
    void convertLog(ActionEvent actionEvent) {
        Window window = this.getCloseButton().getScene().getWindow();
        ArrayList<FileChooser.ExtensionFilter> arrayList = new ArrayList<FileChooser.ExtensionFilter>();
        String string = "";
        if (this.formatToggleMat.isSelected()) {
            arrayList.add(new FileChooser.ExtensionFilter("MAT Files", new String[]{"*.mat"}));
            string = ".mat";
        }
        if (this.formatToggleCsv.isSelected()) {
            arrayList.add(new FileChooser.ExtensionFilter("CSV Files", new String[]{"*.csv"}));
            string = ".csv";
        }
        arrayList.add(new FileChooser.ExtensionFilter("All Files", new String[]{"*.*"}));
        File file2 = new File(this.logPath);
        this.outputFileChooser.setTitle("Choose output file");
        azx.a(this.outputFileChooser, file2.getParentFile());
        this.outputFileChooser.setInitialFileName(ev.b(this.logPath));
        this.outputFileChooser.getExtensionFilters().setAll(arrayList);
        File file3 = this.outputFileChooser.showSaveDialog(azx.a(actionEvent));
        if (file3 == null) {
            return;
        }
        xs<File> xs2 = ((bby)this.selectedFormat.get()).f.apply((amk)((Object)this.selectedView.get()));
        this.conversionInProgress.setValue(Boolean.TRUE);
        this.progressBar.setProgress(-1.0);
        String string2 = file3.getAbsolutePath();
        if (string2.endsWith(string)) {
            string2 = string2.substring(0, string2.length() - string.length());
        }
        String string3 = string2;
        CompletableFuture.supplyAsync(() -> {
            try {
                return (File)xs2.a(file2, string3);
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }).whenCompleteAsync((file, throwable) -> {
            if (throwable != null) {
                atd.a(throwable.getMessage(), window);
            } else {
                atd.a(file, window);
            }
            this.conversionInProgress.setValue(Boolean.FALSE);
            this.progressBar.setProgress(1.0);
        }, azx.d);
    }
}

