/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import java.util.concurrent.ExecutorService;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.DoubleProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.concurrent.Task;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ProgressBar;
import javafx.scene.layout.Pane;
import javafx.scene.text.Text;
import javax.inject.Inject;
import lombok.Generated;
import us.hebi.gui.lib.aga;
import us.hebi.gui.lib.aqr;
import us.hebi.gui.lib.aqy;
import us.hebi.gui.lib.arl;
import us.hebi.gui.lib.ath;
import us.hebi.gui.lib.atn;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.azz;
import us.hebi.gui.lib.baf;
import us.hebi.gui.lib.bcj;

public class UpdateItem {
    @FXML
    protected Text deviceName;
    @FXML
    protected Text currentText;
    @FXML
    protected Text updateText;
    @FXML
    protected Button updateBtn;
    @FXML
    protected ProgressBar progressBar;
    private final Pane content;
    private DoubleProperty numActiveTasks;
    private atn updateInfo;
    private arl device;
    private BooleanProperty hasUpdated = new SimpleBooleanProperty(false);
    @Inject
    private ath bootloaderService;
    @Inject
    private ExecutorService executorService;

    public UpdateItem(atn atn2, DoubleProperty doubleProperty) {
        this.content = (Pane)azz.a(this, "updateitem.fxml");
        this.numActiveTasks = doubleProperty;
        this.updateInfo = atn2;
        this.device = atn2.device;
        this.deviceName.textProperty().bind((ObservableValue)this.device.a);
        this.updateBtn.setOnAction(this::update);
        this.updateBtn.visibleProperty().bind((ObservableValue)this.hasUpdated.not());
        this.updateBtn.managedProperty().bind((ObservableValue)this.updateBtn.visibleProperty());
        Object[] objectArray = new Object[1];
        aqy aqy2 = atn2.device.getInfo();
        aqr aqr2 = aqy2.a;
        objectArray[0] = aqr2.a() == aga.c ? aqr2.r() : "N/A";
        UpdateItem.setText(this.currentText, "Current: %s", objectArray);
        UpdateItem.setText(this.updateText, "Update to: %s", atn2.E());
        this.progressBar.setVisible(false);
    }

    public void update(ActionEvent actionEvent) {
        if (this.hasUpdated.get()) {
            return;
        }
        this.hasUpdated.set(true);
        Task<Boolean> task = this.bootloaderService.createAutoUpdateTask(this.device, bcj.d);
        Runnable runnable = () -> baf.b(this.device.a());
        azx.a(task, bl2 -> {
            this.executorService.submit(runnable);
            UpdateItem.setText(this.updateText, "Update Finished", new Object[0]);
            UpdateItem.setText(this.currentText, "Current: %s", this.updateInfo.E());
            this.progressBar.setVisible(false);
            this.numActiveTasks.setValue((Number)(this.numActiveTasks.get() - 1.0));
        }, throwable -> {
            UpdateItem.setText(this.updateText, "Update failed: %s", throwable.getLocalizedMessage());
            this.hasUpdated.set(false);
            this.progressBar.setVisible(false);
            this.numActiveTasks.setValue((Number)(this.numActiveTasks.get() - 1.0));
        });
        this.numActiveTasks.setValue((Number)(this.numActiveTasks.get() + 1.0));
        this.executorService.submit((Runnable)task);
        this.updateText.textProperty().bind((ObservableValue)task.messageProperty());
        this.progressBar.progressProperty().bind((ObservableValue)task.progressProperty());
        this.progressBar.setVisible(true);
    }

    protected static void setText(Text text, String string, Object ... objectArray) {
        if (text.textProperty().isBound()) {
            text.textProperty().unbind();
        }
        text.setText(String.format(string, objectArray));
    }

    @Generated
    public Pane getContent() {
        return this.content;
    }
}

