/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import atlantafx.base.controls.CustomTextField;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.ResourceBundle;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Control;
import javax.inject.Inject;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import us.hebi.gui.controls.HBlock;
import us.hebi.gui.controls.HBlockSection;
import us.hebi.gui.controls.HDoubleInputField;
import us.hebi.gui.lib.acb;
import us.hebi.gui.lib.afu;
import us.hebi.gui.lib.afv;
import us.hebi.gui.lib.aqt;
import us.hebi.gui.lib.aqy;
import us.hebi.gui.lib.aum;
import us.hebi.gui.lib.azl;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.yz;
import us.hebi.gui.lib.za;
import us.hebi.gui.lib.zb;
import us.hebi.gui.views.scope.components.ParseUtils;

public class PidController {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private HBlock block;
    @FXML
    private HDoubleInputField kp;
    @FXML
    private HDoubleInputField ki;
    @FXML
    private HDoubleInputField kd;
    @FXML
    private HDoubleInputField ff;
    @FXML
    private HDoubleInputField deadZone;
    @FXML
    private HDoubleInputField iClamp;
    @FXML
    private HDoubleInputField punch;
    @FXML
    private HBlockSection targetSection;
    @FXML
    private HDoubleInputField targetMin;
    @FXML
    private HDoubleInputField targetMax;
    @FXML
    private HDoubleInputField targetLp;
    @FXML
    private HBlockSection outputSection;
    @FXML
    private HDoubleInputField outMin;
    @FXML
    private HDoubleInputField outMax;
    @FXML
    private HDoubleInputField outLp;
    @FXML
    private HBlockSection variousSection;
    @FXML
    private HDoubleInputField dOnError;
    private List<Node> advancedNodes = new ArrayList<Node>();
    @Inject
    aum module;
    private za category;
    private ReadOnlyBooleanProperty advancedView;

    private static String uppercaseFirstLetter(String string) {
        return Character.toUpperCase(string.charAt(0)) + string.substring(1);
    }

    public void initialize(za za2, ReadOnlyBooleanProperty readOnlyBooleanProperty, ValidationSupport validationSupport, ValidationSupport validationSupport2) {
        this.block.setTitle(PidController.uppercaseFirstLetter(za2.name()));
        this.category = za2;
        this.advancedView = readOnlyBooleanProperty;
        CustomTextField customTextField = this.getControl(zb.n).getTextInput();
        azx.a(customTextField.visibleProperty(), Boolean.FALSE);
        azx.a(customTextField.disableProperty(), Boolean.TRUE);
        this.setAdvanced(new Node[]{this.punch, this.targetSection, this.outputSection, this.variousSection});
        switch (za2) {
            case a: {
                this.setAdvanced(new Node[]{this.ff});
                break;
            }
            case b: {
                this.setAdvanced(new Node[]{this.kd, this.ki, this.iClamp});
            }
        }
        for (zb zb2 : zb.values()) {
            this.setupControl(zb2, validationSupport, validationSupport2);
        }
        this.advancedNodes.clear();
    }

    private void setAdvanced(Node ... nodeArray) {
        Node[] nodeArray2 = nodeArray;
        int n2 = nodeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = nodeArray2[i2];
            azx.a(node, (ObservableBooleanValue)this.advancedView);
            this.advancedNodes.add(node);
        }
    }

    public void addGainsToMessage(afu afu2) {
        for (zb zb2 : zb.values()) {
            this.getControl(zb2);
            CustomTextField customTextField = this.getControl(zb2).getTextInput();
            Double d2 = zb2.P ? ParseUtils.tryParseNonNanDouble(customTextField) : ParseUtils.tryParseFiniteDouble(customTextField);
            if (d2 == null) continue;
            yz.a(afu2, this.category, zb2, d2);
        }
    }

    public void setTextFields(afv afv2) {
        for (zb zb2 : zb.values()) {
            CustomTextField customTextField = this.getControl(zb2).getTextInput();
            double d2 = yz.a(afv2, this.category, zb2);
            if (Double.isNaN(d2)) {
                customTextField.setText("");
                continue;
            }
            customTextField.setText(acb.b(d2));
        }
    }

    public void clearAllTextFields() {
        for (zb zb2 : zb.values()) {
            this.getControl(zb2).getTextInput().setText("");
        }
    }

    private void setupControl(zb zb2, ValidationSupport validationSupport, ValidationSupport validationSupport2) {
        HDoubleInputField hDoubleInputField = this.getControl(zb2);
        ReadOnlyDoubleProperty readOnlyDoubleProperty = this.getProperty(zb2);
        hDoubleInputField.feedbackValueProperty().bind((ObservableValue)readOnlyDoubleProperty);
        boolean bl2 = zb2 == zb.c;
        hDoubleInputField.setFormat(bl2 ? "#0.000##" : "#0.###");
        Validator<String> validator = zb2.P ? ParseUtils.NON_NAN_DOUBLE_VALIDATOR : ParseUtils.FINITE_DOUBLE_VALIDATOR;
        hDoubleInputField.setAllowInf(zb2.P);
        Validator<String> validator2 = azl.a(hDoubleInputField.getTextInput(), validator, readOnlyDoubleProperty, bl2 ? 1.0E-5 : 0.001);
        (this.advancedNodes.contains((Object)hDoubleInputField) ? validationSupport2 : validationSupport).registerValidator((Control)hDoubleInputField.getTextInput(), false, validator2);
    }

    private ReadOnlyDoubleProperty getProperty(zb zb2) {
        Object object = this.module.getInfo();
        aqt aqt2 = ((aqy)object).a;
        switch (this.category) {
            case a: {
                switch (zb2) {
                    case a: {
                        aqt aqt3 = aqt2;
                        return aqt3.aN;
                    }
                    case b: {
                        aqt aqt4 = aqt2;
                        return aqt4.aM;
                    }
                    case c: {
                        aqt aqt5 = aqt2;
                        return aqt5.aL;
                    }
                    case d: {
                        aqt aqt6 = aqt2;
                        return aqt6.aJ;
                    }
                    case e: {
                        aqt aqt7 = aqt2;
                        return aqt7.aI;
                    }
                    case f: {
                        aqt aqt8 = aqt2;
                        return aqt8.aK;
                    }
                    case g: {
                        aqt aqt9 = aqt2;
                        return aqt9.aT;
                    }
                    case h: {
                        object = aqt2;
                        return ((aqt)object).aR;
                    }
                    case i: {
                        object = aqt2;
                        return ((aqt)object).aP;
                    }
                    case j: {
                        aqt aqt10 = aqt2;
                        return aqt10.aU;
                    }
                    case k: {
                        aqt aqt11 = aqt2;
                        return aqt11.aQ;
                    }
                    case l: {
                        aqt aqt12 = aqt2;
                        return aqt12.aO;
                    }
                    case m: {
                        aqt aqt13 = aqt2;
                        return aqt13.aS;
                    }
                    case n: {
                        aqt aqt14 = aqt2;
                        return aqt14.aH;
                    }
                }
            }
            case b: {
                switch (zb2) {
                    case a: {
                        aqt aqt15 = aqt2;
                        return aqt15.bb;
                    }
                    case b: {
                        aqt aqt16 = aqt2;
                        return aqt16.ba;
                    }
                    case c: {
                        aqt aqt17 = aqt2;
                        return aqt17.aZ;
                    }
                    case d: {
                        aqt aqt18 = aqt2;
                        return aqt18.aX;
                    }
                    case e: {
                        aqt aqt19 = aqt2;
                        return aqt19.aW;
                    }
                    case f: {
                        aqt aqt20 = aqt2;
                        return aqt20.aY;
                    }
                    case g: {
                        aqt aqt21 = aqt2;
                        return aqt21.bh;
                    }
                    case h: {
                        object = aqt2;
                        return ((aqt)object).bf;
                    }
                    case i: {
                        object = aqt2;
                        return ((aqt)object).bd;
                    }
                    case j: {
                        aqt aqt22 = aqt2;
                        return aqt22.bi;
                    }
                    case k: {
                        aqt aqt23 = aqt2;
                        return aqt23.be;
                    }
                    case l: {
                        aqt aqt24 = aqt2;
                        return aqt24.bc;
                    }
                    case m: {
                        aqt aqt25 = aqt2;
                        return aqt25.bg;
                    }
                    case n: {
                        aqt aqt26 = aqt2;
                        return aqt26.aV;
                    }
                }
            }
            case c: {
                switch (zb2) {
                    case a: {
                        aqt aqt27 = aqt2;
                        return aqt27.az;
                    }
                    case b: {
                        aqt aqt28 = aqt2;
                        return aqt28.ay;
                    }
                    case c: {
                        aqt aqt29 = aqt2;
                        return aqt29.ax;
                    }
                    case d: {
                        aqt aqt30 = aqt2;
                        return aqt30.av;
                    }
                    case e: {
                        aqt aqt31 = aqt2;
                        return aqt31.au;
                    }
                    case f: {
                        aqt aqt32 = aqt2;
                        return aqt32.aw;
                    }
                    case g: {
                        aqt aqt33 = aqt2;
                        return aqt33.aF;
                    }
                    case h: {
                        object = aqt2;
                        return ((aqt)object).aD;
                    }
                    case i: {
                        object = aqt2;
                        return ((aqt)object).aB;
                    }
                    case j: {
                        aqt aqt34 = aqt2;
                        return aqt34.aG;
                    }
                    case k: {
                        aqt aqt35 = aqt2;
                        return aqt35.aC;
                    }
                    case l: {
                        aqt aqt36 = aqt2;
                        return aqt36.aA;
                    }
                    case m: {
                        aqt aqt37 = aqt2;
                        return aqt37.aE;
                    }
                    case n: {
                        aqt aqt38 = aqt2;
                        return aqt38.at;
                    }
                }
            }
        }
        throw new IllegalArgumentException("Unknown property: " + String.valueOf((Object)this.category) + " > " + String.valueOf((Object)zb2));
    }

    private HDoubleInputField getControl(zb zb2) {
        switch (zb2) {
            case a: {
                return this.kp;
            }
            case b: {
                return this.ki;
            }
            case c: {
                return this.kd;
            }
            case d: {
                return this.ff;
            }
            case e: {
                return this.deadZone;
            }
            case f: {
                return this.iClamp;
            }
            case g: {
                return this.punch;
            }
            case h: {
                return this.targetMin;
            }
            case i: {
                return this.targetMax;
            }
            case j: {
                return this.targetLp;
            }
            case k: {
                return this.outMin;
            }
            case l: {
                return this.outMax;
            }
            case m: {
                return this.outLp;
            }
            case n: {
                return this.dOnError;
            }
        }
        throw new IllegalStateException("Unknown field: " + String.valueOf((Object)zb2));
    }
}

