/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import atlantafx.base.controls.CustomTextField;
import io.fair_acc.chartfx.utils.PropUtil;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.IntConsumer;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.stage.Window;
import javax.inject.Inject;
import javax.xml.transform.sax.SAXSource;
import lombok.Generated;
import org.controlsfx.validation.ValidationResult;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import us.hebi.gui.controls.HDoubleInputField;
import us.hebi.gui.controls.HEnumInputField;
import us.hebi.gui.controls.TextUtil;
import us.hebi.gui.lib.aak;
import us.hebi.gui.lib.aaq;
import us.hebi.gui.lib.abk;
import us.hebi.gui.lib.abm;
import us.hebi.gui.lib.abo;
import us.hebi.gui.lib.acj;
import us.hebi.gui.lib.agw;
import us.hebi.gui.lib.agx;
import us.hebi.gui.lib.agy;
import us.hebi.gui.lib.agz;
import us.hebi.gui.lib.aha;
import us.hebi.gui.lib.ahb;
import us.hebi.gui.lib.ahc;
import us.hebi.gui.lib.ahd;
import us.hebi.gui.lib.ahe;
import us.hebi.gui.lib.ahf;
import us.hebi.gui.lib.ahg;
import us.hebi.gui.lib.anm;
import us.hebi.gui.lib.aox;
import us.hebi.gui.lib.aql;
import us.hebi.gui.lib.aqm;
import us.hebi.gui.lib.aqn;
import us.hebi.gui.lib.aqq;
import us.hebi.gui.lib.aqs;
import us.hebi.gui.lib.aqu;
import us.hebi.gui.lib.aqy;
import us.hebi.gui.lib.are;
import us.hebi.gui.lib.arf;
import us.hebi.gui.lib.arj;
import us.hebi.gui.lib.aro;
import us.hebi.gui.lib.asy;
import us.hebi.gui.lib.atd;
import us.hebi.gui.lib.ate;
import us.hebi.gui.lib.aty;
import us.hebi.gui.lib.auh;
import us.hebi.gui.lib.aum;
import us.hebi.gui.lib.ava;
import us.hebi.gui.lib.avk;
import us.hebi.gui.lib.azi;
import us.hebi.gui.lib.azl;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.uk;
import us.hebi.gui.views.scope.components.EncoderConfigController;
import us.hebi.gui.views.scope.components.MotorDriverCommand;
import us.hebi.gui.views.scope.components.ParseUtils;
import us.hebi.gui.views.scope.dialogs.calibrate.AdcCalibrationDialog;
import us.hebi.gui.views.scope.dialogs.calibrate.MotorEncoderCalibrationDialog;
import us.hebi.gui.views.scope.dialogs.motordriver.SaveMotorDriverXmlDialog;

public class MotorDriverController
extends azi {
    @FXML
    private Button calibrateAdcBtn;
    @FXML
    private Button clearBtn;
    @FXML
    private ToggleButton persistToggle;
    @FXML
    private ToggleButton showAdvancedToggle;
    @FXML
    private ToggleButton showEncoderToggle;
    @FXML
    private HEnumInputField<ahd> controlMode;
    @FXML
    private HEnumInputField<agz> outputEncoder;
    @FXML
    private HEnumInputField<agz> deflectionEncoder;
    @FXML
    private HEnumInputField<agz> motorEncoder;
    @FXML
    private Pane encoderA1;
    @FXML
    private EncoderConfigController encoderA1Controller;
    @FXML
    private Pane encoderA2;
    @FXML
    private EncoderConfigController encoderA2Controller;
    @FXML
    private Pane encoderB1;
    @FXML
    private EncoderConfigController encoderB1Controller;
    @FXML
    private Pane encoderB2;
    @FXML
    private EncoderConfigController encoderB2Controller;
    @FXML
    private Pane encoderHalls;
    @FXML
    private EncoderConfigController encoderHallsController;
    @FXML
    private HEnumInputField<ahg> windingOrder;
    @FXML
    private HEnumInputField<ahc> hallOrder;
    @FXML
    private HEnumInputField<ahb> hallOffset;
    @FXML
    private VBox focContainer;
    @FXML
    private HDoubleInputField focIdIClamp;
    @FXML
    private HDoubleInputField focIdKi;
    @FXML
    private HDoubleInputField focIdKp;
    @FXML
    private HDoubleInputField focIqIClamp;
    @FXML
    private HDoubleInputField focIqKi;
    @FXML
    private HDoubleInputField focIqKp;
    @FXML
    private HDoubleInputField gearEfficiency;
    @FXML
    private HDoubleInputField maxOutputTorque;
    @FXML
    private HDoubleInputField gearRatioNumerator;
    @FXML
    private HDoubleInputField gearRatioDenominator;
    @FXML
    private HDoubleInputField calibOffsetIa;
    @FXML
    private HDoubleInputField calibOffsetIb;
    @FXML
    private HDoubleInputField calibOffsetIc;
    @FXML
    private HDoubleInputField calibOffsetIBus;
    @FXML
    private HDoubleInputField calibOffsetVa;
    @FXML
    private HDoubleInputField calibOffsetVb;
    @FXML
    private HDoubleInputField calibOffsetVc;
    @FXML
    private HDoubleInputField housingThermalResistance;
    @FXML
    private HDoubleInputField housingThermalTimeConstant;
    @FXML
    private HDoubleInputField thermalModelStartPercentage;
    @FXML
    private HDoubleInputField slewRateVoltage;
    @FXML
    private HDoubleInputField slewRateCurrent;
    @FXML
    private HDoubleInputField motorElectricalPowerLimit;
    @FXML
    private HDoubleInputField motorMechanicalPowerLimit;
    @FXML
    private Button loadFileBtn;
    @FXML
    private HDoubleInputField maxBoardCurrent;
    @FXML
    private HDoubleInputField maxDutyCycle;
    @FXML
    private HDoubleInputField maxMotorSpeed;
    @FXML
    private HDoubleInputField minDutyCycle;
    @FXML
    private HDoubleInputField switchingFreq;
    @FXML
    private HDoubleInputField controlDivider;
    @FXML
    private HDoubleInputField currentSenseThresholdVds;
    @FXML
    private HDoubleInputField currentSenseThresholdWinding;
    @FXML
    private HDoubleInputField currentFilterSize;
    @FXML
    private HDoubleInputField currentSenseGain;
    @FXML
    private HEnumInputField<ahf> torqueSource;
    @FXML
    private HEnumInputField<ahe> temperatureSource;
    @FXML
    private HDoubleInputField temperatureSourceUserValue;
    @FXML
    private HDoubleInputField polePairs;
    @FXML
    private Button resetBtn;
    @FXML
    private Button saveFileBtn;
    @FXML
    private Button sendBtn;
    @FXML
    private HDoubleInputField speedConstant;
    @FXML
    private HDoubleInputField torqueConstant;
    @FXML
    private HDoubleInputField windingInductance;
    @FXML
    private HDoubleInputField windingMaxCurrent;
    @FXML
    private HDoubleInputField windingMaxTemp;
    @FXML
    private HDoubleInputField motorTorqueTempConstant;
    @FXML
    private HDoubleInputField motorVelocityTempConstant;
    @FXML
    private HDoubleInputField motorRotorInertia;
    @FXML
    private HDoubleInputField windingResistance;
    @FXML
    private HDoubleInputField windingThermalResistance;
    @FXML
    private HDoubleInputField windingThermalTimeConstant;
    @FXML
    private Button suggestFocGainsButton;
    @FXML
    private Button calibrateMotorEncoderBtn;
    List<Runnable> addInputList = new ArrayList<Runnable>();
    List<Runnable> onClear = new ArrayList<Runnable>();
    ValidationSupport validation;
    @Inject
    aro properties;
    @Inject
    aty commandService;
    @Inject
    aum device;
    @Inject
    auh selector;
    @Inject
    avk fileChooser;
    @Inject
    ate notificationService;
    @Inject
    SaveMotorDriverXmlDialog saveMotorDriverXmlDialog;
    @Inject
    MotorEncoderCalibrationDialog motorEncoderCalibrationDialog;
    @Inject
    AdcCalibrationDialog adcCalibrationDialog;
    @Inject
    asy dialogService;

    @Override
    public void initializeFx() {
        this.validation = azl.a();
        MotorDriverCommand motorDriverCommand = new MotorDriverCommand();
        this.setupInputFields(motorDriverCommand);
        BooleanBinding booleanBinding = this.selector.selectionSingle().not();
        this.clearBtn.setOnAction(actionEvent -> this.onClear.forEach(Runnable::run));
        aox.b((Node)this.sendBtn, azl.b(this.validation));
        this.sendBtn.disableProperty().bind((ObservableValue)booleanBinding.or((ObservableBooleanValue)this.validation.invalidProperty()));
        this.sendBtn.setOnAction(actionEvent -> {
            motorDriverCommand.clear();
            this.addInputList.forEach(Runnable::run);
            if (this.persistToggle.isSelected()) {
                motorDriverCommand.setPersistAllFlag();
            }
            this.commandService.b(this.selector.getSelectedAddresses(), motorDriverCommand);
        });
        this.resetBtn.disableProperty().bind((ObservableValue)this.selector.selectionEmpty());
        this.resetBtn.setOnAction(actionEvent -> {
            motorDriverCommand.clear();
            this.commandService.a(this.selector.getSelectedAddresses(), motorDriverCommand.setResetFlag());
        });
        aox.a((Node)this.resetBtn, new ObservableBooleanValue[]{this.device.needsResetProperty()});
        this.persistToggle.selectedProperty().bindBidirectional((Property)this.properties.t);
        this.showAdvancedToggle.selectedProperty().bindBidirectional((Property)this.properties.u);
        this.saveFileBtn.disableProperty().bind((ObservableValue)booleanBinding);
        this.loadFileBtn.disableProperty().bind((ObservableValue)booleanBinding);
        this.saveFileBtn.setOnAction(this::saveToFile);
        this.loadFileBtn.setOnAction(this::loadFromFile);
    }

    void saveToFile(ActionEvent actionEvent) {
        this.saveMotorDriverXmlDialog.setContent(abk.fromInfo(this.device.getInfo()));
        this.dialogService.a(this.saveMotorDriverXmlDialog);
    }

    void loadFromFile(ActionEvent actionEvent) {
        Window window = azx.a(actionEvent);
        avk avk2 = this.fileChooser;
        avk2.a(avk2.c, "lastDriverConfigChoiceDirectory");
        avk avk3 = avk2;
        File file = avk3.b(avk3.c.showOpenDialog(window), "lastDriverConfigChoiceDirectory");
        if (file == null) {
            return;
        }
        try {
            SAXSource sAXSource = acj.getSourceWithIncludes(file);
            abk abk2 = (abk)new aak().readXml(sAXSource);
            this.setFieldsFromXml(abk2);
            return;
        }
        catch (Exception exception) {
            this.notificationService.f(exception);
            return;
        }
    }

    private void setFieldsFromXml(abk abk2) {
        aaq aaq2;
        abo abo2;
        abm abm2 = abk2.getMotor();
        if (abm2 != null) {
            this.polePairs.setTextNullable(abm2.getPolePairs());
            this.speedConstant.setTextNullable(abm2.getSpeedConstant());
            this.torqueConstant.setTextNullable(abm2.getTorqueConstant());
            this.maxMotorSpeed.setTextNullable(abm2.getMaxMotorSpeed());
            this.windingResistance.setTextNullable(abm2.getWindingResistance());
            this.windingInductance.setTextNullable(abm2.getWindingInductance());
            this.windingMaxCurrent.setTextNullable(abm2.getMaxWindingCurrent());
            this.windingMaxTemp.setTextNullable(abm2.getMaxWindingTemperature());
            this.motorTorqueTempConstant.setTextNullable(abm2.getTorqueTempConstant());
            this.motorVelocityTempConstant.setTextNullable(abm2.getVelocityTempConstant());
            this.motorRotorInertia.setTextNullable(abm2.getRotorInertia());
        }
        if ((abo2 = abk2.getThermalModel()) != null) {
            this.windingThermalResistance.setTextNullable(abo2.getWindingThermalResistance());
            this.windingThermalTimeConstant.setTextNullable(abo2.getWindingThermalTimeConst());
            this.housingThermalResistance.setTextNullable(abo2.getHousingThermalResistance());
            this.housingThermalTimeConstant.setTextNullable(abo2.getHousingThermalTimeConst());
            Optional.ofNullable(abo2.getTemperatureSource()).map(ahe::a).ifPresent(this.temperatureSource::setValue);
            this.temperatureSourceUserValue.setTextNullable(abo2.getUserValue());
            this.thermalModelStartPercentage.setTextNullable(abo2.getModelStartPercentage());
        }
        if ((aaq2 = abk2.getController()) != null) {
            Optional.ofNullable(aaq2.getIqGains()).ifPresent(abg2 -> {
                this.focIqKp.setTextNullable(abg2.getK());
                this.focIqKi.setTextNullable(abg2.getKi());
                this.focIqIClamp.setTextNullable(abg2.getIClamp());
            });
            Optional.ofNullable(aaq2.getIdGains()).ifPresent(abg2 -> {
                this.focIdKp.setTextNullable(abg2.getK());
                this.focIdKi.setTextNullable(abg2.getKi());
                this.focIdIClamp.setTextNullable(abg2.getIClamp());
            });
            this.slewRateCurrent.setTextNullable(aaq2.getSlewRateCurrent());
            this.slewRateVoltage.setTextNullable(aaq2.getSlewRateVoltage());
            this.motorElectricalPowerLimit.setTextNullable(aaq2.getMotorElectricalPowerLimit());
            this.motorMechanicalPowerLimit.setTextNullable(aaq2.getMotorMechanicalPowerLimit());
        }
        Optional.ofNullable(abk2.getEncoders()).ifPresent(aau2 -> {
            Optional.ofNullable(aau2.getMotorEncoderPort()).map(agz::a).ifPresent(this.motorEncoder::setValue);
            Optional.ofNullable(aau2.getOutputEncoderPort()).map(agz::a).ifPresent(this.outputEncoder::setValue);
            Optional.ofNullable(aau2.getDeflectionEncoderPort()).map(agz::a).ifPresent(this.deflectionEncoder::setValue);
            Optional.ofNullable(aau2.getTorqueSource()).map(ahf::a).ifPresent(this.torqueSource::setValue);
            Optional.ofNullable(aau2.getHallSwitches()).ifPresent(this.encoderHallsController::setFromXml);
            Optional.ofNullable(aau2.getEncoderA1()).ifPresent(this.encoderA1Controller::setFromXml);
            Optional.ofNullable(aau2.getEncoderA2()).ifPresent(this.encoderA2Controller::setFromXml);
            Optional.ofNullable(aau2.getEncoderB1()).ifPresent(this.encoderB1Controller::setFromXml);
            Optional.ofNullable(aau2.getEncoderB2()).ifPresent(this.encoderB2Controller::setFromXml);
        });
        Optional.ofNullable(abk2.getBoard()).ifPresent(aao2 -> {
            this.minDutyCycle.setTextNullable(aao2.getMinDutyCycle());
            this.maxDutyCycle.setTextNullable(aao2.getMaxDutyCycle());
            this.maxBoardCurrent.setTextNullable(aao2.getMaxBoardCurrent());
            this.switchingFreq.setTextNullable(aao2.getSwitchingFrequency());
            this.currentSenseThresholdVds.setTextNullable(aao2.getCurrentSenseThresholdVds());
            this.currentSenseThresholdWinding.setTextNullable(aao2.getCurrentSenseThresholdWinding());
            this.currentSenseGain.setTextNullable(aao2.getCurrentSenseGain());
            this.currentFilterSize.setTextNullable(aao2.getCurrentFilterSize());
            this.controlDivider.setTextNullable(aao2.getControlDivider());
            Optional.ofNullable(aao2.getWindingOrder()).map(ahg::a).ifPresent(this.windingOrder::setValue);
            Optional.ofNullable(aao2.getHallOrder()).map(ahc::a).ifPresent(this.hallOrder::setValue);
            Optional.ofNullable(aao2.getHallOffset()).map(ahb::a).ifPresent(this.hallOffset::setValue);
        });
        Optional.ofNullable(abk2.getBoardCalibration()).ifPresent(aam2 -> {
            this.calibOffsetIa.setTextNullable(aam2.getOffsetIa());
            this.calibOffsetIb.setTextNullable(aam2.getOffsetIb());
            this.calibOffsetIc.setTextNullable(aam2.getOffsetIc());
            this.calibOffsetIBus.setTextNullable(aam2.getOffsetIBus());
            this.calibOffsetVa.setTextNullable(aam2.getOffsetVa());
            this.calibOffsetVb.setTextNullable(aam2.getOffsetVb());
            this.calibOffsetVc.setTextNullable(aam2.getOffsetVc());
        });
        Optional.ofNullable(abk2.getGearTrain()).ifPresent(abi2 -> {
            this.gearRatioNumerator.setTextNullable(abk2.getGearTrain().getGearRatioNumerator());
            this.gearRatioDenominator.setTextNullable(abk2.getGearTrain().getGearRatioDenominator());
            this.gearEfficiency.setTextNullable(abk2.getGearTrain().getEfficiency());
            this.maxOutputTorque.setTextNullable(abi2.getMaxOutputTorque());
        });
    }

    private void setupInputFields(MotorDriverCommand motorDriverCommand) {
        Object object2 = this.device.getInfo();
        are are2 = ((aqy)object2).a;
        object2 = are2;
        arf arf2 = are2.a;
        object2 = are2;
        arj arj2 = ((are)object2).a;
        object2 = are2;
        aqu aqu2 = ((are)object2).a;
        object2 = are2;
        aqq aqq2 = ((are)object2).a;
        Object object3 = are2;
        aqm aqm2 = ((are)object3).a;
        object3 = are2;
        aqn aqn2 = ((are)object3).a;
        object3 = are2;
        aql aql2 = ((are)object3).a;
        MotorDriverController motorDriverController = this;
        object3 = aqu2;
        motorDriverController.bindIntField(motorDriverController.gearRatioNumerator, (ReadOnlyDoubleProperty)((aqu)object3).bl, n2 -> motorDriverCommand.gearTrain().a(n2));
        MotorDriverController motorDriverController2 = this;
        object3 = aqu2;
        motorDriverController2.bindIntField(motorDriverController2.gearRatioDenominator, (ReadOnlyDoubleProperty)((aqu)object3).bk, n2 -> motorDriverCommand.gearTrain().b(n2));
        MotorDriverController motorDriverController3 = this;
        object3 = aqu2;
        motorDriverController3.bindField(motorDriverController3.gearEfficiency, (ReadOnlyDoubleProperty)((aqu)object3).bj, f2 -> motorDriverCommand.gearTrain().a(f2));
        MotorDriverController motorDriverController4 = this;
        object3 = aqu2;
        motorDriverController4.bindField(motorDriverController4.maxOutputTorque, (ReadOnlyDoubleProperty)((aqu)object3).bm, f2 -> motorDriverCommand.gearTrain().b(f2));
        for (CustomTextField customTextField : List.of(this.gearRatioNumerator.getTextInput(), this.gearRatioDenominator.getTextInput())) {
            this.validation.registerValidator((Control)customTextField, (control, object) -> {
                boolean bl2 = (!this.gearRatioNumerator.getText().isBlank() || !this.gearRatioDenominator.getText().isBlank()) && !ParseUtils.isInteger(customTextField.getText());
                return ValidationResult.fromErrorIf((Control)customTextField, "Numerator and denominator must be set together.", bl2);
            });
            PropUtil.runOnChange(this.validation::revalidate, new ObservableValue[]{customTextField.textProperty()});
        }
        MotorDriverController motorDriverController5 = this;
        object2 = aqq2;
        motorDriverController5.bindEnumField(motorDriverController5.outputEncoder, (ReadOnlyObjectProperty)((aqq)object2).s, (Consumer)agz2 -> motorDriverCommand.encoders().b(agz2.a));
        MotorDriverController motorDriverController6 = this;
        object2 = aqq2;
        motorDriverController6.bindEnumField(motorDriverController6.deflectionEncoder, (ReadOnlyObjectProperty)((aqq)object2).q, (Consumer)agz2 -> motorDriverCommand.encoders().c(agz2.a));
        MotorDriverController motorDriverController7 = this;
        object2 = aqq2;
        motorDriverController7.bindEnumField(motorDriverController7.motorEncoder, (ReadOnlyObjectProperty)((aqq)object2).r, (Consumer)agz2 -> motorDriverCommand.encoders().a(agz2.a));
        MotorDriverController motorDriverController8 = this;
        object3 = aqq2;
        motorDriverController8.bindEnumField(motorDriverController8.torqueSource, (ReadOnlyObjectProperty)((aqq)object3).t, (Consumer)ahf2 -> motorDriverCommand.encoders().a(ahf2.a));
        this.encoderA1Controller.bindFields(this, agz.c, motorDriverCommand);
        this.encoderA2Controller.bindFields(this, agz.d, motorDriverCommand);
        this.encoderB1Controller.bindFields(this, agz.e, motorDriverCommand);
        this.encoderB2Controller.bindFields(this, agz.f, motorDriverCommand);
        this.encoderHallsController.bindFields(this, agz.g, motorDriverCommand);
        MotorDriverController motorDriverController9 = this;
        object3 = aqm2;
        motorDriverController9.bindField(motorDriverController9.minDutyCycle, (ReadOnlyDoubleProperty)((aqm)object3).X, f2 -> motorDriverCommand.board().a(f2));
        MotorDriverController motorDriverController10 = this;
        object3 = aqm2;
        motorDriverController10.bindField(motorDriverController10.maxDutyCycle, (ReadOnlyDoubleProperty)((aqm)object3).W, f2 -> motorDriverCommand.board().b(f2));
        MotorDriverController motorDriverController11 = this;
        object3 = aqm2;
        motorDriverController11.bindField(motorDriverController11.maxBoardCurrent, (ReadOnlyDoubleProperty)((aqm)object3).V, f2 -> motorDriverCommand.board().c(f2));
        MotorDriverController motorDriverController12 = this;
        object3 = aqm2;
        motorDriverController12.bindField(motorDriverController12.switchingFreq, (ReadOnlyDoubleProperty)((aqm)object3).Q, f2 -> motorDriverCommand.board().d(f2));
        MotorDriverController motorDriverController13 = this;
        object3 = aqm2;
        motorDriverController13.bindField(motorDriverController13.controlDivider, (ReadOnlyDoubleProperty)((aqm)object3).P, f2 -> motorDriverCommand.board().e((int)f2));
        MotorDriverController motorDriverController14 = this;
        object3 = aqm2;
        motorDriverController14.bindField(motorDriverController14.currentSenseThresholdVds, (ReadOnlyDoubleProperty)((aqm)object3).T, f2 -> motorDriverCommand.board().a((int)f2));
        MotorDriverController motorDriverController15 = this;
        object3 = aqm2;
        motorDriverController15.bindField(motorDriverController15.currentSenseThresholdWinding, (ReadOnlyDoubleProperty)((aqm)object3).U, f2 -> motorDriverCommand.board().b((int)f2));
        MotorDriverController motorDriverController16 = this;
        object3 = aqm2;
        motorDriverController16.bindField(motorDriverController16.currentFilterSize, (ReadOnlyDoubleProperty)((aqm)object3).R, f2 -> motorDriverCommand.board().d((int)f2));
        MotorDriverController motorDriverController17 = this;
        object3 = aqm2;
        motorDriverController17.bindField(motorDriverController17.currentSenseGain, (ReadOnlyDoubleProperty)((aqm)object3).S, f2 -> motorDriverCommand.board().c((int)f2));
        MotorDriverController motorDriverController18 = this;
        object3 = aqm2;
        motorDriverController18.bindEnumField(motorDriverController18.windingOrder, (ReadOnlyObjectProperty)((aqm)object3).k, (Consumer)ahg2 -> motorDriverCommand.board().a(ahg2.a));
        MotorDriverController motorDriverController19 = this;
        object3 = aqm2;
        motorDriverController19.bindEnumField(motorDriverController19.hallOrder, (ReadOnlyObjectProperty)((aqm)object3).j, (Consumer)ahc2 -> motorDriverCommand.board().a(ahc2.a));
        MotorDriverController motorDriverController20 = this;
        object3 = aqm2;
        motorDriverController20.bindEnumField(motorDriverController20.hallOffset, (ReadOnlyObjectProperty)((aqm)object3).i, (Consumer)ahb2 -> motorDriverCommand.board().a(ahb2.a));
        MotorDriverController motorDriverController21 = this;
        object3 = aql2;
        motorDriverController21.bindField(motorDriverController21.calibOffsetIa, (ReadOnlyDoubleProperty)((aql)object3).J, f2 -> motorDriverCommand.boardCalibration().a(f2));
        MotorDriverController motorDriverController22 = this;
        object3 = aql2;
        motorDriverController22.bindField(motorDriverController22.calibOffsetIb, (ReadOnlyDoubleProperty)((aql)object3).K, f2 -> motorDriverCommand.boardCalibration().b(f2));
        MotorDriverController motorDriverController23 = this;
        object3 = aql2;
        motorDriverController23.bindField(motorDriverController23.calibOffsetIc, (ReadOnlyDoubleProperty)((aql)object3).L, f2 -> motorDriverCommand.boardCalibration().c(f2));
        MotorDriverController motorDriverController24 = this;
        object3 = aql2;
        motorDriverController24.bindField(motorDriverController24.calibOffsetIBus, (ReadOnlyDoubleProperty)((aql)object3).I, f2 -> motorDriverCommand.boardCalibration().d(f2));
        MotorDriverController motorDriverController25 = this;
        object3 = aql2;
        motorDriverController25.bindField(motorDriverController25.calibOffsetVa, (ReadOnlyDoubleProperty)((aql)object3).M, f2 -> motorDriverCommand.boardCalibration().e(f2));
        MotorDriverController motorDriverController26 = this;
        object3 = aql2;
        motorDriverController26.bindField(motorDriverController26.calibOffsetVb, (ReadOnlyDoubleProperty)((aql)object3).N, f2 -> motorDriverCommand.boardCalibration().f(f2));
        MotorDriverController motorDriverController27 = this;
        object3 = aql2;
        motorDriverController27.bindField(motorDriverController27.calibOffsetVc, (ReadOnlyDoubleProperty)((aql)object3).O, f2 -> motorDriverCommand.boardCalibration().g(f2));
        MotorDriverController motorDriverController28 = this;
        object3 = arj2;
        motorDriverController28.bindField(motorDriverController28.windingThermalResistance, (ReadOnlyDoubleProperty)((arj)object3).cB, f2 -> motorDriverCommand.thermalModel().a(f2));
        MotorDriverController motorDriverController29 = this;
        object3 = arj2;
        motorDriverController29.bindField(motorDriverController29.windingThermalTimeConstant, (ReadOnlyDoubleProperty)((arj)object3).cC, f2 -> motorDriverCommand.thermalModel().c(f2));
        MotorDriverController motorDriverController30 = this;
        object3 = arj2;
        motorDriverController30.bindField(motorDriverController30.housingThermalResistance, (ReadOnlyDoubleProperty)((arj)object3).cy, f2 -> motorDriverCommand.thermalModel().b(f2));
        MotorDriverController motorDriverController31 = this;
        object3 = arj2;
        motorDriverController31.bindField(motorDriverController31.housingThermalTimeConstant, (ReadOnlyDoubleProperty)((arj)object3).cz, f2 -> motorDriverCommand.thermalModel().d(f2));
        MotorDriverController motorDriverController32 = this;
        object3 = arj2;
        motorDriverController32.bindField(motorDriverController32.thermalModelStartPercentage, (ReadOnlyDoubleProperty)((arj)object3).cA, f2 -> motorDriverCommand.thermalModel().f(f2));
        MotorDriverController motorDriverController33 = this;
        object3 = arj2;
        motorDriverController33.bindField(motorDriverController33.temperatureSourceUserValue, (ReadOnlyDoubleProperty)((arj)object3).cx, f2 -> motorDriverCommand.thermalModel().e(f2));
        MotorDriverController motorDriverController34 = this;
        object3 = arj2;
        motorDriverController34.bindEnumField(motorDriverController34.temperatureSource, (ReadOnlyObjectProperty)((arj)object3).H, (Consumer)ahe2 -> motorDriverCommand.thermalModel().a(ahe2.a));
        MotorDriverController motorDriverController35 = this;
        object3 = aqn2;
        motorDriverController35.bindField(motorDriverController35.slewRateVoltage, (ReadOnlyDoubleProperty)((aqn)object3).ac, f2 -> motorDriverCommand.controller().b(f2));
        MotorDriverController motorDriverController36 = this;
        object3 = aqn2;
        motorDriverController36.bindField(motorDriverController36.slewRateCurrent, (ReadOnlyDoubleProperty)((aqn)object3).ab, f2 -> motorDriverCommand.controller().c(f2));
        MotorDriverController motorDriverController37 = this;
        object3 = aqn2;
        motorDriverController37.bindField(motorDriverController37.motorElectricalPowerLimit, (ReadOnlyDoubleProperty)((aqn)object3).Y, f2 -> motorDriverCommand.controller().d(f2));
        MotorDriverController motorDriverController38 = this;
        object3 = aqn2;
        motorDriverController38.bindField(motorDriverController38.motorMechanicalPowerLimit, (ReadOnlyDoubleProperty)((aqn)object3).Z, f2 -> motorDriverCommand.controller().e(f2));
        MotorDriverController motorDriverController39 = this;
        object2 = arf2;
        motorDriverController39.bindField(motorDriverController39.polePairs, (ReadOnlyDoubleProperty)((arf)object2).cj, f2 -> motorDriverCommand.motor().a((int)f2));
        MotorDriverController motorDriverController40 = this;
        object3 = arf2;
        motorDriverController40.bindField(motorDriverController40.speedConstant, (ReadOnlyDoubleProperty)((arf)object3).cl, f2 -> motorDriverCommand.motor().f(f2));
        MotorDriverController motorDriverController41 = this;
        object3 = arf2;
        motorDriverController41.bindField(motorDriverController41.torqueConstant, (ReadOnlyDoubleProperty)((arf)object3).cm, f2 -> motorDriverCommand.motor().g(f2));
        MotorDriverController motorDriverController42 = this;
        object3 = arf2;
        motorDriverController42.bindField(motorDriverController42.maxMotorSpeed, (ReadOnlyDoubleProperty)((arf)object3).cg, f2 -> motorDriverCommand.motor().c(f2));
        MotorDriverController motorDriverController43 = this;
        object3 = arf2;
        motorDriverController43.bindField(motorDriverController43.windingResistance, (ReadOnlyDoubleProperty)((arf)object3).cq, f2 -> motorDriverCommand.motor().e(f2));
        MotorDriverController motorDriverController44 = this;
        object3 = arf2;
        motorDriverController44.bindField(motorDriverController44.windingInductance, (ReadOnlyDoubleProperty)((arf)object3).cp, f2 -> motorDriverCommand.motor().d((float)((double)f2 * 0.001)));
        MotorDriverController motorDriverController45 = this;
        object2 = arf2;
        motorDriverController45.bindField(motorDriverController45.windingMaxCurrent, (ReadOnlyDoubleProperty)((arf)object2).ch, f2 -> motorDriverCommand.motor().a(f2));
        MotorDriverController motorDriverController46 = this;
        object3 = arf2;
        motorDriverController46.bindField(motorDriverController46.windingMaxTemp, (ReadOnlyDoubleProperty)((arf)object3).ci, f2 -> motorDriverCommand.motor().b(f2));
        MotorDriverController motorDriverController47 = this;
        object3 = arf2;
        motorDriverController47.bindField(motorDriverController47.motorVelocityTempConstant, (ReadOnlyDoubleProperty)((arf)object3).co, f2 -> motorDriverCommand.motor().i(f2));
        MotorDriverController motorDriverController48 = this;
        object3 = arf2;
        motorDriverController48.bindField(motorDriverController48.motorTorqueTempConstant, (ReadOnlyDoubleProperty)((arf)object3).cn, f2 -> motorDriverCommand.motor().h(f2));
        MotorDriverController motorDriverController49 = this;
        object3 = arf2;
        motorDriverController49.bindField(motorDriverController49.motorRotorInertia, (ReadOnlyDoubleProperty)((arf)object3).ck, f2 -> motorDriverCommand.motor().j(f2));
        MotorDriverController motorDriverController50 = this;
        object2 = aqn2;
        object2 = ((aqn)object2).b;
        motorDriverController50.bindField(motorDriverController50.focIqKp, (ReadOnlyDoubleProperty)((aqs)object2).as, f2 -> motorDriverCommand.controller().b().a(f2));
        MotorDriverController motorDriverController51 = this;
        object2 = aqn2;
        object2 = ((aqn)object2).b;
        motorDriverController51.bindField(motorDriverController51.focIqKi, (ReadOnlyDoubleProperty)((aqs)object2).ar, f2 -> motorDriverCommand.controller().b().b(f2));
        MotorDriverController motorDriverController52 = this;
        object2 = aqn2;
        object2 = ((aqn)object2).b;
        motorDriverController52.bindField(motorDriverController52.focIqIClamp, (ReadOnlyDoubleProperty)((aqs)object2).aq, f2 -> motorDriverCommand.controller().b().f(f2));
        MotorDriverController motorDriverController53 = this;
        object2 = aqn2;
        object2 = ((aqn)object2).a;
        motorDriverController53.bindField(motorDriverController53.focIdKp, (ReadOnlyDoubleProperty)((aqs)object2).as, f2 -> motorDriverCommand.controller().a().a(f2));
        MotorDriverController motorDriverController54 = this;
        object2 = aqn2;
        object2 = ((aqn)object2).a;
        motorDriverController54.bindField(motorDriverController54.focIdKi, (ReadOnlyDoubleProperty)((aqs)object2).ar, f2 -> motorDriverCommand.controller().a().b(f2));
        MotorDriverController motorDriverController55 = this;
        object2 = aqn2;
        object2 = ((aqn)object2).a;
        motorDriverController55.bindField(motorDriverController55.focIdIClamp, (ReadOnlyDoubleProperty)((aqs)object2).aq, f2 -> motorDriverCommand.controller().a().f(f2));
        this.suggestFocGainsButton.disableProperty().bind((ObservableValue)this.focIdKp.getTextInput().disableProperty());
        this.suggestFocGainsButton.setOnAction(actionEvent -> {
            aqm aqm3 = aqm2;
            Object object = aqm3;
            object = aqm2;
            double d2 = aqm3.Q.get() / Math.max(((aqm)object).P.get(), 1.0);
            long l2 = Math.round(d2 * 0.05);
            TextInputDialog textInputDialog = new TextInputDialog(String.valueOf(l2));
            textInputDialog.setHeaderText("The controller bandwidth defaults to 5% of the sampling frequency (" + uk.b(d2 / 1000.0) + " KHz).");
            textInputDialog.setContentText("Controller bandwidth [Hz]");
            Optional optional = textInputDialog.showAndWait();
            if (optional.isPresent()) {
                double d3 = TextUtil.parseDouble((String)optional.get());
                if (!Double.isFinite(d3)) {
                    atd.a((String)optional.get() + " is not a valid value.", azx.a(actionEvent));
                    return;
                }
                arf arf3 = arf2;
                object = arf3;
                object = arf2;
                double d4 = d2;
                double d5 = (float)(((arf)object).cp.get() * 0.001);
                double d6 = arf3.cq.get();
                double d7 = 1.0 / d4;
                double d8 = d3 * (Math.PI * 2) * d7;
                double d9 = d6 * (d8 / (1.0 - Math.exp(-d6 * d7 / d5)));
                double d10 = 1.0 - Math.exp(-d6 * d7 / d5);
                ava ava2 = new ava(d9, d10);
                object = arf2;
                double d11 = ((arf)object).ch.get() * 0.1;
                this.focIqKp.setTextNullable(ava2.ds);
                this.focIqKi.setTextNullable(ava2.dt);
                this.focIqIClamp.setTextNullable(d11);
                if (this.showAdvancedToggle.isSelected()) {
                    this.focIdKp.setTextNullable(ava2.ds);
                    this.focIdKi.setTextNullable(ava2.dt);
                    this.focIdIClamp.setTextNullable(d11);
                }
            }
        });
        this.calibrateMotorEncoderBtn.disableProperty().bind((ObservableValue)this.motorEncoder.disabledProperty());
        this.calibrateMotorEncoderBtn.setOnAction(actionEvent -> this.dialogService.a(this.motorEncoderCalibrationDialog).setOnResult(avh2 -> {}));
        this.calibrateAdcBtn.disableProperty().bind((ObservableValue)this.calibOffsetIa.getTextInput().disabledProperty());
        this.calibrateAdcBtn.setOnAction(actionEvent -> this.dialogService.a(this.adcCalibrationDialog).setOnResult(aut2 -> {
            this.calibOffsetIa.setTextNullable(Float.valueOf(aut2.K));
            this.calibOffsetIb.setTextNullable(Float.valueOf(aut2.L));
            this.calibOffsetIc.setTextNullable(Float.valueOf(aut2.M));
            this.calibOffsetIBus.setTextNullable(Float.valueOf(aut2.N));
        }));
        azx.b(() -> {
            if (!this.showAdvancedToggle.isSelected()) {
                this.focIdKp.setText(this.focIqKp.getText());
                this.focIdKi.setText(this.focIqKi.getText());
                this.focIdIClamp.setText(this.focIqIClamp.getText());
            }
        }, new Observable[]{this.showAdvancedToggle.selectedProperty(), this.focIqKp.textProperty(), this.focIqKi.textProperty(), this.focIqIClamp.textProperty()});
        this.controlMode.getChoiceBox().setDisable(true);
        MotorDriverController motorDriverController56 = this;
        object3 = aqn2;
        motorDriverController56.bindEnumField(motorDriverController56.controlMode, (ReadOnlyObjectProperty)((aqn)object3).l, (Consumer)ahd2 -> {});
    }

    <E extends Enum<E>> void bindEnumField(HEnumInputField<E> hEnumInputField, ReadOnlyObjectProperty<E> readOnlyObjectProperty, Consumer<E> consumer) {
        Enum enum_ = MotorDriverController.getDefaultEnumValue((Enum)readOnlyObjectProperty.get());
        hEnumInputField.initValues(readOnlyObjectProperty, enum_);
        this.validation.registerValidator((Control)hEnumInputField.getChoiceBox(), false, azl.a(hEnumInputField));
        this.onClear.add(hEnumInputField::clear);
        this.addInputList.add(() -> {
            Object e2 = hEnumInputField.getValue();
            if (e2 != null && e2 != enum_) {
                consumer.accept(e2);
            }
        });
    }

    private static <E extends Enum<E>> E getDefaultEnumValue(E e2) {
        if (e2 instanceof aha) {
            return (E)((Object)aha.a);
        }
        if (e2 instanceof agz) {
            return (E)((Object)agz.a);
        }
        if (e2 instanceof ahf) {
            return (E)((Object)ahf.a);
        }
        if (e2 instanceof ahe) {
            return (E)((Object)ahe.a);
        }
        if (e2 instanceof ahg) {
            return (E)((Object)ahg.a);
        }
        if (e2 instanceof ahc) {
            return (E)((Object)ahc.a);
        }
        if (e2 instanceof ahb) {
            return (E)((Object)ahb.a);
        }
        if (e2 instanceof agx) {
            return (E)((Object)agx.a);
        }
        if (e2 instanceof agy) {
            return (E)((Object)agy.a);
        }
        if (e2 instanceof agw) {
            return (E)((Object)agw.a);
        }
        if (e2 instanceof ahd) {
            return (E)((Object)ahd.a);
        }
        throw new IllegalArgumentException("Unknown default type for: " + String.valueOf(e2));
    }

    void bindField(HDoubleInputField hDoubleInputField, ReadOnlyDoubleProperty readOnlyDoubleProperty, anm anm2) {
        hDoubleInputField.feedbackValueProperty().bind((ObservableValue)readOnlyDoubleProperty);
        CustomTextField customTextField = hDoubleInputField.getTextInput();
        Validator<String> validator = azl.a(customTextField, ParseUtils.FINITE_DOUBLE_VALIDATOR, readOnlyDoubleProperty, 0.001);
        this.validation.registerValidator((Control)customTextField, false, validator);
        this.addInputList.add(() -> {
            Double d2;
            if (!customTextField.getText().isBlank() && (d2 = ParseUtils.tryParseFiniteDouble(customTextField)) != null) {
                anm2.accept(d2.floatValue());
            }
        });
        this.onClear.add(() -> ((CustomTextField)customTextField).clear());
    }

    void bindIntField(HDoubleInputField hDoubleInputField, ReadOnlyDoubleProperty readOnlyDoubleProperty, IntConsumer intConsumer) {
        hDoubleInputField.feedbackValueProperty().bind((ObservableValue)readOnlyDoubleProperty);
        CustomTextField customTextField = hDoubleInputField.getTextInput();
        Validator<String> validator = azl.a(customTextField, ParseUtils.INTEGER_VALIDATOR, readOnlyDoubleProperty, 0.001);
        this.validation.registerValidator((Control)customTextField, false, validator);
        this.addInputList.add(() -> {
            Integer n2;
            if (!customTextField.getText().isBlank() && (n2 = ParseUtils.tryParseInteger(customTextField.getText())) != null) {
                intConsumer.accept(n2);
            }
        });
        this.onClear.add(() -> ((CustomTextField)customTextField).clear());
    }

    @Generated
    public ToggleButton getPersistToggle() {
        return this.persistToggle;
    }
}

