/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import com.jfoenix.controls.JFXSlider;
import com.jfoenix.controls.JFXToggleButton;
import java.net.URL;
import java.util.List;
import java.util.ResourceBundle;
import java.util.function.DoubleConsumer;
import java.util.function.Supplier;
import javafx.beans.InvalidationListener;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ChangeListener;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.fxml.Initializable;
import javafx.scene.control.Button;
import javafx.scene.control.CheckBox;
import javafx.scene.control.Slider;
import javafx.scene.control.ToggleButton;
import javafx.scene.layout.HBox;
import javafx.scene.layout.Pane;
import javafx.scene.layout.VBox;
import javafx.scene.text.Text;
import javax.inject.Inject;
import us.hebi.gui.controls.SliderUtil;
import us.hebi.gui.lib.agk;
import us.hebi.gui.lib.aib;
import us.hebi.gui.lib.aqy;
import us.hebi.gui.lib.aqz;
import us.hebi.gui.lib.ara;
import us.hebi.gui.lib.arl;
import us.hebi.gui.lib.aty;
import us.hebi.gui.lib.auh;
import us.hebi.gui.lib.aum;
import us.hebi.gui.lib.awd;
import us.hebi.gui.lib.axl;
import us.hebi.gui.lib.axm;
import us.hebi.gui.views.scope.components.ParseUtils;
import us.hebi.gui.views.scope.components.PinUtils;

public class MonitoringIoController
implements Initializable {
    @FXML
    private VBox bankA;
    @FXML
    private VBox bankB;
    @FXML
    private VBox bankE;
    @FXML
    private VBox bankF;
    @Inject
    aum module;
    @Inject
    aty commandService;
    private final aib cmd = new aib();
    boolean commandsEnabled = true;
    @Inject
    awd plottingService;
    @Inject
    auh selectorService;

    private void sendCommands() {
        if (!this.commandsEnabled) {
            return;
        }
        this.cmd.clear();
        agk agk2 = this.cmd.getIoBoard().a();
        this.addDigitalOut(1, agk2::d);
        this.addDigitalOut(2, agk2::e);
        this.addDigitalOut(3, agk2::f);
        this.addDigitalOut(4, agk2::g);
        this.addDigitalOut(5, agk2::h);
        this.addDigitalOut(6, agk2::i);
        this.addDigitalOut(7, agk2::j);
        this.addDigitalOut(8, agk2::k);
        agk agk3 = this.cmd.getIoBoard().b();
        this.addPwmOut(1, agk3::d);
        this.addPwmOut(2, agk3::e);
        this.addPwmOut(3, agk3::f);
        this.addPwmOut(4, agk3::g);
        this.addPwmOut(5, agk3::h);
        this.addPwmOut(6, agk3::i);
        this.addPwmOut(7, agk3::j);
        this.addPwmOut(8, agk3::k);
        this.selectorService.getSelectedModules().forEach(arl2 -> this.commandService.a(arl2.a(), this.cmd));
    }

    private void addDigitalOut(int n2, DoubleConsumer doubleConsumer) {
        HBox hBox = MonitoringIoController.getPin(this.bankE, n2);
        ToggleButton toggleButton = (ToggleButton)hBox.getChildren().get(2);
        if (hBox.isDisable() || toggleButton.isDisable() || !toggleButton.isVisible()) {
            return;
        }
        doubleConsumer.accept(toggleButton.isSelected() ? 1.0 : 0.0);
    }

    private void addPwmOut(int n2, DoubleConsumer doubleConsumer) {
        HBox hBox = MonitoringIoController.getPin(this.bankF, n2);
        Slider slider = (Slider)hBox.getChildren().get(2);
        if (hBox.isDisable() || slider.isDisable() || !slider.isVisible()) {
            return;
        }
        doubleConsumer.accept(slider.getValue());
    }

    public void initialize(URL uRL, ResourceBundle resourceBundle) {
        this.commandsEnabled = false;
        Object object = this.module.getInfo();
        ara ara2 = ((aqy)object).a;
        MonitoringIoController monitoringIoController = this;
        object = ara2;
        monitoringIoController.initializeBank(monitoringIoController.bankA, ((ara)object).a);
        MonitoringIoController monitoringIoController2 = this;
        ara ara3 = ara2;
        monitoringIoController2.initializeBank(monitoringIoController2.bankB, ara3.b);
        MonitoringIoController monitoringIoController3 = this;
        ara3 = ara2;
        monitoringIoController3.initializeBank(monitoringIoController3.bankE, ara3.e);
        MonitoringIoController monitoringIoController4 = this;
        ara3 = ara2;
        monitoringIoController4.initializeBank(monitoringIoController4.bankF, ara3.f);
        this.commandsEnabled = true;
    }

    private void initializeBank(VBox vBox, aqz aqz2) {
        InvalidationListener invalidationListener = observable -> this.sendCommands();
        for (int i2 = 1; i2 <= 8; ++i2) {
            ChangeListener changeListener;
            Object object;
            CheckBox checkBox;
            ReadOnlyDoubleProperty readOnlyDoubleProperty = PinUtils.getPinProperty(i2, aqz2);
            HBox hBox = MonitoringIoController.getPin(vBox, i2);
            hBox.disableProperty().bind((ObservableValue)ParseUtils.isNaN((ObservableDoubleValue)readOnlyDoubleProperty));
            Text text = MonitoringIoController.getText((Pane)hBox);
            text.textProperty().bind((ObservableValue)ParseUtils.asFormattedString(readOnlyDoubleProperty));
            text.visibleProperty().bind((ObservableValue)hBox.disabledProperty().not());
            Button button = MonitoringIoController.getButton((Pane)hBox);
            Supplier<axm> supplier = axl.a(button.getText());
            button.setOnAction(this.plottingService.a((List<arl>)this.selectorService.getSelectedModules(), button.getText(), supplier));
            if (vBox == this.bankE) {
                checkBox = (CheckBox)hBox.getChildren().get(1);
                object = (JFXToggleButton)((Object)hBox.getChildren().get(2));
                changeListener = (arg_0, arg_1, arg_2) -> this.lambda$initializeBank$2((JFXToggleButton)((Object)object), invalidationListener, readOnlyDoubleProperty, arg_0, arg_1, arg_2);
                checkBox.selectedProperty().addListener(changeListener);
                changeListener.changed(null, null, (Object)checkBox.isSelected());
            }
            if (vBox != this.bankF) continue;
            checkBox = (CheckBox)hBox.getChildren().get(1);
            object = (JFXSlider)((Object)hBox.getChildren().get(2));
            changeListener = (Button)hBox.getChildren().get(3);
            ChangeListener changeListener2 = (arg_0, arg_1, arg_2) -> this.lambda$initializeBank$3((JFXSlider)((Object)object), invalidationListener, readOnlyDoubleProperty, arg_0, arg_1, arg_2);
            checkBox.selectedProperty().addListener(changeListener2);
            changeListener2.changed(null, null, (Object)checkBox.isSelected());
            SliderUtil.setValueLabelFactory((JFXSlider)((Object)object), d2 -> d2);
            SliderUtil.setupTargetButton((Slider)object, checkBox.selectedProperty(), (Button)changeListener, d2 -> d2, d2 -> d2);
        }
    }

    private static HBox getPin(VBox vBox, int n2) {
        return (HBox)vBox.getChildren().get(n2);
    }

    private static Button getButton(Pane pane) {
        if (pane.getChildren().get(0) instanceof HBox) {
            pane = (Pane)pane.getChildren().get(0);
        }
        return (Button)pane.getChildren().get(0);
    }

    private static Text getText(Pane pane) {
        if (pane.getChildren().get(0) instanceof HBox) {
            pane = (Pane)pane.getChildren().get(0);
        }
        return (Text)pane.getChildren().get(1);
    }

    private /* synthetic */ void lambda$initializeBank$3(JFXSlider jFXSlider, InvalidationListener invalidationListener, ReadOnlyDoubleProperty readOnlyDoubleProperty, ObservableValue observableValue, Boolean bl2, Boolean bl3) {
        if (bl3.booleanValue()) {
            jFXSlider.setDisable(false);
            jFXSlider.valueProperty().unbind();
            jFXSlider.valueProperty().addListener(invalidationListener);
        } else {
            jFXSlider.setDisable(true);
            jFXSlider.valueProperty().bind((ObservableValue)readOnlyDoubleProperty);
            jFXSlider.valueProperty().removeListener(invalidationListener);
        }
        this.sendCommands();
    }

    private /* synthetic */ void lambda$initializeBank$2(JFXToggleButton jFXToggleButton, InvalidationListener invalidationListener, ReadOnlyDoubleProperty readOnlyDoubleProperty, ObservableValue observableValue, Boolean bl2, Boolean bl3) {
        if (bl3.booleanValue()) {
            jFXToggleButton.setDisable(false);
            jFXToggleButton.selectedProperty().unbind();
            jFXToggleButton.selectedProperty().addListener(invalidationListener);
        } else {
            jFXToggleButton.setDisable(true);
            jFXToggleButton.selectedProperty().bind((ObservableValue)readOnlyDoubleProperty.isEqualTo(1));
            jFXToggleButton.selectedProperty().removeListener(invalidationListener);
        }
        this.sendCommands();
    }
}

