/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import atlantafx.base.controls.CustomTextField;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import java.util.concurrent.CompletableFuture;
import java.util.function.DoubleConsumer;
import java.util.function.Function;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.property.ReadOnlyObjectProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.ChoiceDialog;
import javafx.scene.control.Control;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.ToggleButton;
import javafx.scene.text.Text;
import javafx.stage.Window;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import javax.xml.transform.TransformerException;
import okhttp3.Headers;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import us.hebi.gui.controls.HDoubleInputField;
import us.hebi.gui.controls.HEnumInputField;
import us.hebi.gui.lib.aem;
import us.hebi.gui.lib.afj;
import us.hebi.gui.lib.afl;
import us.hebi.gui.lib.afu;
import us.hebi.gui.lib.afv;
import us.hebi.gui.lib.afy;
import us.hebi.gui.lib.agt;
import us.hebi.gui.lib.ahr;
import us.hebi.gui.lib.aib;
import us.hebi.gui.lib.aox;
import us.hebi.gui.lib.aqj;
import us.hebi.gui.lib.aqt;
import us.hebi.gui.lib.ari;
import us.hebi.gui.lib.arl;
import us.hebi.gui.lib.aro;
import us.hebi.gui.lib.atd;
import us.hebi.gui.lib.aty;
import us.hebi.gui.lib.auh;
import us.hebi.gui.lib.aum;
import us.hebi.gui.lib.avk;
import us.hebi.gui.lib.azl;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.baf;
import us.hebi.gui.lib.bap;
import us.hebi.gui.lib.bcm;
import us.hebi.gui.lib.bco;
import us.hebi.gui.lib.v;
import us.hebi.gui.lib.za;
import us.hebi.gui.lib.zc;
import us.hebi.gui.lib.zd;
import us.hebi.gui.views.scope.components.ParseUtils;
import us.hebi.gui.views.scope.components.PidController;

public class GainsController {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private Button loadFileBtn;
    @FXML
    private Button loadDefaultsBtn;
    @FXML
    private Button saveFileBtn;
    @FXML
    private Button sendBtn;
    @FXML
    private Button sendDirectBtn;
    @FXML
    private Button clearBtn;
    @FXML
    private HEnumInputField<afl> controlStrategy;
    @FXML
    private HEnumInputField<agt> mStopStrategy;
    @FXML
    private HEnumInputField<ahr> posLimitStrategy;
    @FXML
    private Hyperlink docsLink;
    @FXML
    private Text docsText;
    @FXML
    private ToggleButton advancedToggle;
    @FXML
    private ToggleButton persistToggle;
    @FXML
    private HDoubleInputField minPosLimit;
    @FXML
    private HDoubleInputField maxPosLimit;
    @FXML
    private HDoubleInputField minVelLimit;
    @FXML
    private HDoubleInputField maxVelLimit;
    @FXML
    private HDoubleInputField minEffortLimit;
    @FXML
    private HDoubleInputField maxEffortLimit;
    @FXML
    private Parent positionPid;
    @FXML
    private PidController positionPidController;
    @FXML
    private Parent velocityPid;
    @FXML
    private PidController velocityPidController;
    @FXML
    private Parent effortPid;
    @FXML
    private PidController effortPidController;
    final ValidationSupport basicValidation = azl.a();
    final ValidationSupport advancedValidation = azl.a();
    @Inject
    aro properties;
    @Inject
    aum module;
    @Inject
    avk fileChooser;
    @Inject
    auh moduleSelector;
    @Inject
    aty commandService;
    aib reusableCommand;
    @Inject
    bap webViewer;
    private BooleanProperty advancedView;
    private final List<Runnable> clearers = new ArrayList<Runnable>();

    @FXML
    public void openGainsDocumentationInBrowser(ActionEvent actionEvent) {
        this.webViewer.showDocument("https://docs.hebi.us/core_concepts.html#motor_control");
    }

    @FXML
    private void sendGains(ActionEvent actionEvent) {
        ahr ahr2;
        agt agt2;
        aib aib2 = this.reusableCommand;
        aib2.clear();
        afu afu2 = aib2.getGains();
        if (this.persistToggle.isSelected()) {
            aib2.setPersistAllFlag();
        }
        afj afj2 = aib2.getSafetyLimits();
        GainsController.addSafetyLimit(this.minPosLimit, afj2::a);
        GainsController.addSafetyLimit(this.maxPosLimit, afj2::b);
        GainsController.addSafetyLimit(this.minVelLimit, afj2::c);
        GainsController.addSafetyLimit(this.maxVelLimit, afj2::d);
        GainsController.addSafetyLimit(this.minEffortLimit, afj2::e);
        GainsController.addSafetyLimit(this.maxEffortLimit, afj2::f);
        afl afl2 = this.controlStrategy.getValue();
        if (afl2 != null) {
            afu2.a(afl2);
        }
        if ((agt2 = this.mStopStrategy.getValue()) != null) {
            afu2.a(agt2);
        }
        if ((ahr2 = this.posLimitStrategy.getValue()) != null) {
            afj2.a(ahr2);
            afj2.b(ahr2);
        }
        this.positionPidController.addGainsToMessage(afu2);
        this.velocityPidController.addGainsToMessage(afu2);
        this.effortPidController.addGainsToMessage(afu2);
        this.moduleSelector.getSelectedAddresses().forEach(aem2 -> this.commandService.a((aem)aem2, aib2));
    }

    private static void addSafetyLimit(HDoubleInputField hDoubleInputField, DoubleConsumer doubleConsumer) {
        if (!hDoubleInputField.getTextInput().isDisable() && hDoubleInputField.isInputValid()) {
            doubleConsumer.accept(hDoubleInputField.getInputValue());
        }
    }

    @FXML
    void clearAllFields(ActionEvent actionEvent) {
        this.positionPidController.clearAllTextFields();
        this.velocityPidController.clearAllTextFields();
        this.effortPidController.clearAllTextFields();
        this.controlStrategy.clear();
        this.mStopStrategy.clear();
        this.posLimitStrategy.clear();
        Iterator<Runnable> iterator = this.clearers.iterator();
        while (iterator.hasNext()) {
            iterator.next().run();
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    <T> Optional<T[]> readGainsFile(Function<zc, T[]> function) {
        Window window = this.getActiveWindow();
        avk avk2 = this.fileChooser;
        avk2.a(avk2.c, "lastGainsChoiceDirectory");
        avk avk3 = avk2;
        File file = avk3.b(avk3.c.showOpenDialog(window), "lastGainsChoiceDirectory");
        if (file == null) {
            return Optional.empty();
        }
        T[] TArray = null;
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            zc zc2 = zc.a(fileInputStream);
            TArray = function.apply(zc2);
            if (TArray.length != 0) return Optional.ofNullable(TArray);
            atd.a("Selected file did not contain gains", this.getActiveWindow());
            Optional<T[]> optional = Optional.empty();
            return optional;
        }
        catch (Exception exception) {
            atd.a(exception, this.getActiveWindow());
        }
        return Optional.ofNullable(TArray);
    }

    @FXML
    void loadDefaultGains(ActionEvent actionEvent) {
        if (this.module.isEmpty()) {
            return;
        }
        bcm bcm2 = bcm.a();
        afl afl2 = Optional.ofNullable(this.controlStrategy.getValue()).orElse(this.module.getGains().a());
        Headers headers = baf.a(this.module.getInfo());
        CompletableFuture.supplyAsync(() -> {
            try {
                Headers headers2 = headers;
                String string = this.toStrategyUrlName(afl2);
                String string2 = this.module.getModule().c().toString();
                String string3 = bco.a(bcm.b("gains", string, string2), headers2);
                return zc.a(new ByteArrayInputStream(string3.getBytes(v.a))).a();
            }
            catch (IOException iOException) {
                throw new RuntimeException(iOException);
            }
        }).whenCompleteAsync((afvArray, throwable) -> {
            if (throwable != null) {
                atd.a("Could not load default gains because the \nserver could not be reached, or because there are \nno default gains for the selected module and \nstrategy '" + String.valueOf((Object)afl2) + "'.", this.getActiveWindow());
                return;
            }
            if (((afv[])afvArray).length != 1) {
                atd.a("Could not load gains due to invalid source format.", this.getActiveWindow());
                return;
            }
            this.setGainFields(afvArray[0]);
        }, azx.d);
    }

    private String toStrategyUrlName(afl afl2) {
        switch (afl2) {
            case d: {
                return "strategy2";
            }
            case e: {
                return "strategy3";
            }
            case f: {
                return "strategy4";
            }
            case g: {
                return "strategy5";
            }
        }
        return afl2.toString();
    }

    @FXML
    void loadFromFileAndSend(ActionEvent actionEvent) {
        ObservableList<arl> observableList;
        int n2;
        if (!this.tryShowGroupGainsNotice()) {
            return;
        }
        Optional<T[]> optional = this.readGainsFile(zc::a);
        if (!optional.isPresent()) {
            return;
        }
        aib[] aibArray = (aib[])optional.get();
        if (aibArray.length != (n2 = (observableList = this.moduleSelector.getSelectedModules()).size())) {
            atd.a(String.format("Selected file contains %d modules, but %d modules are selected", aibArray.length, n2), this.getActiveWindow());
            return;
        }
        for (int i2 = 0; i2 < n2; ++i2) {
            arl arl2 = (arl)observableList.get(i2);
            this.commandService.a(arl2.a(), aibArray[i2]);
        }
    }

    @FXML
    void loadFromFile(ActionEvent actionEvent) {
        afv afv2;
        Optional<T[]> optional = this.readGainsFile(zc::a);
        if (!optional.isPresent()) {
            return;
        }
        afv[] afvArray = (afv[])optional.get();
        if (afvArray.length > 1) {
            ArrayList<Integer> arrayList = new ArrayList<Integer>();
            for (int i2 = 0; i2 < afvArray.length; ++i2) {
                arrayList.add(i2 + 1);
            }
            ChoiceDialog choiceDialog = new ChoiceDialog((Object)1, arrayList);
            choiceDialog.setTitle("Group Gain Selector");
            choiceDialog.setHeaderText("File contains gains for more than one device");
            choiceDialog.setContentText("Choose device index:");
            choiceDialog.initOwner(this.getActiveWindow());
            Optional optional2 = choiceDialog.showAndWait();
            if (!optional2.isPresent()) {
                return;
            }
            afv2 = afvArray[(Integer)optional2.get() - 1];
        } else {
            afv2 = afvArray[0];
        }
        this.setGainFields(afv2);
    }

    private void setGainFields(afv afv2) {
        afl afl2 = afv2.a();
        if (afl2 == afl.a) {
            afl2 = null;
        }
        this.controlStrategy.setValue(afl2);
        this.positionPidController.setTextFields(afv2);
        this.velocityPidController.setTextFields(afv2);
        this.effortPidController.setTextFields(afv2);
    }

    @FXML
    void saveGainsToFile(ActionEvent actionEvent) {
        if (this.moduleSelector.getSelectedModules().size() == 0) {
            return;
        }
        if (!this.tryShowGroupGainsNotice()) {
            return;
        }
        File file = this.fileChooser.f(this.getActiveWindow());
        if (file == null) {
            return;
        }
        zd zd2 = zd.a((afy[])this.moduleSelector.getSelectedModules().stream().map(arl::getInfo).toArray(afy[]::new));
        try (FileOutputStream fileOutputStream = new FileOutputStream(file);){
            zd2.a(fileOutputStream);
            return;
        }
        catch (IOException | TransformerException exception) {
            atd.a(exception, this.getActiveWindow());
            return;
        }
    }

    private boolean tryShowGroupGainsNotice() {
        if (!this.moduleSelector.selectionMultiple().get()) {
            return true;
        }
        return atd.a("Gains from multiple devices are stored in a single file.\nWhen loading or saving gains from multiple devices,\nthe order within the file will match the order of selected\ndevices as shown on the left. The device order can be\nchanged using the ALT + UpDown shortcuts.", this.getActiveWindow());
    }

    private Window getActiveWindow() {
        return this.controlStrategy.getScene().getWindow();
    }

    @FXML
    void initialize() {
        this.advancedToggle.setSelected(this.properties.m.get());
        this.properties.m.bind((ObservableValue)this.advancedToggle.selectedProperty());
        this.persistToggle.setSelected(this.properties.s.get());
        this.properties.s.bind((ObservableValue)this.persistToggle.selectedProperty());
        this.positionPidController.initialize(za.a, (ReadOnlyBooleanProperty)this.advancedView, this.basicValidation, this.advancedValidation);
        this.velocityPidController.initialize(za.b, (ReadOnlyBooleanProperty)this.advancedView, this.basicValidation, this.advancedValidation);
        this.effortPidController.initialize(za.c, (ReadOnlyBooleanProperty)this.advancedView, this.basicValidation, this.advancedValidation);
        aox.c((Node)this.advancedToggle, azl.a(this.advancedValidation));
        aox.b((Node)this.advancedToggle, azl.b(this.advancedValidation));
        aox.a((Node)this.sendBtn, azl.b(this.basicValidation), azl.b(this.advancedValidation));
        Object object = this.module.getGains();
        this.controlStrategy.initValues((ReadOnlyObjectProperty<afl>)((aqt)object).v, afl.a);
        this.basicValidation.registerValidator((Control)this.controlStrategy.getChoiceBox(), false, azl.a(this.controlStrategy));
        Object object2 = this.module.getGains();
        this.mStopStrategy.initValues((ReadOnlyObjectProperty<agt>)((aqt)object2).w, agt.a);
        this.basicValidation.registerValidator((Control)this.mStopStrategy.getChoiceBox(), false, azl.a(this.mStopStrategy));
        object2 = this.module.getSafetyLimits();
        this.posLimitStrategy.initValues((ReadOnlyObjectProperty<ahr>)((ari)object2).G, ahr.a);
        this.basicValidation.registerValidator((Control)this.posLimitStrategy.getChoiceBox(), false, azl.a(this.posLimitStrategy));
        GainsController gainsController = this;
        ari ari2 = this.module.getSafetyLimits();
        object = ari2;
        object = this.module.getFeedback();
        gainsController.initializeSafetyLimit(gainsController.minPosLimit, (ReadOnlyDoubleProperty)ari2.cv, (ReadOnlyDoubleProperty)((aqj)object).y);
        GainsController gainsController2 = this;
        ari ari3 = this.module.getSafetyLimits();
        object = ari3;
        object = this.module.getFeedback();
        gainsController2.initializeSafetyLimit(gainsController2.maxPosLimit, (ReadOnlyDoubleProperty)ari3.cs, (ReadOnlyDoubleProperty)((aqj)object).y);
        GainsController gainsController3 = this;
        ari ari4 = this.module.getSafetyLimits();
        object = ari4;
        object = this.module.getFeedback();
        gainsController3.initializeSafetyLimit(gainsController3.minVelLimit, (ReadOnlyDoubleProperty)ari4.cw, (ReadOnlyDoubleProperty)((aqj)object).D);
        GainsController gainsController4 = this;
        ari ari5 = this.module.getSafetyLimits();
        object = ari5;
        object = this.module.getFeedback();
        gainsController4.initializeSafetyLimit(gainsController4.maxVelLimit, (ReadOnlyDoubleProperty)ari5.ct, (ReadOnlyDoubleProperty)((aqj)object).D);
        GainsController gainsController5 = this;
        ari ari6 = this.module.getSafetyLimits();
        object = ari6;
        object = this.module.getFeedback();
        gainsController5.initializeSafetyLimit(gainsController5.minEffortLimit, (ReadOnlyDoubleProperty)ari6.cu, (ReadOnlyDoubleProperty)((aqj)object).h);
        GainsController gainsController6 = this;
        ari ari7 = this.module.getSafetyLimits();
        object = ari7;
        object = this.module.getFeedback();
        gainsController6.initializeSafetyLimit(gainsController6.maxEffortLimit, (ReadOnlyDoubleProperty)ari7.cr, (ReadOnlyDoubleProperty)((aqj)object).h);
        this.sendBtn.setOnAction(this::sendGains);
        this.sendBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionEmpty().or((ObservableBooleanValue)this.basicValidation.invalidProperty()).or((ObservableBooleanValue)this.advancedValidation.invalidProperty()));
        this.saveFileBtn.setOnAction(this::saveGainsToFile);
        this.saveFileBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionEmpty());
        this.loadDefaultsBtn.setOnAction(this::loadDefaultGains);
        this.loadDefaultsBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionEmpty());
        this.loadFileBtn.setOnAction(this::loadFromFile);
        this.loadFileBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionEmpty());
        this.sendDirectBtn.setOnAction(this::loadFromFileAndSend);
        this.sendDirectBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionEmpty());
        this.clearBtn.setOnAction(this::clearAllFields);
    }

    private void initializeSafetyLimit(HDoubleInputField hDoubleInputField, ReadOnlyDoubleProperty readOnlyDoubleProperty, ReadOnlyDoubleProperty readOnlyDoubleProperty2) {
        hDoubleInputField.feedbackValueProperty().bind((ObservableValue)readOnlyDoubleProperty);
        hDoubleInputField.setShowTarget(true);
        hDoubleInputField.setTargetSupplier(() -> ((ReadOnlyDoubleProperty)readOnlyDoubleProperty2).get());
        CustomTextField customTextField = hDoubleInputField.getTextInput();
        Validator<String> validator = azl.a(customTextField, ParseUtils.NON_NAN_DOUBLE_VALIDATOR, readOnlyDoubleProperty, 0.001);
        this.basicValidation.registerValidator((Control)customTextField, false, validator);
        this.clearers.add(() -> ((CustomTextField)customTextField).clear());
    }

    @PostConstruct
    public void postConstruct() {
        this.reusableCommand = aty.b();
        this.advancedView = this.properties.m;
    }
}

