/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.scope.components;

import atlantafx.base.controls.CustomTextField;
import java.util.OptionalDouble;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.ReadOnlyDoubleProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableDoubleValue;
import javafx.beans.value.ObservableValue;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.layout.HBox;
import javafx.scene.text.Text;
import javax.inject.Inject;
import org.controlsfx.validation.ValidationSupport;
import org.controlsfx.validation.Validator;
import us.hebi.gui.controls.TextFieldUtil;
import us.hebi.gui.controls.TextUtil;
import us.hebi.gui.lib.ad;
import us.hebi.gui.lib.aib;
import us.hebi.gui.lib.amv;
import us.hebi.gui.lib.aqj;
import us.hebi.gui.lib.aqy;
import us.hebi.gui.lib.arh;
import us.hebi.gui.lib.arl;
import us.hebi.gui.lib.atd;
import us.hebi.gui.lib.aty;
import us.hebi.gui.lib.auh;
import us.hebi.gui.lib.aum;
import us.hebi.gui.lib.azl;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.bug;
import us.hebi.gui.lib.fe;
import us.hebi.gui.views.scope.components.ParseUtils;

public class DeviceParams {
    @FXML
    private HBox positionField;
    @FXML
    private HBox positionOffsetField;
    @FXML
    private HBox effortField;
    @FXML
    private HBox deflectionOffsetField;
    @FXML
    private Button applyBtn;
    @FXML
    private Button applySelectedBtn;
    @FXML
    private Button calibratePositionBtn;
    @Inject
    aum module;
    @Inject
    auh moduleSelector;
    @Inject
    aty commandService;
    final aib cmd = new aib();
    final ValidationSupport validation = azl.a();

    @FXML
    void initialize() {
        aqj aqj2 = this.module.getFeedback();
        Object object = this.module.getInfo();
        arh arh2 = ((aqy)object).a;
        DeviceParams deviceParams = this;
        object = arh2;
        aqj aqj3 = aqj2;
        deviceParams.initializeField(deviceParams.positionField, (ReadOnlyBooleanProperty)((arh)object).y, (ReadOnlyDoubleProperty)aqj3.y, ParseUtils.FINITE_DOUBLE_VALIDATOR);
        DeviceParams deviceParams2 = this;
        object = arh2;
        aqj3 = aqj2;
        deviceParams2.initializeField(deviceParams2.positionOffsetField, (ReadOnlyBooleanProperty)((arh)object).w, (ReadOnlyDoubleProperty)aqj3.y, ParseUtils.FINITE_DOUBLE_VALIDATOR);
        DeviceParams deviceParams3 = this;
        object = arh2;
        aqj3 = aqj2;
        deviceParams3.initializeField(deviceParams3.effortField, (ReadOnlyBooleanProperty)((arh)object).x, (ReadOnlyDoubleProperty)aqj3.h, ParseUtils.ONLY_ZERO_VALIDATOR);
        DeviceParams deviceParams4 = this;
        object = arh2;
        aqj3 = aqj2;
        deviceParams4.initializeField(deviceParams4.deflectionOffsetField, (ReadOnlyBooleanProperty)((arh)object).v, (ReadOnlyDoubleProperty)aqj3.f, ParseUtils.FINITE_DOUBLE_VALIDATOR);
        this.applyBtn.setOnAction(actionEvent -> this.sendMessage(false));
        this.applySelectedBtn.setOnAction(actionEvent -> this.sendMessage(true));
        this.applyBtn.disableProperty().bind((ObservableValue)this.module.getEmptyProperty().or((ObservableBooleanValue)this.validation.invalidProperty()));
        this.applySelectedBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionMultiple().not().or((ObservableBooleanValue)this.validation.invalidProperty()));
        this.deflectionOffsetField.setVisible(false);
        this.deflectionOffsetField.setManaged(false);
        if (!amv.j("hebi.scope.enableCalibrateButton")) {
            this.calibratePositionBtn.setVisible(false);
            this.calibratePositionBtn.setManaged(false);
        }
        this.calibratePositionBtn.disableProperty().bind((ObservableValue)this.moduleSelector.selectionSingle().not());
        this.calibratePositionBtn.setOnAction(this::sendCalibratePosition);
    }

    private void sendCalibratePosition(ActionEvent actionEvent) {
        if (!atd.a("This will calibrate the position encoder. This action is irreversible, and \nchanges internal device state that will change the behavior of commands sent \nto the module. Make sure that the actuator is sitting on a flat surface and \nthat nothing is attached to the actuator output.", azx.a(actionEvent))) {
            return;
        }
        this.cmd.clear();
        this.cmd.getRootMessage().a().e().a(true);
        this.commandService.a(this.moduleSelector.getSingleSelection().map(arl::a), this.cmd);
    }

    private void sendMessage(boolean bl2) {
        if (!atd.a("Are you sure you want to change the reference points? This action is irreversible, \nand changes internal device state that will change the behavior of commands sent \nto the module. Note that this will cause code commanding this module to perform \ndifferently.", this.applyBtn.getScene().getWindow())) {
            return;
        }
        this.cmd.clear();
        bug bug2 = this.cmd.getRootMessage().a().e();
        DeviceParams deviceParams = this;
        deviceParams.tryParseValue(deviceParams.positionField).ifPresent(d2 -> bug2.c(true).a((float)d2));
        DeviceParams deviceParams2 = this;
        deviceParams2.tryParseValue(deviceParams2.positionOffsetField).ifPresent(d2 -> bug2.f(true).c((float)d2));
        DeviceParams deviceParams3 = this;
        deviceParams3.tryParseValue(deviceParams3.effortField).ifPresent(d2 -> bug2.e(true).b((float)d2));
        DeviceParams deviceParams4 = this;
        deviceParams4.tryParseValue(deviceParams4.deflectionOffsetField).ifPresent(d2 -> bug2.g(true).d((float)d2));
        if (bl2) {
            this.commandService.a(this.moduleSelector.getSelectedAddresses(), this.cmd);
            return;
        }
        this.commandService.a(this.module.getModule().a(), this.cmd);
    }

    private void initializeField(HBox hBox, ReadOnlyBooleanProperty readOnlyBooleanProperty, ReadOnlyDoubleProperty readOnlyDoubleProperty, Validator<String> validator) {
        CustomTextField customTextField = (CustomTextField)((Object)hBox.getChildren().get(hBox.getChildren().size() - 2));
        Button button = (Button)hBox.getChildren().get(1);
        Text text = (Text)hBox.getChildren().get(hBox.getChildren().size() - 1);
        TextFieldUtil.setupClearButtonField(customTextField);
        this.validation.registerValidator((Control)customTextField, false, validator);
        if (validator == ParseUtils.ONLY_ZERO_VALIDATOR) {
            button.setOnAction(actionEvent -> customTextField.setText("0"));
        } else {
            button.setOnAction(actionEvent -> customTextField.setText(TextUtil.format4digitsWithoutZeros(readOnlyDoubleProperty.getValue())));
        }
        text.textProperty().bind((ObservableValue)ParseUtils.asFormattedString(readOnlyDoubleProperty));
        hBox.disableProperty().bind((ObservableValue)readOnlyBooleanProperty.not().or((ObservableBooleanValue)ParseUtils.isNaN((ObservableDoubleValue)readOnlyDoubleProperty)));
        text.visibleProperty().bind((ObservableValue)hBox.disabledProperty().not());
    }

    private OptionalDouble tryParseValue(HBox hBox) {
        String string = ((CustomTextField)((Object)hBox.getChildren().get(hBox.getChildren().size() - 2))).getText();
        if (ad.a(string)) {
            return OptionalDouble.empty();
        }
        Double d2 = fe.a(string);
        if (d2 == null) {
            return OptionalDouble.empty();
        }
        return OptionalDouble.of(d2);
    }
}

