/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps.hrdf;

import java.io.IOException;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import javafx.collections.FXCollections;
import javafx.collections.ObservableList;
import lombok.Generated;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.byn;
import us.hebi.gui.lib.bzz;
import us.hebi.gui.views.maps.hrdf.DirectoryUpdateService;
import us.hebi.gui.views.maps.hrdf.RobotSource;

public class RobotSourceLoader
extends DirectoryUpdateService {
    final ObservableList<RobotSource> sources = FXCollections.observableArrayList();

    public RobotSourceLoader() {
        super("robots");
    }

    public void forceReload() {
        this.sources.clear();
        this.onDirectoryUpdate();
    }

    @Override
    protected void onDirectoryUpdate() {
        CompletableFuture.supplyAsync(this::loadSourceFiles, this.executor).thenAcceptAsync(arg_0 -> this.sources.setAll(arg_0), azx.d);
    }

    private List<RobotSource> loadSourceFiles() {
        ArrayList<RobotSource> arrayList;
        block11: {
            DirectoryStream<Path> directoryStream = Files.newDirectoryStream(this.getDirectoryPath(), "*.json");
            try {
                ArrayList<RobotSource> arrayList2 = new ArrayList<RobotSource>();
                for (Path path : directoryStream) {
                    if (Files.size(path) <= 0L) continue;
                    bzz bzz2 = bzz.a(Files.readAllBytes(path));
                    try {
                        byn byn2 = byn.a(bzz2);
                        if (byn2.g.ax() <= 0) continue;
                        arrayList2.add(new RobotSource(byn2));
                    }
                    catch (IOException iOException) {
                        System.err.println(String.valueOf(path) + " could not be parsed: " + iOException.getMessage());
                    }
                }
                arrayList = arrayList2;
                if (directoryStream == null) break block11;
            }
            catch (Throwable throwable) {
                try {
                    if (directoryStream != null) {
                        try {
                            directoryStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException iOException) {
                    azx.b(() -> this.notificationService.f(iOException));
                    return Collections.emptyList();
                }
            }
            directoryStream.close();
        }
        return arrayList;
    }

    @Generated
    public ObservableList<RobotSource> getSources() {
        return this.sources;
    }
}

