/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps.components.dialogs;

import java.io.File;
import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.property.Property;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.control.Button;
import javafx.scene.control.ComboBox;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.stage.DirectoryChooser;
import javafx.stage.Stage;
import javax.inject.Inject;
import lombok.Generated;
import org.controlsfx.validation.ValidationResult;
import org.controlsfx.validation.ValidationSupport;
import us.hebi.gui.lib.aoz;
import us.hebi.gui.lib.azi;
import us.hebi.gui.lib.azl;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.fc;
import us.hebi.gui.views.maps.MapsAppState;
import us.hebi.gui.views.maps.utils.UtLiveChart;
import us.hebi.gui.views.scope.components.ParseUtils;

public class MapsSettingsController
extends azi {
    @FXML
    private ComboBox<String> unitChoice;
    @FXML
    private TextField addressField;
    @FXML
    private ToggleButton enableNavigationToggle;
    @FXML
    private ToggleButton enableMapRequestToggle;
    @FXML
    private ToggleButton hiddenToggle;
    @FXML
    private Button showUtBtn;
    @FXML
    private Button closeBtn;
    @FXML
    private Button resetLogDirBtn;
    @FXML
    private Button setLogDirBtn;
    @FXML
    private TextField soundVelocity;
    @FXML
    private ToggleButton showLiveMapToggle;
    @FXML
    private ToggleButton showDefaultSourcesToggle;
    @FXML
    private ToggleButton showCustomSourcesToggle;
    @FXML
    private ToggleButton showCustomProbesToggle;
    @Inject
    aoz maps;
    @Inject
    MapsAppState state;

    @Override
    public void initializeFx() {
        this.showLiveMapToggle.selectedProperty().bindBidirectional((Property)this.state.showLiveMapProperty());
        this.showDefaultSourcesToggle.selectedProperty().bindBidirectional((Property)this.state.showBuiltinSourcesProperty());
        this.showCustomSourcesToggle.selectedProperty().bindBidirectional((Property)this.state.showCustomSourcesProperty());
        this.showCustomProbesToggle.selectedProperty().bindBidirectional((Property)this.state.showCustomProbesProperty());
        this.hiddenToggle.selectedProperty().bindBidirectional((Property)this.state.showInternalOptionsProperty());
        this.enableNavigationToggle.selectedProperty().bindBidirectional((Property)this.state.enableNavigationProperty());
        this.enableMapRequestToggle.selectedProperty().bindBidirectional((Property)this.state.enableMapRequestProperty());
        ValidationSupport validationSupport = azl.a();
        validationSupport.registerValidator((Control)this.addressField, true, (control, string) -> {
            if (!fc.b(string)) {
                return ValidationResult.fromErrorIf(control, "Expected IPv4 address", true);
            }
            return ValidationResult.fromWarningIf(control, "IPv4 address is not reachable", !this.maps.f.get());
        });
        azx.b(validationSupport::revalidate, new Observable[]{this.maps.f});
        this.addressField.textProperty().bindBidirectional((Property)this.state.mapsAddressProperty());
        this.addressField.textProperty().addListener((observableValue, string, string2) -> ParseUtils.toInet4Address(string2).ifPresent(this.maps::a));
        ParseUtils.toInet4Address(this.addressField.getText()).ifPresent(this.maps::a);
        this.unitChoice.valueProperty().bindBidirectional((Property)this.state.unitLabelProperty());
        ValidationSupport validationSupport2 = azl.a();
        validationSupport2.registerValidator((Control)this.soundVelocity, ParseUtils.FINITE_DOUBLE_VALIDATOR);
        this.showUtBtn.disableProperty().bind((ObservableValue)validationSupport2.invalidProperty());
        this.showUtBtn.setOnAction(actionEvent -> {
            Stage stage = UtLiveChart.createStage();
            azx.b(stage);
            stage.toFront();
        });
        this.soundVelocity.setText(Double.toString(this.state.getSoundVelocity()));
        this.soundVelocity.textProperty().addListener((observableValue, string, string2) -> {
            Double d2 = ParseUtils.tryParseDouble(string2);
            if (d2 != null) {
                this.state.setSoundVelocity(d2);
            }
        });
        this.resetLogDirBtn.setOnAction(actionEvent -> this.state.resetLogDirectory());
        this.setLogDirBtn.setOnAction(actionEvent -> {
            File file = new File(this.state.getLogDirectory());
            if (!file.exists() && !file.mkdirs()) {
                file = null;
            }
            DirectoryChooser directoryChooser = new DirectoryChooser();
            directoryChooser.setTitle("Select directory");
            directoryChooser.setInitialDirectory(file);
            Optional.ofNullable(directoryChooser.showDialog(azx.a(actionEvent))).map(File::getAbsolutePath).ifPresent(this.state::setLogDirectory);
        });
    }

    @Generated
    public Button getCloseBtn() {
        return this.closeBtn;
    }

    @Generated
    public MapsAppState getState() {
        return this.state;
    }
}

