/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps.components.dialogs;

import java.util.Optional;
import javafx.beans.Observable;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.event.EventHandler;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.TextField;
import javafx.scene.control.ToggleButton;
import javafx.scene.input.KeyCombination;
import javafx.scene.input.KeyEvent;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.StackPane;
import javax.inject.Inject;
import lombok.Generated;
import org.controlsfx.validation.ValidationSupport;
import us.hebi.gui.lib.aoz;
import us.hebi.gui.lib.apb;
import us.hebi.gui.lib.apc;
import us.hebi.gui.lib.ate;
import us.hebi.gui.lib.azi;
import us.hebi.gui.lib.azl;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.bab;
import us.hebi.gui.lib.bat;
import us.hebi.gui.lib.bcs;
import us.hebi.gui.lib.bcu;
import us.hebi.gui.lib.bcw;
import us.hebi.gui.lib.bcx;
import us.hebi.gui.lib.bcy;
import us.hebi.gui.lib.can;
import us.hebi.gui.views.maps.MapsAppState;
import us.hebi.gui.views.maps.MapsCss;
import us.hebi.gui.views.scope.components.ParseUtils;

public class FlatWizardController
extends azi {
    @FXML
    private ToggleButton bottomLeft;
    @FXML
    private ToggleButton bottomRight;
    @FXML
    private Button closeBtn;
    @FXML
    private Button clearBtn;
    @FXML
    private Button generateBtn;
    @FXML
    private StackPane rectangleLines;
    @FXML
    private AnchorPane root;
    @FXML
    private ToggleButton topLeft;
    @FXML
    private ToggleButton topRight;
    @FXML
    private TextField paddingField;
    final IntegerProperty numSelectedPoints = new SimpleIntegerProperty(0);
    final BooleanBinding needsMorePoints = this.numSelectedPoints.lessThan(3);
    @Inject
    aoz maps;
    @Inject
    apc registration;
    @Inject
    ate notification;
    @Inject
    MapsAppState state;

    @Override
    public void initializeFx() {
        bat.f((Parent)this.root);
        ValidationSupport validationSupport = azl.a();
        validationSupport.registerValidator((Control)this.paddingField, ParseUtils.FINITE_DOUBLE_VALIDATOR);
        this.state.addUnitFields(this.paddingField);
        azx.b(() -> {
            this.generateBtn.pseudoClassStateChanged(MapsCss.HIGHLIGHTED, !this.needsMorePoints.get());
            this.rectangleLines.pseudoClassStateChanged(MapsCss.SELECTED, !this.needsMorePoints.get());
        }, new Observable[]{this.needsMorePoints});
        FlatWizardController flatWizardController = this;
        bcu bcu2 = flatWizardController.setupToggleButton(flatWizardController.topLeft, bab.k);
        FlatWizardController flatWizardController2 = this;
        bcu bcu3 = flatWizardController2.setupToggleButton(flatWizardController2.topRight, bab.l);
        FlatWizardController flatWizardController3 = this;
        bcu bcu4 = flatWizardController3.setupToggleButton(flatWizardController3.bottomLeft, bab.m);
        FlatWizardController flatWizardController4 = this;
        bcu bcu5 = flatWizardController4.setupToggleButton(flatWizardController4.bottomRight, bab.n);
        this.generateBtn.disableProperty().bind((ObservableValue)this.needsMorePoints.or((ObservableBooleanValue)validationSupport.invalidProperty()));
        this.generateBtn.setOnAction(actionEvent -> {
            this.registration.aX();
            if (!this.topLeft.isSelected()) {
                bcu2.c(this.deriveWaypointAndAddMarkers(bcu3, bcu4, bcu5));
            } else if (!this.topRight.isSelected()) {
                bcu3.c(this.deriveWaypointAndAddMarkers(bcu2, bcu5, bcu4));
            } else if (!this.bottomLeft.isSelected()) {
                bcu4.c(this.deriveWaypointAndAddMarkers(bcu2, bcu5, bcu3));
            } else if (!this.bottomRight.isSelected()) {
                bcu5.c(this.deriveWaypointAndAddMarkers(bcu4, bcu3, bcu2));
            }
            bcx bcx2 = bcu2.a().a(bcu3.a()).b();
            bcx bcx3 = bcu2.a().a(bcu4.a()).b();
            double d2 = this.state.getUnits().f(Optional.ofNullable(ParseUtils.tryParseDouble(this.paddingField.getText())).orElse(0.0));
            bcx bcx4 = bcx2.c().a(d2);
            bcx bcx5 = bcx3.c().a(d2);
            bcx bcx6 = bcx2.c().a(-d2);
            bcx bcx7 = bcx3.c().a(-d2);
            bcu bcu7 = bcu2.d().a(bcx4).a(bcx5);
            bcu bcu8 = bcu3.d().a(bcx6).a(bcx5);
            bcu bcu9 = bcu4.d().a(bcx4).a(bcx7);
            bcu bcu10 = bcu5.d().a(bcx6).a(bcx7);
            bcu[] bcuArray = new bcu[9];
            bcuArray[0] = bcu7.d();
            bcu bcu11 = bcu8;
            bcu bcu12 = bcu7;
            bcuArray[1] = bcw.a(bcu12, bcu11);
            bcuArray[2] = bcu8.d();
            bcu11 = bcu9;
            bcu12 = bcu7;
            bcuArray[3] = bcw.a(bcu12, bcu11);
            bcu11 = bcu10;
            bcu12 = bcu7;
            bcuArray[4] = bcw.a(bcu12, bcu11);
            bcu11 = bcu10;
            bcu12 = bcu8;
            bcuArray[5] = bcw.a(bcu12, bcu11);
            bcuArray[6] = bcu9.d();
            bcu11 = bcu10;
            bcu12 = bcu9;
            bcuArray[7] = bcw.a(bcu12, bcu11);
            bcuArray[8] = bcu10.d();
            apb apb2 = new apb(bcuArray);
            bcx bcx8 = bcx3;
            bcx bcx9 = bcy.a(bcx2, bcx8, bcx.d()).b();
            bcy.a(bcx9, bcx2, bcx3);
            apb2.e(bcu2 -> bcu2.a(bcx2.a1, bcx3.a1, bcx4.a1, bcx2.a2, bcx3.a2, bcx4.a2, bcx2.a3, bcx3.a3, bcx4.a3));
            this.registration.a(apb2);
            this.closeBtn.getOnAction().handle(actionEvent);
        });
        this.clearBtn.disableProperty().bind((ObservableValue)this.numSelectedPoints.isEqualTo(0));
        this.clearBtn.setOnAction(actionEvent -> {
            this.topLeft.setSelected(false);
            this.topRight.setSelected(false);
            this.bottomLeft.setSelected(false);
            this.bottomRight.setSelected(false);
            this.paddingField.setText("0");
        });
    }

    private bcu deriveWaypointAndAddMarkers(bcu bcu2, bcu bcu3, bcu bcu4) {
        this.registration.a(bcu2, bcu3, bcu4);
        bcu bcu5 = bcu.c();
        bcu[] bcuArray = new bcu[]{bcu2, bcu3, bcu4};
        can.c(true, "need at least one transform");
        bcs bcs2 = new bcs();
        double d2 = 0.0;
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        bcu[] bcuArray2 = bcuArray;
        for (int i2 = 0; i2 < 3; ++i2) {
            bcuArray2[i2].a(bcs2);
            d2 += bcs2.cK;
            d3 += bcs2.dK;
            d4 += bcs2.dL;
            d5 += bcs2.dW;
        }
        bcs2.cK = d2 / 3.0;
        bcs2.dK = d3 / 3.0;
        bcs2.dL = d4 / 3.0;
        bcs2.dW = d5 / 3.0;
        bcs2.cp();
        bcu5.a(bcs2);
        bcu5.dY = bcu2.dY + bcu3.dY - bcu4.dY;
        bcu5.ea = bcu2.ea + bcu3.ea - bcu4.ea;
        bcu5.ee = bcu2.ee + bcu3.ee - bcu4.ee;
        return bcu5;
    }

    private bcu setupToggleButton(ToggleButton toggleButton, KeyCombination keyCombination) {
        toggleButton.visibleProperty().bind((ObservableValue)toggleButton.selectedProperty().or((ObservableBooleanValue)this.needsMorePoints));
        bcu bcu2 = bcu.c();
        toggleButton.selectedProperty().addListener((observableValue, bl2, bl3) -> {
            if (bl3.booleanValue()) {
                bcu2.c(this.maps.b);
                this.numSelectedPoints.set(this.numSelectedPoints.get() + 1);
                return;
            }
            this.numSelectedPoints.set(this.numSelectedPoints.get() - 1);
        });
        bab.a((Node)toggleButton, keyCombination, (EventHandler<KeyEvent>)((EventHandler)keyEvent -> {
            if (!azx.a((Node)toggleButton)) {
                return;
            }
            azx.a(toggleButton.selectedProperty());
        }));
        return bcu2;
    }

    public Button getCloseButton() {
        return this.closeBtn;
    }

    @Generated
    public MapsAppState getState() {
        return this.state;
    }
}

