/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.maps.components;

import com.jfoenix.controls.JFXButton;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.concurrent.TimeUnit;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.IntegerProperty;
import javafx.beans.property.Property;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.property.SimpleIntegerProperty;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ObservableList;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Button;
import javafx.scene.control.Control;
import javafx.scene.control.ScrollPane;
import javafx.scene.control.Tab;
import javafx.scene.control.TabPane;
import javafx.scene.control.TextField;
import javafx.scene.control.TextInputDialog;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.Pane;
import javax.inject.Inject;
import lombok.Generated;
import org.controlsfx.validation.ValidationSupport;
import us.hebi.gui.lib.aoz;
import us.hebi.gui.lib.asy;
import us.hebi.gui.lib.ate;
import us.hebi.gui.lib.azi;
import us.hebi.gui.lib.azl;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.baq;
import us.hebi.gui.lib.biw;
import us.hebi.gui.lib.biz;
import us.hebi.gui.lib.bku;
import us.hebi.gui.lib.bla;
import us.hebi.gui.lib.blc;
import us.hebi.gui.lib.ble;
import us.hebi.gui.lib.blg;
import us.hebi.gui.lib.bli;
import us.hebi.gui.lib.bmb;
import us.hebi.gui.lib.bmd;
import us.hebi.gui.lib.bna;
import us.hebi.gui.lib.bnc;
import us.hebi.gui.lib.byl;
import us.hebi.gui.lib.can;
import us.hebi.gui.lib.fc;
import us.hebi.gui.lib.vj;
import us.hebi.gui.views.maps.EncoderState;
import us.hebi.gui.views.maps.EncoderState$FlawDetectorType;
import us.hebi.gui.views.maps.MapsAppState;
import us.hebi.gui.views.maps.MapsCss;
import us.hebi.gui.views.maps.components.dialogs.MapsSettingsController;
import us.hebi.gui.views.maps.controls.SelectionButton;
import us.hebi.gui.views.maps.hrdf.ProbeLoader;
import us.hebi.gui.views.maps.hrdf.Probes;
import us.hebi.gui.views.maps.hrdf.RobotSource;
import us.hebi.gui.views.maps.hrdf.RobotSourceLoader;
import us.hebi.gui.views.scope.components.ParseUtils;

public class ConfigurationController
extends azi {
    @FXML
    private ToggleGroup flawDetectorToggle;
    @FXML
    private ToggleButton flawDetectorQuadrature;
    @FXML
    private ToggleButton flawDetectorZetec2;
    @FXML
    private ToggleButton flawDetectorZetec3;
    @FXML
    private ToggleButton flawDetectorIntegrated;
    @FXML
    private TextField addressField;
    @FXML
    private ToggleGroup positionSourceToggle;
    @FXML
    private ToggleButton source10dof;
    @FXML
    private ToggleButton source7dofLong;
    @FXML
    private ToggleButton source7dofShort;
    @FXML
    private ToggleButton source9dof;
    @FXML
    private ToggleButton sourceMobileIO;
    @FXML
    private Pane positionSourceList;
    @FXML
    private Button continueBtn;
    @FXML
    private Button setConfigBtn;
    @FXML
    private TextField probeRx;
    @FXML
    private TextField probeRy;
    @FXML
    private TextField probeRz;
    @FXML
    private TextField probeX;
    @FXML
    private TextField probeY;
    @FXML
    private TextField probeZ;
    @FXML
    private TextField probeWidth;
    @FXML
    private Button saveCustomProbeBtn;
    @FXML
    private Tab probeTabContact;
    @FXML
    private Tab probeTabCustom;
    @FXML
    private Tab probeTabPaut;
    @FXML
    private TabPane probeTabPane;
    @FXML
    private Button settingsBtn;
    @FXML
    private Pane settingsDialog;
    @FXML
    private ScrollPane positionSourceScrollPane;
    @FXML
    private Button detectRobotsBtn;
    @FXML
    private MapsSettingsController settingsDialogController;
    @FXML
    private Pane customProbeList;
    @Inject
    asy dialogService;
    @Inject
    ate notificationService;
    @Inject
    aoz maps;
    @Inject
    MapsAppState state;
    @Inject
    EncoderState encoderState;
    @Inject
    RobotSourceLoader robotSourceLoader;
    @Inject
    ProbeLoader probeLoader;
    BooleanProperty disableEdits = new SimpleBooleanProperty(false);
    BooleanProperty hasSetConfig = new SimpleBooleanProperty(false);
    final IntegerProperty detectedCount = new SimpleIntegerProperty(0);
    final BooleanBinding invalidCount = this.detectedCount.isEqualTo(0);

    public boolean isDisableEdits() {
        return this.disableEdits.get();
    }

    public BooleanProperty disableEditsProperty() {
        return this.disableEdits;
    }

    @Override
    public void initializeFx() {
        ObservableList<RobotSource> observableList2;
        baq.a(this.positionSourceScrollPane);
        baq.b(this.positionSourceScrollPane);
        this.settingsBtn.setOnAction(actionEvent -> this.dialogService.a((Parent)this.settingsDialog, this.settingsDialogController.getCloseBtn()));
        this.state.addUnitFields(this.probeX, this.probeY, this.probeZ, this.probeWidth);
        switch (this.encoderState.getFlawDetectorType()) {
            case None: 
            case Quadrature: {
                this.flawDetectorQuadrature.setSelected(true);
                break;
            }
            case Zetec2: {
                this.flawDetectorZetec2.setSelected(true);
                break;
            }
            case Zetec3: {
                this.flawDetectorZetec3.setSelected(true);
                break;
            }
            case Integrated: {
                this.flawDetectorIntegrated.setSelected(true);
            }
        }
        this.flawDetectorToggle.selectedToggleProperty().addListener((observableValue, toggle, toggle2) -> {
            if (toggle2 == this.flawDetectorQuadrature) {
                this.encoderState.setFlawDetectorType(EncoderState$FlawDetectorType.Quadrature);
                return;
            }
            if (toggle2 == this.flawDetectorZetec2) {
                this.encoderState.setFlawDetectorType(EncoderState$FlawDetectorType.Zetec2);
                return;
            }
            if (toggle2 == this.flawDetectorZetec3) {
                this.encoderState.setFlawDetectorType(EncoderState$FlawDetectorType.Zetec3);
                return;
            }
            if (toggle2 == this.flawDetectorIntegrated) {
                this.encoderState.setFlawDetectorType(EncoderState$FlawDetectorType.Integrated);
            }
        });
        azx.a(this.flawDetectorToggle);
        ValidationSupport validationSupport = azl.a();
        validationSupport.registerValidator((Control)this.addressField, true, ParseUtils.IPV4_VALIDATOR);
        this.addressField.textProperty().bindBidirectional((Property)this.state.getString("encoderAddress", "10.10.1.10"));
        this.source7dofShort.setUserData((Object)RobotSource.MAPS_7dof_short);
        this.source7dofLong.setUserData((Object)RobotSource.MAPS_7dof_long);
        this.source9dof.setUserData((Object)RobotSource.MAPS_9dof);
        this.source10dof.setUserData((Object)RobotSource.MAPS_10dof_legacy);
        this.sourceMobileIO.setUserData((Object)RobotSource.MAPS_mobileIO);
        this.positionSourceToggle.selectToggle(null);
        for (ObservableList<RobotSource> observableList2 : this.positionSourceToggle.getToggles()) {
            if (observableList2.getUserData() != this.state.getPositionSource()) continue;
            this.positionSourceToggle.selectToggle((Toggle)observableList2);
        }
        this.positionSourceToggle.selectedToggleProperty().addListener((observableValue, toggle, toggle2) -> {
            Object object;
            if (toggle2 != null && (object = toggle2.getUserData()) instanceof RobotSource) {
                RobotSource robotSource = (RobotSource)object;
                this.state.setPositionSource(robotSource);
            }
        });
        azx.a(this.positionSourceToggle);
        this.probeX.textProperty().bindBidirectional((Property)this.state.getString("probeX", "0"));
        this.probeY.textProperty().bindBidirectional((Property)this.state.getString("probeY", "0"));
        this.probeZ.textProperty().bindBidirectional((Property)this.state.getString("probeZ", "0"));
        this.probeRx.textProperty().bindBidirectional((Property)this.state.getString("probeRx", "0"));
        this.probeRy.textProperty().bindBidirectional((Property)this.state.getString("probeRy", "0"));
        this.probeRz.textProperty().bindBidirectional((Property)this.state.getString("probeRz", "0"));
        this.probeWidth.textProperty().bindBidirectional((Property)this.state.getString("probeWidth", "0"));
        azx.b(() -> {
            this.settingsBtn.pseudoClassStateChanged(MapsCss.HIGHLIGHTED, !this.maps.f.get());
            this.setConfigBtn.pseudoClassStateChanged(MapsCss.HIGHLIGHTED, this.maps.f.get() && !this.hasSetConfig.get());
            this.continueBtn.pseudoClassStateChanged(MapsCss.HIGHLIGHTED, this.maps.f.get() && this.hasSetConfig.get());
        }, new Observable[]{this.hasSetConfig, this.maps.f});
        azx.b(() -> this.hasSetConfig.set(false), new Observable[]{this.positionSourceToggle.selectedToggleProperty(), this.flawDetectorToggle.selectedToggleProperty(), this.probeX.textProperty(), this.probeY.textProperty(), this.probeZ.textProperty(), this.probeRx.textProperty(), this.probeRy.textProperty(), this.probeRz.textProperty()});
        azx.b(() -> {
            ConfigurationController configurationController = this;
            this.state.setProbeWidth(configurationController.textToMeters(configurationController.probeWidth.getText()));
        }, new Observable[]{this.probeWidth.textProperty()});
        azx.a(this.probeTabContact, () -> this.setProbe(Probes.CONTACT));
        azx.a(this.probeTabPaut, () -> this.setProbe(Probes.PAUT));
        this.probeTabPane.getSelectionModel().select(this.state.getSelectedProbeIndex());
        this.state.selectedProbeIndexProperty().bind((ObservableValue)this.probeTabPane.getSelectionModel().selectedIndexProperty());
        this.disableEdits.bind((ObservableValue)this.probeTabCustom.selectedProperty().not());
        this.saveCustomProbeBtn.visibleProperty().bind((ObservableValue)this.probeTabCustom.selectedProperty().and((ObservableBooleanValue)this.state.showCustomProbesProperty()));
        azx.a(new Node[]{this.saveCustomProbeBtn});
        this.setupCustomProbeButtons();
        this.saveCustomProbeBtn.setOnAction(actionEvent -> {
            TextInputDialog textInputDialog = new TextInputDialog();
            textInputDialog.initOwner(azx.a(actionEvent));
            textInputDialog.setTitle("Save Probe");
            textInputDialog.setContentText("Name");
            textInputDialog.setHeaderText(null);
            textInputDialog.setGraphic(null);
            textInputDialog.showAndWait().ifPresent(string -> this.probeLoader.saveProbe(this.getProbe().b().a((CharSequence)string)));
        });
        Iterator iterator = this.flawDetectorToggle.selectedToggleProperty().isNull().or((ObservableBooleanValue)this.positionSourceToggle.selectedToggleProperty().isNull()).or((ObservableBooleanValue)this.encoderState.showAddressProperty().and((ObservableBooleanValue)validationSupport.invalidProperty()));
        this.setConfigBtn.disableProperty().bind((ObservableValue)iterator.or((ObservableBooleanValue)this.maps.f.not()));
        this.setConfigBtn.setOnAction(this::setConfiguration);
        this.continueBtn.disableProperty().bind((ObservableValue)this.hasSetConfig.not());
        this.continueBtn.setOnAction(this.state::nextView);
        this.robotSourceLoader.forceReload();
        observableList2 = this.robotSourceLoader.getSources();
        ArrayList arrayList = new ArrayList();
        azx.b(() -> {
            this.positionSourceList.getChildren().removeAll((Collection)arrayList);
            this.positionSourceToggle.getToggles().removeAll((Collection)arrayList);
            arrayList.clear();
            observableList2.stream().map(SelectionButton::new).forEach(arrayList::add);
            this.positionSourceList.getChildren().addAll((Collection)arrayList);
            this.positionSourceToggle.getToggles().addAll((Collection)arrayList);
        }, new Observable[]{observableList2});
        azx.b(() -> {
            for (Toggle toggle : this.positionSourceToggle.getToggles()) {
                if (!(toggle instanceof ToggleButton)) continue;
                ToggleButton toggleButton = (ToggleButton)toggle;
                this.setPositionSourceToggleVisibility(new Node[]{toggleButton});
            }
        }, new Observable[]{this.positionSourceToggle.getToggles()});
        this.detectRobotsBtn.setOnAction(actionEvent -> {
            bku bku2 = bku.a();
            bku2.a().d().a(blc.c);
            this.maps.a(bku2, TimeUnit.SECONDS.toMillis(15L), bkw2 -> {
                blg blg2 = bkw2.a.a;
                if (bli.a(blg2.de) == bli.b) {
                    System.out.println("Detected modules: \n" + String.valueOf(blg2));
                    this.detectedCount.set(blg2.a.ax());
                    return;
                }
                this.notificationService.j("Unknown error detecting robot modules");
            });
        });
    }

    private void setupCustomProbeButtons() {
        BooleanBinding booleanBinding = Bindings.isNotEmpty((ObservableList)this.customProbeList.getChildren());
        this.customProbeList.visibleProperty().bind((ObservableValue)this.state.showCustomProbesProperty().and((ObservableBooleanValue)booleanBinding));
        azx.a(new Node[]{this.customProbeList});
        azx.b(() -> {
            this.customProbeList.getChildren().clear();
            for (byl byl2 : this.probeLoader.getProbes()) {
                JFXButton jFXButton = azx.a(new JFXButton(byl2.aq.a(can.b)), "sw-ActionButton");
                jFXButton.setOnAction(actionEvent -> {
                    this.probeTabCustom.getTabPane().getSelectionModel().select((Object)this.probeTabCustom);
                    this.setProbe(byl2);
                });
                this.customProbeList.getChildren().add((Object)jFXButton);
            }
        }, new Observable[]{this.probeLoader.getProbes()});
    }

    private void setPositionSourceToggleVisibility(Node ... nodeArray) {
        Node[] nodeArray2 = nodeArray;
        int n2 = nodeArray.length;
        for (int i2 = 0; i2 < n2; ++i2) {
            Node node = nodeArray2[i2];
            Object object = node.getUserData();
            if (!(object instanceof RobotSource)) continue;
            RobotSource robotSource = (RobotSource)object;
            object = this.invalidCount.or((ObservableBooleanValue)this.detectedCount.isEqualTo(robotSource.getNames().length)).and((ObservableBooleanValue)(robotSource.isBuiltIn() ? this.state.showBuiltinSourcesProperty() : this.state.showCustomSourcesProperty()));
            if (robotSource.isInternalOption()) {
                object = object.and((ObservableBooleanValue)this.state.showInternalOptionsProperty());
            }
            node.visibleProperty().bind((ObservableValue)object);
            node.managedProperty().bind((ObservableValue)object);
        }
    }

    private void setProbe(byl byl2) {
        this.probeX.setText(this.metersToText(byl2.dK));
        this.probeY.setText(this.metersToText(byl2.dL));
        this.probeZ.setText(this.metersToText(byl2.dW));
        this.probeRx.setText(String.valueOf(byl2.eR));
        this.probeRy.setText(String.valueOf(byl2.eS));
        this.probeRz.setText(String.valueOf(byl2.eT));
        this.probeWidth.setText(this.metersToText(byl2.eU));
    }

    private byl getProbe() {
        if (this.probeTabContact.isSelected()) {
            return Probes.CONTACT;
        }
        if (this.probeTabPaut.isSelected()) {
            return Probes.PAUT;
        }
        if (this.probeTabCustom.isSelected()) {
            ConfigurationController configurationController = this;
            ConfigurationController configurationController2 = this;
            ConfigurationController configurationController3 = this;
            ConfigurationController configurationController4 = this;
            ConfigurationController configurationController5 = this;
            ConfigurationController configurationController6 = this;
            ConfigurationController configurationController7 = this;
            return Probes.CUSTOM.a(configurationController.textToMeters(configurationController.probeX.getText())).b(configurationController2.textToMeters(configurationController2.probeY.getText())).c(configurationController3.textToMeters(configurationController3.probeZ.getText())).d(configurationController4.textToRads(configurationController4.probeRx.getText())).e(configurationController5.textToRads(configurationController5.probeRy.getText())).f(configurationController6.textToRads(configurationController6.probeRz.getText())).g(configurationController7.textToMeters(configurationController7.probeWidth.getText()));
        }
        throw new IllegalStateException("No tab selected");
    }

    private String metersToText(double d2) {
        return String.valueOf((double)Math.round(d2 / this.state.getUnits().f(1.0) * 1000.0) / 1000.0);
    }

    private double textToMeters(String string) {
        double d2 = Double.parseDouble(string);
        return this.state.getUnits().f(d2);
    }

    private double textToRads(String string) {
        return Double.parseDouble(string);
    }

    private void setConfiguration(ActionEvent actionEvent) {
        bku bku2 = bku.a();
        RobotSource robotSource = this.state.getPositionSource();
        biw biw2 = bku2.a().e().a(biz.a);
        bmb bmb2 = bku2.a().a().a(bmd.a);
        switch (this.encoderState.getFlawDetectorType()) {
            case Quadrature: {
                biw2.a(biz.b).e(2);
                break;
            }
            case Zetec2: 
            case Zetec3: {
                int n2 = vj.b(fc.a(this.addressField.getText()));
                biw2.a(biz.c).e(this.encoderState.getFlawDetectorType() == EncoderState$FlawDetectorType.Zetec2 ? 2 : 3).a(n2);
                break;
            }
            case Integrated: {
                bmb2.a(bmd.b);
            }
        }
        bna bna2 = bku2.a().a().a(0).b(0);
        bla bla2 = bku2.a().d().b(robotSource.getFamily()).a(robotSource.getNames()).a((CharSequence)robotSource.getHrdf(this.getProbe()));
        if (robotSource == RobotSource.MAPS_mobileIO) {
            bna2.a(bnc.a);
            bla2.a(ble.c);
        } else {
            bna2.a(bnc.b).a(true);
            bla2.a(ble.b);
        }
        this.maps.a(bku2, bkw2 -> this.hasSetConfig.set(true));
    }

    @Generated
    public MapsAppState getState() {
        return this.state;
    }

    @Generated
    public EncoderState getEncoderState() {
        return this.encoderState;
    }
}

