/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.imitation;

import atlantafx.base.controls.CustomTextField;
import java.io.IOException;
import java.net.InetAddress;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.application.Platform;
import javafx.beans.property.BooleanProperty;
import javafx.beans.property.Property;
import javafx.beans.property.ReadOnlyBooleanProperty;
import javafx.beans.property.SimpleBooleanProperty;
import javafx.beans.value.ObservableValue;
import javafx.fxml.FXML;
import javafx.scene.Node;
import javafx.scene.Parent;
import javafx.scene.control.Labeled;
import javafx.scene.control.TextArea;
import javafx.scene.control.Toggle;
import javafx.scene.control.ToggleButton;
import javafx.scene.control.ToggleGroup;
import javafx.scene.layout.AnchorPane;
import javafx.scene.layout.VBox;
import javafx.scene.shape.Circle;
import javafx.scene.text.Text;
import javafx.stage.Window;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.inject.Inject;
import us.hebi.gui.lib.acq;
import us.hebi.gui.lib.aev;
import us.hebi.gui.lib.amx;
import us.hebi.gui.lib.aoo;
import us.hebi.gui.lib.aop;
import us.hebi.gui.lib.aox;
import us.hebi.gui.lib.aro;
import us.hebi.gui.lib.atd;
import us.hebi.gui.lib.azl;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.bat;
import us.hebi.gui.lib.baw;
import us.hebi.gui.lib.bax;
import us.hebi.gui.lib.wb;
import us.hebi.gui.lib.wc;
import us.hebi.gui.lib.wm;
import us.hebi.gui.views.imitation.ImitationPresenter$Properties;
import us.hebi.gui.views.scope.components.ParseUtils;

public class ImitationPresenter {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private AnchorPane rootPane;
    @FXML
    private ToggleButton arm6Regular;
    @FXML
    private ToggleGroup selectedArm;
    @FXML
    private ToggleButton arm6DoubleShoulder;
    @FXML
    private ToggleButton arm7Regular;
    @FXML
    private ToggleGroup selectedArm1;
    @FXML
    private ToggleButton arm7DoubleShoulder;
    @FXML
    private ToggleButton baseOmni;
    @FXML
    private ToggleGroup selectedBase;
    @FXML
    private ToggleButton baseHexapod;
    @FXML
    private ToggleButton baseMecanum;
    @FXML
    private ToggleButton baseTready;
    @FXML
    private ToggleButton baseDiffDrive;
    @FXML
    private ToggleButton baseIgor;
    @FXML
    private ToggleGroup selectedPort;
    @FXML
    private ToggleGroup selectedInterface;
    @FXML
    private TextArea customNames;
    @FXML
    private CustomTextField familyName;
    @FXML
    private VBox interfaceToggleBox;
    @FXML
    private ToggleButton interfaceLocalhost;
    @FXML
    private ToggleButton interfaceAny;
    @FXML
    private ToggleButton portDefault;
    @FXML
    private ToggleButton portCustom;
    @FXML
    public Text localAddressPort;
    @FXML
    public Text localAddressIp;
    @FXML
    private Circle connectionLed;
    int uniqueId;
    private final List<wb> kitDeviceList = new ArrayList<wb>();
    private final List<wb> customDeviceList = new ArrayList<wb>();
    private Map<bax, List<wb>> kitMap;
    private wc deviceWrapper = new wc();
    private wm server;
    BooleanProperty hasErrors = new SimpleBooleanProperty(false);
    @Inject
    ImitationPresenter$Properties properties;
    @Inject
    aro scopeProperties;

    @FXML
    void initialize() throws IOException {
        azx.b(this::initializeOnFxThread);
    }

    public void setNamesFromRobotConfig(acq acq2) {
        this.selectedArm.selectToggle(null);
        this.selectedBase.selectToggle(null);
        this.familyName.setText(String.valueOf(acq2.getFamilies()));
        this.customNames.setText(String.valueOf(acq2.getNames()));
    }

    private void initializeOnFxThread() {
        this.selectedArm.selectedToggleProperty().addListener(observable -> this.update());
        this.selectedBase.selectedToggleProperty().addListener(observable -> this.update());
        azl.a((Labeled)this.portDefault, (ReadOnlyBooleanProperty)this.hasErrors);
        int n2 = this.properties.selectedArmIndex.get();
        if (n2 >= 0 && n2 < this.selectedArm.getToggles().size()) {
            this.selectedArm.selectToggle((Toggle)this.selectedArm.getToggles().get(n2));
        }
        this.selectedArm.selectedToggleProperty().addListener((observableValue, toggle, toggle2) -> {
            int n2 = toggle2 == null ? -1 : this.selectedArm.getToggles().indexOf(toggle2);
            this.properties.selectedArmIndex.set(n2);
        });
        n2 = this.properties.selectedBaseIndex.get();
        if (n2 >= 0 && n2 < this.selectedBase.getToggles().size()) {
            this.selectedBase.selectToggle((Toggle)this.selectedBase.getToggles().get(n2));
        }
        this.selectedBase.selectedToggleProperty().addListener((observableValue, toggle, toggle2) -> {
            int n2 = toggle2 == null ? -1 : this.selectedBase.getToggles().indexOf(toggle2);
            this.properties.selectedBaseIndex.set(n2);
        });
        this.customNames.textProperty().addListener((observableValue, string, string2) -> this.updateCustomNames());
        this.customNames.textProperty().bindBidirectional((Property)this.properties.customNames);
        this.customNames.setTooltip(bat.a("delimiters\n*  newline\n*  comma\n*  semicolon\n\nignored\n*  quotes\n*  brackets\n*  parentheses\n*  whitespace"));
        this.familyName.textProperty().addListener((observableValue, string, string2) -> this.applyFamily());
        this.familyName.textProperty().bindBidirectional((Property)this.properties.familyName);
        this.localAddressPort.visibleProperty().bind((ObservableValue)this.portCustom.selectedProperty());
        this.localAddressPort.managedProperty().bind((ObservableValue)this.localAddressPort.visibleProperty());
        this.localAddressIp.visibleProperty().bind((ObservableValue)this.interfaceLocalhost.selectedProperty());
        this.localAddressIp.managedProperty().bind((ObservableValue)this.localAddressIp.visibleProperty());
        this.properties.useLocalhost.a(this.interfaceLocalhost.selectedProperty());
        this.properties.useCustomPort.a(this.portCustom.selectedProperty());
        atd.a("Note that Scope and the APIs may not check localhost by default. You may need to manually add 127.0.0.1 to the lookup addresses.", this.interfaceLocalhost);
        this.selectedPort.selectedToggleProperty().addListener((observableValue, toggle, toggle2) -> {
            if (toggle2 == this.portCustom) {
                Window window = azx.a((Node)this.portCustom);
                Optional<String> optional = aop.a("Custom port", "        Pick a custom port that the server should be run on. '0' opens a random\n        available port. Note that non-standard ports need to be manually added\n        to the lookup addresses in Scope and the APIs.\n", String.valueOf(this.properties.customPort.get()), window);
                if (optional.isEmpty()) {
                    this.portDefault.setSelected(true);
                    return;
                }
                Integer n2 = ParseUtils.tryParseInteger(optional.get());
                if (n2 == null || n2 < 0 || n2 > 65535) {
                    atd.a("Input is not a valid port: '" + optional.get() + "'", window);
                    this.portDefault.setSelected(true);
                    return;
                }
                this.properties.customPort.set(n2.intValue());
            }
            this.initServer();
        });
        this.selectedInterface.selectedToggleProperty().addListener((observableValue, toggle, toggle2) -> {
            if (toggle2 == null) {
                this.selectedInterface.selectToggle((Toggle)this.interfaceAny);
                return;
            }
            this.initServer();
        });
        this.initServer();
        bat.f((Parent)this.rootPane);
    }

    void initServer() {
        AutoCloseable[] cfr_ignored_0 = new AutoCloseable[0];
        amx.a(this.server);
        aox.a((Node)this.connectionLed, aoo.a);
        if (this.selectedPort.getSelectedToggle() == null) {
            this.server = null;
            return;
        }
        try {
            InetAddress inetAddress = this.interfaceLocalhost.isSelected() ? InetAddress.getLoopbackAddress() : null;
            int n2 = this.portDefault.isSelected() ? 16665 : this.properties.customPort.get();
            this.deviceWrapper.m(this.properties.uniqueSenderId.get());
            this.deviceWrapper.a(this.getFullDeviceList());
            this.server = new baw(this, inetAddress, n2, this.deviceWrapper);
            aox.a((Node)this.connectionLed, aoo.b);
            this.hasErrors.set(false);
            this.localAddressPort.setText(String.valueOf(((aev)this.server).b.getPort()));
            this.localAddressIp.setText(((aev)this.server).b.getAddress().getHostAddress());
            wm wm2 = this.server;
            Thread thread = new Thread(wm2);
            thread.setDaemon(true);
            thread.start();
            return;
        }
        catch (IOException iOException) {
            aox.a((Node)this.connectionLed, aoo.c);
            this.hasErrors.set(true);
            Platform.runLater(() -> atd.a(new RuntimeException("You may already be running another imitation process", iOException), this.rootPane.getScene().getWindow()));
            return;
        }
    }

    void applyFamily() {
        ImitationPresenter imitationPresenter = this;
        List<String> list = imitationPresenter.parseNames(imitationPresenter.familyName.getText());
        String string = list.isEmpty() ? "" : list.get(0);
        Iterator<wb> iterator = this.kitDeviceList.iterator();
        while (iterator.hasNext()) {
            iterator.next().a(string);
        }
        iterator = this.customDeviceList.iterator();
        while (iterator.hasNext()) {
            iterator.next().a(string);
        }
        if (list.size() > 1) {
            for (int i2 = 1; i2 < Math.min(this.customDeviceList.size(), list.size()); ++i2) {
                this.customDeviceList.get(i2).a(list.get(i2));
            }
        }
    }

    private List<String> parseNames(String string2) {
        return Arrays.stream(string2.split("[,;\n]")).map(string -> string.replaceAll("['\"{}\\[\\]()]", "")).map(String::strip).filter(string -> !string.isEmpty()).limit(16382 - this.kitDeviceList.size()).toList();
    }

    void updateCustomNames() {
        ImitationPresenter imitationPresenter = this;
        List<String> list = imitationPresenter.parseNames(imitationPresenter.customNames.getText());
        boolean bl2 = false;
        while (this.customDeviceList.size() < list.size()) {
            this.customDeviceList.add(wb.a());
            bl2 = true;
        }
        this.applyFamily();
        int n2 = 0;
        for (wb wb2 : this.customDeviceList) {
            if (n2 < list.size()) {
                wb2.b(list.get(n2));
                wb2.K = false;
            } else {
                wb2.K = true;
            }
            ++n2;
        }
        if (bl2 && this.server != null) {
            this.deviceWrapper.a(this.getFullDeviceList());
        }
    }

    @PostConstruct
    public void init() {
        this.kitMap = new HashMap<bax, List<wb>>();
        for (bax bax2 : bax.values()) {
            List<wb> list = bax2.af.stream().map(string -> {
                wb wb2 = wb.a();
                wb.a().K = true;
                return wb2.b((String)string);
            }).toList();
            this.kitMap.put(bax2, list);
            this.kitDeviceList.addAll(list);
        }
    }

    private List<wb> getFullDeviceList() {
        if (this.customDeviceList.size() == 0) {
            return this.kitDeviceList;
        }
        ArrayList<wb> arrayList = new ArrayList<wb>(this.kitDeviceList.size() + this.customDeviceList.size());
        arrayList.addAll(this.kitDeviceList);
        arrayList.addAll(this.customDeviceList);
        return arrayList;
    }

    @PreDestroy
    public void stop() {
        AutoCloseable[] cfr_ignored_0 = new AutoCloseable[0];
        amx.a(this.server);
    }

    void update() {
        ArrayList arrayList = new ArrayList();
        Toggle toggle = this.selectedArm.getSelectedToggle();
        if (toggle == this.arm6Regular) {
            arrayList.addAll(this.kitMap.get((Object)bax.a));
        } else if (toggle == this.arm6DoubleShoulder) {
            arrayList.addAll(this.kitMap.get((Object)bax.b));
        } else if (toggle == this.arm7Regular) {
            arrayList.addAll(this.kitMap.get((Object)bax.c));
        } else if (toggle == this.arm7DoubleShoulder) {
            arrayList.addAll(this.kitMap.get((Object)bax.d));
        }
        Toggle toggle2 = this.selectedBase.getSelectedToggle();
        if (toggle2 == this.baseOmni) {
            arrayList.addAll(this.kitMap.get((Object)bax.e));
        } else if (toggle2 == this.baseDiffDrive) {
            arrayList.addAll(this.kitMap.get((Object)bax.f));
        } else if (toggle2 == this.baseMecanum) {
            arrayList.addAll(this.kitMap.get((Object)bax.g));
        } else if (toggle2 == this.baseHexapod) {
            arrayList.addAll(this.kitMap.get((Object)bax.h));
        } else if (toggle2 == this.baseTready) {
            arrayList.addAll(this.kitMap.get((Object)bax.i));
        } else if (toggle2 == this.baseIgor) {
            arrayList.addAll(this.kitMap.get((Object)bax.j));
        }
        Iterator<wb> iterator = this.kitDeviceList.iterator();
        while (iterator.hasNext()) {
            iterator.next().K = true;
        }
        iterator = arrayList.iterator();
        while (iterator.hasNext()) {
            iterator.next().K = false;
        }
        this.applyFamily();
    }
}

