/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.views.bootloader;

import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import java.util.ResourceBundle;
import javafx.beans.Observable;
import javafx.beans.binding.Bindings;
import javafx.beans.binding.BooleanBinding;
import javafx.beans.binding.DoubleBinding;
import javafx.beans.value.ObservableBooleanValue;
import javafx.beans.value.ObservableNumberValue;
import javafx.beans.value.ObservableValue;
import javafx.collections.ListChangeListener;
import javafx.collections.ObservableList;
import javafx.concurrent.Task;
import javafx.concurrent.Worker;
import javafx.event.ActionEvent;
import javafx.fxml.FXML;
import javafx.geometry.Pos;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Button;
import javafx.scene.control.ButtonType;
import javafx.scene.control.ChoiceBox;
import javafx.scene.control.Dialog;
import javafx.scene.control.DialogPane;
import javafx.scene.control.RadioButton;
import javafx.scene.control.SelectionMode;
import javafx.scene.control.TextArea;
import javafx.scene.control.TextField;
import javafx.scene.control.ToolBar;
import javafx.scene.control.TreeItem;
import javafx.scene.control.TreeView;
import javafx.scene.layout.VBox;
import javafx.util.Callback;
import javafx.util.Duration;
import javax.annotation.PostConstruct;
import javax.inject.Inject;
import org.controlsfx.control.Notifications;
import org.controlsfx.control.TaskProgressView;
import us.hebi.gui.lib.ad;
import us.hebi.gui.lib.aem;
import us.hebi.gui.lib.aga;
import us.hebi.gui.lib.aib;
import us.hebi.gui.lib.amv;
import us.hebi.gui.lib.aov;
import us.hebi.gui.lib.aow;
import us.hebi.gui.lib.aqj;
import us.hebi.gui.lib.aqr;
import us.hebi.gui.lib.aqt;
import us.hebi.gui.lib.aqw;
import us.hebi.gui.lib.aqy;
import us.hebi.gui.lib.arb;
import us.hebi.gui.lib.arg;
import us.hebi.gui.lib.arl;
import us.hebi.gui.lib.atd;
import us.hebi.gui.lib.atf;
import us.hebi.gui.lib.ath;
import us.hebi.gui.lib.aty;
import us.hebi.gui.lib.aue;
import us.hebi.gui.lib.aug;
import us.hebi.gui.lib.auh;
import us.hebi.gui.lib.aup;
import us.hebi.gui.lib.aur;
import us.hebi.gui.lib.azx;
import us.hebi.gui.lib.bau;
import us.hebi.gui.lib.bcj;
import us.hebi.gui.lib.bck;
import us.hebi.gui.lib.bcl;
import us.hebi.gui.lib.bpk;
import us.hebi.gui.lib.bqy;
import us.hebi.gui.lib.h;
import us.hebi.gui.lib.vj;
import us.hebi.gui.lib.vl;

public class BootloaderPresenter {
    @FXML
    private ResourceBundle resources;
    @FXML
    private URL location;
    @FXML
    private ToolBar topBar;
    @FXML
    private Button loginButton;
    @FXML
    private Button bootButton;
    @FXML
    private Button calibrateCurrentButton;
    @FXML
    private Button programRawButton;
    @FXML
    private Button programEncryptingButton;
    @FXML
    private Button showMacAddressesButton;
    @FXML
    private Button setBootloaderParametersButton;
    @FXML
    private Button setApplicationParametersButton;
    @FXML
    private Button fullUpdateButton;
    @FXML
    private Button updateApplicationButton;
    @FXML
    private Button updateBootloaderButton;
    @FXML
    private Button updateBootloaderLoaderButton;
    @FXML
    private Button eraseApplicationButton;
    @FXML
    private Button stopButton;
    @FXML
    private Button calibratePositionButton;
    @FXML
    private Button calibrateEffortButton;
    @FXML
    private Button setDatabaseValueButton;
    @FXML
    private Button eraseDatabaseButton;
    @FXML
    private Button resetButton;
    @FXML
    private Button saveApplicationButton;
    @FXML
    private Button saveBootloaderButton;
    @FXML
    private Button saveAllPartitionsButton;
    @FXML
    private Button saveDatabaseButton;
    @FXML
    private TaskProgressView<Task<?>> taskProgressView;
    @FXML
    private VBox buttonVBox;
    @FXML
    public TreeView<String> typeTree;
    @FXML
    private TreeView<arl> moduleTree;
    @FXML
    private RadioButton viewSelectorFamilyName;
    @FXML
    private ChoiceBox<String> interfaceChoiceBox;
    @FXML
    private TextField hwType;
    @FXML
    private TextField hwEceType;
    @FXML
    private TextField hwEceRevision;
    @FXML
    private TextField hwSerial;
    @FXML
    private TextField fwType;
    @FXML
    private TextField fwRevision;
    @FXML
    private TextField ethMacAddress;
    @FXML
    private TextField ethIpAddress;
    @FXML
    private TextField ethNetmask;
    @FXML
    private TextField ethGateway;
    @FXML
    private TextField fwMode;
    @FXML
    private TextField hwRevision;
    @FXML
    private TextField hwSpringConstant;
    private static final String DATABASE_MESSAGE = "Clearing the database will wipe any existing calibration data and requires an appropriate physical setup. Continuing may render the device unusable. Are you sure that you want to proceed?";
    private static final String CALIBRATION_MESSAGE = "Calibrating will wipe any existing calibration data and requires an appropriate physical setup.Are you sure that you want to proceed?";
    int dbAddress = 28672;
    Float floatVal = null;
    Integer intVal = null;
    @Inject
    atf authenticationService;
    @Inject
    aug lookupService;
    @Inject
    auh selector;
    @Inject
    aue interfaceChoiceService;
    @Inject
    aur simpleCategoryTree;
    @Inject
    public aup filteredFlatModuleTree;
    @Inject
    aty commandService;
    aib command;
    @Inject
    aow moduleTreeCellFactory;
    @Inject
    ath bootloaderService;

    @FXML
    void refreshInterfaces(ActionEvent actionEvent) {
        this.interfaceChoiceService.refreshInterfaces();
    }

    @FXML
    void reset(ActionEvent actionEvent) {
        this.command.clear();
        this.command.setResetFlag();
        this.selector.getSelectedAddresses().forEach(aem2 -> this.commandService.a((aem)aem2, this.command));
    }

    @FXML
    void stopBoot(ActionEvent actionEvent) {
        this.command.clear();
        this.command.setStayInBootloaderFlag();
        this.selector.getSelectedAddresses().forEach(aem2 -> this.commandService.a((aem)aem2, this.command));
    }

    @FXML
    void boot(ActionEvent actionEvent) {
        this.command.clear();
        this.command.setBootFlag();
        this.selector.getSelectedAddresses().forEach(aem2 -> this.commandService.a((aem)aem2, this.command));
    }

    @FXML
    void setBootloaderHardwareParameters(ActionEvent actionEvent) {
        this.bootloaderService.setBootloaderHardwareParameters((List<arl>)this.selector.getSelectedModules(), this.authenticationService.cW.get());
    }

    @FXML
    void setApplicationHardwareParameters(ActionEvent actionEvent) {
        this.bootloaderService.setApplicationHardwareParameters((List<arl>)this.selector.getSelectedModules());
    }

    @FXML
    void programApplication(ActionEvent actionEvent) {
        this.bootloaderService.programApplicationMultiple((List<arl>)this.selector.getSelectedModules(), this.programRawButton.getScene().getWindow());
    }

    @FXML
    void programEncryptingFirmware(ActionEvent actionEvent) {
        this.bootloaderService.programEncryptingFirmwareMultiple((List<arl>)this.selector.getSelectedModules(), this.programEncryptingButton.getScene().getWindow());
    }

    @FXML
    void doFullUpdate(ActionEvent actionEvent) {
        this.bootloaderService.doFullUpdate(this.selector.getSingleSelection());
    }

    @FXML
    void updateApplication(ActionEvent actionEvent) {
        this.bootloaderService.updateFirmwareMultiple((List<arl>)this.selector.getSelectedModules(), bcj.d);
    }

    @FXML
    void updateBootloader(ActionEvent actionEvent) {
        this.bootloaderService.updateFirmwareMultiple((List<arl>)this.selector.getSelectedModules(), bcj.e);
    }

    @FXML
    void updateBootloaderLoader(ActionEvent actionEvent) {
        this.bootloaderService.updateFirmwareMultiple((List<arl>)this.selector.getSelectedModules(), bcj.f);
    }

    @FXML
    void eraseApplication(ActionEvent actionEvent) {
        for (arl arl2 : this.selector.getSelectedModules()) {
            this.bootloaderService.erasePartition(Optional.ofNullable(arl2), bpk.d);
        }
    }

    @FXML
    void eraseDatabase(ActionEvent actionEvent) {
        if (!atd.a(CALIBRATION_MESSAGE, azx.a(actionEvent))) {
            return;
        }
        for (arl arl2 : this.selector.getSelectedModules()) {
            this.bootloaderService.erasePartition(Optional.ofNullable(arl2), bpk.e);
        }
    }

    @FXML
    void saveAllPartitions(ActionEvent actionEvent) {
        this.bootloaderService.saveToFile(this.selector.getSingleSelection(), bpk.c, this.saveAllPartitionsButton.getScene().getWindow());
    }

    @FXML
    void saveBootloader(ActionEvent actionEvent) {
        this.bootloaderService.saveToFile(this.selector.getSingleSelection(), bpk.f, this.saveBootloaderButton.getScene().getWindow());
    }

    @FXML
    void saveApplication(ActionEvent actionEvent) {
        this.bootloaderService.saveToFile(this.selector.getSingleSelection(), bpk.d, this.saveApplicationButton.getScene().getWindow());
    }

    @FXML
    void saveDatabase(ActionEvent actionEvent) {
        this.bootloaderService.saveToFile(this.selector.getSingleSelection(), bpk.e, this.saveDatabaseButton.getScene().getWindow());
    }

    @FXML
    void calibrateCurrent(ActionEvent actionEvent) {
        if (!atd.a(CALIBRATION_MESSAGE, azx.a(actionEvent))) {
            return;
        }
        System.out.println("continue");
        this.selector.getSelectedAddresses().forEach(aem2 -> {
            this.command.clear();
            this.command.getRootMessage().a().e().d(true);
            this.commandService.a((aem)aem2, this.command);
        });
    }

    @FXML
    void calibratePosition(ActionEvent actionEvent) {
        if (!atd.a(CALIBRATION_MESSAGE, azx.a(actionEvent))) {
            return;
        }
        this.selector.getSelectedAddresses().forEach(aem2 -> {
            this.command.clear();
            this.command.getRootMessage().a().e().a(true);
            this.commandService.a((aem)aem2, this.command);
        });
    }

    @FXML
    void calibrateEffort(ActionEvent actionEvent) {
        if (!atd.a(CALIBRATION_MESSAGE, azx.a(actionEvent))) {
            return;
        }
        this.selector.getSelectedAddresses().forEach(aem2 -> {
            this.command.clear();
            this.command.getRootMessage().a().e().b(true);
            this.commandService.a((aem)aem2, this.command);
        });
    }

    @FXML
    void showMacAddresses(ActionEvent actionEvent) {
        arl arl22;
        Object object = "";
        for (arl arl22 : this.selector.getSelectedModules()) {
            object = (String)object + arl22.c().toString() + "\n";
        }
        Iterator iterator = new TextArea((String)object);
        arl22 = new Dialog();
        arl22.setTitle("Mac Address");
        DialogPane dialogPane = arl22.getDialogPane();
        dialogPane.setContent((Node)iterator);
        dialogPane.getButtonTypes().addAll((Object[])new ButtonType[]{ButtonType.OK});
        arl22.show();
    }

    @FXML
    void showLoginDialog(ActionEvent actionEvent) {
        bck bck2 = this.authenticationService.authClient;
        HashMap<String, String> hashMap = new HashMap<String, String>();
        hashMap.put("approval_prompt", "force");
        bck2.a = bck2.a.getAuthorizationUrlWithPKCE(hashMap);
        bck2.webViewer.showDocument(bck2.a.getAuthorizationUrl());
    }

    @FXML
    void setDatabaseValue(ActionEvent actionEvent) {
        Optional optional = aov.a("Set Database Value", h.a(new String[]{"Address", "FloatValue", "IntValue"}), h.a(new String[]{"0x" + Integer.toHexString(this.dbAddress), this.floatVal == null ? "" : this.floatVal.toString(), this.intVal == null ? "" : this.intVal.toString()})).showAndWait();
        if (!optional.isPresent()) {
            return;
        }
        List list = (List)optional.get();
        try {
            boolean bl2 = !ad.a((String)list.get(1));
            boolean bl3 = !ad.a((String)list.get(2));
            h.a(!ad.a((String)list.get(0)), (Object)"Address must not be empty");
            h.a(bl2 || bl3, (Object)"Expected a value field to be set.");
            h.a(!bl2 || !bl3, (Object)"Expected only one value field to be set.");
            this.dbAddress = Integer.decode((String)list.get(0));
            this.floatVal = bl2 ? Float.valueOf(Float.parseFloat((String)list.get(1))) : null;
            this.intVal = bl3 ? Integer.decode((String)list.get(2)) : null;
            this.command.clear();
            bqy bqy2 = this.command.getRootMessage().d().d();
            bqy2.b(this.dbAddress);
            if (bl2) {
                bqy2.a(this.floatVal.floatValue());
            }
            if (bl3) {
                bqy2.a(this.intVal);
            }
            this.selector.getSelectedAddresses().forEach(aem2 -> this.commandService.a((aem)aem2, this.command));
            return;
        }
        catch (Exception exception) {
            Alert alert = new Alert(Alert.AlertType.ERROR);
            alert.setTitle("Error");
            alert.setHeaderText(null);
            alert.setContentText(exception.getMessage());
            alert.showAndWait();
            return;
        }
    }

    @FXML
    void initialize() {
        assert (this.bootButton != null) : "fx:id=\"bootButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.calibrateCurrentButton != null) : "fx:id=\"calibrateCurrentButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.taskProgressView != null) : "fx:id=\"taskProgressView\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.moduleTree != null) : "fx:id=\"moduleTree\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.typeTree != null) : "fx:id=\"typeTree\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.programRawButton != null) : "fx:id=\"programButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.programEncryptingButton != null) : "fx:id=\"programButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.updateApplicationButton != null) : "fx:id=\"programButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.eraseApplicationButton != null) : "fx:id=\"eraseApplicationButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.stopButton != null) : "fx:id=\"stopButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.calibratePositionButton != null) : "fx:id=\"calibratePositionButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.eraseDatabaseButton != null) : "fx:id=\"eraseDatabaseButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.resetButton != null) : "fx:id=\"resetButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.saveAllPartitionsButton != null) : "fx:id=\"saveAllPartitionsButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.saveApplicationButton != null) : "fx:id=\"saveApplicationButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.saveBootloaderButton != null) : "fx:id=\"saveBootloaderButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        assert (this.saveDatabaseButton != null) : "fx:id=\"saveDatabaseButton\" was not injected: check your FXML file 'bootloader.fxml'.";
        this.typeTree.setRoot(this.simpleCategoryTree.getCategoryTree());
        this.typeTree.setShowRoot(false);
        this.typeTree.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.moduleTreeCellFactory.d.bind((ObservableValue)this.viewSelectorFamilyName.selectedProperty());
        this.moduleTree.setCellFactory((Callback)this.moduleTreeCellFactory);
        this.moduleTree.setRoot(this.filteredFlatModuleTree.getModuleTree());
        this.moduleTree.setShowRoot(false);
        this.moduleTree.getSelectionModel().setSelectionMode(SelectionMode.MULTIPLE);
        this.selector.setDataSource((ObservableList<TreeItem<arl>>)this.moduleTree.getSelectionModel().getSelectedItems());
        this.typeTree.getSelectionModel().getSelectedItems().addListener((ListChangeListener)new bau(this));
        BooleanBinding booleanBinding = Bindings.createBooleanBinding(() -> !this.taskProgressView.getTasks().isEmpty(), (Observable[])new Observable[]{this.taskProgressView.getTasks()});
        this.taskProgressView.visibleProperty().bind((ObservableValue)booleanBinding);
        this.bootloaderService.setTaskList(this.taskProgressView.getTasks());
        this.taskProgressView.getTasks().addListener(change -> {
            while (change.next()) {
                if (!change.wasRemoved()) continue;
                block5: for (Task task : change.getRemoved()) {
                    if (task.getState() != Worker.State.FAILED) {
                        amv.j("hebi.bootloader.showSuccessNotifications");
                    }
                    Notifications notifications = Notifications.create().position(Pos.BOTTOM_RIGHT).hideAfter(Duration.INDEFINITE).owner(this.taskProgressView).title(task.getTitle()).text(task.getMessage());
                    switch (task.getState()) {
                        case FAILED: {
                            notifications.showError();
                            continue block5;
                        }
                        case CANCELLED: {
                            notifications.showWarning();
                            continue block5;
                        }
                    }
                    notifications.showInformation();
                }
            }
        });
        BooleanBinding booleanBinding2 = booleanBinding.or((ObservableBooleanValue)this.selector.selectionEmpty());
        BooleanBinding booleanBinding3 = booleanBinding.or((ObservableBooleanValue)this.selector.selectionSingle().not());
        BooleanBinding booleanBinding4 = this.authenticationService.cW.not();
        azx.a((ObservableBooleanValue)booleanBinding2, new Node[]{this.bootButton, this.stopButton, this.updateApplicationButton, this.updateBootloaderButton, this.showMacAddressesButton, this.programRawButton, this.eraseApplicationButton, this.resetButton, this.calibrateCurrentButton, this.calibratePositionButton, this.calibrateEffortButton});
        azx.a((ObservableBooleanValue)booleanBinding3, new Node[]{this.fullUpdateButton});
        azx.a((ObservableBooleanValue)booleanBinding4.or((ObservableBooleanValue)booleanBinding2), new Node[]{this.updateBootloaderLoaderButton, this.programEncryptingButton, this.eraseDatabaseButton, this.setDatabaseValueButton, this.setBootloaderParametersButton, this.saveAllPartitionsButton, this.saveApplicationButton, this.saveDatabaseButton, this.saveBootloaderButton});
        bcl.a();
        if (!bcl.aX()) {
            this.topBar.getItems().remove((Object)this.loginButton);
            this.buttonVBox.getChildren().removeAll((Object[])new Node[]{this.programEncryptingButton, this.setBootloaderParametersButton, this.saveAllPartitionsButton, this.saveApplicationButton, this.saveDatabaseButton, this.saveBootloaderButton});
        }
        this.setBootloaderParametersButton.textProperty().bind((ObservableValue)Bindings.when((ObservableBooleanValue)this.authenticationService.cW).then("Set Key / Info (BL)").otherwise("Set Info (BL)"));
        this.interfaceChoiceService.init(this.interfaceChoiceBox);
        this.selector.addSingleSelectionChangeListener(this::bindToModule);
        this.bindToModule(auh.EMPTY_DEVICE);
    }

    private void bindToModule(arl arl2) {
        if (arl2 == null) {
            System.out.println("can't bind to null module");
            return;
        }
        aqy aqy2 = arl2.getInfo();
        Object object = aqy2;
        aqr aqr2 = aqy2.a;
        object = aqy2;
        aqw aqw2 = ((aqy)object).a;
        object = aqy2;
        arg arg2 = ((aqy)object).a;
        object = aqy2;
        aqj aqj2 = ((aqy)object).a;
        object = aqy2;
        arb cfr_ignored_0 = ((aqy)object).a;
        object = aqy2;
        aqt cfr_ignored_1 = ((aqy)object).a;
        object = aqw2;
        this.hwType.visibleProperty().bind((ObservableValue)((aqw)object).q.isNotEmpty());
        object = aqw2;
        this.hwType.textProperty().bind((ObservableValue)((aqw)object).q);
        object = aqw2;
        this.hwRevision.visibleProperty().bind((ObservableValue)((aqw)object).p.isNotEmpty());
        object = aqw2;
        this.hwRevision.textProperty().bind((ObservableValue)((aqw)object).p);
        object = aqw2;
        this.hwEceType.visibleProperty().bind((ObservableValue)((aqw)object).o.isNotEmpty());
        object = aqw2;
        this.hwEceType.textProperty().bind((ObservableValue)((aqw)object).o);
        object = aqw2;
        this.hwEceRevision.visibleProperty().bind((ObservableValue)((aqw)object).n.isNotEmpty());
        object = aqw2;
        this.hwEceRevision.textProperty().bind((ObservableValue)((aqw)object).n);
        object = aqw2;
        this.hwSerial.visibleProperty().bind((ObservableValue)((aqw)object).r.isNotEmpty());
        object = aqw2;
        this.hwSerial.textProperty().bind((ObservableValue)((aqw)object).r);
        aqj aqj3 = aqj2;
        object = aqj3;
        object = aqj2;
        DoubleBinding doubleBinding = aqj3.h.divide((ObservableNumberValue)((aqj)object).f).multiply(-1);
        this.hwSpringConstant.textProperty().bind((ObservableValue)doubleBinding.asString("%.3f"));
        object = aqr2;
        this.fwType.visibleProperty().bind((ObservableValue)((aqr)object).m.isNotEmpty());
        object = aqr2;
        this.fwType.textProperty().bind((ObservableValue)((aqr)object).m);
        object = aqr2;
        this.fwRevision.visibleProperty().bind((ObservableValue)((aqr)object).l.isNotEmpty());
        object = aqr2;
        this.fwRevision.textProperty().bind((ObservableValue)((aqr)object).l);
        object = aqr2;
        this.fwMode.visibleProperty().bind((ObservableValue)((aqr)object).u.isNotEqualTo((Object)aga.a));
        object = aqr2;
        this.fwMode.textProperty().bind((ObservableValue)((aqr)object).u.asString());
        object = arg2;
        this.ethMacAddress.visibleProperty().bind((ObservableValue)((arg)object).C.isNotEqualTo((Object)vl.a));
        object = arg2;
        this.ethMacAddress.textProperty().bind((ObservableValue)((arg)object).C.asString());
        object = arg2;
        this.ethIpAddress.visibleProperty().bind((ObservableValue)((arg)object).z.isNotEqualTo((Object)vj.a));
        Observable[] observableArray = new Observable[2];
        object = arg2;
        observableArray[0] = ((arg)object).z;
        object = arg2;
        observableArray[1] = ((arg)object).A;
        this.ethIpAddress.textProperty().bind((ObservableValue)Bindings.createStringBinding(() -> {
            String string = arg2.b().toString();
            switch (arg2.a()) {
                case b: {
                    return string + " (dhcp)";
                }
                case c: {
                    return string + " (static)";
                }
            }
            return string;
        }, (Observable[])observableArray));
        object = arg2;
        this.ethNetmask.visibleProperty().bind((ObservableValue)((arg)object).E.isNotEqualTo((Object)vj.a));
        object = arg2;
        this.ethNetmask.textProperty().bind((ObservableValue)((arg)object).E.asString());
        object = arg2;
        this.ethGateway.visibleProperty().bind((ObservableValue)((arg)object).B.isNotEqualTo((Object)vj.a));
        object = arg2;
        this.ethGateway.textProperty().bind((ObservableValue)((arg)object).B.asString());
        BooleanBinding booleanBinding = this.selector.selectionMultiple().not();
        this.authenticationService.cW.not();
        object = aqr2;
        BooleanBinding booleanBinding2 = ((aqr)object).u.isNotEqualTo((Object)aga.b);
        object = aqr2;
        BooleanBinding booleanBinding3 = ((aqr)object).u.isNotEqualTo((Object)aga.c);
        azx.a((ObservableBooleanValue)booleanBinding2.and((ObservableBooleanValue)booleanBinding), new Node[]{this.setBootloaderParametersButton});
        azx.a((ObservableBooleanValue)booleanBinding3.and((ObservableBooleanValue)booleanBinding), new Node[]{this.setApplicationParametersButton});
    }

    @PostConstruct
    public void postConstruct() {
        this.lookupService.setFrequency(5.0);
        this.command = aty.b();
    }
}

