/*
 * Decompiled with CFR 0.152.
 */
package us.hebi.gui.lib;

import com.fasterxml.jackson.annotation.JsonAnySetter;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.dataformat.yaml.YAMLFactory;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.xml.bind.annotation.XmlRootElement;
import lombok.Generated;
import us.hebi.gui.lib.aa;
import us.hebi.gui.lib.acr;
import us.hebi.gui.lib.amw;
import us.hebi.gui.lib.amx;
import us.hebi.gui.lib.h;

@XmlRootElement
public class acq {
    private static final Pattern VALID_STRUCT_FIELD_NAME = Pattern.compile("^[a-zA-Z_][a-zA-Z0-9_]*$");
    private URL origin;
    private amw version;
    private List<String> names = Collections.emptyList();
    private List<String> families = Collections.emptyList();
    private double feedbackFrequency = Double.NaN;
    private double commandLifetime = Double.NaN;
    private String hrdf;
    private Map<String, String> gains = Collections.emptyMap();
    private List<acr> plugins = Collections.emptyList();
    private Map<String, Object> userData;
    private static final amw VERSION_1_0_0 = new amw("1.0.0");
    private static final amw VERSION_1_1_0;
    public static amw HIGHEST_SUPPORTED_VERSION;

    public static acq tryReadFile(Path path) throws IOException {
        aa.a(Files.isRegularFile(path, new LinkOption[0]), (Object)"file is not a regular file");
        return acq.parseURL(amx.a(() -> path.toUri().toURL())).relativizePaths().validate();
    }

    public static acq parseURL(URL uRL) throws IOException {
        Object[] objectArray = new Object[]{uRL};
        String string = "invalid input: %s";
        if (uRL == null) {
            throw new NullPointerException(aa.b(string, objectArray));
        }
        ObjectMapper objectMapper = new ObjectMapper(new YAMLFactory());
        objectMapper.registerSubtypes(acq.class, acr.class);
        return objectMapper.readValue(uRL, acq.class).setOrigin(uRL);
    }

    private acq setOrigin(URL uRL) {
        this.origin = uRL;
        return this;
    }

    public acq relativizePaths() {
        URI uRI = amx.a(aa.a(this.origin, (Object)"origin: null")::toURI);
        this.hrdf = this.relativize(uRI, this.hrdf);
        this.gains.replaceAll((string, string2) -> this.relativize(uRI, this.gains.get(string)));
        return this;
    }

    private String relativize(URI uRI, String string) {
        if (string == null) {
            return null;
        }
        return Paths.get(uRI.resolve(string)).toAbsolutePath().toString();
    }

    private String relativize(Path path, String string) {
        if (string == null) {
            return null;
        }
        return path.relativize(Paths.get(string, new String[0])).toAbsolutePath().toString();
    }

    public acq validate() {
        aa.a(!this.names.isEmpty(), (Object)"Names must not be empty");
        aa.a(!this.families.isEmpty(), (Object)"Families must not be empty");
        aa.a(this.families.size() == 1 || this.families.size() == this.names.size(), (Object)"Families must be singular or match the number of names");
        aa.a(this.version != null, (Object)"Version must be set");
        acq.validateKeys(this.gains);
        acq.validateKeys(this.userData);
        if (this.plugins != null && !this.plugins.isEmpty()) {
            Iterator<acr> iterator = this.plugins.iterator();
            while (iterator.hasNext()) {
                acq.validateKeys(iterator.next().getProps());
            }
        }
        return this;
    }

    private static void validateKeys(Map<String, ?> map) {
        if (map == null || map.isEmpty()) {
            return;
        }
        for (String string : map.keySet()) {
            Object[] objectArray = new Object[]{string};
            String string2 = "Keys must be alphanumeric with optional underscores and do not start with a number. Encountered invalid key '%s'";
            if (acq.isValidKey(string)) continue;
            throw new IllegalArgumentException(aa.b(string2, objectArray));
        }
    }

    private static boolean isValidKey(String string) {
        return VALID_STRUCT_FIELD_NAME.matcher(string).matches();
    }

    @JsonProperty(value="names", required=true)
    public void setNames(Object object) {
        this.names = acq.toStringList(object);
    }

    @JsonProperty(value="families", required=true)
    public void setFamilies(Object object) {
        this.families = acq.toStringList(object);
    }

    @JsonProperty(value="feedback_frequency")
    public void setFeedbackFrequency(double d2) {
        this.requireMinimumVersion(VERSION_1_1_0);
        this.feedbackFrequency = d2;
    }

    @JsonProperty(value="command_lifetime")
    public void setCommandLifetime(double d2) {
        this.requireMinimumVersion(VERSION_1_1_0);
        this.commandLifetime = d2;
    }

    @JsonProperty(value="hrdf")
    public void setHrdf(String string) {
        this.hrdf = string;
    }

    @JsonProperty(value="gains")
    public void setGains(Object object) {
        if (object == null) {
            this.gains = Collections.emptyMap();
            return;
        }
        if (object instanceof String) {
            this.gains = new HashMap<String, String>();
            this.gains.put("default", (String)object);
            return;
        }
        if (object instanceof Map) {
            this.gains = (Map)object;
            return;
        }
        throw new IllegalArgumentException("Expected file or list of named gains. Found: ".concat(String.valueOf(object)));
    }

    @JsonProperty(value="user_data")
    public void setUserData(Object object) {
        if (object == null) {
            this.userData = Collections.emptyMap();
            return;
        }
        if (object instanceof Map) {
            this.userData = (Map)object;
            return;
        }
        throw new IllegalArgumentException("Expected list of key:value pairs. Found: ".concat(String.valueOf(object)));
    }

    @JsonProperty(value="plugins")
    public void setPlugins(List<acr> list) {
        if (list == null) {
            this.plugins = Collections.emptyList();
            return;
        }
        this.plugins = list;
    }

    private static List<String> toStringList(Object object) {
        if (object instanceof String) {
            return Collections.singletonList((String)object);
        }
        if (object instanceof List) {
            return (List)object;
        }
        throw new IllegalArgumentException("Expected string or list of strings");
    }

    @JsonAnySetter
    public void setProperty(String string, Object object) {
        if (this.version == null) {
            throw new IllegalStateException("Encountered unknown field for an unknown version. Please specify the file version on the first line.");
        }
        if (HIGHEST_SUPPORTED_VERSION.b(this.version)) {
            throw new IllegalArgumentException("Encountered unsupported key '" + string + "' with value '" + object + "'");
        }
        System.err.printf("Ignoring unknown field '%s' with value '%s'%n", string, object);
    }

    @JsonProperty(value="version", required=true)
    public void setVersion(String string) {
        amw amw2 = this.version = new amw(string);
        if (acq.HIGHEST_SUPPORTED_VERSION.bH < amw2.bH) {
            throw new IllegalArgumentException(String.format("This API supports robot config version '%s'. Please update your API to parse version '%s' files.", HIGHEST_SUPPORTED_VERSION, this.version));
        }
        if (HIGHEST_SUPPORTED_VERSION.a(this.version)) {
            System.err.printf("This API supports robot config version '%s'. Please upgrade your API to fully parse version '%s'. Some features may not be available.%n", HIGHEST_SUPPORTED_VERSION, this.version);
        }
    }

    private void requireMinimumVersion(amw amw2) {
        if (!this.version.b(amw2)) {
            h.a("The robot config file specifies version '%s' but uses features that were introduced in '%s'", new Object[]{this.version.toString(), amw2.toString()});
        }
    }

    @Generated
    public amw getVersion() {
        return this.version;
    }

    @Generated
    public List<String> getNames() {
        return this.names;
    }

    @Generated
    public List<String> getFamilies() {
        return this.families;
    }

    @Generated
    public double getFeedbackFrequency() {
        return this.feedbackFrequency;
    }

    @Generated
    public double getCommandLifetime() {
        return this.commandLifetime;
    }

    @Generated
    public String getHrdf() {
        return this.hrdf;
    }

    @Generated
    public Map<String, String> getGains() {
        return this.gains;
    }

    @Generated
    public List<acr> getPlugins() {
        return this.plugins;
    }

    @Generated
    public Map<String, Object> getUserData() {
        return this.userData;
    }

    @Generated
    public String toString() {
        return "RobotConfig(origin=" + this.getOrigin() + ", version=" + this.getVersion() + ", names=" + this.getNames() + ", families=" + this.getFamilies() + ", feedbackFrequency=" + this.getFeedbackFrequency() + ", commandLifetime=" + this.getCommandLifetime() + ", hrdf=" + this.getHrdf() + ", gains=" + this.getGains() + ", plugins=" + this.getPlugins() + ", userData=" + this.getUserData() + ")";
    }

    @Generated
    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof acq)) {
            return false;
        }
        acq acq2 = (acq)object;
        if (!acq2.canEqual(this)) {
            return false;
        }
        if (Double.compare(this.getFeedbackFrequency(), acq2.getFeedbackFrequency()) != 0) {
            return false;
        }
        if (Double.compare(this.getCommandLifetime(), acq2.getCommandLifetime()) != 0) {
            return false;
        }
        URL uRL = this.getOrigin();
        URL uRL2 = acq2.getOrigin();
        if (uRL == null ? uRL2 != null : !((Object)uRL).equals(uRL2)) {
            return false;
        }
        amw amw2 = this.getVersion();
        amw amw3 = acq2.getVersion();
        if (amw2 == null ? amw3 != null : !((Object)amw2).equals(amw3)) {
            return false;
        }
        List<String> list = this.getNames();
        List<String> list2 = acq2.getNames();
        if (list == null ? list2 != null : !((Object)list).equals(list2)) {
            return false;
        }
        List<String> list3 = this.getFamilies();
        List<String> list4 = acq2.getFamilies();
        if (list3 == null ? list4 != null : !((Object)list3).equals(list4)) {
            return false;
        }
        String string = this.getHrdf();
        String string2 = acq2.getHrdf();
        if (string == null ? string2 != null : !string.equals(string2)) {
            return false;
        }
        Map<String, String> map = this.getGains();
        Map<String, String> map2 = acq2.getGains();
        if (map == null ? map2 != null : !((Object)map).equals(map2)) {
            return false;
        }
        List<acr> list5 = this.getPlugins();
        List<acr> list6 = acq2.getPlugins();
        if (list5 == null ? list6 != null : !((Object)list5).equals(list6)) {
            return false;
        }
        Map<String, Object> map3 = this.getUserData();
        Map<String, Object> map4 = acq2.getUserData();
        return !(map3 == null ? map4 != null : !((Object)map3).equals(map4));
    }

    @Generated
    protected boolean canEqual(Object object) {
        return object instanceof acq;
    }

    @Generated
    public int hashCode() {
        long l2 = Double.doubleToLongBits(this.getFeedbackFrequency());
        int n2 = 59 + (int)(l2 >>> 32 ^ l2);
        long l3 = Double.doubleToLongBits(this.getCommandLifetime());
        n2 = n2 * 59 + (int)(l3 >>> 32 ^ l3);
        URL uRL = this.getOrigin();
        n2 = n2 * 59 + (uRL == null ? 43 : ((Object)uRL).hashCode());
        amw amw2 = this.getVersion();
        n2 = n2 * 59 + (amw2 == null ? 43 : ((Object)amw2).hashCode());
        List<String> list = this.getNames();
        n2 = n2 * 59 + (list == null ? 43 : ((Object)list).hashCode());
        List<String> list2 = this.getFamilies();
        n2 = n2 * 59 + (list2 == null ? 43 : ((Object)list2).hashCode());
        String string = this.getHrdf();
        n2 = n2 * 59 + (string == null ? 43 : string.hashCode());
        Map<String, String> map = this.getGains();
        n2 = n2 * 59 + (map == null ? 43 : ((Object)map).hashCode());
        List<acr> list3 = this.getPlugins();
        n2 = n2 * 59 + (list3 == null ? 43 : ((Object)list3).hashCode());
        Map<String, Object> map2 = this.getUserData();
        return n2 * 59 + (map2 == null ? 43 : ((Object)map2).hashCode());
    }

    @Generated
    public URL getOrigin() {
        return this.origin;
    }

    static {
        HIGHEST_SUPPORTED_VERSION = VERSION_1_1_0 = new amw("1.1.0");
    }
}

